/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import com.sun.xml.registry.ebxml.infomodel.AssociationImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;

public class BusinessLifeCycleManagerImpl
extends LifeCycleManagerImpl
implements BusinessLifeCycleManager {
    BusinessLifeCycleManagerImpl(RegistryServiceImpl service) {
        super(service);
    }

    public BulkResponse saveOrganizations(Collection organizations) throws JAXRException {
        ArrayList objects = new ArrayList(organizations);
        Iterator iter = organizations.iterator();
        while (iter.hasNext()) {
            Object org = iter.next();
            if (!(org instanceof Organization)) {
                throw new UnexpectedObjectException("Error: Expecting an Organization, got a " + org.getClass().getName());
            }
            objects.addAll(((Organization)org).getUsers());
        }
        return this.saveObjects(objects);
    }

    public BulkResponse saveServices(Collection services) throws JAXRException {
        LinkedList<Organization> orgs = new LinkedList<Organization>();
        Iterator iter = services.iterator();
        while (iter.hasNext()) {
            Object service = iter.next();
            if (!(service instanceof Service)) {
                throw new UnexpectedObjectException("Error: Expecting a Service, got a " + service.getClass().getName());
            }
            Organization org = ((Service)service).getProvidingOrganization();
            if (org == null) continue;
            orgs.add(org);
        }
        BulkResponse br = this.saveObjects(services);
        this.saveObjects(orgs);
        return br;
    }

    public BulkResponse saveServiceBindings(Collection bindings) throws JAXRException {
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            Object binding = iter.next();
            if (binding instanceof ServiceBinding) continue;
            throw new UnexpectedObjectException("Error: Expecting a ServiceBinding, got a " + binding.getClass().getName());
        }
        BulkResponse br = this.saveObjects(bindings);
        if (br.getExceptions() != null) {
            System.out.println("exceptions total: " + br.getExceptions().size());
            int c = 1;
            Iterator i = br.getExceptions().iterator();
            while (i.hasNext()) {
                Exception e = (Exception)i.next();
                System.out.println("exception #" + c++);
                e.printStackTrace();
            }
        }
        return br;
    }

    public BulkResponse saveConcepts(Collection concepts) throws JAXRException {
        Iterator iter = concepts.iterator();
        while (iter.hasNext()) {
            Object concept = iter.next();
            if (concept instanceof Concept) continue;
            throw new UnexpectedObjectException("Error: Expecting a Concept, got a " + concept.getClass().getName());
        }
        return this.saveObjects(concepts);
    }

    public BulkResponse saveClassificationSchemes(Collection schemes) throws JAXRException {
        Iterator iter = schemes.iterator();
        while (iter.hasNext()) {
            Object scheme = iter.next();
            if (scheme instanceof ClassificationScheme) continue;
            throw new UnexpectedObjectException("Error: Expecting a ClassificationScheme, got a " + scheme.getClass().getName());
        }
        return this.saveObjects(schemes);
    }

    public BulkResponse saveAssociations(Collection associations, boolean replace) throws JAXRException {
        Iterator iter = associations.iterator();
        while (iter.hasNext()) {
            Object association = iter.next();
            if (association instanceof Association) continue;
            throw new UnexpectedObjectException("Error: Expecting an Association, got a " + association.getClass().getName());
        }
        return this.saveObjects(associations);
    }

    public BulkResponse deleteOrganizations(Collection organizationKeys) throws JAXRException {
        return this.deleteObjects(organizationKeys);
    }

    public BulkResponse deleteServices(Collection serviceKeys) throws JAXRException {
        return this.deleteObjects(serviceKeys);
    }

    public BulkResponse deleteServiceBindings(Collection bindingKeys) throws JAXRException {
        return this.deleteObjects(bindingKeys);
    }

    public BulkResponse deleteConcepts(Collection conceptKeys) throws JAXRException {
        return this.deleteObjects(conceptKeys);
    }

    public BulkResponse deleteClassificationSchemes(Collection schemeKeys) throws JAXRException {
        return this.deleteObjects(schemeKeys);
    }

    public BulkResponse deleteAssociations(Collection assKeys) throws JAXRException {
        return this.deleteObjects(assKeys);
    }

    public void confirmAssociation(Association association) throws JAXRException, InvalidRequestException {
        AssociationImpl assImpl = (AssociationImpl)association;
        assImpl.confirm(this);
    }

    public void unConfirmAssociation(Association association) throws JAXRException, InvalidRequestException {
    }
}

