/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml;

import com.sun.xml.registry.ebxml.BusinessLifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.QueryImpl;
import com.sun.xml.registry.ebxml.QueryManagerImpl;
import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import java.io.StringWriter;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.Query;
import org.apache.commons.logging.Log;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.query.AdhocQueryRequest;
import org.oasis.ebxml.registry.bindings.query.AdhocQueryRequestChoice;
import org.oasis.ebxml.registry.bindings.query.ResponseOption;
import org.oasis.ebxml.registry.bindings.query.types.ReturnTypeType;

public class DeclarativeQueryManagerImpl
extends QueryManagerImpl
implements DeclarativeQueryManager {
    private Log log;

    DeclarativeQueryManagerImpl(RegistryServiceImpl regService, BusinessLifeCycleManagerImpl lcm) throws JAXRException {
        super(regService, lcm, null);
        this.log = regService.getConnection().getConnectionFactory().getLog();
    }

    public Query createQuery(int queryType, String queryString) throws InvalidRequestException, JAXRException {
        if (queryType != 0) {
            throw new InvalidRequestException("Type must be Query.QUERY_TYPE_SQL");
        }
        return new QueryImpl(queryType, queryString);
    }

    public BulkResponse executeQuery(Query query) throws JAXRException {
        String sqlString = ((Object)query).toString();
        AdhocQueryRequestChoice aqrc = new AdhocQueryRequestChoice();
        aqrc.setSQLQuery(sqlString);
        this.log.debug((Object)("sqlString=\"" + sqlString + "\""));
        AdhocQueryRequest aqr = new AdhocQueryRequest();
        aqr.setAdhocQueryRequestChoice(aqrc);
        ResponseOption ro = new ResponseOption();
        ro.setReturnComposedObjects(true);
        ro.setReturnType(ReturnTypeType.LEAFCLASSWITHREPOSITORYITEM);
        aqr.setResponseOption(ro);
        StringWriter sw = new StringWriter();
        try {
            aqr.marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException(x);
        }
        catch (ValidationException x) {
            throw new JAXRException(x);
        }
        return this.regService.getSoapMessenger().sendSoapRequest(sw.toString());
    }
}

