/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml;

import com.sun.ebxml.registry.RegistryException;
import com.sun.ebxml.registry.util.BindingUtility;
import com.sun.xml.registry.ebxml.BulkResponseImpl;
import com.sun.xml.registry.ebxml.BusinessQueryManagerImpl;
import com.sun.xml.registry.ebxml.ConnectionImpl;
import com.sun.xml.registry.ebxml.RegistryServiceImpl;
import com.sun.xml.registry.ebxml.infomodel.AssociationImpl;
import com.sun.xml.registry.ebxml.infomodel.AuditableEventImpl;
import com.sun.xml.registry.ebxml.infomodel.ClassificationImpl;
import com.sun.xml.registry.ebxml.infomodel.ClassificationSchemeImpl;
import com.sun.xml.registry.ebxml.infomodel.ConceptImpl;
import com.sun.xml.registry.ebxml.infomodel.EmailAddressImpl;
import com.sun.xml.registry.ebxml.infomodel.ExternalIdentifierImpl;
import com.sun.xml.registry.ebxml.infomodel.ExternalLinkImpl;
import com.sun.xml.registry.ebxml.infomodel.ExtrinsicObjectImpl;
import com.sun.xml.registry.ebxml.infomodel.InternationalStringImpl;
import com.sun.xml.registry.ebxml.infomodel.KeyImpl;
import com.sun.xml.registry.ebxml.infomodel.LocalizedStringImpl;
import com.sun.xml.registry.ebxml.infomodel.OrganizationImpl;
import com.sun.xml.registry.ebxml.infomodel.PersonNameImpl;
import com.sun.xml.registry.ebxml.infomodel.PostalAddressImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectRef;
import com.sun.xml.registry.ebxml.infomodel.RegistryPackageImpl;
import com.sun.xml.registry.ebxml.infomodel.ServiceBindingImpl;
import com.sun.xml.registry.ebxml.infomodel.ServiceImpl;
import com.sun.xml.registry.ebxml.infomodel.SlotImpl;
import com.sun.xml.registry.ebxml.infomodel.SpecificationLinkImpl;
import com.sun.xml.registry.ebxml.infomodel.TelephoneNumberImpl;
import com.sun.xml.registry.ebxml.infomodel.UserImpl;
import com.sun.xml.registry.ebxml.util.UUIDFactory;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.activation.DataHandler;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.Query;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.AuditableEvent;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.ExtrinsicObject;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import org.apache.commons.logging.Log;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.rim.LeafRegistryObjectList;
import org.oasis.ebxml.registry.bindings.rim.LeafRegistryObjectListTypeItem;
import org.oasis.ebxml.registry.bindings.rim.ObjectRef;
import org.oasis.ebxml.registry.bindings.rim.ObjectRefList;
import org.oasis.ebxml.registry.bindings.rim.ObjectRefListItem;
import org.oasis.ebxml.registry.bindings.rs.DeprecateObjectsRequest;
import org.oasis.ebxml.registry.bindings.rs.RemoveObjectsRequest;
import org.oasis.ebxml.registry.bindings.rs.SubmitObjectsRequest;
import org.oasis.ebxml.registry.bindings.rs.UpdateObjectsRequest;

public abstract class LifeCycleManagerImpl
implements LifeCycleManager {
    RegistryServiceImpl regService = null;
    HashSet modifiedObjects = null;
    private HashMap objectTypesMap = null;
    private Log log;

    LifeCycleManagerImpl(RegistryServiceImpl regService) {
        this.regService = regService;
        this.modifiedObjects = new HashSet();
        this.log = regService.getConnection().getConnectionFactory().getLog();
    }

    public String getCallerAlias() {
        String alias = null;
        ConnectionImpl conn = this.regService.getConnection();
        X500PrivateCredential cred = conn.getX500PrivateCredential();
        if (cred != null) {
            alias = cred.getAlias();
        }
        return alias;
    }

    public Object createObject(String className) throws JAXRException, InvalidRequestException, UnsupportedCapabilityException {
        Object obj = null;
        try {
            className = "com.sun.xml.registry.ebxml.infomodel." + className + "Impl";
            Class<?> cls = this.getClass().getClassLoader().loadClass(className);
            Class<?> lcmCls = this.getClass().getClassLoader().loadClass("com.sun.xml.registry.ebxml.LifeCycleManagerImpl");
            Class[] parmTypes = new Class[]{lcmCls};
            Constructor<?> cons = cls.getDeclaredConstructor(parmTypes);
            Object[] args = new Object[]{this};
            obj = cons.newInstance(args);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidRequestException("Invalid className '" + className + "' argument.");
        }
        catch (NoSuchMethodException e) {
            throw new JAXRException(e);
        }
        catch (InvocationTargetException e) {
            throw new JAXRException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new JAXRException(e);
        }
        catch (InstantiationException e) {
            throw new JAXRException(e);
        }
        catch (ExceptionInInitializerError e) {
            throw new JAXRException(e);
        }
        catch (SecurityException e) {
            throw new JAXRException(e);
        }
        return obj;
    }

    public Association createAssociation(RegistryObject targetObject, Concept associationType) throws JAXRException {
        AssociationImpl ass = new AssociationImpl(this);
        ass.setTargetObject(targetObject);
        ass.setAssociationType(associationType);
        return ass;
    }

    public Classification createClassification(ClassificationScheme scheme, String name, String value) throws JAXRException {
        InternationalString is = this.createInternationalString(name);
        Classification cl = this.createClassification(scheme, is, value);
        return cl;
    }

    public Classification createClassification(ClassificationScheme scheme, InternationalString name, String value) throws JAXRException {
        ClassificationImpl cl = new ClassificationImpl(this);
        cl.setClassificationScheme(scheme);
        cl.setName(name);
        cl.setValue(value);
        return cl;
    }

    public Classification createClassification(Concept concept) throws JAXRException, InvalidRequestException {
        ClassificationImpl cl = new ClassificationImpl(this);
        cl.setConcept(concept);
        return cl;
    }

    public ClassificationScheme createClassificationScheme(String name, String description) throws JAXRException, InvalidRequestException {
        InternationalString isName = this.createInternationalString(name);
        InternationalString isDesc = this.createInternationalString(description);
        ClassificationScheme scheme = this.createClassificationScheme(isName, isDesc);
        return scheme;
    }

    public ClassificationScheme createClassificationScheme(InternationalString name, InternationalString description) throws JAXRException, InvalidRequestException {
        ClassificationSchemeImpl scheme = new ClassificationSchemeImpl(this);
        scheme.setName(name);
        scheme.setDescription(description);
        return scheme;
    }

    public ClassificationScheme createClassificationScheme(Concept concept) throws JAXRException, InvalidRequestException {
        ClassificationSchemeImpl scheme = new ClassificationSchemeImpl(this, concept);
        return scheme;
    }

    public Concept createConcept(RegistryObject parent, String name, String value) throws JAXRException {
        InternationalString isName = this.createInternationalString(name);
        return this.createConcept(parent, isName, value);
    }

    public Concept createConcept(RegistryObject parent, InternationalString name, String value) throws JAXRException {
        ConceptImpl concept = new ConceptImpl(this);
        if (parent instanceof ClassificationScheme) {
            ((ClassificationScheme)parent).addChildConcept(concept);
        } else if (parent instanceof Concept) {
            concept.setParentConcept((Concept)parent);
        }
        concept.setName(name);
        concept.setValue(value);
        return concept;
    }

    public EmailAddress createEmailAddress(String address) throws JAXRException {
        EmailAddressImpl email = new EmailAddressImpl(this);
        email.setAddress(address);
        return email;
    }

    public EmailAddress createEmailAddress(String address, String type) throws JAXRException {
        EmailAddressImpl email = new EmailAddressImpl(this);
        email.setAddress(address);
        email.setType(type);
        return email;
    }

    public ExternalIdentifier createExternalIdentifier(ClassificationScheme scheme, String name, String value) throws JAXRException {
        InternationalString is = this.createInternationalString(name);
        ExternalIdentifier extId = this.createExternalIdentifier(scheme, is, value);
        return extId;
    }

    public ExternalIdentifier createExternalIdentifier(ClassificationScheme scheme, InternationalString name, String value) throws JAXRException {
        ExternalIdentifierImpl extId = new ExternalIdentifierImpl(this);
        extId.setIdentificationScheme(scheme);
        extId.setName(name);
        extId.setValue(value);
        return extId;
    }

    public ExternalLink createExternalLink(String externalURI, String description) throws JAXRException {
        InternationalString isDesc = this.createInternationalString(description);
        ExternalLink link = this.createExternalLink(externalURI, isDesc);
        return link;
    }

    public ExternalLink createExternalLink(String externalURI, InternationalString description) throws JAXRException {
        ExternalLinkImpl link = new ExternalLinkImpl(this);
        link.setDescription(description);
        link.setExternalURI(externalURI);
        return link;
    }

    public ExtrinsicObject createExtrinsicObject(DataHandler repositoryItem) throws JAXRException {
        ExtrinsicObjectImpl eo = new ExtrinsicObjectImpl(this);
        if (repositoryItem != null) {
            eo.setRepositoryItem(repositoryItem);
        }
        return eo;
    }

    public ExtrinsicObject createExtrinsicObject() throws JAXRException {
        return this.createExtrinsicObject(null);
    }

    public InternationalString createInternationalString() throws JAXRException {
        return this.createInternationalString(Locale.getDefault(), "");
    }

    public InternationalString createInternationalString(String s) throws JAXRException {
        return this.createInternationalString(Locale.getDefault(), s);
    }

    public InternationalString createInternationalString(Locale l, String s) throws JAXRException {
        LocalizedStringImpl ls = new LocalizedStringImpl(this);
        ls.setLocale(l);
        ls.setValue(s);
        InternationalStringImpl is = new InternationalStringImpl(this);
        is.addLocalizedString(ls);
        return is;
    }

    public Key createKey(String id) throws JAXRException {
        KeyImpl key = new KeyImpl(this);
        key.setId(id);
        return key;
    }

    public Key createKey() throws JAXRException {
        String id = this.createId();
        return this.createKey(id);
    }

    public String createId() throws JAXRException {
        String id = "urn:uuid:" + UUIDFactory.getInstance().newUUID().toString();
        return id;
    }

    public LocalizedString createLocalizedString(Locale l, String s) throws JAXRException {
        LocalizedStringImpl lString = new LocalizedStringImpl(this);
        lString.setLocale(l);
        lString.setValue(s);
        return lString;
    }

    public LocalizedString createLocalizedString(Locale l, String s, String charSetName) throws JAXRException {
        LocalizedString lString = this.createLocalizedString(l, s);
        lString.setCharsetName(charSetName);
        return lString;
    }

    public Organization createOrganization(String name) throws JAXRException {
        InternationalString is = this.createInternationalString(name);
        Organization org = this.createOrganization(is);
        return org;
    }

    public Organization createOrganization(InternationalString name) throws JAXRException {
        OrganizationImpl org = new OrganizationImpl(this);
        org.setName(name);
        return org;
    }

    public PersonName createPersonName(String firstName, String middleName, String lastName) throws JAXRException {
        PersonNameImpl personName = new PersonNameImpl(this);
        personName.setFirstName(firstName);
        personName.setMiddleName(middleName);
        personName.setLastName(lastName);
        return personName;
    }

    public PersonName createPersonName(String fullName) throws JAXRException {
        PersonNameImpl personName = new PersonNameImpl(this);
        personName.setFullName(fullName);
        return personName;
    }

    public PostalAddress createPostalAddress(String streetNumber, String street, String city, String stateOrProvince, String country, String postalCode, String type) throws JAXRException {
        PostalAddressImpl addr = new PostalAddressImpl(this);
        addr.setStreetNumber(streetNumber);
        addr.setStreet(street);
        addr.setCity(city);
        addr.setStateOrProvince(stateOrProvince);
        addr.setCountry(country);
        addr.setPostalCode(postalCode);
        addr.setType(type);
        return addr;
    }

    public RegistryPackage createRegistryPackage(String name) throws JAXRException {
        InternationalString is = this.createInternationalString(name);
        return this.createRegistryPackage(is);
    }

    public RegistryPackage createRegistryPackage(InternationalString name) throws JAXRException {
        RegistryPackageImpl pkg = new RegistryPackageImpl(this);
        pkg.setName(name);
        return pkg;
    }

    public Service createService(String name) throws JAXRException {
        InternationalString is = this.createInternationalString(name);
        return this.createService(is);
    }

    public Service createService(InternationalString name) throws JAXRException {
        ServiceImpl service = new ServiceImpl(this);
        service.setName(name);
        return service;
    }

    public ServiceBinding createServiceBinding() throws JAXRException {
        ServiceBindingImpl serviceBinding = new ServiceBindingImpl(this);
        return serviceBinding;
    }

    public Slot createSlot(String name, String value, String slotType) throws JAXRException {
        ArrayList<String> al = new ArrayList<String>();
        al.add(value);
        return this.createSlot(name, al, slotType);
    }

    public Slot createSlot(String name, Collection values, String slotType) throws JAXRException {
        SlotImpl slot = new SlotImpl(this);
        slot.setName(name);
        slot.setValues(values);
        slot.setSlotType(slotType);
        return slot;
    }

    public SpecificationLink createSpecificationLink() throws JAXRException {
        SpecificationLinkImpl specLink = new SpecificationLinkImpl(this);
        return specLink;
    }

    public TelephoneNumber createTelephoneNumber() throws JAXRException {
        TelephoneNumberImpl ph = new TelephoneNumberImpl(this);
        return ph;
    }

    public User createUser() throws JAXRException {
        UserImpl user = new UserImpl(this);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkResponse saveAllObjects() throws JAXRException {
        HashSet _modifiedObjects = null;
        HashSet hashSet = this.modifiedObjects;
        synchronized (hashSet) {
            _modifiedObjects = (HashSet)this.modifiedObjects.clone();
        }
        return this.saveObjects(_modifiedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModifiedObject(RegistryObject ro) {
        HashSet hashSet = this.modifiedObjects;
        synchronized (hashSet) {
            this.modifiedObjects.add(ro);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModifiedObject(RegistryObject ro) {
        HashSet hashSet = this.modifiedObjects;
        synchronized (hashSet) {
            this.modifiedObjects.remove(ro);
        }
    }

    public BulkResponse saveObjects(Collection objects) throws JAXRException {
        if (objects == null || objects.size() == 0) {
            return new BulkResponseImpl();
        }
        HashSet submitObjects = new HashSet();
        HashSet processedObjects = new HashSet();
        HashSet composedObjects = new HashSet();
        String pad = "";
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            this.processObject(obj, submitObjects, processedObjects, composedObjects, pad);
        }
        this.log.debug((Object)("submitObjects = " + submitObjects));
        this.log.debug((Object)("processedObjects = " + processedObjects));
        BulkResponse response = null;
        HashMap attachMap = new HashMap();
        LeafRegistryObjectList list = this.makeLeafRegistryObjectList(submitObjects, processedObjects, composedObjects, attachMap);
        if (list != null && (response = this.doSubmitObjectsRequest(list, attachMap)).getStatus() == 0) {
            this.markRegistryObjectsClean(submitObjects);
        }
        return response;
    }

    public void processObject(Object obj, HashSet submitObjects, HashSet processedObjects, HashSet composedObjects, String pad) throws JAXRException {
        this.log.debug((Object)(pad + "processObject entered: obj = " + obj));
        if (!(obj instanceof RegistryObjectImpl) && !(obj instanceof RegistryObjectRef)) {
            this.log.debug((Object)(pad + "processObject: skipping obj = " + obj));
            return;
        }
        if (processedObjects.contains(obj)) {
            this.log.debug((Object)(pad + "processObject: returning on already processed obj = " + obj));
            return;
        }
        this.log.debug((Object)(pad + "processObject: processedObject.add on obj = " + obj + " processedObjects.contains = " + processedObjects.contains(obj)));
        processedObjects.add(obj);
        if (obj instanceof RegistryObjectRef) {
            this.processRegistryObjectRef((RegistryObjectRef)obj, submitObjects, processedObjects, composedObjects, pad);
        } else if (obj instanceof RegistryObjectImpl) {
            this.processRegistryObject((RegistryObjectImpl)obj, submitObjects, processedObjects, composedObjects, pad);
        }
    }

    public void processRegistryObjectRef(RegistryObjectRef ref, HashSet submitObjects, HashSet processedObjects, HashSet composedObjects, String pad) throws JAXRException {
        this.log.debug((Object)(pad + "processRegistryObjectRef entered: ref = " + ref));
        RegistryObjectImpl ro = (RegistryObjectImpl)ref.getRegistryObject("RegistryObject");
        this.log.debug((Object)(pad + "processRegistryObjectRef: ro = " + ro));
        if (ro != null) {
            if (!ro.isNew() && !ro.isModified()) {
                this.log.debug((Object)(pad + "processRegistryObjectRef: submitObject.add for clean ref  = " + ro));
                submitObjects.add(ref);
            } else {
                this.processObject(ro, submitObjects, processedObjects, composedObjects, pad);
            }
        }
    }

    public void processRegistryObject(RegistryObjectImpl ro, HashSet submitObjects, HashSet processedObjects, HashSet composedObjects, String pad) throws JAXRException {
        this.log.debug((Object)(pad + "processRegistryObject: entered submitObject.add on ro  = " + ro));
        submitObjects.add(ro);
        HashSet assObjects = ro.getAssociationsAndAssociatedObjects();
        Iterator it = assObjects.iterator();
        while (it.hasNext()) {
            RegistryObjectImpl assObj = (RegistryObjectImpl)it.next();
            if (!assObj.isNew() && !assObj.isModified()) continue;
            this.processObject(assObj, submitObjects, processedObjects, composedObjects, pad.concat(" "));
        }
        Collection elObjects = ro.getExternalLinks();
        Iterator it2 = elObjects.iterator();
        while (it2.hasNext()) {
            Object elObj = it2.next();
            this.processObject(elObj, submitObjects, processedObjects, composedObjects, pad.concat(" "));
        }
        if (ro.isNew() || ro.isModified()) {
            HashSet _composedObjects = new HashSet();
            ro.getComposedObjects(_composedObjects);
            composedObjects.addAll(_composedObjects);
            Iterator composedIter = _composedObjects.iterator();
            while (composedIter.hasNext()) {
                Object composedObj = composedIter.next();
                this.processObject(composedObj, submitObjects, processedObjects, composedObjects, pad.concat(" "));
            }
            HashSet refObjects = ro.getRegistryObjectRefs();
            if (refObjects != null) {
                Iterator refIter = refObjects.iterator();
                while (refIter.hasNext()) {
                    Object refObj = refIter.next();
                    this.processObject(refObj, submitObjects, processedObjects, composedObjects, pad.concat(" "));
                }
            }
        }
    }

    private LeafRegistryObjectList makeLeafRegistryObjectList(HashSet objects, HashSet processedObjects, HashSet composedObjects, HashMap attachMap) throws JAXRException {
        HashSet<String> roIds = new HashSet<String>();
        HashSet<String> refIds = new HashSet<String>();
        if (objects == null || objects.size() == 0) {
            return null;
        }
        LeafRegistryObjectList list = new LeafRegistryObjectList();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            ObjectRef ebRef;
            String id;
            LeafRegistryObjectListTypeItem item = new LeafRegistryObjectListTypeItem();
            Object obj = it.next();
            RegistryObjectImpl ro = null;
            if (obj instanceof RegistryObjectImpl) {
                ro = (RegistryObjectImpl)obj;
                id = ro.getId();
                if (!composedObjects.contains(ro)) {
                    this.log.debug((Object)("makeLeafRegistryObjectList: ro=" + ro + " modified=" + ro.isModified() + " new=" + ro.isNew()));
                    if (ro.isModified() || ro.isNew()) {
                        this.log.debug((Object)("makeLeafRegistryObjectList: submitting " + obj));
                        if (obj instanceof Association) {
                            item.setAssociation(((AssociationImpl)obj).toBindingObject());
                        } else if (obj instanceof AuditableEvent) {
                            item.setAuditableEvent(((AuditableEventImpl)obj).toBindingObject());
                        } else if (obj instanceof Classification) {
                            item.setClassification(((ClassificationImpl)obj).toBindingObject());
                        } else if (obj instanceof Concept) {
                            item.setClassificationNode(((ConceptImpl)obj).toBindingObject());
                        } else if (obj instanceof ClassificationScheme) {
                            this.log.debug((Object)("makeLeafRegistryObjectList: setting item to scheme " + obj));
                            item.setClassificationScheme(((ClassificationSchemeImpl)obj).toBindingObject());
                        } else if (obj instanceof ExternalIdentifier) {
                            item.setExternalIdentifier(((ExternalIdentifierImpl)obj).toBindingObject());
                        } else if (obj instanceof ExternalLink) {
                            item.setExternalLink(((ExternalLinkImpl)obj).toBindingObject());
                        } else if (obj instanceof ExtrinsicObject) {
                            ExtrinsicObjectImpl eo = (ExtrinsicObjectImpl)obj;
                            item.setExtrinsicObject(eo.toBindingObject());
                            DataHandler ri = eo.getRepositoryItem();
                            if (ri != null) {
                                attachMap.put(id, ri);
                            }
                        } else if (obj instanceof Organization) {
                            item.setOrganization(((OrganizationImpl)obj).toBindingObject());
                        } else if (obj instanceof RegistryPackage) {
                            item.setRegistryPackage(((RegistryPackageImpl)obj).toBindingObject());
                        } else if (obj instanceof Service) {
                            item.setService(((ServiceImpl)obj).toBindingObject());
                        } else if (obj instanceof ServiceBinding) {
                            item.setServiceBinding(((ServiceBindingImpl)obj).toBindingObject());
                        } else if (obj instanceof SpecificationLink) {
                            item.setSpecificationLink(((SpecificationLinkImpl)obj).toBindingObject());
                        } else if (obj instanceof User) {
                            item.setUser(((UserImpl)obj).toBindingObject());
                        }
                        if (roIds.contains(id)) continue;
                        roIds.add(id);
                        list.addLeafRegistryObjectListTypeItem(item);
                        continue;
                    }
                    if (refIds.contains(id)) continue;
                    refIds.add(id);
                    ebRef = new ObjectRef();
                    ebRef.setId(id);
                    item.setObjectRef(ebRef);
                    this.log.debug((Object)("makeLeafRegistryObjectList: submitting ref to unmodified ro=" + ro));
                    list.addLeafRegistryObjectListTypeItem(item);
                    continue;
                }
                this.log.debug((Object)("makeLeafRegistryObjectList: skipping composedObject ro=" + ro + " modified=" + ro.isModified() + " new=" + ro.isNew()));
                continue;
            }
            if (obj instanceof RegistryObjectRef) {
                id = ((RegistryObjectRef)obj).getId();
                if (refIds.contains(id)) continue;
                refIds.add(id);
                ebRef = new ObjectRef();
                ebRef.setId(id);
                item.setObjectRef(ebRef);
                this.log.debug((Object)("makeLeafRegistryObjectList: submitting ref=" + obj));
                list.addLeafRegistryObjectListTypeItem(item);
                continue;
            }
            throw new JAXRException("Unexpected ebXML object to save" + obj);
        }
        this.log.debug((Object)("makeLeafRegistryObjectList: returning item count = " + list.getLeafRegistryObjectListTypeItemCount()));
        return list;
    }

    private BulkResponse doSubmitObjectsRequest(LeafRegistryObjectList list, HashMap attachMap) throws JAXRException {
        BulkResponseImpl response = null;
        SubmitObjectsRequest req = new SubmitObjectsRequest();
        req.setLeafRegistryObjectList(list);
        StringWriter sw = new StringWriter();
        try {
            req.marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException(x);
        }
        catch (ValidationException x) {
            this.log.debug((Object)x);
            throw new JAXRException(x);
        }
        response = this.regService.getSoapMessenger().sendSoapRequest(sw.toString(), attachMap, true);
        this.setKeysOnBulkResponse(req, response);
        return response;
    }

    private BulkResponse doUpdateObjectsRequest(LeafRegistryObjectList list, HashMap attachMap) throws JAXRException {
        BulkResponseImpl response = null;
        UpdateObjectsRequest req = new UpdateObjectsRequest();
        req.setLeafRegistryObjectList(list);
        StringWriter sw = new StringWriter();
        try {
            req.marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException(x);
        }
        catch (ValidationException x) {
            throw new JAXRException(x);
        }
        response = this.regService.getSoapMessenger().sendSoapRequest(sw.toString(), attachMap, true);
        this.setKeysOnBulkResponse(req, response);
        return response;
    }

    private void setKeysOnBulkResponse(Object req, BulkResponseImpl response) throws JAXRException {
        ArrayList idList = null;
        try {
            idList = BindingUtility.getInstance().getIdsFromRequest(req);
        }
        catch (RegistryException e) {
            throw new JAXRException(e);
        }
        ArrayList<Key> keyList = new ArrayList<Key>();
        Iterator iter = idList.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            Key key = this.createKey(id);
            keyList.add(key);
        }
        response.setCollection(keyList);
    }

    private void markRegistryObjectsClean(Collection objects) {
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof RegistryObjectImpl)) continue;
            RegistryObjectImpl ro = (RegistryObjectImpl)obj;
            ro.setNew(false);
            ro.setModified(false);
        }
    }

    public BulkResponse deprecateObjects(Collection keys) throws JAXRException {
        ObjectRefList orl = this.createObjectRefList(keys);
        DeprecateObjectsRequest dor = new DeprecateObjectsRequest();
        dor.setObjectRefList(orl);
        StringWriter sw = new StringWriter();
        try {
            dor.marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException(x);
        }
        catch (ValidationException x) {
            throw new JAXRException(x);
        }
        return this.regService.getSoapMessenger().sendSoapRequest(sw.toString(), null, true);
    }

    public BulkResponse unDeprecateObjects(Collection keys) throws JAXRException {
        return null;
    }

    public BulkResponse deleteObjects(Collection keys) throws JAXRException {
        BulkResponse br = this.getRegistryService().getBusinessQueryManager().getRegistryObjects(keys);
        Collection objects = br.getCollection();
        if (objects != null && !objects.isEmpty()) {
            Iterator i = objects.iterator();
            while (i.hasNext()) {
                RegistryObject ro = (RegistryObject)i.next();
                Collection associations = ro.getAssociations();
                if (associations == null || associations.isEmpty()) continue;
                Iterator aIter = associations.iterator();
                while (aIter.hasNext()) {
                    Association a = (Association)aIter.next();
                    Key key = a.getKey();
                    if (keys.contains(key)) continue;
                    keys.add(key);
                }
            }
        }
        BulkResponseImpl response = null;
        ObjectRefList orl = this.createObjectRefList(keys);
        RemoveObjectsRequest ror = new RemoveObjectsRequest();
        ror.setObjectRefList(orl);
        StringWriter sw = new StringWriter();
        try {
            ror.marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException(x);
        }
        catch (ValidationException x) {
            throw new JAXRException(x);
        }
        response = this.regService.getSoapMessenger().sendSoapRequest(sw.toString(), null, true);
        response.setCollection(keys);
        return response;
    }

    public void createConceptEquivalence(Concept concept1, Concept concept2) throws JAXRException {
        BusinessQueryManagerImpl bqm = (BusinessQueryManagerImpl)this.regService.getBusinessQueryManager();
        Concept eqConcept = bqm.findConceptByPath("/urn:uuid:6902675f-2f18-44b8-888b-c91db8b96b4d/EquivalentTo");
        Association assoc = this.createAssociation(concept2, eqConcept);
        concept1.addAssociation(assoc);
    }

    public void deleteConceptEquivalence(Concept concept1, Concept concept2) throws JAXRException {
    }

    public BulkResponse deleteObjects(Collection keys, String objectType) throws JAXRException {
        return this.deleteObjects(keys);
    }

    public RegistryService getRegistryService() throws JAXRException {
        return this.regService;
    }

    private ObjectRefList createObjectRefList(Collection keys) throws JAXRException {
        HashSet<String> processedIds = new HashSet<String>();
        processedIds.add(null);
        ObjectRefList orl = new ObjectRefList();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            KeyImpl key;
            String id;
            Object obj = it.next();
            if (!(obj instanceof KeyImpl) || processedIds.contains(id = (key = (KeyImpl)obj).getId())) continue;
            processedIds.add(id);
            ObjectRef ebObjRef = new ObjectRef();
            ebObjRef.setId(id);
            ObjectRefListItem orli = new ObjectRefListItem();
            orli.setObjectRef(ebObjRef);
            orl.addObjectRefListItem(orli);
        }
        return orl;
    }

    private void initializeObjectTypesMap() {
        try {
            DeclarativeQueryManager dqm = this.getRegistryService().getDeclarativeQueryManager();
            String queryStr = "SELECT * FROM ClassificationNode children, ClassificationNode parent where (parent.path LIKE '/urn:uuid:3188a449-18ac-41fb-be9f-99a1adca02cb/RegistryObject%') AND (parent.path NOT LIKE '/urn:uuid:3188a449-18ac-41fb-be9f-99a1adca02cb/RegistryObject/RegistryEntry/ExtrinsicObject/%') AND parent.id = children.parent";
            Query query = dqm.createQuery(0, queryStr);
            BulkResponse resp = dqm.executeQuery(query);
            if (resp != null && resp.getStatus() != 0) {
                Collection exceptions = resp.getExceptions();
                Iterator iter = exceptions.iterator();
                while (iter.hasNext()) {
                    Exception e = (Exception)iter.next();
                    e.printStackTrace();
                }
                return;
            }
            this.objectTypesMap = new HashMap();
            Collection concepts = resp.getCollection();
            Iterator iter = concepts.iterator();
            while (iter.hasNext()) {
                Concept concept = (Concept)iter.next();
                String value = concept.getValue();
                if (value.equals("ClassificationNode")) {
                    value = "Concept";
                }
                this.objectTypesMap.put(value, concept);
            }
        }
        catch (JAXRException e) {
            e.printStackTrace();
        }
    }

    public HashMap getObjectTypesMap() {
        if (this.objectTypesMap == null) {
            this.initializeObjectTypesMap();
        }
        return this.objectTypesMap;
    }
}

