/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.infomodel.ExtensibleObjectImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Slot;
import org.oasis.ebxml.registry.bindings.rim.SlotType1;
import org.oasis.ebxml.registry.bindings.rim.ValueList;
import org.oasis.ebxml.registry.bindings.rim.ValueListTypeItem;

public class SlotImpl
implements Slot {
    private String name = null;
    private String slotType = null;
    private ArrayList values = new ArrayList();
    private ExtensibleObjectImpl parent = null;
    protected LifeCycleManagerImpl lcm = null;

    public SlotImpl(LifeCycleManagerImpl lcm) throws JAXRException {
        this.lcm = lcm;
    }

    SlotImpl(LifeCycleManagerImpl lcm, SlotType1 ebSlot) throws JAXRException {
        this.lcm = lcm;
        this.name = ebSlot.getName();
        this.slotType = ebSlot.getSlotType();
        ValueList valList = ebSlot.getValueList();
        if (valList != null) {
            ValueListTypeItem[] vlti = valList.getValueListTypeItem();
            for (int i = 0; i < vlti.length; ++i) {
                this.values.add(vlti[i].getValue());
            }
        }
    }

    void setParent(ExtensibleObjectImpl _parent) throws InvalidRequestException {
        if (_parent != null && this.parent != null && _parent != this.parent) {
            throw new InvalidRequestException("Error. Cannot add Slot to object " + _parent + " as it is already added to object " + this.parent);
        }
        this.parent = _parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String par1) throws JAXRException {
        this.name = par1;
        if (this.parent != null) {
            this.parent.setModified(true);
        }
    }

    public String getSlotType() throws JAXRException {
        return this.slotType;
    }

    public void setSlotType(String par1) throws JAXRException {
        this.slotType = par1;
        if (this.parent != null) {
            this.parent.setModified(true);
        }
    }

    public Collection getValues() throws JAXRException {
        return (ArrayList)this.values.clone();
    }

    public void setValues(Collection par1) throws JAXRException {
        this.values.clear();
        this.values.addAll(par1);
        if (this.parent != null) {
            this.parent.setModified(true);
        }
    }

    void setBindingObject(SlotType1 ebSlot) throws JAXRException {
        ebSlot.setName(this.name);
        ebSlot.setSlotType(this.slotType);
        ValueList valueList = new ValueList();
        Iterator iter = this.getValues().iterator();
        while (iter.hasNext()) {
            String value = (String)iter.next();
            ValueListTypeItem item = new ValueListTypeItem();
            item.setValue(value);
            valueList.addValueListTypeItem(item);
        }
        ebSlot.setValueList(valueList);
    }

    protected Object clone() throws CloneNotSupportedException {
        SlotImpl _clone = null;
        try {
            new SlotImpl(this.lcm);
            _clone.setName(this.getName());
            _clone.setSlotType(this.getSlotType());
            _clone.setValues(this.getValues());
            _clone.setParent(this.parent);
        }
        catch (JAXRException e) {
            e.printStackTrace();
        }
        return _clone;
    }
}

