/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.xml;

import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.mq.xml.XElement;
import org.jboss.mq.xml.XElementConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XElementProducer {
    private XElementConsumer consumer;
    private Vector targetRecords = new Vector();
    private Handler handler = new Handler();
    private Exception thrownError = null;

    public XElementProducer(XElementConsumer consumerObject) {
        this.consumer = consumerObject;
    }

    public void addElementRecord(String name) {
        this.targetRecords.addElement(name);
    }

    public void clearElementRecords() {
        this.targetRecords.removeAllElements();
    }

    public void parse(InputStream is) throws Exception {
        if (this.consumer == null) {
            throw new NullPointerException();
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser2 = factory.newSAXParser();
            if (this.consumer instanceof ErrorHandler) {
                XMLReader reader = parser2.getXMLReader();
                reader.setErrorHandler((ErrorHandler)((Object)this.consumer));
            }
            this.thrownError = null;
            parser2.parse(new InputSource(is), (DefaultHandler)this.handler);
        }
        catch (SAXException e) {
            if (this.thrownError != null) {
                throw this.thrownError;
            }
            throw e;
        }
    }

    public void parse(URL url) throws Exception {
        if (this.consumer == null) {
            throw new NullPointerException();
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser2 = factory.newSAXParser();
            if (this.consumer instanceof ErrorHandler) {
                XMLReader reader = parser2.getXMLReader();
                reader.setErrorHandler((ErrorHandler)((Object)this.consumer));
            }
            this.thrownError = null;
            parser2.parse(url.toExternalForm(), (DefaultHandler)this.handler);
        }
        catch (SAXException e) {
            if (this.thrownError != null) {
                throw this.thrownError;
            }
            throw e;
        }
    }

    class Handler
    extends DefaultHandler {
        private XElement currentXElement;

        Handler() {
        }

        public void startDocument() throws SAXException {
            try {
                XElementProducer.this.consumer.documentStartEvent();
            }
            catch (Exception e) {
                XElementProducer.this.thrownError = e;
                throw new SAXException(e.toString());
            }
        }

        public void endDocument() throws SAXException {
            try {
                XElementProducer.this.consumer.documentEndEvent();
            }
            catch (Exception e) {
                XElementProducer.this.thrownError = e;
                throw new SAXException(e.toString());
            }
        }

        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            if (this.currentXElement != null) {
                XElement o = new XElement(qname, atts);
                this.currentXElement.addElement(o);
                this.currentXElement = o;
            } else if (XElementProducer.this.targetRecords.size() == 0) {
                this.currentXElement = new XElement(qname, atts);
            } else {
                for (int i = 0; i < XElementProducer.this.targetRecords.size(); ++i) {
                    if (!qname.equals(XElementProducer.this.targetRecords.elementAt(i))) continue;
                    this.currentXElement = new XElement(qname, atts);
                    break;
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.currentXElement != null) {
                if (!qName.equals(this.currentXElement.getName())) {
                    throw new SAXException("XElement parsing sanitity check failed");
                }
                XElement t = this.currentXElement;
                this.currentXElement = this.currentXElement.getParent();
                if (this.currentXElement == null) {
                    try {
                        XElementProducer.this.consumer.recordReadEvent(t);
                    }
                    catch (Exception e) {
                        XElementProducer.this.thrownError = e;
                        throw new SAXException(e.toString());
                    }
                }
            }
        }

        public void characters(char[] chars, int start, int length) {
            if (length == 0) {
                return;
            }
            if (this.currentXElement != null) {
                this.currentXElement.add(new String(chars, start, length));
            }
        }
    }
}

