/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.jboss.logging.Logger;
import org.jboss.security.Util;
import org.jboss.security.srp.SRPParameters;
import org.jboss.security.srp.SRPPermission;

public class SRPClientSession {
    private static Logger log = Logger.getLogger(class$org$jboss$security$srp$SRPClientSession == null ? (class$org$jboss$security$srp$SRPClientSession = SRPClientSession.class$("org.jboss.security.srp.SRPClientSession")) : class$org$jboss$security$srp$SRPClientSession);
    private SRPParameters params;
    private BigInteger N;
    private BigInteger g;
    private BigInteger x;
    private BigInteger v;
    private byte[] s;
    private BigInteger a;
    private BigInteger A;
    private byte[] K;
    private MessageDigest clientHash;
    private MessageDigest serverHash;
    private static int A_LEN = 64;
    static /* synthetic */ Class class$org$jboss$security$srp$SRPClientSession;

    public SRPClientSession(String username, char[] password, SRPParameters params) {
        this(username, password, params, null);
    }

    public SRPClientSession(String username, char[] password, SRPParameters params, byte[] abytes) {
        MessageDigest tmp;
        try {
            Util.init();
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        this.params = params;
        this.g = new BigInteger(1, params.g);
        this.N = new BigInteger(1, params.N);
        if (abytes != null) {
            if (8 * abytes.length != A_LEN) {
                throw new IllegalArgumentException("The abytes param must be " + A_LEN / 8 + " in length, abytes.length=" + abytes.length);
            }
            this.a = new BigInteger(abytes);
        }
        if (log.isTraceEnabled()) {
            log.trace("g: " + Util.tob64(params.g));
        }
        byte[] xb = Util.calculatePasswordHash(username, password, params.s);
        if (log.isTraceEnabled()) {
            log.trace("x: " + Util.tob64(xb));
        }
        this.x = new BigInteger(1, xb);
        this.v = this.g.modPow(this.x, this.N);
        if (log.isTraceEnabled()) {
            log.trace("v: " + Util.tob64(this.v.toByteArray()));
        }
        this.serverHash = Util.newDigest();
        this.clientHash = Util.newDigest();
        byte[] hn = Util.newDigest().digest(params.N);
        if (log.isTraceEnabled()) {
            log.trace("H(N): " + Util.tob64(hn));
        }
        byte[] hg = Util.newDigest().digest(params.g);
        if (log.isTraceEnabled()) {
            log.trace("H(g): " + Util.tob64(hg));
        }
        byte[] hxg = Util.xor(hn, hg, 20);
        if (log.isTraceEnabled()) {
            log.trace("H(N) xor H(g): " + Util.tob64(hxg));
        }
        this.clientHash.update(hxg);
        if (log.isTraceEnabled()) {
            tmp = Util.copy(this.clientHash);
            log.trace("H[H(N) xor H(g)]: " + Util.tob64(tmp.digest()));
        }
        this.clientHash.update(Util.newDigest().digest(username.getBytes()));
        if (log.isTraceEnabled()) {
            tmp = Util.copy(this.clientHash);
            log.trace("H[H(N) xor H(g) | H(U)]: " + Util.tob64(tmp.digest()));
        }
        this.clientHash.update(params.s);
        if (log.isTraceEnabled()) {
            tmp = Util.copy(this.clientHash);
            log.trace("H[H(N) xor H(g) | H(U) | s]: " + Util.tob64(tmp.digest()));
        }
        this.K = null;
    }

    public byte[] exponential() {
        byte[] Abytes = null;
        if (this.A == null) {
            if (this.a == null) {
                BigInteger one = BigInteger.ONE;
                do {
                    this.a = new BigInteger(A_LEN, Util.getPRNG());
                } while (this.a.compareTo(one) <= 0);
            }
            this.A = this.g.modPow(this.a, this.N);
            Abytes = Util.trim(this.A.toByteArray());
            this.clientHash.update(Abytes);
            if (log.isTraceEnabled()) {
                MessageDigest tmp = Util.copy(this.clientHash);
                log.trace("H[H(N) xor H(g) | H(U) | s | A]: " + Util.tob64(tmp.digest()));
            }
            this.serverHash.update(Abytes);
        }
        return Abytes;
    }

    public byte[] response(byte[] Bbytes) throws NoSuchAlgorithmException {
        this.clientHash.update(Bbytes);
        if (log.isTraceEnabled()) {
            MessageDigest tmp = Util.copy(this.clientHash);
            log.trace("H[H(N) xor H(g) | H(U) | s | A | B]: " + Util.tob64(tmp.digest()));
        }
        byte[] hB = Util.newDigest().digest(Bbytes);
        byte[] ub = new byte[]{hB[0], hB[1], hB[2], hB[3]};
        BigInteger B = new BigInteger(1, Bbytes);
        if (log.isTraceEnabled()) {
            log.trace("B: " + Util.tob64(B.toByteArray()));
        }
        if (B.compareTo(this.v) < 0) {
            B = B.add(this.N);
        }
        if (log.isTraceEnabled()) {
            log.trace("B': " + Util.tob64(B.toByteArray()));
        }
        if (log.isTraceEnabled()) {
            log.trace("v: " + Util.tob64(this.v.toByteArray()));
        }
        BigInteger u = new BigInteger(1, ub);
        if (log.isTraceEnabled()) {
            log.trace("u: " + Util.tob64(u.toByteArray()));
        }
        BigInteger B_v = B.subtract(this.v);
        if (log.isTraceEnabled()) {
            log.trace("B - v: " + Util.tob64(B_v.toByteArray()));
        }
        BigInteger a_ux = this.a.add(u.multiply(this.x));
        if (log.isTraceEnabled()) {
            log.trace("a + u * x: " + Util.tob64(a_ux.toByteArray()));
        }
        BigInteger S = B_v.modPow(a_ux, this.N);
        if (log.isTraceEnabled()) {
            log.trace("S: " + Util.tob64(S.toByteArray()));
        }
        MessageDigest sessionDigest = MessageDigest.getInstance(this.params.hashAlgorithm);
        this.K = sessionDigest.digest(S.toByteArray());
        if (log.isTraceEnabled()) {
            log.trace("K: " + Util.tob64(this.K));
        }
        this.clientHash.update(this.K);
        byte[] M1 = this.clientHash.digest();
        if (log.isTraceEnabled()) {
            log.trace("M1: H[H(N) xor H(g) | H(U) | s | A | B | K]: " + Util.tob64(M1));
        }
        this.serverHash.update(M1);
        this.serverHash.update(this.K);
        if (log.isTraceEnabled()) {
            MessageDigest tmp = Util.copy(this.serverHash);
            log.trace("H[A | M1 | K]: " + Util.tob64(tmp.digest()));
        }
        return M1;
    }

    public boolean verify(byte[] M2) {
        byte[] myM2 = this.serverHash.digest();
        boolean valid = Arrays.equals(M2, myM2);
        if (log.isTraceEnabled()) {
            log.trace("verify serverM2: " + Util.tob64(M2));
            log.trace("verify M2: " + Util.tob64(myM2));
        }
        return valid;
    }

    public byte[] getSessionKey() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            SRPPermission p = new SRPPermission("getSessionKey");
            sm.checkPermission(p);
        }
        return this.K;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

