/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.propertyeditor;

import [Ljava.lang.Class;;
import [Ljava.lang.String;;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.util.propertyeditor.ClassArrayEditor;
import org.jboss.util.propertyeditor.IntArrayEditor;
import org.jboss.util.propertyeditor.StringArrayEditor;

public class PropertyEditors {
    private static Logger log = Logger.getLogger(PropertyEditors.class);

    public static PropertyEditor findEditor(Class type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static PropertyEditor findEditor(String typeName) throws ClassNotFoundException {
        Class<?> type = Classes.getPrimitiveTypeForName(typeName);
        if (type == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            type = loader.loadClass(typeName);
        }
        return PropertyEditorManager.findEditor(type);
    }

    public static PropertyEditor getEditor(Class type) {
        PropertyEditor editor = PropertyEditors.findEditor(type);
        if (editor == null) {
            throw new RuntimeException("No property editor for type: " + type);
        }
        return editor;
    }

    public static PropertyEditor getEditor(String typeName) throws ClassNotFoundException {
        PropertyEditor editor = PropertyEditors.findEditor(typeName);
        if (editor == null) {
            throw new RuntimeException("No property editor for type: " + typeName);
        }
        return editor;
    }

    public static void registerEditor(Class type, Class editorType) {
        PropertyEditorManager.registerEditor(type, editorType);
    }

    public static void registerEditor(String typeName, String editorTypeName) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> type = loader.loadClass(typeName);
        Class<?> editorType = loader.loadClass(editorTypeName);
        PropertyEditorManager.registerEditor(type, editorType);
    }

    public static Object convertValue(String text, String typeName) throws ClassNotFoundException, IntrospectionException {
        PropertyEditor editor;
        Class<?> typeClass = Classes.getPrimitiveTypeForName(typeName);
        if (typeClass == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            typeClass = loader.loadClass(typeName);
        }
        if ((editor = PropertyEditorManager.findEditor(typeClass)) == null) {
            throw new IntrospectionException("No property editor for type=" + typeClass);
        }
        editor.setAsText(text);
        return editor.getValue();
    }

    public static void mapJavaBeanProperties(Object bean, Properties beanProps) throws IntrospectionException {
        HashMap<String, PropertyDescriptor> propertyMap = new HashMap<String, PropertyDescriptor>();
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        for (int p = 0; p < props.length; ++p) {
            String fieldName = props[p].getName();
            propertyMap.put(fieldName, props[p]);
        }
        boolean trace = log.isTraceEnabled();
        Iterator<Object> keys = beanProps.keySet().iterator();
        if (trace) {
            log.trace("Mapping properties for bean: " + bean);
        }
        while (keys.hasNext()) {
            String name = (String)keys.next();
            String text = beanProps.getProperty(name);
            PropertyDescriptor pd = (PropertyDescriptor)propertyMap.get(name);
            if (pd == null) {
                if (name.length() > 1) {
                    char first = name.charAt(0);
                    String exName = Character.toUpperCase(first) + name.substring(1);
                    pd = (PropertyDescriptor)propertyMap.get(exName);
                }
                if (pd == null) {
                    String msg = "No property found for: " + name + " on JavaBean: " + bean;
                    throw new IntrospectionException(msg);
                }
            }
            Method setter = pd.getWriteMethod();
            if (trace) {
                log.trace("Property editor found for: " + name + ", editor: " + pd + ", setter: " + setter);
            }
            if (setter == null) continue;
            Class<?> ptype = pd.getPropertyType();
            PropertyEditor editor = PropertyEditorManager.findEditor(ptype);
            if (editor == null && trace) {
                log.trace("Failed to find property editor for: " + name);
            }
            try {
                editor.setAsText(text);
                Object[] args = new Object[]{editor.getValue()};
                setter.invoke(bean, args);
            }
            catch (Exception e) {
                if (!trace) continue;
                log.trace("Failed to write property", e);
            }
        }
    }

    public String[] getEditorSearchPath() {
        return PropertyEditorManager.getEditorSearchPath();
    }

    public void setEditorSearchPath(String[] path) {
        PropertyEditorManager.setEditorSearchPath(path);
    }

    static {
        String[] currentPath = PropertyEditorManager.getEditorSearchPath();
        int length = currentPath != null ? currentPath.length : 0;
        String[] newPath = new String[length + 2];
        System.arraycopy(currentPath, 0, newPath, 2, length);
        newPath[0] = "org.jboss.util.propertyeditor";
        newPath[1] = "org.jboss.mx.util.propertyeditor";
        PropertyEditorManager.setEditorSearchPath(newPath);
        Class strArrayType = String;.class;
        PropertyEditorManager.registerEditor(strArrayType, StringArrayEditor.class);
        Class clsArrayType = Class;.class;
        PropertyEditorManager.registerEditor(clsArrayType, ClassArrayEditor.class);
        Class intArrayType = [I.class;
        PropertyEditorManager.registerEditor(intArrayType, IntArrayEditor.class);
    }
}

