/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.collection;

import fr.improve.struts.taglib.layout.util.LayoutUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class CollectionsIterator {
    private Iterator mainIterator;
    private String id;
    private String indexId;
    private String property;
    private int index = 0;
    private CollectionsIterator nestedIterator;

    public CollectionsIterator(Object in_bean, String in_property, String in_id, String in_indexId) throws JspException {
        Object lc_collection = in_bean;
        if (in_bean != null) {
            lc_collection = LayoutUtils.getProperty(in_bean, in_property);
            this.mainIterator = LayoutUtils.getCollection(lc_collection).iterator();
        }
        this.id = in_id;
        this.property = in_property;
        this.indexId = in_indexId;
    }

    public void addLastIterator(CollectionsIterator in_iterator) {
        if (this.nestedIterator == null) {
            this.nestedIterator = in_iterator;
        } else {
            this.nestedIterator.addLastIterator(in_iterator);
        }
    }

    public boolean hasNext(PageContext in_pageContext) {
        if (this.mainIterator != null && this.mainIterator.hasNext() || this.nestedIterator != null && this.nestedIterator.hasNext(in_pageContext)) {
            return true;
        }
        if (this.id != null) {
            in_pageContext.removeAttribute(this.id);
        }
        if (this.indexId != null) {
            in_pageContext.removeAttribute(this.indexId);
        }
        return false;
    }

    private boolean isInitialized() {
        return this.mainIterator != null;
    }

    protected boolean hasNestedIterator() {
        return this.nestedIterator != null;
    }

    public Object next(PageContext in_pageContext, Map out_changes) throws JspException {
        return this.next(in_pageContext, out_changes, true);
    }

    private Object next(PageContext in_pageContext, Map out_changes, boolean in_increment) throws JspException {
        if (this.nestedIterator == null) {
            Object lc_bean = this.mainIterator.next();
            if (this.id != null) {
                in_pageContext.setAttribute(this.id, lc_bean);
                out_changes.put(this.id, new Integer(1));
            }
            if (this.indexId != null) {
                in_pageContext.setAttribute(this.indexId, (Object)new Integer(this.index));
            }
            if (in_increment) {
                ++this.index;
            }
            return lc_bean;
        }
        if (this.nestedIterator.hasNext(in_pageContext)) {
            this.nestedIterator.next(in_pageContext, out_changes, in_increment);
            return null;
        }
        Object lc_bean = this.mainIterator.next();
        int lc_span = 1;
        lc_span = this.nestedIterator.reset(in_pageContext, lc_bean);
        if (this.nestedIterator.hasNext(in_pageContext)) {
            this.nestedIterator.next(in_pageContext, out_changes, in_increment);
        } else {
            this.nestedIterator.emptyNext(in_pageContext, out_changes);
        }
        if (this.id != null) {
            in_pageContext.setAttribute(this.id, lc_bean);
            out_changes.put(this.id, new Integer(lc_span));
        }
        if (this.indexId != null) {
            in_pageContext.setAttribute(this.indexId, (Object)new Integer(this.index));
        }
        if (in_increment) {
            ++this.index;
        }
        return lc_bean;
    }

    public void skip(PageContext in_pageContext, Map out_changes) throws JspException {
        this.next(in_pageContext, out_changes, false);
    }

    private void emptyNext(PageContext in_pg, Map out_changes) {
        if (this.nestedIterator == null) {
            if (this.id != null) {
                in_pg.removeAttribute(this.id);
                out_changes.put(this.id, new Integer(1));
            }
        } else {
            throw new IllegalStateException("Case not implemented");
        }
    }

    private int reset(PageContext in_pg, Object in_bean) throws JspException {
        Collection lc_collection = LayoutUtils.getCollection(LayoutUtils.getProperty(in_bean, this.property));
        if (lc_collection == null) {
            lc_collection = Collections.EMPTY_LIST;
        }
        this.mainIterator = lc_collection.iterator();
        this.index = 0;
        if (this.indexId != null) {
            in_pg.removeAttribute(this.indexId);
        }
        if (this.nestedIterator == null) {
            return lc_collection.size();
        }
        return this.nestedIterator.computeLength(lc_collection);
    }

    private int computeLength(Collection in_collection) throws JspException {
        Iterator lc_it = in_collection.iterator();
        int lc_length = 0;
        while (lc_it.hasNext()) {
            Object lc_bean = lc_it.next();
            Collection lc_collection = LayoutUtils.getCollection(LayoutUtils.getProperty(lc_bean, this.property));
            if (this.nestedIterator == null) {
                int lc_size = lc_collection.size();
                lc_length += lc_size > 1 ? lc_size : 1;
                continue;
            }
            lc_length += this.nestedIterator.computeLength(lc_collection);
        }
        return lc_length;
    }

    public int getIndex() {
        return this.index;
    }
}

