/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.crumb;

import fr.improve.struts.taglib.layout.PanelTag;
import fr.improve.struts.taglib.layout.crumb.Crumb;
import fr.improve.struts.taglib.layout.event.EndLayoutEvent;
import fr.improve.struts.taglib.layout.event.StartLayoutEvent;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.apache.struts.util.ResponseUtils;

public class CrumbsTag
extends PanelTag {
    protected boolean needSeparator = false;
    protected int level = 0;
    protected String separator = "|";
    protected String separatorClass;
    protected String separatorWidth;
    protected String separatorHeight;
    protected String separatorDivTag;
    protected String crumbsName;
    protected String crumbsProperty;

    public int doEndTag() throws JspException {
        StringBuffer buffer = new StringBuffer();
        if (this.crumbsName != null && this.crumbsName.length() != 0) {
            Iterator lc_iterator = LayoutUtils.getIterator(this.pageContext, this.crumbsName, this.crumbsProperty);
            while (lc_iterator.hasNext()) {
                Crumb lc_crumb = (Crumb)lc_iterator.next();
                this.printCrumb(buffer, lc_crumb);
            }
        }
        buffer.append("</td></tr>");
        this.doAfterBody(buffer);
        this.doEndPanel(buffer);
        ResponseUtils.write((PageContext)this.pageContext, (String)buffer.toString());
        new EndLayoutEvent((Tag)this, null).send();
        this.needSeparator = false;
        this.level = 0;
        return 6;
    }

    public int doStartTag() throws JspException {
        new StartLayoutEvent((Tag)this, null).send();
        StringBuffer buffer = new StringBuffer();
        this.doStartPanel(buffer);
        this.doPrintTitle(buffer);
        this.doBeforeBody(buffer);
        buffer.append("<tr><td>");
        ResponseUtils.write((PageContext)this.pageContext, (String)buffer.toString());
        return 1;
    }

    public int getLevel() {
        return this.level;
    }

    public String getSeparator() {
        if (this.separatorClass == null) {
            return this.separator;
        }
        if (this.separatorDivTag == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<div class=\"");
            buffer.append(this.separatorClass);
            buffer.append("\" width=\"");
            buffer.append(this.separatorWidth);
            buffer.append("\" height=\"");
            buffer.append(this.separatorHeight);
            buffer.append("\">&nbsp</div>");
            this.separatorDivTag = buffer.toString();
        }
        return this.separatorDivTag;
    }

    public void printCrumb(StringBuffer in_buffer, Crumb in_crumb) throws JspException {
        String lc_styleClass;
        if (this.needSeparator()) {
            in_buffer.append("&nbsp;");
            in_buffer.append(this.getSeparator());
            in_buffer.append("&nbsp;");
        }
        if ((lc_styleClass = this.getStyleClass()) != null) {
            lc_styleClass = lc_styleClass + this.getLevel();
        }
        in_buffer.append("<a");
        if (in_crumb.getLink() != null) {
            in_buffer.append(" href=\"");
            in_buffer.append(((HttpServletRequest)this.pageContext.getRequest()).getContextPath());
            in_buffer.append(in_crumb.getLink());
            in_buffer.append("\"");
            if (in_crumb.getTarget() != null) {
                in_buffer.append(" target=\"");
                in_buffer.append(in_crumb.getTarget());
                in_buffer.append("\"");
            }
        }
        if (lc_styleClass != null) {
            in_buffer.append(" class=\"");
            in_buffer.append(lc_styleClass);
            in_buffer.append("\"");
        }
        in_buffer.append(">");
        String lc_bundle = in_crumb.getBundle();
        if (lc_bundle == null) {
            lc_bundle = this.bundle;
        }
        in_buffer.append(LayoutUtils.getLabel(this.pageContext, lc_bundle, in_crumb.getKey(), null, false));
        in_buffer.append("</a>");
    }

    public String getSeparatorClass() {
        return this.separatorClass;
    }

    public String getSeparatorHeight() {
        return this.separatorHeight;
    }

    public String getSeparatorWidth() {
        return this.separatorWidth;
    }

    public boolean needSeparator() {
        boolean value = this.needSeparator;
        this.needSeparator = true;
        ++this.level;
        return value;
    }

    public void release() {
        super.release();
        this.needSeparator = false;
        this.level = 0;
        this.separatorClass = null;
        this.separatorHeight = null;
        this.separatorWidth = null;
        this.separatorDivTag = null;
        this.crumbsName = null;
        this.crumbsProperty = null;
    }

    public void setSeparator(String newSeparator) {
        this.separator = newSeparator;
    }

    public void setSeparatorClass(String newSeparatorClass) {
        this.separatorClass = newSeparatorClass;
    }

    public void setSeparatorHeight(String newSeparatorHeight) {
        this.separatorHeight = newSeparatorHeight;
    }

    public void setSeparatorWidth(String newSeparatorWidth) {
        this.separatorWidth = newSeparatorWidth;
    }

    public String getCrumbsName() {
        return this.crumbsName;
    }

    public void setCrumbsName(String crumbsName) {
        this.crumbsName = crumbsName;
    }

    public String getCrumbsProperty() {
        return this.crumbsProperty;
    }

    public void setCrumbsProperty(String crumbsProperty) {
        this.crumbsProperty = crumbsProperty;
    }
}

