/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.field;

import fr.improve.struts.taglib.layout.field.AbstractFieldTag;
import fr.improve.struts.taglib.layout.formatter.FormatException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.struts.taglib.html.BaseHandlerTag;
import org.apache.struts.taglib.html.TextTag;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.util.ResponseUtils;

public class TextFieldTag
extends AbstractFieldTag {
    private TextTag textFieldTag = new TextTag();
    protected String format;
    protected String editFormat;

    protected boolean doBeforeValue() throws JspException {
        this.fieldTag = this.textFieldTag;
        return true;
    }

    protected Object getFieldValue() throws JspException {
        Object lc_value = super.getFieldValue();
        if (lc_value != null) {
            switch (this.getFieldDisplayMode()) {
                case 2: {
                    if (this.editFormat == null) break;
                    try {
                        lc_value = this.getSkin().getFormatter().format(lc_value, this.editFormat, this.pageContext);
                        break;
                    }
                    catch (FormatException fe) {
                        RequestUtils.saveException((PageContext)this.pageContext, (Throwable)fe);
                        throw new JspException("Format " + this.editFormat + "failed: " + fe.getMessage());
                    }
                }
                default: {
                    if (this.format == null) break;
                    try {
                        lc_value = this.getSkin().getFormatter().format(lc_value, this.format, this.pageContext);
                        break;
                    }
                    catch (FormatException fe) {
                        RequestUtils.saveException((PageContext)this.pageContext, (Throwable)fe);
                        throw new JspException("Format " + this.format + "failed: " + fe.getMessage());
                    }
                }
            }
        }
        return lc_value;
    }

    public int doStartInspectField() throws JspException {
        if (!this.doBeforeValue()) {
            return 0;
        }
        Object lc_value = this.getFieldValue();
        if (lc_value != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<span class=\"");
            buffer.append(this.styleClass);
            buffer.append("\">");
            if (this.format == null) {
                if (this.filter) {
                    buffer.append(ResponseUtils.filter((String)lc_value.toString()));
                } else {
                    buffer.append(lc_value.toString());
                }
            } else {
                buffer.append(lc_value);
            }
            buffer.append("</span>");
            ResponseUtils.write((PageContext)this.pageContext, (String)buffer.toString());
        }
        this.doAfterValue();
        return 1;
    }

    public void release() {
        super.release();
        this.format = null;
        this.editFormat = null;
    }

    public void setType(String type) {
        this.format = type;
    }

    public void setEditType(String type) {
        this.editFormat = type;
    }

    public String getType() {
        return this.format;
    }

    protected void copyProperties(BaseHandlerTag in_dest) throws JspException {
        super.copyProperties(in_dest);
        this.textFieldTag.setCols(this.getCols());
        this.textFieldTag.setMaxlength(this.getMaxlength());
        this.textFieldTag.setProperty(this.getProperty());
        this.textFieldTag.setRows(this.getRows());
        this.textFieldTag.setValue(this.getValue());
        this.textFieldTag.setAccept(this.getAccept());
        this.textFieldTag.setName(this.getName());
    }
}

