/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.pager;

import fr.improve.struts.taglib.layout.collection.CollectionTag;
import fr.improve.struts.taglib.layout.event.EndLayoutEvent;
import fr.improve.struts.taglib.layout.event.LayoutEventListener;
import fr.improve.struts.taglib.layout.event.StartLayoutEvent;
import fr.improve.struts.taglib.layout.pager.PagerContainer;
import fr.improve.struts.taglib.layout.pager.PagerStatusEvent;
import fr.improve.struts.taglib.layout.pager.PagerStatusListener;
import fr.improve.struts.taglib.layout.skin.Skin;
import fr.improve.struts.taglib.layout.sort.SortUtil;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.util.ResponseUtils;

public class PagerTag
extends TagSupport
implements LayoutEventListener,
PagerStatusListener {
    public static final String PAGE_NUMBER_KEY = "pagerPage";
    protected static final String PAGER_INDEX = "fr.improve.struts.taglib.layout.pager.PagerTag.PAGER_INDEX";
    protected static final String PAGER_INDEX_CURRENT_PAGE = "fr.improve.struts.taglib.layout.pager.PagerTag.PAGER_INDEX_CURRENT_PAGE";
    protected static final String BOTTOM = "bottom";
    protected static final String TOP = "top";
    protected static final String BOTH = "both";
    protected String url;
    protected String maxPageItems = "10";
    protected int size;
    protected int numberOfPage;
    protected String linksLocation = "bottom";
    private String pagerId = null;
    protected String previousMsgKey = "layout.pager.previous.label";
    protected String nextMsgKey = "layout.pager.next.label";
    protected String previousImgKey = "layout.pager.previous.img";
    protected String nextImgKey = "layout.pager.next.img";
    protected String width;
    protected String styleClass;

    public Object processPagerStatusEvent(PagerStatusEvent in_event) throws JspException {
        Integer[] lc_infos = new Integer[]{new Integer(this.getCurrentPage()), new Integer(this.numberOfPage), new Integer(this.size), new Integer(this.maxPageItems)};
        return lc_infos;
    }

    public Object processStartLayoutEvent(StartLayoutEvent in_event) throws JspException {
        Tag lc_source = in_event.getSource();
        if (lc_source instanceof PagerContainer) {
            PagerContainer lc_pagerContainer = (PagerContainer)lc_source;
            lc_pagerContainer.setOffset(this.getIndexFirstItem());
            lc_pagerContainer.setLength(this.getIndexLastItem() - this.getIndexFirstItem());
            ((CollectionTag)lc_pagerContainer).setSortType(4);
            if (TOP.equalsIgnoreCase(this.getLinksLocation()) || BOTH.equalsIgnoreCase(this.getLinksLocation())) {
                new StartLayoutEvent((Tag)this, null).send();
                StringBuffer lc_pagerAnchor = new StringBuffer();
                lc_pagerAnchor.append("<td colspan=\"");
                lc_pagerAnchor.append(String.valueOf(LayoutUtils.getSkin(this.pageContext.getSession()).getFieldInterface().getColumnNumber()));
                if (this.styleClass != null) {
                    lc_pagerAnchor.append("\" class=\"");
                    lc_pagerAnchor.append(this.styleClass);
                }
                lc_pagerAnchor.append("\"><a id=\"");
                lc_pagerAnchor.append(this.pagerId + "Anchor");
                lc_pagerAnchor.append("\"/></td>");
                ResponseUtils.write((PageContext)this.pageContext, (String)lc_pagerAnchor.toString());
                new EndLayoutEvent((Tag)this, null).send();
            }
        }
        return in_event.sendToParent((Tag)this);
    }

    public Object processEndLayoutEvent(EndLayoutEvent in_event) throws JspException {
        Tag lc_source = in_event.getSource();
        boolean lc_printPager = false;
        if (lc_source instanceof PagerContainer) {
            PagerContainer lc_pagerContainerTag = (PagerContainer)lc_source;
            this.setSize(lc_pagerContainerTag.getSize());
            this.url = SortUtil.getURLForCollection("", (HttpServletRequest)this.pageContext.getRequest());
            lc_printPager = true;
        }
        if (lc_printPager) {
            StringBuffer sb = new StringBuffer();
            this.doPrintTag(sb);
            ResponseUtils.write((PageContext)this.pageContext, (String)sb.toString());
            if (TOP.equalsIgnoreCase(this.getLinksLocation()) || BOTH.equalsIgnoreCase(this.getLinksLocation())) {
                StringBuffer js = new StringBuffer();
                js.append("<script>");
                js.append("document.getElementById('");
                js.append(this.pagerId + "Anchor");
                js.append("').parentNode.insertBefore(document.getElementById('");
                js.append(this.pagerId);
                js.append("').cloneNode(true), document.getElementById('");
                js.append(this.pagerId + "Anchor");
                js.append("'));");
                js.append("document.getElementById('");
                js.append(this.pagerId);
                js.append("').setAttribute('id','");
                js.append(this.pagerId + "Top");
                js.append("');");
                if (TOP.equalsIgnoreCase(this.getLinksLocation())) {
                    js.append("document.getElementById('");
                    js.append(this.pagerId);
                    js.append("').parentNode.removeChild(document.getElementById('");
                    js.append(this.pagerId);
                    js.append("'));");
                }
                js.append("</script>");
                ResponseUtils.write((PageContext)this.pageContext, (String)js.toString());
            }
        }
        return in_event.sendToParent((Tag)this);
    }

    public int doEndTag() throws JspException {
        this.url = null;
        this.size = 0;
        this.numberOfPage = 0;
        return 6;
    }

    public int doStartTag() throws JspException {
        this.pagerId = "pager" + new Date().getTime();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.addIndex();
        return 1;
    }

    protected void addIndex() {
        String l_index = (String)this.pageContext.getAttribute(PAGER_INDEX);
        l_index = l_index == null ? new String("0") : String.valueOf(Integer.parseInt(l_index) + 1);
        this.pageContext.setAttribute(PAGER_INDEX, (Object)l_index);
    }

    public void release() {
        this.styleClass = null;
        this.maxPageItems = "10";
        this.linksLocation = BOTTOM;
        this.pagerId = null;
        super.release();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String newUrl) {
        this.url = newUrl;
    }

    public String getMaxPageItems() {
        return this.maxPageItems;
    }

    public void setMaxPageItems(String in_maxPageItems) throws JspException {
        String l_errorMessageNumber = "PagerTag : invalid attribut : maxPageItems should be a number";
        String l_errorMessageNumberBiggerThanOne = "PagerTat : invalid attribut : maxPageItems should be a number bigger than 0";
        try {
            int l_maxPageItems = Integer.parseInt(in_maxPageItems);
            if (l_maxPageItems < 1) {
                throw new JspException(l_errorMessageNumberBiggerThanOne);
            }
        }
        catch (NumberFormatException enfe) {
            throw new JspException(l_errorMessageNumber);
        }
        this.maxPageItems = in_maxPageItems;
    }

    protected String getPagerIndex() {
        return (String)this.pageContext.getAttribute(PAGER_INDEX);
    }

    protected Integer getCurrentPagePagerIndex(String in_pagerIndex) {
        return (Integer)this.pageContext.getSession().getAttribute(((HttpServletRequest)this.pageContext.getRequest()).getServletPath() + PAGER_INDEX_CURRENT_PAGE + in_pagerIndex);
    }

    protected void setCurrentPagePagerIndex(String in_pagerIndex, int in_currentPage) {
        this.pageContext.getSession().setAttribute(((HttpServletRequest)this.pageContext.getRequest()).getServletPath() + PAGER_INDEX_CURRENT_PAGE + in_pagerIndex, (Object)new Integer(in_currentPage));
    }

    protected int getCurrentPage() {
        Integer lc_integerPossibleValue;
        String l_pagerIndex = this.getPagerIndex();
        String l_collectionIndex = this.pageContext.getRequest().getParameter("layoutCollection");
        if (l_collectionIndex == null) {
            return 0;
        }
        if (!l_pagerIndex.equals(l_collectionIndex)) {
            if (this.getCurrentPagePagerIndex(l_pagerIndex) != null) {
                return this.getCurrentPagePagerIndex(l_pagerIndex);
            }
            return 0;
        }
        int lc_currentPage = -1;
        String lc_possibleValue = this.pageContext.getRequest().getParameter(PAGE_NUMBER_KEY);
        if (lc_possibleValue != null) {
            try {
                lc_currentPage = Integer.parseInt(lc_possibleValue);
            }
            catch (NumberFormatException nfe) {}
        } else if (lc_currentPage == -1 && (lc_integerPossibleValue = (Integer)this.pageContext.getRequest().getAttribute(PAGE_NUMBER_KEY)) != null) {
            lc_currentPage = lc_integerPossibleValue;
        }
        if (lc_currentPage == -1) {
            lc_currentPage = 0;
        }
        this.setCurrentPagePagerIndex(l_pagerIndex, lc_currentPage);
        return lc_currentPage;
    }

    protected String getURL(int in_page) {
        String l_url = this.url;
        l_url = l_url.indexOf("?") == -1 ? l_url + "?" : l_url + "&";
        l_url = l_url + PAGE_NUMBER_KEY;
        l_url = l_url + "=";
        l_url = l_url + in_page;
        return l_url;
    }

    public int getIndexFirstItem() {
        int l_currentPage = this.getCurrentPage();
        int l_maxPageItems = Integer.parseInt(this.maxPageItems);
        return l_currentPage * l_maxPageItems;
    }

    public int getIndexLastItem() {
        int l_currentPage = this.getCurrentPage();
        int l_maxPageItems = Integer.parseInt(this.maxPageItems);
        return (l_currentPage + 1) * l_maxPageItems;
    }

    public void setSize(int in_size) {
        this.size = in_size;
    }

    public void doPrintTag(StringBuffer in_buffer) throws JspException {
        int l_maxPageItems = Integer.parseInt(this.maxPageItems);
        int l_currentPage = this.getCurrentPage();
        Skin lc_skin = LayoutUtils.getSkin(this.pageContext.getSession());
        if (this.size < l_maxPageItems) {
            return;
        }
        in_buffer.append("<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\"");
        if (this.width != null) {
            in_buffer.append(" width=\"");
            in_buffer.append(this.width);
            in_buffer.append("\"");
        }
        if (this.styleClass != null) {
            in_buffer.append(" class=\"");
            in_buffer.append(this.styleClass);
            in_buffer.append("\"");
        }
        in_buffer.append(" id=\"");
        in_buffer.append(this.pagerId);
        in_buffer.append("\"><tr>\n");
        this.doPrintPrevious(in_buffer, l_currentPage, lc_skin);
        this.doPrintMain(in_buffer, l_maxPageItems, l_currentPage);
        this.doPrintNext(in_buffer, l_maxPageItems, l_currentPage, lc_skin);
        in_buffer.append("</tr></table>");
    }

    protected void doPrintNext(StringBuffer in_buffer, int l_maxPageItems, int l_currentPage, Skin lc_skin) {
        in_buffer.append("<td width=\"50%\" style=\"text-align : left\"");
        if (this.styleClass != null) {
            in_buffer.append(" class='");
            in_buffer.append(this.styleClass);
            in_buffer.append("'");
        }
        in_buffer.append(">");
        if ((l_currentPage + 1) * l_maxPageItems < this.size) {
            in_buffer.append("<a href=\"");
            in_buffer.append(this.getURL(l_currentPage + 1));
            in_buffer.append("\">");
            String lc_nextImgPath = lc_skin.getProperty(this.nextImgKey);
            String lc_nextLabel = lc_skin.getProperty(this.nextMsgKey);
            if (lc_nextImgPath == null || lc_nextImgPath.length() == 0) {
                in_buffer.append(lc_nextLabel);
            } else {
                in_buffer.append("<img src='");
                in_buffer.append(lc_skin.getImageDirectory(this.pageContext.getRequest()));
                in_buffer.append("/");
                in_buffer.append(lc_nextImgPath);
                in_buffer.append("' border='0' alt='");
                in_buffer.append(lc_nextLabel);
                in_buffer.append("'>");
            }
            in_buffer.append("</a>");
        }
        in_buffer.append("</td>\n");
    }

    protected void doPrintMain(StringBuffer in_buffer, int l_maxPageItems, int l_currentPage) {
        in_buffer.append("<td ");
        if (this.styleClass != null) {
            in_buffer.append(" class='");
            in_buffer.append(this.styleClass);
            in_buffer.append("'");
        }
        in_buffer.append(">");
        int i = 0;
        while (this.size > l_maxPageItems * i) {
            if (i != l_currentPage) {
                in_buffer.append("<a href=\"");
                in_buffer.append(this.getURL(i));
                if (this.styleClass != null) {
                    in_buffer.append("\" class=\"");
                    in_buffer.append(this.styleClass);
                }
                in_buffer.append("\">");
            }
            in_buffer.append(i + 1);
            if (i != l_currentPage) {
                in_buffer.append("</a>");
            }
            in_buffer.append("&nbsp;");
            ++i;
        }
        this.numberOfPage = i;
        in_buffer.append("</td>\n");
    }

    protected void doPrintPrevious(StringBuffer in_buffer, int l_currentPage, Skin lc_skin) {
        in_buffer.append("<td width=\"50%\" style=\"text-align : right\"");
        if (this.styleClass != null) {
            in_buffer.append(" class='");
            in_buffer.append(this.styleClass);
            in_buffer.append("'");
        }
        in_buffer.append(">");
        if (l_currentPage >= 1) {
            in_buffer.append("<a href=\"");
            in_buffer.append(this.getURL(l_currentPage - 1));
            in_buffer.append("\">");
            String lc_previousImgPath = lc_skin.getProperty(this.previousImgKey);
            String lc_previousLabel = lc_skin.getProperty(this.previousMsgKey);
            if (lc_previousImgPath == null || lc_previousImgPath.length() == 0) {
                in_buffer.append(lc_previousLabel);
            } else {
                in_buffer.append("<img src='");
                in_buffer.append(lc_skin.getImageDirectory(this.pageContext.getRequest()));
                in_buffer.append("/");
                in_buffer.append(lc_previousImgPath);
                in_buffer.append("' border='0' alt='");
                in_buffer.append(lc_previousLabel);
                in_buffer.append("'>");
            }
            in_buffer.append("</a>");
        }
        in_buffer.append("</td>\n");
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public final String getLinksLocation() {
        return this.linksLocation;
    }

    public final void setLinksLocation(String linksLocation) {
        this.linksLocation = linksLocation;
    }

    public final String getPagerId() {
        return this.pagerId;
    }
}

