/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.skin;

import fr.improve.struts.taglib.layout.formatter.AbstractFormatter;
import fr.improve.struts.taglib.layout.policy.AbstractPolicy;
import fr.improve.struts.taglib.layout.skin.BadSkinConfigurationException;
import fr.improve.struts.taglib.layout.util.FieldInterface;
import fr.improve.struts.taglib.layout.util.FormUtilsInterface;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class Skin {
    public static final String CSS_FILE = "skin";
    public static final String IMAGE_DIR = "directory.images";
    public static final String CONFIG_DIR = "directory.config";
    public static final String NULL_FIELDS = "display.null.fields";
    public static final String PANEL_CLASS = "panel.class";
    public static final String COLLECTION_CLASS = "collection.class";
    public static final String TABS_CLASS = "tabs.class";
    public static final String FIELD_CLASS = "field.class";
    public static final String FORMATTER_CLASS = "formatter.class";
    public static final String POLICY_CLASS = "policy.class";
    public static final String FOLLOW_LINKS_IF_CHANGED = "follow.change";
    public static final String DISPLAY_ERRORS_MESSAGE = "error.display";
    public static final String SORT_TOKEN_REQUIRED = "sort.token.required";
    public static final String LINK_TOKEN_INCLUDE = "link.token.include";
    public static final String FORMUTIL_CLASSS = "formutils.class";
    public static final String TREE_NUMBER_MENUS_LOADED = "tree.numberOfMenusLoaded";
    private static String resourcesName = "Struts-Layout";
    private static Map skins = new Hashtable();
    private ResourceBundle resources;
    private ResourceBundle defaultResources;
    private Locale locale;
    private AbstractFormatter formatter;
    private AbstractPolicy policy;
    private FormUtilsInterface formutils;
    private String configDir;
    private String imageDir;
    private boolean sortTokenRequired;
    private boolean linkTokenRequired;
    private int numberOfMenusLoaded;
    private FieldInterface fieldInterface;

    public static void setResourcesName(String in_name) {
        resourcesName = in_name;
    }

    private Skin(String in_name, String in_locale) {
        this.locale = new Locale(in_name, in_locale);
        try {
            String lc_policyClass;
            this.resources = ResourceBundle.getBundle(resourcesName, this.locale);
            this.defaultResources = ResourceBundle.getBundle("Struts-Layout");
            String lc_formatterClass = this.getProperty(FORMATTER_CLASS);
            if (lc_formatterClass != null && lc_formatterClass.length() > 0) {
                this.formatter = (AbstractFormatter)Class.forName(lc_formatterClass).newInstance();
            }
            if ((lc_policyClass = this.getProperty(POLICY_CLASS)) != null && lc_policyClass.length() > 0) {
                this.policy = (AbstractPolicy)Class.forName(lc_policyClass).newInstance();
            }
            String lc_fieldInterfaceClass = this.getProperty(FIELD_CLASS);
            this.fieldInterface = (FieldInterface)Class.forName(lc_fieldInterfaceClass).newInstance();
            String lc_formUtilsClass = this.getProperty(FORMUTIL_CLASSS);
            this.formutils = (FormUtilsInterface)Class.forName(lc_formUtilsClass).newInstance();
            this.configDir = this.getProperty(CONFIG_DIR);
            this.imageDir = this.getProperty(IMAGE_DIR);
            this.sortTokenRequired = Boolean.valueOf(this.getProperty(SORT_TOKEN_REQUIRED));
            this.linkTokenRequired = Boolean.valueOf(this.getProperty(LINK_TOKEN_INCLUDE));
            this.numberOfMenusLoaded = Integer.valueOf(this.getProperty(TREE_NUMBER_MENUS_LOADED));
        }
        catch (MissingResourceException e) {
            throw new BadSkinConfigurationException(e);
        }
        catch (ClassNotFoundException cnfe) {
            throw new BadSkinConfigurationException(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new BadSkinConfigurationException(iae);
        }
        catch (InstantiationException ie) {
            throw new BadSkinConfigurationException(ie);
        }
        catch (ClassCastException cce) {
            throw new BadSkinConfigurationException(cce);
        }
    }

    public static Skin getSkin(String in_name, String in_locale) {
        Skin lc_skin = (Skin)skins.get(in_name + "_" + in_locale);
        if (lc_skin == null) {
            lc_skin = new Skin(in_name, in_locale);
            skins.put(in_name + "_" + in_locale, lc_skin);
        }
        return lc_skin;
    }

    public String getImageDirectory(ServletRequest in_request) {
        HttpServletRequest lc_request = (HttpServletRequest)in_request;
        if (this.imageDir.charAt(0) == '/') {
            return this.imageDir;
        }
        return lc_request.getContextPath() + '/' + this.imageDir;
    }

    public void setImageDir(String in_imageDir) {
        this.imageDir = in_imageDir;
    }

    public String getConfigDirectory(ServletRequest in_request) {
        HttpServletRequest lc_request = (HttpServletRequest)in_request;
        if (this.configDir.charAt(0) == '/') {
            return this.configDir;
        }
        return lc_request.getContextPath() + '/' + this.configDir;
    }

    public void setConfigDir(String in_configDir) {
        this.configDir = in_configDir;
    }

    public boolean getDisplayNullFields() {
        return "true".equalsIgnoreCase(this.getProperty(NULL_FIELDS));
    }

    public boolean getFollowLinkIfFormChanged() {
        return "true".equalsIgnoreCase(this.getProperty(FOLLOW_LINKS_IF_CHANGED));
    }

    public boolean getDisplayErrorMessage() {
        return "true".equalsIgnoreCase(this.getProperty(DISPLAY_ERRORS_MESSAGE));
    }

    public String getName() {
        return this.locale.getLanguage();
    }

    public String getLocale() {
        return this.locale.getCountry();
    }

    public String getCssFileName() {
        String lc_fileName = this.getProperty(CSS_FILE);
        if (lc_fileName == null || lc_fileName.length() == 0) {
            return this.getName() + ".css";
        }
        return this.getProperty(CSS_FILE);
    }

    public Class getPanelClass() {
        Class<?> lc_class = null;
        try {
            lc_class = Class.forName(this.getProperty(PANEL_CLASS));
        }
        catch (ClassNotFoundException e) {
            throw new BadSkinConfigurationException(e);
        }
        return lc_class;
    }

    public Class getCollectionClass(String in_model) {
        Class<?> lc_class = null;
        try {
            lc_class = in_model == null ? Class.forName(this.getProperty(COLLECTION_CLASS)) : Class.forName(this.getProperty("collection.class." + in_model));
        }
        catch (ClassNotFoundException e) {
            throw new BadSkinConfigurationException(e);
        }
        return lc_class;
    }

    public Class getTabsClass() {
        Class<?> lc_class = null;
        try {
            lc_class = Class.forName(this.getProperty(TABS_CLASS));
        }
        catch (ClassNotFoundException e) {
            throw new BadSkinConfigurationException(e);
        }
        return lc_class;
    }

    public FieldInterface getFieldInterface() {
        return this.getFieldInterface(null);
    }

    public FieldInterface getFieldInterface(String in_model) {
        if (in_model == null) {
            return this.fieldInterface;
        }
        FieldInterface lc_interface = null;
        try {
            Class<?> lc_class = Class.forName(this.getProperty("field.class." + in_model));
            lc_interface = (FieldInterface)lc_class.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new BadSkinConfigurationException(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new BadSkinConfigurationException(iae);
        }
        catch (InstantiationException ie) {
            throw new BadSkinConfigurationException(ie);
        }
        return lc_interface;
    }

    public AbstractFormatter getFormatter() {
        if (this.formatter == null) {
            throw new BadSkinConfigurationException("Null formatter");
        }
        return this.formatter;
    }

    public AbstractPolicy getPolicy() {
        if (this.policy == null) {
            throw new BadSkinConfigurationException("Null policy");
        }
        return this.policy;
    }

    public FormUtilsInterface getFormUtils() {
        return this.formutils;
    }

    public boolean isSortTokenRequired() {
        return this.sortTokenRequired;
    }

    public boolean isLinkTokenRequired() {
        return this.linkTokenRequired;
    }

    public String getProperty(String in_property) {
        String lc_value;
        try {
            lc_value = this.resources.getString(in_property);
        }
        catch (MissingResourceException mre) {
            lc_value = this.defaultResources.getString(in_property);
        }
        return lc_value;
    }

    public int getNumberOfMenusLoaded() {
        return this.numberOfMenusLoaded;
    }
}

