/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.sort;

import fr.improve.struts.taglib.layout.skin.Skin;
import fr.improve.struts.taglib.layout.sort.BeanComparator;
import fr.improve.struts.taglib.layout.sort.SortException;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class SortUtil
implements Serializable {
    public static final String SORT_UTIL_CLASS = "sortutil.class";
    public static final String SORTUTIL_KEY = "fr.improve.struts.taglib.layout.sort.SortUtil";
    public static final String SORTUTIL_COLLECTION = "layoutCollection";
    public static final String SORTUTIL_PROPERTY = "layoutCollectionProperty";
    protected Vector collections = new Vector();
    protected HashMap attributes = new HashMap();
    protected HashMap parameters = new HashMap();
    protected String url;
    protected int index = 0;
    protected int hashCode;

    public void initSortUtil(HttpServletRequest in_request, String in_url) {
        Object lc_key;
        Enumeration lc_enumeration = in_request.getParameterNames();
        while (lc_enumeration.hasMoreElements()) {
            lc_key = lc_enumeration.nextElement();
            this.parameters.put(lc_key, in_request.getParameter(lc_key.toString()));
        }
        lc_enumeration = in_request.getAttributeNames();
        while (lc_enumeration.hasMoreElements()) {
            lc_key = lc_enumeration.nextElement();
            this.attributes.put(lc_key, in_request.getAttribute(lc_key.toString()));
        }
        this.url = in_url;
    }

    public static void addCollection(Object in_list, HttpServletRequest in_request) {
        SortUtil lc_sortUtil = (SortUtil)in_request.getSession().getAttribute(SORTUTIL_KEY);
        if (lc_sortUtil == null || in_request.getAttribute("fr.improve.struts.taglib.layout.sort.SortUtilaaa") == null) {
            lc_sortUtil = SortUtil.createSortUtil(in_request);
            in_request.getSession().setAttribute(SORTUTIL_KEY, (Object)lc_sortUtil);
            in_request.setAttribute("fr.improve.struts.taglib.layout.sort.SortUtilaaa", (Object)"aaa");
        }
        lc_sortUtil.collections.add(in_list);
    }

    protected void buildRequest(HttpServletRequest in_request) {
        Iterator lc_iterator = this.attributes.keySet().iterator();
        while (lc_iterator.hasNext()) {
            Object lc_key = lc_iterator.next();
            in_request.setAttribute(lc_key.toString(), this.attributes.get(lc_key));
        }
    }

    protected String buildURL(HttpServletRequest in_request) {
        Iterator lc_iterator = this.parameters.keySet().iterator();
        StringBuffer lc_url = new StringBuffer(this.url);
        boolean hasParameter = this.url.indexOf(63) != -1;
        while (lc_iterator.hasNext()) {
            Object lc_key = lc_iterator.next();
            if ("pagerPage".equals(lc_key)) continue;
            if (hasParameter) {
                lc_url.append("&");
            } else {
                lc_url.append("?");
                hasParameter = true;
            }
            lc_url.append(LayoutUtils.encodeURL(lc_key.toString()));
            lc_url.append("=");
            Object lc_param = this.parameters.get(lc_key);
            if (lc_param == null) continue;
            lc_url.append(LayoutUtils.encodeURL(lc_param.toString()));
        }
        return lc_url.toString();
    }

    protected List getCollectionToSort(HttpServletRequest in_request) throws SortException {
        int lc_index;
        String lc_indexAsString = in_request.getParameter(SORTUTIL_COLLECTION);
        try {
            lc_index = Integer.parseInt(lc_indexAsString);
        }
        catch (NumberFormatException e) {
            throw new SortException("Impossible to find the collection to sort");
        }
        List lc_list = null;
        if (lc_index >= 0) {
            try {
                lc_list = (List)this.collections.get(lc_index);
            }
            catch (ClassCastException e) {
                throw new SortException("Impossible to sort a bean of type " + this.collections.get(lc_index).getClass());
            }
        }
        return lc_list;
    }

    protected String getPropertyToSort(HttpServletRequest in_request) throws SortException {
        return in_request.getParameter(SORTUTIL_PROPERTY);
    }

    public List getSortedCollection() {
        List lc_list = (List)this.collections.get(this.index);
        ++this.index;
        return lc_list;
    }

    public static String getURLForCollection(String in_property, HttpServletRequest in_request) {
        SortUtil lc_sortUtil = (SortUtil)in_request.getSession().getAttribute(SORTUTIL_KEY);
        if (lc_sortUtil == null || in_request.getAttribute("fr.improve.struts.taglib.layout.sort.SortUtilaaa") == null) {
            lc_sortUtil = SortUtil.createSortUtil(in_request);
            in_request.getSession().setAttribute(SORTUTIL_KEY, (Object)lc_sortUtil);
            in_request.setAttribute("fr.improve.struts.taglib.layout.sort.SortUtilaaa", (Object)"aaa");
        }
        StringBuffer lc_buffer = new StringBuffer(in_request.getContextPath());
        lc_buffer.append("/sort.do?");
        lc_buffer.append(SORTUTIL_COLLECTION);
        lc_buffer.append('=');
        lc_buffer.append(lc_sortUtil.collections.size() - 1);
        lc_buffer.append('&');
        lc_buffer.append(SORTUTIL_PROPERTY);
        lc_buffer.append('=');
        lc_buffer.append(in_property);
        lc_buffer.append('&');
        lc_buffer.append("layoutCollectionState");
        lc_buffer.append('=');
        lc_buffer.append(SortUtil.getRequestState(in_request));
        return lc_buffer.toString();
    }

    public String sort(HttpServletRequest in_request) throws SortException {
        this.validateRequest(in_request);
        List lc_collection = this.getCollectionToSort(in_request);
        String lc_property = this.getPropertyToSort(in_request);
        this.sortCollection(lc_collection, lc_property);
        this.buildRequest(in_request);
        in_request.getSession().removeAttribute(SORTUTIL_KEY);
        in_request.setAttribute(SORTUTIL_KEY, (Object)this);
        return this.buildURL(in_request);
    }

    protected void sortCollection(List in_collection, String in_property) {
        if (in_property != null && in_property.length() != 0) {
            ArrayList copy = new ArrayList(in_collection);
            Collections.sort(in_collection, new BeanComparator(in_property));
            if (copy.equals(in_collection)) {
                Collections.reverse(in_collection);
            }
        }
    }

    private static final String getRequestState(HttpServletRequest in_request) {
        Integer lc_value = (Integer)in_request.getSession().getAttribute("fr.improve.struts.taglib.layout.sort.SortUtilbbb");
        if (lc_value == null) {
            lc_value = new Integer(0);
            in_request.getSession().setAttribute("fr.improve.struts.taglib.layout.sort.SortUtilbbb", (Object)lc_value);
        }
        return lc_value.toString();
    }

    protected final void validateRequest(HttpServletRequest in_request) throws SortException {
        Integer lc_integer = (Integer)in_request.getSession().getAttribute("fr.improve.struts.taglib.layout.sort.SortUtilbbb");
        if (lc_integer == null) {
            throw new SortException("session state unknown");
        }
        String lc_value = in_request.getParameter("layoutCollectionState");
        if (lc_value == null) {
            throw new SortException("bad request");
        }
        Skin lc_skin = LayoutUtils.getSkin(in_request.getSession());
        Integer lc_integerValue = new Integer(lc_value);
        if (lc_skin.isSortTokenRequired() && lc_integer.compareTo(lc_integerValue) > 0) {
            throw new SortException("bad session state");
        }
        in_request.getSession().setAttribute("fr.improve.struts.taglib.layout.sort.SortUtilbbb", (Object)new Integer(lc_integer + 1));
    }

    public static SortUtil createSortUtil(HttpServletRequest in_request) {
        SortUtil lc_sortUtil;
        try {
            String lc_sortUtilClass = LayoutUtils.getSkin(in_request.getSession()).getProperty(SORT_UTIL_CLASS);
            try {
                lc_sortUtil = (SortUtil)Class.forName(lc_sortUtilClass).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                lc_sortUtil = new SortUtil();
            }
        }
        catch (MissingResourceException mre) {
            lc_sortUtil = new SortUtil();
        }
        lc_sortUtil.initSortUtil(in_request, in_request.getServletPath());
        return lc_sortUtil;
    }
}

