/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.treeview;

import com.fgm.web.menu.MenuComponent;
import fr.improve.struts.taglib.layout.PanelTag;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import fr.improve.struts.taglib.layout.util.MenuInterface;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.struts.util.ResponseUtils;

public class TreeViewTag
extends PanelTag
implements MenuInterface {
    private static final String VERTICAL_TREE = "treeLine.gif";
    private static final String CLOSE_NODE = "treeNodeClose.gif";
    private static final String LAST_CLOSE_NODE = "treeNodeCloseLast.gif";
    private static final String OPEN_NODE = "treeNodeOpen.gif";
    private static final String LAST_OPEN_NODE = "treeNodeOpenLast.gif";
    private static final String LAST_ITEM = "treeItemLast.gif";
    private static final String ITEM = "treeItem.gif";
    private static final String TREEVIEW_NUMBER = "fr.improve.struts.taglib.layout.TreeviewTag.TREEVIEW_NUMBER";
    protected Vector menus = new Vector();
    protected boolean autoIncrement = true;
    protected int expandedLevelsAtFirst = -1;

    public void addItem(MenuComponent item) {
        this.menus.add(item);
    }

    public void addItems(MenuComponent[] items) {
        this.menus.addAll(Arrays.asList(items));
    }

    public int doEndTag() throws JspException {
        if (this.menus.size() == 0 && this.name != null) {
            this.addItems(LayoutUtils.getMenu(this.pageContext, this.name).getMenuComponents());
        }
        this.doStartLayout();
        StringBuffer buffer = new StringBuffer();
        this.doStartPanel(buffer);
        buffer.append("<tr><td>");
        buffer.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
        Integer lc_i = this.computeTreeviewId();
        String lc_styleClass = this.styleClass;
        if (lc_styleClass == null) {
            lc_styleClass = "";
        }
        if (lc_styleClass.length() != 0 && this.autoIncrement) {
            lc_styleClass = lc_styleClass + "1";
        }
        TreeViewTag.doPrintMenu(buffer, this.menus.toArray(new MenuComponent[this.menus.size()]), (HttpServletRequest)this.pageContext.getRequest(), this.pageContext.getServletContext(), this.bundle, lc_i.toString(), this.name, lc_styleClass);
        buffer.append("</table>");
        if (this.pageContext.getRequest().getAttribute("fr.improve.struts.taglib.layout.treeview.TreeViewTag.KEY") == null && this.name != null) {
            buffer.append("<iframe id=\"treeFrame\" name=\"treeFrame\" style=\"width:0px; height:0px; border: 0px\" src=\"about:blank\"></iframe>");
            this.pageContext.getRequest().setAttribute("fr.improve.struts.taglib.layout.treeview.TreeViewTag.KEY", (Object)"");
        }
        buffer.append("</td></tr>");
        this.doEndPanel(buffer);
        if (this.expandedLevelsAtFirst > 0) {
            Cookie[] lc_cookies = ((HttpServletRequest)this.pageContext.getRequest()).getCookies();
            boolean lc_firstDisplay = true;
            if (lc_cookies != null) {
                int i = 0;
                while (i < lc_cookies.length) {
                    if (lc_cookies[i].getName().equals("treeView")) {
                        lc_firstDisplay = false;
                        break;
                    }
                    ++i;
                }
            }
            if (lc_firstDisplay) {
                buffer.append("<script>");
                buffer.append("expandFirstLevels(");
                buffer.append(lc_i);
                buffer.append(", ");
                buffer.append(this.expandedLevelsAtFirst);
                buffer.append(");");
                buffer.append("</script>");
            }
        }
        ResponseUtils.write((PageContext)this.pageContext, (String)buffer.toString());
        this.doEndLayout();
        this.menus.removeAllElements();
        this.name = null;
        return 6;
    }

    private Integer computeTreeviewId() throws JspException {
        TreeViewIds treeviewIds = (TreeViewIds)this.pageContext.getSession().getAttribute(TREEVIEW_NUMBER);
        if (treeviewIds == null) {
            treeviewIds = new TreeViewIds();
            this.pageContext.getSession().setAttribute(TREEVIEW_NUMBER, (Object)treeviewIds);
        }
        if (this.name != null) {
            Integer lc_id = (Integer)treeviewIds.namedTreeview.get(this.name);
            if (lc_id == null) {
                lc_id = new Integer(treeviewIds.getNewId());
                treeviewIds.namedTreeview.put(this.name, lc_id);
            }
            return lc_id;
        }
        if (this.pageContext.getRequest().getAttribute(TREEVIEW_NUMBER) != null) {
            throw new JspException("There can be only one anonymous treeview per request");
        }
        this.pageContext.getRequest().setAttribute(TREEVIEW_NUMBER, (Object)"");
        Integer lc_id = (Integer)treeviewIds.anonymousTreeview.get(((HttpServletRequest)this.pageContext.getRequest()).getRequestURI());
        if (lc_id == null) {
            lc_id = new Integer(treeviewIds.getNewId());
            treeviewIds.anonymousTreeview.put(((HttpServletRequest)this.pageContext.getRequest()).getRequestURI(), lc_id);
        }
        return lc_id;
    }

    public static int doPrintMenu(StringBuffer buffer, MenuComponent[] menus, HttpServletRequest in_request, ServletContext in_servletcontext, String in_bundle, String in_path, String in_name, String in_styleClass) throws JspException {
        char lc_lastChar;
        int lc_numberOfMenusPrinted = menus.length;
        String imageDirectory = LayoutUtils.getSkin(in_request.getSession()).getImageDirectory((ServletRequest)in_request);
        String lc_newStyleClass = in_styleClass;
        if (in_styleClass.length() != 0 && Character.isDigit(lc_lastChar = in_styleClass.charAt(in_styleClass.length() - 1))) {
            lc_newStyleClass = lc_newStyleClass.substring(0, lc_newStyleClass.length() - 1) + (char)(lc_lastChar + '\u0001');
        }
        int i = 0;
        while (i < menus.length) {
            MenuComponent item = menus[i];
            String link = item.getLocation();
            String key = item.getTitle();
            String image = item.getImage();
            String target = item.getTarget();
            String onclick = item.getOnClick();
            String style = item.getStyle();
            MenuComponent[] subMenus = item.getMenuComponents();
            boolean lc_hasSubMenus = subMenus != null && subMenus.length > 0;
            boolean lc_isLast = i + 1 == menus.length;
            String lc_path = in_path.length() == 0 ? String.valueOf(i) : in_path + "*" + i;
            boolean lc_close = TreeViewTag.isNodeClosed(in_request, lc_path);
            int lc_numberOfMenusToLoad = LayoutUtils.getSkin(in_request.getSession()).getNumberOfMenusLoaded();
            boolean lc_useIndirection = lc_numberOfMenusPrinted >= lc_numberOfMenusToLoad && in_name != null && lc_close;
            buffer.append("<tr>");
            buffer.append("<td valign=\"top\" height=\"100%\">");
            if (!lc_isLast) {
                buffer.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" height=\"100%\"");
                buffer.append(" style=\"background-image: url(");
                buffer.append(imageDirectory);
                buffer.append("/");
                buffer.append(VERTICAL_TREE);
                buffer.append("); background-repeat: repeat-y; \"><tr><td valign=\"top\">");
            }
            if (lc_hasSubMenus) {
                String lc_openImage;
                String lc_closeImage;
                if (lc_isLast) {
                    lc_closeImage = LAST_CLOSE_NODE;
                    lc_openImage = LAST_OPEN_NODE;
                } else {
                    lc_closeImage = CLOSE_NODE;
                    lc_openImage = OPEN_NODE;
                }
                buffer.append("<a href=\"");
                if (!lc_useIndirection) {
                    buffer.append("javascript://\" onclick=\"return changeTree('");
                    buffer.append(lc_path);
                    buffer.append("','");
                    buffer.append(imageDirectory);
                    buffer.append("/");
                    buffer.append(lc_openImage);
                    buffer.append("','");
                    buffer.append(imageDirectory);
                    buffer.append("/");
                    buffer.append(lc_closeImage);
                    buffer.append("');");
                } else {
                    buffer.append(in_request.getContextPath());
                    buffer.append("/treeview.do?open=");
                    buffer.append(lc_path);
                    buffer.append("&bundle=");
                    buffer.append(in_bundle);
                    buffer.append("&name=");
                    buffer.append(in_name);
                    buffer.append("&class=");
                    buffer.append(in_styleClass);
                    buffer.append("\" id=\"treeViewNode");
                    buffer.append(lc_path);
                    buffer.append("\" onclick=\"return changeTree('");
                    buffer.append(lc_path);
                    buffer.append("','");
                    buffer.append(imageDirectory);
                    buffer.append("/");
                    buffer.append(lc_openImage);
                    buffer.append("','");
                    buffer.append(imageDirectory);
                    buffer.append("/");
                    buffer.append(lc_closeImage);
                    buffer.append("');");
                }
                buffer.append("\" target=\"treeFrame\">");
                buffer.append("<img src=\"");
                buffer.append(imageDirectory);
                buffer.append("/");
                buffer.append(lc_close ? lc_closeImage : lc_openImage);
                buffer.append("\" id=\"treeViewImage");
                buffer.append(lc_path);
                buffer.append("\" border=\"0\" width=\"16\" height=\"22\">");
                buffer.append("</a>");
            } else {
                buffer.append("<img src=\"");
                buffer.append(imageDirectory);
                buffer.append("/");
                if (lc_isLast) {
                    buffer.append(LAST_ITEM);
                } else {
                    buffer.append(ITEM);
                }
                buffer.append("\" border=\"0\" width=\"16\" height=\"22\">");
            }
            if (!lc_isLast) {
                buffer.append("</td></tr></table>");
            }
            buffer.append("</td>");
            if (lc_hasSubMenus) {
                buffer.append("<td valign=\"top\" colspan=\"2\"><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
            }
            buffer.append("<td width=\"1\">");
            buffer.append("</td>");
            buffer.append("<td");
            if (in_styleClass.length() != 0) {
                buffer.append(" class=\"");
                buffer.append(in_styleClass);
                buffer.append("\"");
            }
            if (style != null) {
                buffer.append(" style=\"");
                buffer.append(style);
                buffer.append("\"");
            }
            if (onclick != null) {
                buffer.append(" onclick=\"");
                buffer.append(onclick);
                buffer.append("\"");
            }
            buffer.append(">");
            if (image != null) {
                if (lc_hasSubMenus) {
                    buffer.append("<a href=\"");
                    if (!lc_useIndirection) {
                        buffer.append("javascript://\"");
                    } else {
                        buffer.append(in_request.getContextPath());
                        buffer.append("/treeview.do?open=");
                        buffer.append(lc_path);
                        buffer.append("&bundle=");
                        buffer.append(in_bundle);
                        buffer.append("&name=");
                        buffer.append(in_name);
                        buffer.append("&class=");
                        buffer.append(in_styleClass);
                        buffer.append("\" id=\"treeViewNode");
                        buffer.append(lc_path);
                        buffer.append("\"");
                    }
                    buffer.append(" onclick=\"return changeTreeAndSubtrees('");
                    buffer.append(lc_path);
                    buffer.append("');");
                    buffer.append("\" target=\"treeFrame\">");
                }
                buffer.append("<img src=\"");
                buffer.append(imageDirectory);
                buffer.append("/");
                buffer.append(image);
                buffer.append("\" border=\"0\">");
                if (lc_hasSubMenus) {
                    buffer.append("</a>&nbsp;");
                }
            }
            if (link != null && link.length() > 0) {
                buffer.append("<a href=\"");
                if (target == null && !LayoutUtils.getSkin(in_request.getSession()).getFollowLinkIfFormChanged()) {
                    StringBuffer lc_newLink = new StringBuffer("javascript:checkFormChange('");
                    lc_newLink.append(link);
                    lc_newLink.append("','");
                    lc_newLink.append(LayoutUtils.getLabel(in_request, in_servletcontext, "org.apache.struts.action.MESSAGE", "layout.dataLost", null, false));
                    lc_newLink.append("')");
                    lc_newLink.append("\" onMouseOver=\"status='");
                    lc_newLink.append(link);
                    lc_newLink.append("';return true;\" onMouseOut=\"status='';return true;");
                    link = lc_newLink.toString();
                }
                buffer.append(link);
                buffer.append("\"");
                if (in_styleClass.length() != 0) {
                    buffer.append(" class=\"");
                    buffer.append(in_styleClass);
                    buffer.append("\"");
                }
                if (target != null && target.length() > 0) {
                    buffer.append(" target=\"");
                    buffer.append(target);
                    buffer.append("\"");
                }
                buffer.append(">");
            }
            buffer.append(LayoutUtils.getLabel(in_request, in_servletcontext, in_bundle, key, null, false));
            if (link != null) {
                buffer.append("</a>");
            }
            buffer.append("</td>");
            if (lc_hasSubMenus) {
                buffer.append("</tr>");
                buffer.append("<tr><td valign=\"top\" colspan=\"2\" id=\"treeView" + lc_path + "\"");
                if (lc_close) {
                    buffer.append(" style=\"display:none;\"");
                }
                buffer.append(">");
                if (!lc_useIndirection) {
                    buffer.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
                    lc_numberOfMenusPrinted += TreeViewTag.doPrintMenu(buffer, subMenus, in_request, in_servletcontext, in_bundle, lc_path, in_name, lc_newStyleClass);
                    buffer.append("</table>");
                }
                buffer.append("</td></tr>");
                buffer.append("</table></td>");
            }
            buffer.append("</tr>");
            ++i;
        }
        return lc_numberOfMenusPrinted;
    }

    private static boolean isNodeClosed(HttpServletRequest in_request, String in_path) {
        Cookie[] lc_cookies = in_request.getCookies();
        if (lc_cookies == null) {
            return true;
        }
        int i = 0;
        while (i < lc_cookies.length) {
            Cookie lc_cookie = lc_cookies[i];
            if (lc_cookie.getName().equals("treeView")) {
                return lc_cookie.getValue().indexOf("_treeView" + in_path + "_") == -1;
            }
            ++i;
        }
        return true;
    }

    public int doStartTag() throws JspException {
        return 1;
    }

    public void setAutoIncrement(String in_value) {
        this.autoIncrement = "true".equalsIgnoreCase(in_value);
    }

    public void release() {
        super.release();
        this.autoIncrement = true;
        this.expandedLevelsAtFirst = -1;
    }

    public final void setExpandedLevelsAtFirst(int expandedLevelsAtFirst) {
        this.expandedLevelsAtFirst = expandedLevelsAtFirst;
    }

    public class TreeViewIds {
        private int counter = -1;
        Hashtable namedTreeview = new Hashtable();
        Hashtable anonymousTreeview = new Hashtable();

        TreeViewIds() {
        }

        public synchronized int getNewId() {
            ++this.counter;
            return this.counter;
        }
    }
}

