/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.util.xml.XmlLoadable;
import org.w3c.dom.Element;

public class GenericInterceptorFactory
implements InterceptorFactory {
    private Class clazz = null;
    private String classname;
    private Element element;
    private boolean deployed = true;

    public GenericInterceptorFactory(String classname, Element element) {
        this.classname = classname;
        this.element = element;
    }

    public GenericInterceptorFactory(Class clazz) {
        this.clazz = clazz;
        this.classname = clazz.getName();
    }

    public void undeploy() {
        this.deployed = false;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public String getClassName() {
        return this.classname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interceptor create(Advisor advisor, Joinpoint joinpoint) {
        try {
            GenericInterceptorFactory genericInterceptorFactory = this;
            synchronized (genericInterceptorFactory) {
                if (this.clazz == null) {
                    this.clazz = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
                }
            }
            Interceptor interceptor = (Interceptor)this.clazz.newInstance();
            if (interceptor instanceof XmlLoadable && this.element != null) {
                ((XmlLoadable)interceptor).importXml(this.element);
            }
            return interceptor;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }
}

