/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.advice.AbstractAdvice;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.PerVmAdvice;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorJoinpoint;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.ConstructorJoinpoint;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodCalledByConstructorJoinpoint;
import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;

public class PerJoinpointAdvice
extends AbstractAdvice {
    private boolean initialized = false;
    AspectDefinition aspectDefinition;
    Joinpoint joinpoint;

    public static Interceptor createInterceptor(Advisor advisor, Joinpoint joinpoint, AspectDefinition def, String adviceName) throws Exception {
        if (joinpoint instanceof MethodJoinpoint) {
            MethodJoinpoint method = (MethodJoinpoint)joinpoint;
            if (Modifier.isStatic(method.getMethod().getModifiers())) {
                return PerVmAdvice.generateInterceptor(def.getFactory().createPerJoinpoint(advisor, joinpoint), adviceName);
            }
        } else {
            FieldJoinpoint field;
            if (joinpoint instanceof ConstructorJoinpoint || joinpoint instanceof ConstructorCalledByConstructorJoinpoint || joinpoint instanceof MethodCalledByConstructorJoinpoint) {
                return PerVmAdvice.generateInterceptor(def.getFactory().createPerJoinpoint(advisor, joinpoint), adviceName);
            }
            if (joinpoint instanceof MethodCalledByMethodJoinpoint) {
                MethodCalledByMethodJoinpoint method = (MethodCalledByMethodJoinpoint)joinpoint;
                if (Modifier.isStatic(method.getCalling().getModifiers())) {
                    return PerVmAdvice.generateInterceptor(def.getFactory().createPerJoinpoint(advisor, joinpoint), adviceName);
                }
            } else if (joinpoint instanceof ConstructorCalledByMethodJoinpoint) {
                ConstructorCalledByMethodJoinpoint method = (ConstructorCalledByMethodJoinpoint)joinpoint;
                if (Modifier.isStatic(method.getCalling().getModifiers())) {
                    return PerVmAdvice.generateInterceptor(def.getFactory().createPerJoinpoint(advisor, joinpoint), adviceName);
                }
            } else if (joinpoint instanceof FieldJoinpoint && Modifier.isStatic((field = (FieldJoinpoint)joinpoint).getField().getModifiers())) {
                ClassAdvisor classAdvisor = (ClassAdvisor)advisor;
                Object aspect = classAdvisor.getFieldAspect(field, def);
                return PerVmAdvice.generateInterceptor(aspect, adviceName);
            }
        }
        return new PerJoinpointAdvice(adviceName, def, advisor, joinpoint);
    }

    public PerJoinpointAdvice(String adviceName, AspectDefinition a, Advisor advisor, Joinpoint joinpoint) {
        this.aspectDefinition = a;
        this.adviceName = adviceName;
        advisor.addPerInstanceJoinpointAspect(joinpoint, a);
        this.joinpoint = joinpoint;
    }

    public String getName() {
        return this.aspectDefinition.getName() + "." + this.adviceName;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        if (targetObject == null) {
            return invocation.invokeNext();
        }
        Advised advised = (Advised)targetObject;
        ClassInstanceAdvisor advisor = (ClassInstanceAdvisor)advised._getInstanceAdvisor();
        Object aspect = advisor.getPerInstanceJoinpointAspect(this.joinpoint, this.aspectDefinition);
        if (!this.initialized) {
            this.init(this.adviceName, aspect.getClass());
        }
        Method advice = this.resolveAdvice(invocation);
        Object[] args = new Object[]{invocation};
        try {
            return advice.invoke(aspect, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

