/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PerInstanceInterceptor;
import org.jboss.aop.advice.PerJoinpointInterceptor;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.Joinpoint;

public class ScopedInterceptorFactory
implements InterceptorFactory {
    private AspectDefinition aspect;

    public ScopedInterceptorFactory(AspectDefinition aspect) {
        this.aspect = aspect;
    }

    public AspectDefinition getInterceptorDefinition() {
        return this.aspect;
    }

    public boolean isDeployed() {
        return this.aspect.isDeployed();
    }

    public Interceptor create(Advisor advisor, Joinpoint joinpoint) {
        if (this.aspect.getScope() == Scope.PER_VM) {
            return (Interceptor)AspectManager.instance().getPerVMAspect(this.aspect);
        }
        if (this.aspect.getScope() == Scope.PER_CLASS) {
            if (advisor.getAdviceInterceptor(this.aspect, "invoke") != null) {
                return advisor.getAdviceInterceptor(this.aspect, "invoke");
            }
            advisor.addPerClassAspect(this.aspect);
            Interceptor interceptor = (Interceptor)this.aspect.getFactory().createPerClass(advisor);
            advisor.addAdviceInterceptor(this.aspect, "invoke", interceptor);
            return interceptor;
        }
        if (this.aspect.getScope() == Scope.PER_INSTANCE) {
            return new PerInstanceInterceptor(this.aspect, advisor);
        }
        if (this.aspect.getScope() == Scope.PER_JOINPOINT) {
            try {
                return PerJoinpointInterceptor.createInterceptor(advisor, joinpoint, this.aspect);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String getName() {
        return this.aspect.getName();
    }
}

