/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Iterator;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.pointcut.Pointcut;

public class FieldAccessTransformer {
    Instrumentor instrumentor;
    boolean optimize;
    NotOptimizedTransformer notOptimizedTransformer;
    OptimizedTransformer optimizedTransformer;

    public FieldAccessTransformer(Instrumentor instrumentor) {
        this.instrumentor = instrumentor;
        this.optimize = AspectManager.optimize;
        if (this.optimize) {
            this.optimizedTransformer = new OptimizedTransformer();
        } else {
            this.notOptimizedTransformer = new NotOptimizedTransformer();
        }
    }

    public void buildFieldWrappers(CtClass clazz, ClassAdvisor advisor) throws NotFoundException, CannotCompileException {
        if (this.optimize) {
            this.optimizedTransformer.buildFieldWrappers(clazz, advisor);
        } else {
            this.notOptimizedTransformer.buildFieldWrappers(clazz, advisor);
        }
    }

    public boolean replaceFieldAccess(List fields, CtClass clazz, ClassAdvisor fieldsAdvisor) throws NotFoundException {
        CodeConverter converter = this.instrumentor.getCodeConverter();
        boolean converted = false;
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            CtField field = (CtField)it.next();
            if (this.isAdvisableGetField(field, fieldsAdvisor)) {
                converted = true;
                converter.replaceFieldRead(field, clazz, this.fieldRead(field.getName()));
            }
            if (!this.isAdvisableSetField(field, fieldsAdvisor)) continue;
            converted = true;
            converter.replaceFieldWrite(field, clazz, this.fieldWrite(field.getName()));
        }
        return converted;
    }

    private int fieldOffset(CtClass clazz) throws NotFoundException {
        if (clazz == null) {
            return 0;
        }
        if (clazz.getName().equals("java.lang.Object")) {
            return 0;
        }
        int offset = this.fieldOffset(clazz.getSuperclass());
        CtField[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!this.instrumentor.isAdvisable(fields[i])) continue;
            ++offset;
        }
        return offset;
    }

    private boolean isAdvisableGetField(CtField field, ClassAdvisor advisor) throws NotFoundException {
        Iterator pointcuts = AspectManager.instance().getPointcuts().values().iterator();
        while (pointcuts.hasNext()) {
            Pointcut pointcut = (Pointcut)pointcuts.next();
            if (!pointcut.matchesGet(advisor, field)) continue;
            return true;
        }
        return false;
    }

    private boolean isAdvisableSetField(CtField field, ClassAdvisor advisor) throws NotFoundException {
        Iterator pointcuts = AspectManager.instance().getPointcuts().values().iterator();
        while (pointcuts.hasNext()) {
            Pointcut pointcut = (Pointcut)pointcuts.next();
            if (!pointcut.matchesSet(advisor, field)) continue;
            return true;
        }
        return false;
    }

    private String fieldRead(String fieldName) {
        return fieldName + "_r_" + "$aop";
    }

    private String fieldWrite(String fieldName) {
        return fieldName + "_w_" + "$aop";
    }

    private int getModifiers(CtField field) {
        int mod = 8;
        mod = (field.getModifiers() & 1) != 0 ? (mod |= 1) : ((field.getModifiers() & 4) != 0 ? (mod |= 4) : ((field.getModifiers() & 2) != 0 ? (mod |= 2) : (mod |= 1)));
        return mod;
    }

    private void replaceFieldAccessInternally(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) throws CannotCompileException {
        FieldAccessExprEditor expr = new FieldAccessExprEditor(clazz, field, doGet, doSet, index);
        clazz.instrument((ExprEditor)expr);
    }

    private class FieldAccessExprEditor
    extends ExprEditor {
        CtClass clazz;
        CtField field;
        boolean doGet;
        boolean doSet;
        int fieldIndex;

        public FieldAccessExprEditor(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) {
            this.clazz = clazz;
            this.field = field;
            this.doGet = doGet;
            this.doSet = doSet;
            this.fieldIndex = index;
        }

        public void edit(FieldAccess fieldAccess) throws CannotCompileException {
            if (!fieldAccess.getClassName().equals(this.clazz.getName())) {
                return;
            }
            if (!fieldAccess.getFieldName().equals(this.field.getName())) {
                return;
            }
            if (fieldAccess.isReader() && this.doGet) {
                this.replaceRead(fieldAccess);
            }
            if (fieldAccess.isWriter() && this.doSet) {
                this.replaceWrite(fieldAccess);
            }
        }

        private void replaceRead(FieldAccess fieldAccess) throws CannotCompileException {
            if (FieldAccessTransformer.this.optimize) {
                this.replaceReadOptimized(fieldAccess);
            } else {
                this.replaceReadNotOptimized(fieldAccess);
            }
        }

        private void replaceReadOptimized(FieldAccess fieldAccess) throws CannotCompileException {
            if (fieldAccess.isStatic()) {
                String code = "    {        $_ = ($r)" + FieldAccessTransformer.this.fieldRead(this.field.getName()) + "(null);" + "    } " + "";
                fieldAccess.replace(code);
            } else {
                String code = "    {        $_ = ($r)" + FieldAccessTransformer.this.fieldRead(this.field.getName()) + "($0);" + "    } " + "";
                fieldAccess.replace(code);
            }
        }

        private void replaceReadNotOptimized(FieldAccess fieldAccess) throws CannotCompileException {
            if (fieldAccess.isStatic()) {
                String code = "    if (aop$classAdvisor$aop.doesHaveAspects)     {        Object obj = null;       $_ = ($r)aop$classAdvisor$aop.invokeRead(obj, (int)" + this.fieldIndex + "); " + "    } " + "    else " + "    { " + "       $_ = " + this.clazz.getName() + "." + this.field.getName() + "; " + "    } " + "";
                fieldAccess.replace(code);
            } else {
                String code = "    if (aop$classAdvisor$aop.doesHaveAspects || (_instanceAdvisor != null && _instanceAdvisor.hasInstanceAspects))     {        $_ = ($r)aop$classAdvisor$aop.invokeRead($0, (int)" + this.fieldIndex + "); " + "    } " + "    else " + "    { " + "       $_ = this." + fieldAccess.getFieldName() + "; " + "    } ";
                fieldAccess.replace(code);
            }
        }

        private void replaceWrite(FieldAccess fieldAccess) throws CannotCompileException {
            if (FieldAccessTransformer.this.optimize) {
                this.replaceWriteOptimized(fieldAccess);
            } else {
                this.replaceWriteNotOptimized(fieldAccess);
            }
        }

        private void replaceWriteOptimized(FieldAccess fieldAccess) throws CannotCompileException {
            String fieldWrite = FieldAccessTransformer.this.fieldWrite(this.field.getName());
            if (fieldAccess.isStatic()) {
                String code = "    {        " + fieldWrite + "(null, $1);" + "    } " + "";
                fieldAccess.replace(code);
            } else {
                String code = "    {        " + fieldWrite + "($0, $1);" + "    } " + "";
                fieldAccess.replace(code);
            }
        }

        private void replaceWriteNotOptimized(FieldAccess fieldAccess) throws CannotCompileException {
            if (fieldAccess.isStatic()) {
                String code = "    if (aop$classAdvisor$aop.doesHaveAspects)     {        Object obj = null;      aop$classAdvisor$aop.invokeWrite(obj, (int)" + this.fieldIndex + ", ($w)$1); " + "    } " + "    else " + "    { " + "       " + this.clazz.getName() + "." + fieldAccess.getFieldName() + " = $1; " + "    } ";
                fieldAccess.replace(code);
            } else {
                String code = "    if (aop$classAdvisor$aop.doesHaveAspects || (_instanceAdvisor != null && _instanceAdvisor.hasInstanceAspects))     {        aop$classAdvisor$aop.invokeWrite($0, (int)" + this.fieldIndex + ", ($w)$1); " + "    } " + "    else " + "    { " + "       this." + fieldAccess.getFieldName() + " = $1; " + "    } ";
                fieldAccess.replace(code);
            }
        }
    }

    class NotOptimizedTransformer {
        NotOptimizedTransformer() {
        }

        public void buildFieldWrappers(CtClass clazz, ClassAdvisor advisor) throws NotFoundException, CannotCompileException {
            List fields = FieldAccessTransformer.this.instrumentor.getAdvisableFields(clazz);
            ClassPool classPool = FieldAccessTransformer.this.instrumentor.getClassPool();
            int offset = FieldAccessTransformer.this.fieldOffset(clazz.getSuperclass());
            CtClass[] readParam = new CtClass[]{classPool.get("java.lang.Object")};
            Iterator it = fields.iterator();
            int index = offset;
            while (it.hasNext()) {
                CtField field = (CtField)it.next();
                boolean doGet = FieldAccessTransformer.this.isAdvisableGetField(field, advisor);
                boolean doSet = FieldAccessTransformer.this.isAdvisableSetField(field, advisor);
                if (doGet || doSet) {
                    FieldAccessTransformer.this.instrumentor.setupBasics(clazz);
                    FieldAccessTransformer.this.replaceFieldAccessInternally(clazz, field, doGet, doSet, index);
                    if (!Modifier.isPrivate((int)field.getModifiers())) {
                        int mod = 8;
                        mod = (field.getModifiers() & 1) != 0 ? (mod |= 1) : ((field.getModifiers() & 4) != 0 ? (mod |= 4) : ((field.getModifiers() & 2) != 0 ? (mod |= 2) : (mod |= 1)));
                        String name = field.getName();
                        CtClass ftype = field.getType();
                        boolean isStatic = Modifier.isStatic((int)field.getModifiers());
                        String access = "";
                        String instanceCheck = "";
                        if (!isStatic) {
                            access = "((" + clazz.getName() + ")$1).";
                            instanceCheck = " || ((org.jboss.aop.ClassInstanceAdvisor)((org.jboss.aop.InstanceAdvised)$1)._getInstanceAdvisor()).hasInstanceAspects";
                        }
                        if (doGet) {
                            CtMethod rmethod = CtNewMethod.make((CtClass)ftype, (String)FieldAccessTransformer.this.fieldRead(name), (CtClass[])readParam, null, null, (CtClass)clazz);
                            rmethod.setModifiers(mod);
                            String readcode = "{     if (aop$classAdvisor$aop.doesHaveAspects " + instanceCheck + " ) " + "    { " + "       return ($r)" + "aop$classAdvisor$aop" + ".invokeRead($1, (int)" + index + "); " + "    } " + "    return " + access + name + "; " + "}";
                            rmethod.setBody(readcode);
                            clazz.addMethod(rmethod);
                        }
                        if (doSet) {
                            CtClass[] writeParam = new CtClass[]{classPool.get("java.lang.Object"), ftype};
                            String writecode = "{     if (aop$classAdvisor$aop.doesHaveAspects " + instanceCheck + " ) " + "    { " + "       " + "aop$classAdvisor$aop" + ".invokeWrite($1, (int)" + index + ", ($w)$2); " + "    } " + "    else " + "    { " + "       " + access + name + " = $2; " + "    } " + "}";
                            CtMethod wmethod = CtNewMethod.make((CtClass)CtClass.voidType, (String)FieldAccessTransformer.this.fieldWrite(name), (CtClass[])writeParam, null, null, (CtClass)clazz);
                            wmethod.setModifiers(mod);
                            wmethod.setBody(writecode);
                            clazz.addMethod(wmethod);
                        }
                    }
                }
                ++index;
            }
        }
    }

    class OptimizedTransformer {
        OptimizedTransformer() {
        }

        void buildFieldWrappers(CtClass clazz, ClassAdvisor advisor) throws NotFoundException, CannotCompileException {
            List fields = FieldAccessTransformer.this.instrumentor.getAdvisableFields(clazz);
            int offset = FieldAccessTransformer.this.fieldOffset(clazz.getSuperclass());
            Iterator it = fields.iterator();
            int index = offset;
            while (it.hasNext()) {
                CtField field = (CtField)it.next();
                boolean doGet = FieldAccessTransformer.this.isAdvisableGetField(field, advisor);
                boolean doSet = FieldAccessTransformer.this.isAdvisableSetField(field, advisor);
                if (doGet || doSet) {
                    FieldAccessTransformer.this.instrumentor.setupBasics(clazz);
                    int mod = FieldAccessTransformer.this.getModifiers(field);
                    this.buildOptimizedWrapperPlaceHolders(clazz, field, doGet, doSet, mod);
                    FieldAccessTransformer.this.replaceFieldAccessInternally(clazz, field, doGet, doSet, index);
                    this.buildOptimizedWrappers(clazz, field, doGet, doSet, index);
                }
                ++index;
            }
        }

        private void buildOptimizedWrapperPlaceHolders(CtClass clazz, CtField field, boolean doGet, boolean doSet, int mod) throws NotFoundException, CannotCompileException {
            if (doGet) {
                this.buildOptimizedReadWrapperPlaceHolder(clazz, field, mod);
            }
            if (doSet) {
                this.buildOptimizedWriteWrapperPlaceHolder(clazz, field, mod);
            }
        }

        private void buildOptimizedReadWrapperPlaceHolder(CtClass clazz, CtField field, int mod) throws NotFoundException, CannotCompileException {
            AOPClassPool classPool = (AOPClassPool)FieldAccessTransformer.this.instrumentor.getClassPool();
            String name = field.getName();
            CtClass ftype = field.getType();
            CtClass[] readParam = new CtClass[]{classPool.get("java.lang.Object")};
            String code = "{" + ftype.getName() + " var; return var;}";
            try {
                CtMethod rmethod = CtNewMethod.make((CtClass)ftype, (String)FieldAccessTransformer.this.fieldRead(name), (CtClass[])readParam, null, null, (CtClass)clazz);
                rmethod.setModifiers(mod);
                rmethod.setBody(code);
                clazz.addMethod(rmethod);
            }
            catch (CannotCompileException e) {
                System.out.println(code);
                System.out.println(e.getMessage());
                throw e;
            }
        }

        private void buildOptimizedWriteWrapperPlaceHolder(CtClass clazz, CtField field, int mod) throws NotFoundException, CannotCompileException {
            AOPClassPool classPool = (AOPClassPool)FieldAccessTransformer.this.instrumentor.getClassPool();
            String name = field.getName();
            CtClass ftype = field.getType();
            CtClass[] writeParam = new CtClass[]{classPool.get("java.lang.Object"), ftype};
            String code = "{ System.out.print(\"\"); }";
            try {
                CtMethod wmethod = CtNewMethod.make((CtClass)CtClass.voidType, (String)FieldAccessTransformer.this.fieldWrite(name), (CtClass[])writeParam, null, null, (CtClass)clazz);
                wmethod.setModifiers(mod);
                wmethod.setBody(code);
                clazz.addMethod(wmethod);
            }
            catch (CannotCompileException e) {
                System.out.println(code);
                System.out.println(e.getMessage());
                throw e;
            }
        }

        private String getOptimizedInvocationClassName(CtClass clazz, CtField field, boolean get) throws Exception {
            StringBuffer sb = new StringBuffer();
            sb.append(field.getModifiers());
            sb.append(field.getClass());
            sb.append(field.getDeclaringClass());
            sb.append(field.getFieldInfo().getAccessFlags());
            sb.append(field.getFieldInfo().getDescriptor());
            sb.append(field.getName());
            sb.append(field.getType());
            long hash = sb.hashCode();
            String className = clazz.getName() + "_" + field.getName() + "_" + hash;
            className = get ? className + "_OptimizedGetFieldInvocation" : className + "_OptimizedSetFieldInvocation";
            className = className.replace('-', 'N');
            return className;
        }

        private void buildOptimizedWrappers(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) throws NotFoundException, CannotCompileException {
            if (doGet) {
                this.buildOptimizedReadWrapper(clazz, field, index);
            }
            if (doSet) {
                this.buildOptimizedWriteWrapper(clazz, field, index);
            }
        }

        private void buildOptimizedReadWrapper(CtClass clazz, CtField field, int index) throws NotFoundException, CannotCompileException {
            String optimizedInvocation;
            String wrappedName = field.getName();
            try {
                optimizedInvocation = this.createOptimizedInvocationClass(clazz, field, true);
            }
            catch (Exception e) {
                throw new CannotCompileException((Throwable)e);
            }
            String name = field.getName();
            boolean isStatic = Modifier.isStatic((int)field.getModifiers());
            String code = !isStatic ? "{     org.jboss.aop.ClassInstanceAdvisor instAdv = ((" + clazz.getName() + ")$1)._instanceAdvisor;" + "    if (" + "aop$classAdvisor$aop" + ".doesHaveAspects || (instAdv != null && instAdv.hasInstanceAspects))" + "    { " + "       org.jboss.aop.advice.Interceptor[] interceptors = " + "aop$classAdvisor$aop" + ".getFieldReadInterceptors()[" + index + "]; " + "       if (instAdv != null) " + "       { " + "          interceptors = instAdv.getInterceptors(" + "aop$classAdvisor$aop" + ".getFieldReadInterceptors()[" + index + "]); " + "       } " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.typedTargetObject = (" + clazz.getName() + ")$1; " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       return ($r)invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       return ((" + clazz.getName() + ")$1)." + wrappedName + ";" + "    }" + "}" : "{     if (aop$classAdvisor$aop.doesHaveAspects)     {        org.jboss.aop.advice.Interceptor[] interceptors = aop$classAdvisor$aop.getFieldReadInterceptors()[" + index + "]; " + "   " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       return ($r)invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       return " + clazz.getName() + "." + wrappedName + ";" + "    }" + "}";
            try {
                CtMethod rmethod = clazz.getDeclaredMethod(FieldAccessTransformer.this.fieldRead(name));
                rmethod.setBody(code);
            }
            catch (CannotCompileException e) {
                System.out.println(code);
                System.out.println(e.getMessage());
                throw e;
            }
        }

        private void buildOptimizedWriteWrapper(CtClass clazz, CtField field, int index) throws NotFoundException, CannotCompileException {
            String optimizedInvocation;
            String wrappedName = field.getName();
            AOPClassPool classPool = (AOPClassPool)FieldAccessTransformer.this.instrumentor.getClassPool();
            try {
                optimizedInvocation = this.createOptimizedInvocationClass(clazz, field, false);
            }
            catch (Exception e) {
                throw new CannotCompileException((Throwable)e);
            }
            String name = field.getName();
            CtClass ftype = field.getType();
            boolean isStatic = Modifier.isStatic((int)field.getModifiers());
            CtClass[] writeParam = new CtClass[]{classPool.get("java.lang.Object"), ftype};
            String code = !isStatic ? "{     org.jboss.aop.ClassInstanceAdvisor instAdv = ((" + clazz.getName() + ")$1)._instanceAdvisor;" + "    if (" + "aop$classAdvisor$aop" + ".doesHaveAspects || (instAdv != null && instAdv.hasInstanceAspects)) " + "    { " + "       org.jboss.aop.advice.Interceptor[] interceptors = " + "aop$classAdvisor$aop" + ".getFieldWriteInterceptors()[" + index + "]; " + "       if (instAdv != null) " + "       { " + "          interceptors = instAdv.getInterceptors(" + "aop$classAdvisor$aop" + ".getFieldWriteInterceptors()[" + index + "]); " + "       } " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", ($w)$2" + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.typedTargetObject = (" + clazz.getName() + ")$1; " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       ((" + clazz.getName() + ")$1)." + wrappedName + "=$2" + ";" + "    }" + "}" : "{     if (aop$classAdvisor$aop.doesHaveAspects)     {        org.jboss.aop.advice.Interceptor[] interceptors = aop$classAdvisor$aop.getFieldWriteInterceptors()[" + index + "]; " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + "aop$classAdvisor$aop" + ".getAdvisedFields()[" + index + "]," + index + ", ($w)$2" + ", interceptors); " + "       invocation.setTargetObject($1); " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       " + clazz.getName() + "." + wrappedName + "=$2" + ";" + "    }" + "}";
            try {
                CtMethod rmethod = clazz.getDeclaredMethod(FieldAccessTransformer.this.fieldWrite(name));
                rmethod.setBody(code);
            }
            catch (CannotCompileException e) {
                System.out.println(code);
                System.out.println(e.getMessage());
                throw e;
            }
        }

        private String createOptimizedInvocationClass(CtClass clazz, CtField field, boolean get) throws Exception {
            String ref;
            String wrappedName = field.getName();
            AOPClassPool pool = (AOPClassPool)FieldAccessTransformer.this.instrumentor.getClassPool();
            CtClass fieldInvocation = get ? pool.get("org.jboss.aop.joinpoint.FieldReadInvocation") : pool.get("org.jboss.aop.joinpoint.FieldWriteInvocation");
            String className = this.getOptimizedInvocationClassName(clazz, field, get);
            boolean makeInnerClass = !Modifier.isPublic((int)field.getModifiers());
            CtClass invocation = TransformerCommon.makeInvocationClass(pool, makeInnerClass, clazz, className, fieldInvocation);
            boolean isStatic = Modifier.isStatic((int)field.getModifiers());
            if (!isStatic) {
                CtField target = new CtField(field.getDeclaringClass(), "typedTargetObject", invocation);
                target.setModifiers(1);
                invocation.addField(target);
            }
            CtMethod in = fieldInvocation.getDeclaredMethod("invokeNext");
            CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
            invokeNext.setModifiers(in.getModifiers());
            String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)        {           currentInterceptor--;           throw t;       }    } ";
            String string = ref = isStatic ? field.getDeclaringClass().getName() + "." : " typedTargetObject.";
            if (get) {
                code = code + "return ($w) " + ref + wrappedName + ";";
            } else {
                CtClass type = field.getType();
                code = code + ref + wrappedName + " = " + this.castInvocationValueToTypeString(type) + " return null;";
            }
            code = code + "}";
            try {
                invokeNext.setBody(code);
            }
            catch (CannotCompileException e) {
                System.out.println(code);
                throw e;
            }
            invocation.addMethod(invokeNext);
            this.addCopy(pool, invocation, isStatic, get);
            TransformerCommon.compileOrLoadClass(field.getDeclaringClass(), invocation);
            return invocation.getName();
        }

        private String castInvocationValueToTypeString(CtClass type) {
            String cast = null;
            if (type.isPrimitive()) {
                if (type.equals(CtClass.booleanType)) {
                    cast = "((Boolean)value).booleanValue();";
                } else if (type.equals(CtClass.byteType)) {
                    cast = "((Byte)value).byteValue()";
                } else if (type.equals(CtClass.charType)) {
                    cast = "((Character)value).charValue();";
                } else if (type.equals(CtClass.doubleType)) {
                    cast = "((Double)value).doubleValue();";
                } else if (type.equals(CtClass.floatType)) {
                    cast = "((Float)value).floatValue();";
                } else if (type.equals(CtClass.intType)) {
                    cast = "((Integer)value).intValue();";
                } else if (type.equals(CtClass.longType)) {
                    cast = "((Long)value).longValue();";
                } else if (type.equals(CtClass.shortType)) {
                    cast = "((Short)value).shortValue();";
                }
            } else {
                cast = type.isArray() ? "(" + type.getName() + "[])value;" : "(" + type.getName() + ")value;";
            }
            return cast;
        }

        private void addCopy(ClassPool pool, CtClass invocation, boolean isStatic, boolean isGet) throws Exception {
            CtClass fieldInvocation = isGet ? pool.get("org.jboss.aop.joinpoint.FieldReadInvocation") : pool.get("org.jboss.aop.joinpoint.FieldWriteInvocation");
            CtMethod template = fieldInvocation.getDeclaredMethod("copy");
            CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), null, (CtClass)invocation);
            copy.setModifiers(template.getModifiers());
            String newExpr = isGet ? invocation.getName() + " wrapper = new " + invocation.getName() + "(this.field, this.index, this.interceptors); " : invocation.getName() + " wrapper = new " + invocation.getName() + "(this.field, this.index, this.value, this.interceptors); ";
            String code = "{    " + newExpr + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; ";
            if (!isStatic) {
                code = code + "   wrapper.typedTargetObject = this.typedTargetObject; ";
                code = code + "   wrapper.targetObject = this.targetObject; ";
            }
            code = code + "   return wrapper; }";
            copy.setBody(code);
            invocation.addMethod(copy);
        }
    }
}

