/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.joinpoint;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocationWrapper;

public class MethodInvocation
extends InvocationBase {
    protected Object[] arguments;
    protected long methodHash;
    protected transient MethodInfo info;

    public MethodInvocation(MethodInfo info, Interceptor[] interceptors) {
        super(interceptors);
        this.info = info;
        this.methodHash = info.hash;
    }

    protected MethodInvocation(Interceptor[] interceptors) {
        super(interceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext() throws Throwable {
        if (this.currentInterceptor < this.interceptors.length) {
            try {
                Object object = this.interceptors[this.currentInterceptor++].invoke(this);
                return object;
            }
            finally {
                --this.currentInterceptor;
            }
        }
        try {
            return this.getActualMethod().invoke(this.getTargetObject(), this.arguments);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Object resolveAnnotation(Class annotation) {
        Object val = super.resolveAnnotation(annotation);
        if (val != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().resolveAnnotation(this.getMethod(), annotation)) != null) {
            return val;
        }
        return null;
    }

    public Object getMetaData(Object group, Object attr) {
        Object val = super.getMetaData(group, attr);
        if (val != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().getMethodMetaData().resolve(this, group, attr)) != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().getDefaultMetaData().resolve(this, group, attr)) != null) {
            return val;
        }
        return null;
    }

    public Invocation getWrapper(Interceptor[] newchain) {
        MethodInvocationWrapper wrapper = new MethodInvocationWrapper(this, newchain);
        return wrapper;
    }

    public Invocation copy() {
        MethodInvocation wrapper = new MethodInvocation(this.info, this.interceptors);
        wrapper.metadata = this.metadata;
        wrapper.currentInterceptor = this.currentInterceptor;
        wrapper.instanceResolver = this.instanceResolver;
        wrapper.setTargetObject(this.getTargetObject());
        wrapper.setArguments(this.getArguments());
        return wrapper;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public Method getMethod() {
        return this.info.advisedMethod;
    }

    public Method getActualMethod() {
        return this.info.unadvisedMethod;
    }

    public long getMethodHash() {
        return this.methodHash;
    }

    public Advisor getAdvisor() {
        return this.info.advisor;
    }
}

