/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.metadata;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.expressions.ConstructorExpression;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.metadata.ConstructorMetaData;
import org.jboss.aop.metadata.FieldMetaData;
import org.jboss.aop.metadata.MethodMetaData;
import org.jboss.aop.metadata.SimpleClassMetaDataBinding;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.util.XmlHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SimpleClassMetaDataLoader
implements ClassMetaDataLoader {
    public static final SimpleClassMetaDataLoader singleton = new SimpleClassMetaDataLoader();

    public ClassMetaDataBinding importMetaData(Element element, String name, String tag, String classExpr) throws Exception {
        String val;
        String attr;
        NodeList children;
        Element classElement;
        SimpleClassMetaDataBinding data = new SimpleClassMetaDataBinding(this, name, tag, classExpr);
        Element defaultElement = XmlHelper.getOptionalChild(element, "default");
        if (defaultElement != null) {
            NodeList children2 = defaultElement.getChildNodes();
            boolean hasTag = false;
            for (int i = 0; i < children2.getLength(); ++i) {
                if (children2.item(i).getNodeType() != 1) continue;
                Element child = (Element)children2.item(i);
                String attr2 = child.getTagName();
                String val2 = XmlHelper.getElementContent(child, "");
                data.addDefaultMetaData(tag, attr2, val2);
                hasTag = true;
            }
            if (!hasTag) {
                data.addDefaultMetaData(tag, "$tagged$", new Object());
            }
        }
        if ((classElement = XmlHelper.getOptionalChild(element, "class")) != null) {
            NodeList children3 = classElement.getChildNodes();
            boolean hasTag = false;
            for (int i = 0; i < children3.getLength(); ++i) {
                if (children3.item(i).getNodeType() != 1) continue;
                Element child = (Element)children3.item(i);
                String attr3 = child.getTagName();
                String val3 = XmlHelper.getElementContent(child, "");
                data.addClassMetaData(tag, attr3, val3);
                hasTag = true;
            }
            if (!hasTag) {
                data.addClassMetaData(tag, "$tagged$", new Object());
            }
        }
        Iterator it = XmlHelper.getChildrenByTagName(element, "method");
        while (it.hasNext()) {
            Element method = (Element)it.next();
            String methodName = method.getAttribute("name");
            String expr = method.getAttribute("expr");
            if (methodName != null && methodName.equals("")) {
                methodName = null;
            }
            if (expr != null && expr.equals("")) {
                expr = null;
            }
            if (expr == null && methodName == null) {
                throw new RuntimeException("neither a name or expr attribute has been defined");
            }
            if (expr != null && methodName != null) {
                throw new RuntimeException("cannot specify a name and expr in same place");
            }
            if (expr == null && methodName != null) {
                expr = "* " + methodName + "(..)";
            }
            NodeList children4 = method.getChildNodes();
            boolean hadTag = false;
            for (int i = 0; i < children4.getLength(); ++i) {
                if (children4.item(i).getNodeType() != 1) continue;
                Element child = (Element)children4.item(i);
                String attr4 = child.getTagName();
                String val4 = XmlHelper.getElementContent(child, "");
                data.queueMethodMetaData(expr, tag, attr4, val4);
                hadTag = true;
            }
            if (hadTag) continue;
            data.queueMethodMetaData(expr, tag, "$tagged$", new Object());
        }
        it = XmlHelper.getChildrenByTagName(element, "field");
        while (it.hasNext()) {
            Element field = (Element)it.next();
            String fieldName = field.getAttribute("name");
            children = field.getChildNodes();
            boolean hadTag = false;
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                Element child = (Element)children.item(i);
                attr = child.getTagName();
                val = XmlHelper.getElementContent(child, "");
                data.queueFieldMetaData(fieldName, tag, attr, val);
                hadTag = true;
            }
            if (hadTag) continue;
            data.queueFieldMetaData(fieldName, tag, "$tagged$", new Object());
        }
        it = XmlHelper.getChildrenByTagName(element, "constructor");
        while (it.hasNext()) {
            Element field = (Element)it.next();
            String expr = field.getAttribute("expr");
            children = field.getChildNodes();
            boolean hadTag = false;
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                Element child = (Element)children.item(i);
                attr = child.getTagName();
                val = XmlHelper.getElementContent(child, "");
                data.queueConstructorMetaData(expr, tag, attr, val);
                hadTag = true;
            }
            if (hadTag) continue;
            data.queueConstructorMetaData(expr, tag, "$tagged$", new Object());
        }
        return data;
    }

    public void bind(ClassAdvisor advisor, ClassMetaDataBinding data, Method[] methods, Field[] fields, Constructor[] constructors) throws Exception {
        SimpleClassMetaDataBinding meta = (SimpleClassMetaDataBinding)data;
        SimpleMetaData defaultData = advisor.getDefaultMetaData();
        defaultData.mergeIn(meta.getDefaultMetaData());
        SimpleMetaData classData = advisor.getClassMetaData();
        classData.mergeIn(meta.getClassMetaData());
        if (methods != null) {
            MethodMetaData methodData = advisor.getMethodMetaData();
            this.bindMethodMetaData(meta, methodData, methods);
        }
        if (fields != null) {
            FieldMetaData fieldData = advisor.getFieldMetaData();
            this.bindFieldMetaData(meta, fieldData, fields);
        }
        if (constructors != null) {
            ConstructorMetaData condata = advisor.getConstructorMetaData();
            this.bindConstructorMetaData(meta, condata, constructors);
        }
    }

    protected void bindMethodMetaData(SimpleClassMetaDataBinding data, MethodMetaData methodMetaData, Method[] advisedMethods) {
        ArrayList queuedData = data.getQueuedMethodMetaData();
        for (int i = 0; i < queuedData.size(); ++i) {
            SimpleClassMetaDataBinding.QueuedMethodMetaData queued = (SimpleClassMetaDataBinding.QueuedMethodMetaData)queuedData.get(i);
            for (int j = 0; j < advisedMethods.length; ++j) {
                if (!queued.expr.matches(advisedMethods[j])) continue;
                methodMetaData.addMethodMetaData(advisedMethods[j], (Object)queued.tag, (Object)queued.attr, queued.value);
            }
        }
    }

    protected void bindFieldMetaData(SimpleClassMetaDataBinding data, FieldMetaData fieldMetaData, Field[] advisedFields) {
        ArrayList queuedData = data.getQueuedFieldMetaData();
        for (int i = 0; i < queuedData.size(); ++i) {
            SimpleClassMetaDataBinding.QueuedMetaData queued = (SimpleClassMetaDataBinding.QueuedMetaData)queuedData.get(i);
            for (int j = 0; j < advisedFields.length; ++j) {
                String fieldName = advisedFields[j].getName();
                if (!queued.matches(fieldName)) continue;
                fieldMetaData.addFieldMetaData(advisedFields[j], (Object)queued.tag, (Object)queued.attr, queued.value);
            }
        }
    }

    protected void bindConstructorMetaData(SimpleClassMetaDataBinding data, ConstructorMetaData conMetaData, Constructor[] advisedCons) {
        ArrayList queuedData = data.getQueuedConstructorMetaData();
        for (int i = 0; i < queuedData.size(); ++i) {
            SimpleClassMetaDataBinding.QueuedConstructorMetaData queued = (SimpleClassMetaDataBinding.QueuedConstructorMetaData)queuedData.get(i);
            ConstructorExpression expression = queued.expr;
            for (int j = 0; j < advisedCons.length; ++j) {
                if (!expression.matchParamsOnly(advisedCons[j])) continue;
                conMetaData.addConstructorMetaData(advisedCons[j], (Object)queued.tag, (Object)queued.attr, queued.value);
            }
        }
    }

    public void bind(ClassAdvisor advisor, ClassMetaDataBinding data, CtMethod[] methods, CtField[] fields, CtConstructor[] constructors) throws Exception {
        SimpleClassMetaDataBinding meta = (SimpleClassMetaDataBinding)data;
        SimpleMetaData defaultData = advisor.getDefaultMetaData();
        defaultData.mergeIn(meta.getDefaultMetaData());
        SimpleMetaData classData = advisor.getClassMetaData();
        classData.mergeIn(meta.getClassMetaData());
        if (methods != null) {
            MethodMetaData methodData = advisor.getMethodMetaData();
            this.bindMethodMetaData(meta, methodData, methods);
        }
        if (fields != null) {
            FieldMetaData fieldData = advisor.getFieldMetaData();
            this.bindFieldMetaData(meta, fieldData, fields);
        }
        if (constructors != null) {
            ConstructorMetaData condata = advisor.getConstructorMetaData();
            this.bindConstructorMetaData(meta, condata, constructors);
        }
    }

    protected void bindMethodMetaData(SimpleClassMetaDataBinding data, MethodMetaData methodMetaData, CtMethod[] advisedMethods) throws NotFoundException {
        ArrayList queuedData = data.getQueuedMethodMetaData();
        for (int i = 0; i < queuedData.size(); ++i) {
            SimpleClassMetaDataBinding.QueuedMethodMetaData queued = (SimpleClassMetaDataBinding.QueuedMethodMetaData)queuedData.get(i);
            for (int j = 0; j < advisedMethods.length; ++j) {
                if (!queued.expr.matches(advisedMethods[j])) continue;
                methodMetaData.addMethodMetaData(advisedMethods[j], (Object)queued.tag, (Object)queued.attr, queued.value);
            }
        }
    }

    protected void bindFieldMetaData(SimpleClassMetaDataBinding data, FieldMetaData fieldMetaData, CtField[] advisedFields) {
        ArrayList queuedData = data.getQueuedFieldMetaData();
        for (int i = 0; i < queuedData.size(); ++i) {
            SimpleClassMetaDataBinding.QueuedMetaData queued = (SimpleClassMetaDataBinding.QueuedMetaData)queuedData.get(i);
            for (int j = 0; j < advisedFields.length; ++j) {
                String fieldName = advisedFields[j].getName();
                if (!queued.matches(fieldName)) continue;
                fieldMetaData.addFieldMetaData(advisedFields[j].getName(), (Object)queued.tag, (Object)queued.attr, queued.value);
            }
        }
    }

    protected void bindConstructorMetaData(SimpleClassMetaDataBinding data, ConstructorMetaData conMetaData, CtConstructor[] advisedCons) throws NotFoundException {
        ArrayList queuedData = data.getQueuedConstructorMetaData();
        for (int i = 0; i < queuedData.size(); ++i) {
            SimpleClassMetaDataBinding.QueuedConstructorMetaData queued = (SimpleClassMetaDataBinding.QueuedConstructorMetaData)queuedData.get(i);
            ConstructorExpression expression = queued.expr;
            for (int j = 0; j < advisedCons.length; ++j) {
                if (!expression.matchParamsOnly(advisedCons[j])) continue;
                conMetaData.addConstructorMetaData(advisedCons[j], (Object)queued.tag, (Object)queued.attr, queued.value);
            }
        }
    }
}

