/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut.ast;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassExpression {
    private String original;
    private Pattern classPattern;
    private boolean isAnnotation = false;
    private boolean isInstanceOf = false;
    private boolean isTypedef = false;

    public ClassExpression(String expr) {
        this.original = expr;
        if (expr.startsWith("@")) {
            this.isAnnotation = true;
        } else {
            expr = this.original;
            if (expr.startsWith("$instanceof{")) {
                this.isInstanceOf = true;
                expr = expr.substring(12, expr.lastIndexOf("}"));
            } else if (expr.startsWith("$typedef{")) {
                this.isTypedef = true;
                expr = expr.substring(9, expr.lastIndexOf("}"));
            }
            expr = expr.replaceAll("\\.", "\\\\.");
            expr = expr.replaceAll("\\*", ".*");
            expr = expr.replaceAll("\\[", "\\\\[");
            expr = expr.replaceAll("]", "\\\\]");
            expr = expr.replaceAll("\\$", "\\\\\\$");
            this.classPattern = Pattern.compile(expr);
        }
    }

    public boolean isSimple() {
        return !this.isAnnotation && !this.isInstanceOf && !this.isTypedef;
    }

    public boolean matches(String classname) {
        if (this.isAnnotation) {
            return false;
        }
        Matcher m = this.classPattern.matcher(classname);
        return m.matches();
    }

    public boolean matchesAnnotation(String annotation) {
        if (!this.isAnnotation) {
            return false;
        }
        Matcher m = this.classPattern.matcher(annotation);
        return m.matches();
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean isInstanceOf() {
        return this.isInstanceOf;
    }

    public boolean isTypedef() {
        return this.isTypedef;
    }

    public String getOriginal() {
        return this.original;
    }

    public static String simpleType(Class type) {
        Class<?> ret = type;
        if (ret.isArray()) {
            Class<?> arr = ret;
            String array = "";
            while (arr.isArray()) {
                array = array + "[]";
                arr = arr.getComponentType();
            }
            return arr.getName() + array;
        }
        return ret.getName();
    }
}

