/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.SerialVersionUID;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.util.JavassistMethodHashing;
import org.jboss.aop.util.MethodHashing;
import org.jboss.util.collection.WeakValueHashMap;

public class ClassProxyFactory {
    private static Object maplock = new Object();
    private static WeakValueHashMap classnameMap = new WeakValueHashMap();
    private static WeakHashMap proxyCache = new WeakHashMap();
    private static WeakHashMap methodMapCache = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassProxy newInstance(Class clazz) throws Exception {
        if (ClassProxy.class.isAssignableFrom(clazz)) {
            clazz = clazz.getSuperclass();
        }
        Class proxyClass = null;
        Object object = maplock;
        synchronized (object) {
            proxyClass = (Class)proxyCache.get(clazz);
            if (proxyClass == null) {
                proxyClass = ClassProxyFactory.generateProxy(clazz);
                classnameMap.put((Object)clazz.getName(), (Object)proxyClass);
                proxyCache.put(clazz, proxyClass);
                HashMap map = ClassProxyFactory.methodMap(clazz);
                methodMapCache.put(proxyClass, map);
            }
        }
        ClassProxy proxy = (ClassProxy)proxyClass.newInstance();
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getMethodMap(String classname) {
        Object object = maplock;
        synchronized (object) {
            Class clazz = (Class)classnameMap.get((Object)classname);
            if (clazz == null) {
                return null;
            }
            return (HashMap)methodMapCache.get(clazz);
        }
    }

    public static HashMap getMethodMap(Class clazz) {
        HashMap map = ClassProxyFactory.getMethodMap(clazz.getName());
        if (map != null) {
            return map;
        }
        try {
            return ClassProxyFactory.methodMap(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class generateProxy(Class clazz) throws Exception {
        ClassPool pool = AspectManager.instance().findClassPool(clazz.getClassLoader());
        if (pool == null) {
            throw new NullPointerException("Could not find ClassPool");
        }
        CtClass superclass = pool.get(clazz.getName());
        CtClass template = pool.get("org.jboss.aop.proxy.ClassProxyTemplate");
        CtMethod writeEx = template.getDeclaredMethod("writeExternal");
        CtMethod readEx = template.getDeclaredMethod("readExternal");
        CtMethod body = template.getDeclaredMethod("_proxy$invoke");
        CtMethod getInstanceAdvisor = template.getDeclaredMethod("_getInstanceAdvisor");
        CtMethod setInstanceAdvisor = template.getDeclaredMethod("_setInstanceAdvisor");
        CtMethod dynamicInvoke = template.getDeclaredMethod("_dynamicInvoke");
        CtClass proxy = pool.makeClass("org.jboss.aop.proxy$" + clazz.getName(), superclass);
        proxy.addInterface(pool.get("org.jboss.aop.proxy.ClassProxy"));
        proxy.addInterface(pool.get("java.io.Externalizable"));
        proxy.addInterface(pool.get("org.jboss.aop.instrument.Untransformable"));
        CtClass type = pool.get("org.jboss.aop.ClassInstanceAdvisor");
        CtField field = new CtField(type, "_proxy$instance$advisor", proxy);
        field.setModifiers(2);
        proxy.addField(field, CtField.Initializer.byExpr((String)"new org.jboss.aop.ClassInstanceAdvisor(this)"));
        proxy.addMethod(CtNewMethod.copy((CtMethod)writeEx, (CtClass)proxy, null));
        proxy.addMethod(CtNewMethod.copy((CtMethod)readEx, (CtClass)proxy, null));
        proxy.addMethod(CtNewMethod.copy((CtMethod)getInstanceAdvisor, (CtClass)proxy, null));
        proxy.addMethod(CtNewMethod.copy((CtMethod)setInstanceAdvisor, (CtClass)proxy, null));
        proxy.addMethod(CtNewMethod.copy((CtMethod)dynamicInvoke, (CtClass)proxy, null));
        HashMap allMethods = JavassistMethodHashing.getMethodMap(superclass);
        Iterator it = allMethods.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            CtMethod m = (CtMethod)entry.getValue();
            Long key = (Long)entry.getKey();
            if (!Modifier.isPublic((int)m.getModifiers()) || Modifier.isStatic((int)m.getModifiers())) continue;
            CtMethod newMethod = CtNewMethod.wrapped((CtClass)m.getReturnType(), (String)m.getName(), (CtClass[])m.getParameterTypes(), (CtClass[])m.getExceptionTypes(), (CtMethod)body, (CtMethod.ConstParameter)CtMethod.ConstParameter.integer((long)key), (CtClass)proxy);
            newMethod.setModifiers(m.getModifiers());
            proxy.addMethod(newMethod);
        }
        SerialVersionUID.setSerialVersionUID((CtClass)proxy);
        return proxy.toClass();
    }

    private static void populateMethodTables(HashMap advised, Class superclass) throws Exception {
        if (superclass == null) {
            return;
        }
        if (superclass.getName().equals("java.lang.Object")) {
            return;
        }
        ClassProxyFactory.populateMethodTables(advised, superclass.getSuperclass());
        Method[] declaredMethods = superclass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            if (!ClassAdvisor.isAdvisable(declaredMethods[i])) continue;
            long hash = MethodHashing.methodHash(declaredMethods[i]);
            advised.put(new Long(hash), declaredMethods[i]);
        }
    }

    public static HashMap methodMap(Class clazz) throws Exception {
        HashMap methods = new HashMap();
        ClassProxyFactory.populateMethodTables(methods, clazz);
        return methods;
    }
}

