/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.standalone;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javassist.bytecode.ClassFile;
import org.jboss.aop.Advised;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Deployment;
import org.jboss.aop.instrument.TransformationException;
import org.jboss.aop.standalone.XmlReport;

public class Compiler {
    public boolean verbose = false;
    public static URLClassLoader loader;

    public boolean isJarFile(File src) {
        return src.isFile() && (src.getName().toLowerCase().endsWith(".jar") || src.getName().toLowerCase().endsWith(".zip"));
    }

    public static void main(String[] args) throws Exception {
        Compiler c = new Compiler();
        try {
            c.compile(args);
        }
        catch (Exception e) {
            if (c.verbose) {
                throw e;
            }
            if (e instanceof TransformationException) {
                System.exit(1);
            }
            throw e;
        }
    }

    public void usage() {
        System.err.println("Usage: aopc [-cp <classpath>] [-classpath <classpath>] [-report] [-verbose] [-aoppath <xml files>] <dir>+");
    }

    public void compile(String[] args) throws Exception {
        File f;
        if (args.length == 0) {
            this.usage();
            System.exit(1);
            return;
        }
        ArrayList<URL> paths = new ArrayList<URL>();
        ArrayList<File> files = new ArrayList<File>();
        boolean report = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (args[i].equals("-report")) {
                report = true;
                continue;
            }
            if (args[i].equals("-cp") || args[i].equals("-classpath")) {
                if (i + 1 > args.length - 1) {
                    this.usage();
                    System.exit(1);
                    return;
                }
                StringTokenizer tokenizer = new StringTokenizer(args[++i], File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    String cpath = tokenizer.nextToken();
                    File f2 = new File(cpath);
                    paths.add(f2.toURL());
                }
                continue;
            }
            if (args[i].equals("-aoppath")) {
                System.setProperty("jboss.aop.path", args[++i]);
                continue;
            }
            if (args[i].equals("-aopclasspath")) {
                System.setProperty("jboss.aop.class.path", args[++i]);
                continue;
            }
            if (args[i].equals("--SOURCEPATH")) {
                this.addFilesFromSourcePathFile(files, args[++i]);
                continue;
            }
            File f3 = new File(args[i]).getCanonicalFile();
            files.add(f3);
        }
        URL[] urls = paths.toArray(new URL[paths.size()]);
        loader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
        Deployment.searchClasspath = true;
        AspectManager.verbose = this.verbose;
        AspectManager.instance();
        if (report) {
            for (int i = 0; i < files.size(); ++i) {
                f = (File)files.get(i);
                this.loadFile(f);
            }
            FileOutputStream reportFile = new FileOutputStream("aop-report.xml");
            reportFile.write(XmlReport.toXml().getBytes());
            reportFile.close();
        } else {
            for (int i = 0; i < files.size(); ++i) {
                f = (File)files.get(i);
                if (f.isDirectory()) {
                    this.compileDirectory(f);
                    continue;
                }
                this.compileFile(f);
            }
        }
    }

    private void addFilesFromSourcePathFile(ArrayList files, String sourcePathFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(new File(sourcePathFile).getCanonicalFile()));
            String fileName = reader.readLine();
            while (fileName != null) {
                files.add(new File(fileName).getCanonicalFile());
                fileName = reader.readLine();
            }
        }
        catch (Exception e) {
            try {
                reader.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    public void loadFile(File file) throws Exception {
        DataInputStream is = new DataInputStream(new FileInputStream(file));
        ClassFile cf = new ClassFile(is);
        is.close();
        Class<?> clazz = loader.loadClass(cf.getName());
        if (Advised.class.isAssignableFrom(clazz)) {
            Field f = clazz.getDeclaredField("aop$classAdvisor$aop");
            f.setAccessible(true);
            Object o = f.get(null);
        }
    }

    public void compileFile(File file) throws Exception {
        DataInputStream is = new DataInputStream(new FileInputStream(file));
        ClassFile cf = new ClassFile(is);
        is.close();
        String className = cf.getName();
        URL classUrl = loader.getResource(className.replace('.', '/') + ".class");
        if (classUrl == null) {
            System.out.println("[warning] Unable to find " + file + " within classpath.  Make sure all transforming classes are within classpath.");
            return;
        }
        if (!classUrl.equals(file.toURL())) {
            System.out.println("[warning] Trying to compile " + file + " and found it also within " + classUrl + " will not proceed. ");
            return;
        }
        byte[] bytes = AspectManager.instance().transform(loader, className, null, null, null);
        if (bytes == null) {
            if (this.verbose) {
                System.out.println("[no comp needed] " + file);
            }
            return;
        }
        FileOutputStream os = new FileOutputStream(file);
        os.write(bytes);
        os.close();
        if (this.verbose) {
            System.out.println("[compiled] " + file);
        }
    }

    public void compileDirectory(File base) throws Exception {
        int i;
        File[] directories = base.listFiles(new DirectoryFilter());
        File[] classFiles = base.listFiles(new ClassFileFilter());
        for (i = 0; i < classFiles.length; ++i) {
            this.compileFile(classFiles[i]);
        }
        for (i = 0; i < directories.length; ++i) {
            this.compileDirectory(directories[i]);
        }
    }

    private static class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    private static class ClassFileFilter
    implements FileFilter {
        private ClassFileFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".class");
        }
    }
}

