/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.standalone;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;

public class Package
implements Serializable {
    public HashMap advisors = new HashMap();
    public HashMap packages = new HashMap();
    public String name;

    public Package(String name) {
        this.name = name;
    }

    static void parse(String classname, Package root) {
        Advisor advisor = AspectManager.instance().getAdvisor(classname);
        StringTokenizer tokenizer = new StringTokenizer(classname, ".");
        while (tokenizer.hasMoreTokens()) {
            String pkgName = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                Package subpkg = (Package)root.packages.get(pkgName);
                if (subpkg == null) {
                    subpkg = new Package(pkgName);
                    root.packages.put(pkgName, subpkg);
                }
                root = subpkg;
                continue;
            }
            root.advisors.put(pkgName, advisor);
        }
    }

    public static Package aopClassMap() {
        HashMap advisors = AspectManager.instance().getAdvisors();
        Iterator it = advisors.keySet().iterator();
        Package root = new Package("classes");
        while (it.hasNext()) {
            String classname = (String)it.next();
            Package.parse(classname, root);
        }
        return root;
    }
}

