/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.SpyMessage;

public class TransactionRequest
implements Externalizable {
    static final long serialVersionUID = 5368191944552650149L;
    public static final byte ONE_PHASE_COMMIT_REQUEST = 0;
    public static final byte TWO_PHASE_COMMIT_PREPARE_REQUEST = 1;
    public static final byte TWO_PHASE_COMMIT_COMMIT_REQUEST = 2;
    public static final byte TWO_PHASE_COMMIT_ROLLBACK_REQUEST = 3;
    public byte requestType = 0;
    public Object xid;
    public SpyMessage[] messages;
    public AcknowledgementRequest[] acks;

    public void readExternal(ObjectInput in) throws IOException {
        int i;
        this.requestType = in.readByte();
        try {
            this.xid = in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Class not found for xid.");
        }
        int size = in.readInt();
        this.messages = new SpyMessage[size];
        for (i = 0; i < size; ++i) {
            this.messages[i] = SpyMessage.readMessage(in);
        }
        size = in.readInt();
        this.acks = new AcknowledgementRequest[size];
        for (i = 0; i < size; ++i) {
            this.acks[i] = new AcknowledgementRequest();
            this.acks[i].readExternal(in);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeByte(this.requestType);
        out.writeObject(this.xid);
        if (this.messages == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.messages.length);
            for (i = 0; i < this.messages.length; ++i) {
                SpyMessage.writeMessage(this.messages[i], out);
            }
        }
        if (this.acks == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.acks.length);
            for (i = 0; i < this.acks.length; ++i) {
                this.acks[i].writeExternal(out);
            }
        }
    }
}

