/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.pm.PersistenceManager;
import org.jboss.mq.pm.Tx;

public class TxManager {
    PersistenceManager persistenceManager;
    ConcurrentHashMap globalToLocal = new ConcurrentHashMap();
    static /* synthetic */ Class class$org$jboss$mq$pm$TxManager$GlobalXID;

    public TxManager(PersistenceManager pm) {
        this.persistenceManager = pm;
    }

    public final Tx getPrepared(ConnectionToken dc, Object xid) throws JMSException {
        GlobalXID gxid = new GlobalXID(dc, xid);
        Tx txid = (Tx)this.globalToLocal.get((Object)gxid);
        if (txid == null) {
            throw new SpyJMSException("Transaction does not exist from: " + dc.getClientID() + " xid=" + xid);
        }
        return txid;
    }

    public final Tx createTx() throws JMSException {
        Tx txId = this.persistenceManager.createPersistentTx();
        return txId;
    }

    public final void commitTx(Tx txId) throws JMSException {
        txId.commit(this.persistenceManager);
    }

    public void addPostCommitTask(Tx txId, Runnable task) throws JMSException {
        if (txId == null) {
            task.run();
            return;
        }
        txId.addPostCommitTask(task);
    }

    public void rollbackTx(Tx txId) throws JMSException {
        txId.commit(this.persistenceManager);
    }

    public void addPostRollbackTask(Tx txId, Runnable task) throws JMSException {
        if (txId == null) {
            return;
        }
        txId.addPostRollbackTask(task);
    }

    public Tx createTx(ConnectionToken dc, Object xid) throws JMSException {
        GlobalXID gxid = new GlobalXID(dc, xid);
        if (this.globalToLocal.containsKey((Object)gxid)) {
            throw new SpyJMSException("Duplicate transaction from: " + dc.getClientID() + " xid=" + xid);
        }
        Tx txId = this.createTx();
        this.globalToLocal.put((Object)gxid, (Object)txId);
        txId.addPostCommitTask(gxid);
        txId.addPostRollbackTask(gxid);
        return txId;
    }

    class GlobalXID
    implements Runnable {
        ConnectionToken dc;
        Object xid;

        GlobalXID(ConnectionToken dc, Object xid) {
            this.dc = dc;
            this.xid = xid;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != (class$org$jboss$mq$pm$TxManager$GlobalXID == null ? (class$org$jboss$mq$pm$TxManager$GlobalXID = TxManager.class$("org.jboss.mq.pm.TxManager$GlobalXID")) : class$org$jboss$mq$pm$TxManager$GlobalXID)) {
                return false;
            }
            return ((GlobalXID)obj).xid.equals(this.xid) && ((GlobalXID)obj).dc.equals(this.dc);
        }

        public int hashCode() {
            return this.xid.hashCode();
        }

        public void run() {
            TxManager.this.globalToLocal.remove((Object)this);
        }
    }
}

