/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.util.Iterator;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.JMSServerInterceptor;
import org.jboss.mq.server.JMSServerInterceptorSupport;

public class ClientReconnectInterceptor
extends JMSServerInterceptorSupport {
    protected static Logger log = Logger.getLogger((Class)ClientReconnectInterceptor.class);
    private JMSDestinationManager destinationManager;

    private JMSDestinationManager getDestinationManager() {
        if (this.destinationManager != null) {
            return this.destinationManager;
        }
        JMSServerInterceptor interceptor = this.getNext();
        while (!(interceptor instanceof JMSDestinationManager)) {
            interceptor = this.getNext();
        }
        this.destinationManager = (JMSDestinationManager)interceptor;
        return this.destinationManager;
    }

    private ConnectionToken findConnectionTokenFor(String clientID) {
        Iterator iterator = this.getDestinationManager().clientConsumers.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionToken dc = (ConnectionToken)iterator.next();
            if (!dc.getClientID().equals(clientID)) continue;
            return dc;
        }
        return null;
    }

    public void checkID(String ID) throws JMSException {
        try {
            super.checkID(ID);
        }
        catch (InvalidClientIDException e) {
            ConnectionToken dc = this.findConnectionTokenFor(ID);
            if (dc == null) {
                throw e;
            }
            try {
                super.connectionClosing(dc);
            }
            catch (Throwable e2) {
                log.trace((Object)"Disconnect of previously connected client caused an error:", (Throwable)e);
            }
            super.checkID(ID);
        }
    }
}

