/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.management.MBeanRegistration;
import javax.management.ObjectName;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.CacheStore;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.MessageCacheMBean;
import org.jboss.mq.server.MessageReference;
import org.jboss.system.ServiceMBeanSupport;

public class MessageCache
extends ServiceMBeanSupport
implements MessageCacheMBean,
MBeanRegistration,
Runnable {
    public static final long ONE_MEGABYTE = 1024000L;
    public static final long DEFAULT_HIGH_MEMORY_MARK = 51200000L;
    public static final long DEFAULT_MAX_MEMORY_MARK = 61440000L;
    private LRUCache lruCache = new LRUCache();
    private SynchronizedLong messageCounter = new SynchronizedLong(0L);
    long cacheHits = 0L;
    long cacheMisses = 0L;
    CacheStore cacheStore;
    ObjectName cacheStoreName;
    private Thread referenceSoftner;
    private long highMemoryMark = 51200000L;
    private long maxMemoryMark = 61440000L;
    private boolean makeSoftReferences = true;
    private long lastSoften = 0L;
    private long softenNoMoreOftenThanMillis = 0L;
    private long softenAtLeastEveryMillis = 0L;
    private long softenWaitMillis = 1000L;
    private int minimumHard = 1;
    private int maximumHard = 0;
    int softRefCacheSize = 0;
    int totalCacheSize = 0;
    ReferenceQueue referenceQueue = new ReferenceQueue();
    long softenedSize = 0L;
    boolean checkSoftReferenceDepth = false;

    public MessageCache getInstance() {
        return this;
    }

    public MessageReference add(SpyMessage message) throws JMSException {
        DurableSubscriptionID id = message.header.durableSubscriberID;
        return this.addInternal(message, null, 1, id);
    }

    public MessageReference add(SpyMessage message, BasicQueue queue, int stored) throws JMSException {
        DurableSubscriptionID id = message.header.durableSubscriberID;
        return this.addInternal(message, queue, stored, id);
    }

    public MessageReference add(SpyMessage message, BasicQueue queue, int stored, DurableSubscriptionID id) throws JMSException {
        return this.addInternal(message, queue, stored, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageReference addInternal(SpyMessage message, BasicQueue queue, int stored, DurableSubscriptionID id) throws JMSException {
        MessageReference mh = new MessageReference();
        mh.init(this, this.messageCounter.increment(), message, queue, id);
        mh.setStored(stored);
        MessageReference messageReference = mh;
        synchronized (messageReference) {
            LRUCache lRUCache = this.lruCache;
            synchronized (lRUCache) {
                this.lruCache.addMostRecent(mh);
                ++this.totalCacheSize;
            }
        }
        this.validateSoftReferenceDepth();
        return mh;
    }

    public void remove(MessageReference mr) throws JMSException {
        this.removeInternal(mr, true, true);
    }

    public void removeDelayed(MessageReference mr) throws JMSException {
        this.removeInternal(mr, true, false);
    }

    void soften(MessageReference mr) throws JMSException {
        this.removeInternal(mr, false, false);
        if (this.makeSoftReferences) {
            ++this.softRefCacheSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInternal(MessageReference mr, boolean clear, boolean reset) throws JMSException {
        MessageReference messageReference = mr;
        synchronized (messageReference) {
            if (mr.stored != 3) {
                LRUCache lRUCache = this.lruCache;
                synchronized (lRUCache) {
                    if (mr.hardReference != null) {
                        this.lruCache.remove(mr);
                    }
                    if (clear) {
                        --this.totalCacheSize;
                    }
                }
                if (clear) {
                    mr.clear();
                }
            }
            if (reset) {
                mr.reset();
            }
        }
    }

    public void run() {
        try {
            while (true) {
                Reference r = null;
                r = this.checkSoftReferenceDepth ? this.referenceQueue.poll() : this.referenceQueue.remove(this.softenWaitMillis);
                if (r != null) {
                    --this.softRefCacheSize;
                    while ((r = this.referenceQueue.poll()) != null) {
                        --this.softRefCacheSize;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("soft reference cache size is now: " + this.softRefCacheSize));
                    }
                    this.checkSoftReferenceDepth = true;
                }
                long now = System.currentTimeMillis();
                if (this.softenNoMoreOftenThanMillis > 0L && now - this.lastSoften < this.softenNoMoreOftenThanMillis) {
                    this.checkSoftReferenceDepth = false;
                } else if (this.softenAtLeastEveryMillis > 0L && now - this.lastSoften > this.softenAtLeastEveryMillis) {
                    this.checkSoftReferenceDepth = true;
                }
                if (!this.checkSoftReferenceDepth) continue;
                this.checkSoftReferenceDepth = this.validateSoftReferenceDepth();
                if (this.checkSoftReferenceDepth) continue;
                this.lastSoften = now;
            }
        }
        catch (InterruptedException e) {
        }
        catch (Throwable t) {
            this.log.error((Object)"Message Cache Thread Stopped: ", t);
        }
        this.log.debug((Object)"Thread exiting.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateSoftReferenceDepth() throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        while (this.getState() == 3) {
            MessageReference messageToSoften = null;
            Object object = this.lruCache;
            synchronized (object) {
                int removeCount;
                int softenCount = 0;
                int hardCount = this.getHardRefCacheSize();
                int softCount = this.getSoftRefCacheSize();
                if (hardCount <= this.minimumHard) {
                    return false;
                }
                long currentMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                if (currentMem > this.highMemoryMark) {
                    float severity = (float)(currentMem - this.highMemoryMark) / (float)(this.maxMemoryMark - this.highMemoryMark);
                    severity = Math.min(severity, 1.0f);
                    if (trace) {
                        this.log.trace((Object)("Memory usage serverity=" + severity));
                    }
                    int totalMessageInMem = hardCount + softCount;
                    int howManyShouldBeSoft = (int)((float)totalMessageInMem * severity);
                    softenCount = howManyShouldBeSoft - softCount;
                }
                if (this.maximumHard > 0 && (removeCount = hardCount - this.maximumHard) > 0 && removeCount > softenCount) {
                    softenCount = removeCount;
                }
                if (softenCount > hardCount) {
                    if (trace) {
                        this.log.trace((Object)("Soften count " + softenCount + " greater than hard references " + hardCount));
                    }
                    softenCount = hardCount;
                }
                if (softenCount > 1 || this.maximumHard > 0 && hardCount > this.maximumHard) {
                    if (trace) {
                        this.log.trace((Object)("Need to soften " + softenCount + " messages"));
                    }
                    Node node = this.lruCache.getLeastRecent();
                    messageToSoften = (MessageReference)node.data;
                }
            }
            if (messageToSoften == null) {
                return false;
            }
            object = messageToSoften;
            synchronized (object) {
                if (messageToSoften.messageCache != null && messageToSoften.stored != 3) {
                    messageToSoften.makeSoft();
                    if (messageToSoften.stored == 2) {
                        ++this.softenedSize;
                        return true;
                    }
                    if (messageToSoften.isPersistent()) {
                        return false;
                    }
                } else if (trace) {
                    this.log.trace((Object)("not softening removed message " + messageToSoften));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void messageReferenceUsedEvent(MessageReference mh, boolean wasHard) throws JMSException {
        MessageReference messageReference = mh;
        synchronized (messageReference) {
            LRUCache lRUCache = this.lruCache;
            synchronized (lRUCache) {
                if (wasHard) {
                    this.lruCache.makeMostRecent(mh);
                } else {
                    this.lruCache.addMostRecent(mh);
                }
            }
        }
        if (!wasHard) {
            this.checkSoftReferenceDepth = true;
        }
    }

    SpyMessage loadFromStorage(MessageReference mh) throws JMSException {
        return this.cacheStore.loadFromStorage(mh);
    }

    void saveToStorage(MessageReference mh, SpyMessage message) throws JMSException {
        this.cacheStore.saveToStorage(mh, message);
    }

    void removeFromStorage(MessageReference mh) throws JMSException {
        this.cacheStore.removeFromStorage(mh);
    }

    protected void startService() throws Exception {
        this.cacheStore = (CacheStore)this.getServer().getAttribute(this.cacheStoreName, "Instance");
        this.referenceSoftner = new Thread((Runnable)this, "JBossMQ Cache Reference Softner");
        this.referenceSoftner.setDaemon(true);
        this.referenceSoftner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() {
        LRUCache lRUCache = this.lruCache;
        synchronized (lRUCache) {
            this.referenceSoftner.interrupt();
            this.referenceSoftner = null;
        }
        this.cacheStore = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHardRefCacheSize() {
        LRUCache lRUCache = this.lruCache;
        synchronized (lRUCache) {
            return this.lruCache.size();
        }
    }

    public long getSoftenedSize() {
        return this.softenedSize;
    }

    public int getSoftRefCacheSize() {
        return this.softRefCacheSize;
    }

    public int getTotalCacheSize() {
        return this.totalCacheSize;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public boolean getMakeSoftReferences() {
        return this.makeSoftReferences;
    }

    public void setMakeSoftReferences(boolean makeSoftReferences) {
        this.makeSoftReferences = makeSoftReferences;
    }

    public int getMinimumHard() {
        return this.minimumHard;
    }

    public void setMinimumHard(int minimumHard) {
        this.minimumHard = minimumHard < 1 ? 1 : minimumHard;
    }

    public int getMaximumHard() {
        return this.maximumHard;
    }

    public void setMaximumHard(int maximumHard) {
        this.maximumHard = maximumHard < 0 ? 0 : maximumHard;
    }

    public long getSoftenWaitMillis() {
        return this.softenWaitMillis;
    }

    public void setSoftenWaitMillis(long millis) {
        this.softenWaitMillis = millis < 1000L ? 1000L : millis;
    }

    public long getSoftenNoMoreOftenThanMillis() {
        return this.softenNoMoreOftenThanMillis;
    }

    public void setSoftenNoMoreOftenThanMillis(long millis) {
        this.softenNoMoreOftenThanMillis = millis < 0L ? 0L : millis;
    }

    public long getSoftenAtLeastEveryMillis() {
        return this.softenAtLeastEveryMillis;
    }

    public void setSoftenAtLeastEveryMillis(long millis) {
        this.softenAtLeastEveryMillis = millis < 0L ? 0L : millis;
    }

    public long getHighMemoryMark() {
        return this.highMemoryMark / 1024000L;
    }

    public void setHighMemoryMark(long highMemoryMark) {
        this.highMemoryMark = highMemoryMark > 0L ? highMemoryMark * 1024000L : 0L;
    }

    public long getMaxMemoryMark() {
        return this.maxMemoryMark / 1024000L;
    }

    public void setMaxMemoryMark(long maxMemoryMark) {
        this.maxMemoryMark = maxMemoryMark > 0L ? maxMemoryMark * 1024000L : 0L;
    }

    public long getCurrentMemoryUsage() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024000L;
    }

    public String getName() {
        return "MessageCache";
    }

    public void setCacheStore(ObjectName cacheStoreName) {
        this.cacheStoreName = cacheStoreName;
    }

    public ObjectName getCacheStore() {
        return this.cacheStoreName;
    }

    class Node {
        Node moreRecent = null;
        Node lessRecent = null;
        Object data = null;

        Node() {
        }
    }

    class LRUCache {
        int currentSize = 0;
        HashMap map = new HashMap();
        Node mostRecent = null;
        Node leastRecent = null;

        LRUCache() {
        }

        public void addMostRecent(Object o) {
            Node newNode = new Node();
            newNode.data = o;
            Node oldNode = this.map.put(o, newNode);
            if (oldNode != null) {
                this.map.put(o, oldNode);
                throw new RuntimeException("Can't add object '" + o + "' to LRUCache that is already in cache.");
            }
            if (this.mostRecent == null) {
                this.mostRecent = newNode;
                this.leastRecent = newNode;
            } else {
                newNode.lessRecent = this.mostRecent;
                this.mostRecent.moreRecent = newNode;
                this.mostRecent = newNode;
            }
            ++this.currentSize;
        }

        public void addLeastRecent(Object o) {
            Node newNode = new Node();
            newNode.data = o;
            Node oldNode = this.map.put(o, newNode);
            if (oldNode != null) {
                this.map.put(o, oldNode);
                throw new RuntimeException("Can't add object '" + o + "' to LRUCache that is already in cache.");
            }
            if (this.leastRecent == null) {
                this.mostRecent = newNode;
                this.leastRecent = newNode;
            } else {
                newNode.moreRecent = this.leastRecent;
                this.leastRecent.lessRecent = newNode;
                this.leastRecent = newNode;
            }
            ++this.currentSize;
        }

        public void remove(Object o) {
            Node node = (Node)this.map.remove(o);
            if (node == null) {
                throw new RuntimeException("Can't remove object '" + o + "' that is not in cache.");
            }
            Node more = node.moreRecent;
            Node less = node.lessRecent;
            if (more == null) {
                this.mostRecent = less;
                if (this.mostRecent != null) {
                    this.mostRecent.moreRecent = null;
                }
            } else {
                more.lessRecent = less;
            }
            if (less == null) {
                this.leastRecent = more;
                if (this.leastRecent != null) {
                    this.leastRecent.lessRecent = null;
                }
            } else {
                less.moreRecent = more;
            }
            --this.currentSize;
        }

        public void makeMostRecent(Object o) {
            Node node = (Node)this.map.get(o);
            if (node == null) {
                throw new RuntimeException("Can't make most recent object '" + o + "' that is not in cache.");
            }
            Node more = node.moreRecent;
            Node less = node.lessRecent;
            if (more == null) {
                return;
            }
            more.lessRecent = less;
            if (less == null) {
                this.leastRecent = more;
            } else {
                less.moreRecent = more;
            }
            node.lessRecent = this.mostRecent;
            node.moreRecent = null;
            this.mostRecent.moreRecent = node;
            this.mostRecent = node;
        }

        public int size() {
            return this.currentSize;
        }

        public Node getMostRecent() {
            return this.mostRecent;
        }

        public Node getLeastRecent() {
            return this.leastRecent;
        }
    }
}

