/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.server.user.VOFactory;

import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.cache.ExtendedUserVOCache;
import com.opensymphony.module.access.provider.ejb.OsUserInRealm;
import com.opensymphony.module.access.provider.ejb.OsUserInRealmHome;
import com.opensymphony.module.access.provider.ejb.admin.OsLastlogin;
import com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome;
import com.opensymphony.module.access.provider.ejb.admin.OsUserChangepasswordHome;
import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.User;
import com.opensymphony.module.user.UserManager;
import com.opensymphony.module.user.provider.ejb.entity.OsUser;
import com.opensymphony.module.user.provider.ejb.entity.OsUserHome;
import com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordPeriode;
import com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordPeriodeHome;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.FinderException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.Management.group.VOFactory.SmallGroupVOFactory;
import server.Management.institut.InstitutManagerBean;
import server.Management.rights.authentication.logging.LoginDataHandler;
import server.Management.samba.ejb.SambaGroup;
import server.Management.samba.ejb.SambaGroupHome;
import server.Management.unixServer.SSHConnection;
import server.Management.user.UserManagementBean;

public class ExtendedUserVOFactory {
    private static final Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$server$user$VOFactory$ExtendedUserVOFactory == null ? (class$at$tugraz$genome$usermanagement$server$user$VOFactory$ExtendedUserVOFactory = ExtendedUserVOFactory.class$("at.tugraz.genome.usermanagement.server.user.VOFactory.ExtendedUserVOFactory")) : class$at$tugraz$genome$usermanagement$server$user$VOFactory$ExtendedUserVOFactory));
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$user$VOFactory$ExtendedUserVOFactory;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome;
    static /* synthetic */ Class class$server$Management$samba$ejb$SambaGroupHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome;

    private ExtendedUserVOFactory() {
    }

    public static ExtendedUserVO getUserVO(Long id, boolean ignoreCache) {
        return ExtendedUserVOFactory.getUserVO(UserManagementBean.getUserByID(id).getName(), ignoreCache);
    }

    public static ExtendedUserVO getUserVO(String username, boolean ignoreCache) {
        logger_.info((Object)("getUserVO " + username + " " + ignoreCache));
        ExtendedUserVOCache userVOCache_ = ExtendedUserVOCache.getInstance();
        logger_.debug((Object)("userVOCache_.hasUser(" + username + ")" + userVOCache_.hasUser(username)));
        if (!ignoreCache && userVOCache_.hasUser(username)) {
            ExtendedUserVO user = userVOCache_.getUser(username);
            if (user.getExpireDate() <= System.currentTimeMillis() && !username.startsWith("prj_") && !username.endsWith("$") && (user.isApplicationAuthenticationEnabled() || user.isLdapAuthenticationEnabled())) {
                logger_.info((Object)"Cached Object has expired");
                userVOCache_.updateUser(user.getName());
            }
            return user;
        }
        ExtendedUserVO user = null;
        User user_ = null;
        InitialContext ctx = null;
        OsUser osuser = null;
        try {
            UserManager um = UserManager.getInstance();
            user_ = um.getUser(username);
            ctx = new InitialContext();
            Object osref = ctx.lookup("OsUser");
            OsUserHome oshome = (OsUserHome)PortableRemoteObject.narrow((Object)osref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = ExtendedUserVOFactory.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            osuser = oshome.findByName(username);
            user = new ExtendedUserVO(osuser.getId(), username);
            user.setFullname(user_.getFullName());
            user.setEmail(user_.getEmail());
            user.setExpireDate(user_.getPropertySet().getDate("expiredate"));
            user.setStartDate(user_.getPropertySet().getDate("startdate"));
            Vector<SmallGroupVO> groupsOfUser = new Vector<SmallGroupVO>();
            Iterator it = user_.getGroups().iterator();
            while (it.hasNext()) {
                groupsOfUser.add(SmallGroupVOFactory.getData(((SmallGroupVO)it.next()).getName()));
            }
            user.setGroups(groupsOfUser);
            LoginDataHandler.getInstance().setNewData(username);
            Long date = LoginDataHandler.getInstance().getLastDate(username);
            user.setMainInstitute(InstitutManagerBean.getInstitut(username, ctx));
            if (user.getMainInstitute() != null) {
                user.setAdditionalInstitutes(InstitutManagerBean.getAddtionalInstitutes(username, ctx, user.getMainInstitute()));
            } else {
                user.setAdditionalInstitutes(new Vector());
            }
            String lastRealm = LoginDataHandler.getInstance().getLastRealm(username);
            if (date == 0L || lastRealm.equals("not available")) {
                OsLastlogin last = ExtendedUserVOFactory.getLastLoginDate(username, ctx);
                if (last == null) {
                    date = new Long(0L);
                    lastRealm = "not available";
                } else {
                    date = last.getLastlogin();
                    lastRealm = last.getApplication();
                }
            }
            user.setLastLoginDate(date);
            user.setLastLoginRealm(lastRealm);
            user.setIsLogged(LoginDataHandler.getInstance().isLoggedInServerSide(username));
            user.setLoggedOutSuccessfully(LoginDataHandler.getInstance().loggedOutProperly(username));
            user.setHasToChangePassword(ExtendedUserVOFactory.checkForPaswordChanging(username));
            Object ref = ctx.lookup("OsUserInRealm");
            OsUserInRealmHome home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = ExtendedUserVOFactory.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            Vector list = new Vector(home.findAllRealmsOfUser(user.getName()));
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                OsUserInRealm inRealm = (OsUserInRealm)iter.next();
                if (inRealm.getIsEnabled() == null) {
                    user.setActiveAtCurrentApplication(inRealm.getRealm(), false);
                    continue;
                }
                if (inRealm.getIsEnabled() > 0L) {
                    user.setActiveAtCurrentApplication(inRealm.getRealm(), true);
                    continue;
                }
                user.setActiveAtCurrentApplication(inRealm.getRealm(), false);
                logger_.debug((Object)("user " + user.getName() + " not enabled in application " + inRealm.getRealm()));
            }
        }
        catch (FinderException ex) {
            ex.printStackTrace();
            logger_.error((Object)"user is in no realm enabled");
            return null;
        }
        catch (NamingException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (EntityNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        try {
            Object refSmbGroup = ctx.lookup("SambaGroup");
            SambaGroupHome sambaGroupHome = (SambaGroupHome)PortableRemoteObject.narrow((Object)refSmbGroup, (Class)(class$server$Management$samba$ejb$SambaGroupHome == null ? (class$server$Management$samba$ejb$SambaGroupHome = ExtendedUserVOFactory.class$("server.Management.samba.ejb.SambaGroupHome")) : class$server$Management$samba$ejb$SambaGroupHome));
            user.setWindowsDomain(osuser.getDomain());
            user.setWorkstation(osuser.getWorkstations());
            user.setLogonScript(osuser.getLogin_script());
            user.setProfilePath(osuser.getProfilePath());
            user.setDirDrive(osuser.getDir_drive());
            user.setUserSID(osuser.getUser_sid());
            user.setWindowsHomeDir(osuser.getSambaDir());
            user.setLoginShell(osuser.getLoginShell());
            user.setUid(osuser.getUidNumber());
            user.setHomeDirectory(osuser.getHomeDirectory());
            Long sambaGroupId = osuser.getSambaGroupId();
            user.setSambaGroup("none");
            if (user.getExpireDate() <= System.currentTimeMillis() && !username.startsWith("prj_") && !username.endsWith("$")) {
                logger_.debug((Object)("Current Time: " + System.currentTimeMillis()));
                logger_.debug((Object)("Expire Date: " + user.getExpireDate()));
                if (osuser.getLdapAuthenticationEnabled() == 1L) {
                    try {
                        logger_.info((Object)("Account expired, will disable LDAP Authorization for " + username));
                        osuser.setLdapAuthenticationEnabled(new Long(0L));
                        UserManagementBean.reorganizeSambaProjectRights4User(user.getName());
                        UserManagementBean.removeUserLdapEntry(osuser.getId(), "OU=users," + UserManagementBean.getOrganizationalunitsLdap4CurrentDomain().getDn());
                        SSHConnection sshConnection = new SSHConnection(UserManagementBean.getOrganizationalunitsLdap4CurrentDomain().getOu());
                        sshConnection.invalidateCache();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (osuser.getApplicationAuthenticationEnabled() == 1L) {
                    logger_.info((Object)("Account expired, will disable Authentication Authorization for " + username));
                    osuser.setApplicationAuthenticationEnabled(new Long(0L));
                }
            }
            if (sambaGroupId != null) {
                try {
                    SambaGroup sambaGroup = sambaGroupHome.findByPrimaryKey(osuser.getSambaGroupId());
                    user.setSambaGroup(sambaGroup.getDisplayName());
                    user.setSambaGroupId(sambaGroup.getId());
                }
                catch (FinderException ex4) {
                    // empty catch block
                }
            }
            if (osuser.getApplicationAuthenticationEnabled() > 0L) {
                user.setApplicationAuthenticationEnabled(true);
            } else {
                user.setApplicationAuthenticationEnabled(false);
            }
            if (osuser.getLdapAuthenticationEnabled() > 0L) {
                user.setLdapAuthenticationEnabled(true);
            } else {
                user.setLdapAuthenticationEnabled(false);
            }
        }
        catch (NamingException ex2) {
            ex2.printStackTrace();
        }
        try {
            Object perioderef = ctx.lookup("OsPasswordPeriode");
            OsPasswordPeriodeHome passwordPeriodeHome = (OsPasswordPeriodeHome)PortableRemoteObject.narrow((Object)perioderef, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome = ExtendedUserVOFactory.class$("com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordPeriodeHome")) : class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome));
            OsPasswordPeriode passwdPeriode = passwordPeriodeHome.findByUsername(username);
            user.setChangePeriode(passwdPeriode.getPwdtype());
            logger_.debug((Object)(username + " Expire Type " + passwdPeriode.getPwdtype()));
            if (passwdPeriode.getPeriod().doubleValue() < 1.0) {
                user.setTimeToChangePasswordInDays("never");
            } else {
                Long days = new Long(passwdPeriode.getPeriod() - System.currentTimeMillis());
                Float time = new Float(days / 86400000L);
                if (time.floatValue() <= 0.0f) {
                    user.setTimeToChangePasswordInDays("is expired !");
                } else if (time.floatValue() <= 1.0f) {
                    user.setTimeToChangePasswordInDays("will expire tomorrow !");
                } else if (time.floatValue() <= 6.0f) {
                    user.setTimeToChangePasswordInDays("will expire this week !");
                } else if (time.floatValue() <= 30.0f) {
                    user.setTimeToChangePasswordInDays("will expire this month !");
                } else {
                    user.setTimeToChangePasswordInDays("will expire in " + time.toString() + " days !");
                }
                logger_.debug((Object)(username + " " + user.getTimeToChangePasswordInDays()));
            }
        }
        catch (FinderException ex3) {
            logger_.error((Object)("user has no OsPasswordPeriode " + username));
        }
        catch (NamingException ex3) {
            ex3.printStackTrace();
        }
        userVOCache_.putUserVO(username, user);
        return user;
    }

    private static boolean checkForPaswordChanging(String username) {
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsUserChangepassword");
            OsUserChangepasswordHome passwordHome = (OsUserChangepasswordHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome = ExtendedUserVOFactory.class$("com.opensymphony.module.access.provider.ejb.admin.OsUserChangepasswordHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome));
            passwordHome.findByPrimaryKey(username);
            logger_.debug((Object)("user " + username + " has to change his/her password"));
            return true;
        }
        catch (NamingException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (FinderException ex) {
            return false;
        }
    }

    private static OsLastlogin getLastLoginDate(String username, Context ctx) {
        try {
            Object dataref = ctx.lookup("OsLastlogin");
            OsLastloginHome lastLogin = (OsLastloginHome)PortableRemoteObject.narrow((Object)dataref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome = ExtendedUserVOFactory.class$("com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome));
            OsLastlogin logindata = lastLogin.findByUsername(username);
            return logindata;
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        catch (FinderException ex) {
            logger_.debug((Object)("no last logindate found for user " + username));
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

