/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.xml;

import at.tugraz.genome.usermanagement.server.acl.VO.AclImportVO;
import at.tugraz.genome.usermanagement.server.acl.VO.AclVO;
import at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO;
import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.resource.VO.ResourceVO;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import server.Management.util.Constants;

public class AclParser {
    private AclImportVO aclImportVO = null;

    public AclParser(Document doc) {
        Element root = doc.getDocumentElement();
        ApplicationVO appVO = null;
        Vector groups = new Vector();
        Vector resources = new Vector();
        Vector acls = new Vector();
        if (root.getNodeName().equalsIgnoreCase("AclExport")) {
            NamedNodeMap appAttrs = root.getAttributes();
            Node appAttr = null;
            int i = 0;
            while (i != appAttrs.getLength()) {
                appAttr = appAttrs.item(i);
                if (appAttr.getNodeName().equalsIgnoreCase("Applicationname")) {
                    appVO = new ApplicationVO(appAttr.getNodeValue());
                }
                ++i;
            }
            if (appVO != null) {
                NodeList appChildren = root.getChildNodes();
                Node appChild = null;
                int i2 = 0;
                while (i2 != appChildren.getLength()) {
                    appChild = appChildren.item(i2);
                    if (appChild.getNodeName().equalsIgnoreCase("Groups")) {
                        groups = this.parseGroups(appChild.getChildNodes(), appVO.getApplicationname());
                    }
                    if (appChild.getNodeName().equalsIgnoreCase("Resources")) {
                        resources = this.parseResources(appChild.getChildNodes());
                    }
                    if (appChild.getNodeName().equalsIgnoreCase("Acls")) {
                        acls = this.parseAcls(appChild.getChildNodes());
                    }
                    ++i2;
                }
                this.aclImportVO = new AclImportVO(appVO, groups, resources, acls);
            }
        }
    }

    private Vector parseGroups(NodeList groupList, String realm) {
        Vector<SmallGroupVO> groups = new Vector<SmallGroupVO>();
        Element group = null;
        int i = 0;
        while (i != groupList.getLength()) {
            group = (Element)groupList.item(i);
            if (group.getNodeName().equalsIgnoreCase("Group")) {
                NamedNodeMap atts = group.getAttributes();
                Node att = null;
                String name = null;
                boolean active = false;
                boolean isAdmin = false;
                int j = 0;
                while (j != atts.getLength()) {
                    att = atts.item(j);
                    if (att.getNodeName().equalsIgnoreCase("name")) {
                        name = att.getNodeValue();
                    }
                    if (att.getNodeName().equalsIgnoreCase("active") && att.getNodeValue().equalsIgnoreCase("true")) {
                        active = true;
                    }
                    if (att.getNodeName().equalsIgnoreCase("admin") && att.getNodeValue().equalsIgnoreCase("true")) {
                        isAdmin = true;
                    }
                    if (name != null) {
                        SmallGroupVO groupVO = new SmallGroupVO(name);
                        if (active) {
                            groupVO.setActive(realm, Constants.GROUP_IN_REALM_ACTIVE);
                        } else {
                            groupVO.setActive(realm, Constants.GROUP_IN_REALM_INACTIVE);
                        }
                        Vector<String> adminRealms = new Vector<String>();
                        if (isAdmin) {
                            adminRealms.add(realm);
                        }
                        groupVO.setRealmGroupIsAdmin(adminRealms);
                        groups.add(groupVO);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return groups;
    }

    private Vector parseResources(NodeList resourceList) {
        Vector<ResourceVO> resources = new Vector<ResourceVO>();
        Element resource = null;
        int i = 0;
        while (i != resourceList.getLength()) {
            resource = (Element)resourceList.item(i);
            if (resource.getNodeName().equalsIgnoreCase("Resource")) {
                NamedNodeMap atts = resource.getAttributes();
                Node att = null;
                String key = null;
                String description = null;
                String availableAccess = null;
                int j = 0;
                while (j != atts.getLength()) {
                    att = atts.item(j);
                    if (att.getNodeName().equalsIgnoreCase("resourceKey")) {
                        key = att.getNodeValue();
                    }
                    if (att.getNodeName().equalsIgnoreCase("description")) {
                        description = att.getNodeValue();
                    }
                    if (att.getNodeName().equalsIgnoreCase("availableAccess")) {
                        availableAccess = att.getNodeValue();
                    }
                    if (key != null && key.length() > 0 && availableAccess != null && availableAccess.length() > 0) {
                        ResourceVO resourceVO = new ResourceVO();
                        resourceVO.setResourceKey(key);
                        resourceVO.setAvailAccess(availableAccess);
                        resourceVO.setDescription(description);
                        resources.add(resourceVO);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return resources;
    }

    private Vector parseAcls(NodeList aclList) {
        Vector<AclVO> acls = new Vector<AclVO>();
        Element acl = null;
        int i = 0;
        while (i != aclList.getLength()) {
            acl = (Element)aclList.item(i);
            if (acl.getNodeName().equalsIgnoreCase("Acl")) {
                NamedNodeMap atts = acl.getAttributes();
                Node att = null;
                String key = null;
                String groupId = null;
                String accessLevel = null;
                int j = 0;
                while (j != atts.getLength()) {
                    att = atts.item(j);
                    if (att.getNodeName().equalsIgnoreCase("accessLevel")) {
                        accessLevel = att.getNodeValue();
                    }
                    if (att.getNodeName().equalsIgnoreCase("groupId")) {
                        groupId = att.getNodeValue();
                    }
                    if (att.getNodeName().equalsIgnoreCase("resourceKey")) {
                        key = att.getNodeValue();
                    }
                    if (key != null && key.length() > 0 && accessLevel != null && accessLevel.length() > 0 && groupId != null && groupId.length() > 0) {
                        AclVO aclVO = new AclVO();
                        aclVO.setAccessLevel(accessLevel);
                        aclVO.setGroupId(groupId);
                        aclVO.setResourceKey(key);
                        acls.add(aclVO);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return acls;
    }

    public AclImportVO getAclImportVO() {
        return this.aclImportVO;
    }
}

