/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.xml;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLFileLoader {
    private Document doc = null;
    private static final Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$xml$XMLFileLoader == null ? (class$at$tugraz$genome$usermanagement$xml$XMLFileLoader = XMLFileLoader.class$("at.tugraz.genome.usermanagement.xml.XMLFileLoader")) : class$at$tugraz$genome$usermanagement$xml$XMLFileLoader));
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$xml$XMLFileLoader;

    public XMLFileLoader(File fn) throws SAXException {
        logger_.info((Object)("XMLFileLoader :" + fn.getAbsolutePath()));
        boolean validation = true;
        boolean ignoreWhitespace = true;
        boolean ignoreComments = true;
        boolean putCDATAIntoText = false;
        boolean createEntityRefs = false;
        if (fn.exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(validation);
            dbf.setIgnoringComments(ignoreComments);
            dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
            dbf.setCoalescing(putCDATAIntoText);
            dbf.setExpandEntityReferences(!createEntityRefs);
            DocumentBuilder db = null;
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                System.err.println(pce);
                JOptionPane.showConfirmDialog(null, "Error Initalising Parser! \n Can not start program", "Parser Error", -1, 0);
                System.exit(1);
            }
            db.setErrorHandler(new MyErrorHandler());
            this.doc = null;
            try {
                this.doc = db.parse(fn);
                db = null;
            }
            catch (IOException ioe) {
                System.err.println(ioe);
            }
        } else {
            logger_.info((Object)"Filename does not exist !!!!!");
            this.doc = null;
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            logger_.warn((Object)("Warning: " + this.getParseExceptionInfo(spe)));
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

