/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.access;

import com.opensymphony.module.access.DuplicateKeyException;
import com.opensymphony.module.access.ImmutableException;
import com.opensymphony.module.access.NotFoundException;
import com.opensymphony.module.access.entities.Acl_I;
import com.opensymphony.module.access.entities.Group_I;
import com.opensymphony.module.access.entities.Resource_I;
import com.opensymphony.module.access.entities.User_I;
import com.opensymphony.module.access.provider.BaseProvider;
import com.opensymphony.module.access.provider.ResourceProvider;
import com.opensymphony.module.access.provider.UserProvider;
import com.opensymphony.module.access.util.ConfigLoader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public final class AccessManager
implements Serializable {
    private static AccessManager instance;
    public static final Logger logger;
    private static final String locationOfApplications = "OsApplications";
    private Accessor accessor;
    private List accessProviders = new ArrayList();
    private List resourceProviders = new ArrayList();
    private static final int TYPE_USER = 0;
    private static final int TYPE_RESOURCE = 1;
    static /* synthetic */ Class class$com$opensymphony$module$access$AccessManager;

    private AccessManager() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.accessor = new Accessor();
        ConfigLoader configLoader = new ConfigLoader();
        configLoader.load(locationOfApplications, this);
    }

    public static AccessManager getInstance() {
        if (instance == null) {
            instance = new AccessManager();
        }
        return instance;
    }

    public static void restart() {
        instance = new AccessManager();
    }

    public void addProvider(BaseProvider provider) {
        if (provider instanceof ResourceProvider) {
            logger.debug((Object)("add ResourceProvider " + provider.getRealm()));
            this.resourceProviders.add(provider);
        }
        if (provider instanceof UserProvider) {
            logger.debug((Object)("add UserProvider " + provider.getRealm()));
            this.accessProviders.add(provider);
        }
    }

    public Collection getAccessProviders() {
        return this.accessProviders;
    }

    public Collection getResourceProviders() {
        return this.resourceProviders;
    }

    private BaseProvider getProvider(String name, List providers) {
        Iterator i = providers.iterator();
        while (i.hasNext()) {
            BaseProvider provider = (BaseProvider)i.next();
            if (!provider.handles(name)) continue;
            return provider;
        }
        return null;
    }

    public boolean userHasAccessLevel(String userId, String resourceKey, String accessLevel) throws NotFoundException {
        return this.userHasAccessLevel("default", userId, resourceKey, accessLevel);
    }

    public boolean userHasAccessLevel(String realm, String userId, String resourceKey, String accessLevel) throws NotFoundException {
        logger.debug((Object)("userHasAccessLevel for realm: " + realm));
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        return rp.userHasAccessLevel(userId, resourceKey, accessLevel);
    }

    public String getUserAccessLevels(String userId, String resourceKey) throws NotFoundException {
        return this.getUserAccessLevels("default", userId, resourceKey);
    }

    public String getUserAccessLevels(String realm, String userId, String resourceKey) throws NotFoundException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        return rp.getUserAccessLevels(userId, resourceKey);
    }

    public void updateUserAccessLevel(String userId, String resourceKey, String accessLevel) throws NotFoundException, ImmutableException {
        this.updateUserAccessLevel("default", userId, resourceKey, accessLevel);
    }

    public void updateUserAccessLevel(String realm, String userId, String resourceKey, String accessLevel) throws NotFoundException, ImmutableException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        rp.updateUserAccessLevel(realm, userId, resourceKey, accessLevel);
    }

    public void createUserAccessLevel(String userId, String resourceKey, String accessLevel) throws NotFoundException, ImmutableException, DuplicateKeyException {
        this.createUserAccessLevel("default", userId, resourceKey, accessLevel);
    }

    public void createUserAccessLevel(String realm, String userId, String resourceKey, String accessLevel) throws NotFoundException, ImmutableException, DuplicateKeyException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        rp.createUserAccessLevel(realm, userId, resourceKey, accessLevel);
    }

    public void deleteUserAccessLevel(String userId, String resourceKey) throws NotFoundException, ImmutableException {
        this.deleteUserAccessLevel("default", userId, resourceKey);
    }

    public void deleteUserAccessLevel(String realm, String userId, String resourceKey) throws NotFoundException, ImmutableException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        rp.deleteUserAccessLevel(userId, resourceKey);
    }

    public boolean groupHasAccessLevel(String groupId, String resourceKey, String accessLevel) throws NotFoundException {
        return this.groupHasAccessLevel("default", groupId, resourceKey, accessLevel);
    }

    public boolean groupHasAccessLevel(String realm, String groupId, String resourceKey, String accessLevel) throws NotFoundException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        return rp.groupHasAccessLevel(groupId, resourceKey, accessLevel);
    }

    public String getGroupAccessLevels(String groupId, String resourceKey) throws NotFoundException {
        return this.getGroupAccessLevels("default", groupId, resourceKey);
    }

    public String getGroupAccessLevels(String realm, String groupId, String resourceKey) throws NotFoundException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        return rp.getGroupAccessLevels(groupId, resourceKey);
    }

    public void updateGroupAccessLevels(String groupId, String resourceKey, String accessLevel) throws NotFoundException, ImmutableException {
        this.updateGroupAccessLevels("default", groupId, resourceKey, accessLevel);
    }

    public void updateGroupAccessLevels(String realm, String groupId, String resourceKey, String accessLevel) throws NotFoundException, ImmutableException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        rp.updateGroupAccessLevels(groupId, resourceKey, accessLevel);
    }

    public void createGroupAccessLevel(String groupId, String resourceKey, String accessLevel) throws NotFoundException, ImmutableException {
        this.createGroupAccessLevel("default", groupId, resourceKey, accessLevel);
    }

    public void createGroupAccessLevel(String realm, String groupId, String resourceKey, String accessLevel) throws NotFoundException, ImmutableException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        rp.createGroupAccessLevel(realm, groupId, resourceKey, accessLevel);
    }

    public void deleteGroupAccessLevel(String groupId, String resourceKey) throws NotFoundException, ImmutableException {
        this.deleteGroupAccessLevel("default", groupId, resourceKey);
    }

    public void deleteGroupAccessLevel(String realm, String groupId, String resourceKey) throws NotFoundException, ImmutableException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        rp.deleteGroupAccessLevel(realm, groupId, resourceKey);
    }

    public void deleteResource(String resourceKey) throws NotFoundException, ImmutableException {
        this.deleteResource("default", resourceKey);
    }

    public void deleteResource(String realm, String resourceKey) throws NotFoundException, ImmutableException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        rp.deleteResource(realm, resourceKey);
    }

    public boolean isUserInGroup(String userId, String groupId) throws NotFoundException {
        return this.isUserInGroup("default", userId, groupId);
    }

    public boolean isUserInGroup(String realm, String userId, String groupId) throws NotFoundException {
        UserProvider up = this.accessor.getUserProvider(realm);
        return up.isUserInGroup(userId, groupId);
    }

    public boolean isGroupInGroup(String childGroupId, String parentGroupId) throws NotFoundException {
        return this.isGroupInGroup("default", childGroupId, parentGroupId);
    }

    public boolean isGroupInGroup(String realm, String childGroupId, String parentGroupId) throws NotFoundException {
        UserProvider up = this.accessor.getUserProvider(realm);
        return up.isGroupInGroup(childGroupId, parentGroupId);
    }

    public List listUsersInGroup(String groupId) throws NotFoundException {
        return this.listUsersInGroup("default", groupId);
    }

    public List listParentGroupsOfGroup(String group) throws NotFoundException {
        return this.listParentGroupsOfGroup("default", group);
    }

    public List listParentGroupsOfGroup(String realm, String group) throws NotFoundException {
        UserProvider up = this.accessor.getUserProvider(realm);
        return up.listParentGroupsOfGroup(group);
    }

    public List listGroupsForUser(String userId) throws NotFoundException {
        return this.listGroupsForUser("default", userId);
    }

    public List listGroupsForUser(String realm, String userId) throws NotFoundException {
        UserProvider up = this.accessor.getUserProvider(realm);
        logger.debug((Object)("look for userId " + userId + " at realm: " + realm + "Provider: " + up));
        return up.listGroupsForUser(userId);
    }

    public List listUsersInGroup(String realm, String groupId) throws NotFoundException {
        UserProvider up = this.accessor.getUserProvider(realm);
        logger.debug((Object)("look for groupId " + groupId));
        return up.listUsersInGroup(groupId);
    }

    public List listGroupsInGroup(String parentGroupId) throws NotFoundException {
        return this.listGroupsInGroup("default", parentGroupId);
    }

    public List listGroupsInGroup(String realm, String parentGroupId) throws NotFoundException {
        UserProvider up = this.accessor.getUserProvider(realm);
        return up.listGroupsInGroup(parentGroupId);
    }

    public void addUserToGroup(String userId, String groupId) throws NotFoundException, ImmutableException {
        this.addUserToGroup("default", userId, groupId);
    }

    public void addUserToGroup(String realm, String userId, String groupId) throws NotFoundException, ImmutableException {
        UserProvider up = this.accessor.getUserProvider(realm);
        up.addUserToGroup(userId, groupId);
    }

    public void removeUserFromGroup(String userId, String groupId) throws NotFoundException, ImmutableException {
        this.removeUserFromGroup("default", userId, groupId);
    }

    public void removeUserFromGroup(String realm, String userId, String groupId) throws NotFoundException, ImmutableException {
        UserProvider up = this.accessor.getUserProvider(realm);
        up.removeUserFromGroup(userId, groupId);
    }

    public void addGroupToGroup(String childGroupId, String parentGroupId) throws NotFoundException, ImmutableException {
        this.addGroupToGroup("default", childGroupId, parentGroupId);
    }

    public void addGroupToGroup(String realm, String childGroupId, String parentGroupId) throws NotFoundException, ImmutableException {
        UserProvider up = this.accessor.getUserProvider(realm);
        up.addGroupToGroup(childGroupId, parentGroupId);
    }

    public ArrayList getResources() throws NotFoundException {
        return this.getResources("default");
    }

    public ArrayList getResources(String realm) throws NotFoundException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        return rp.getResources();
    }

    public Resource_I getResource(String resourceKey) throws NotFoundException {
        return this.getResource("default", resourceKey);
    }

    public Resource_I getResource(String realm, String resourceKey) throws NotFoundException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        return rp.getResourceByKey(realm, resourceKey);
    }

    public ArrayList getAclsByGroup(String groupId) throws NotFoundException {
        return this.getAclsByGroup("default", groupId);
    }

    public ArrayList getAclsByGroup(String realm, String groupId) throws NotFoundException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        return rp.getAclsByGroupId(groupId);
    }

    public ArrayList getAclsByUser(String userId) throws NotFoundException {
        return this.getAclsByUser("default", userId);
    }

    public ArrayList getAclsByUser(String realm, String userId) throws NotFoundException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        if (rp != null) {
            return rp.getAclsByUserId(userId);
        }
        return new ArrayList();
    }

    public ArrayList getAclsByResource(String resourceKey) throws NotFoundException {
        return this.getAclsByGroup("default", resourceKey);
    }

    public ArrayList getAclsByResource(String realm, String resourceKey) throws NotFoundException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        return rp.getAclsByResourceKey(resourceKey);
    }

    public void createResource(String resourceKey, String description, String availAccess) throws DuplicateKeyException, ImmutableException {
        this.createResource("default", resourceKey, description, availAccess);
    }

    public void createResource(String realm, String resourceKey, String description, String availAccess) throws DuplicateKeyException, ImmutableException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        if (rp == null) {
            logger.fatal((Object)("no ResourceProvider created for Realm: " + realm));
        }
        rp.createResource(realm, resourceKey, description, availAccess);
    }

    public ArrayList getAcls() throws NotFoundException {
        return this.getAcls("default");
    }

    public ArrayList getAcls(String realm) throws NotFoundException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        return rp.getAcls();
    }

    public ArrayList getUsers() throws NotFoundException {
        return this.getUsers("default");
    }

    public ArrayList getUsers(String realm) throws NotFoundException {
        UserProvider up = this.accessor.getUserProvider(realm);
        return up.getUsers();
    }

    public User_I getUser(String userId) throws NotFoundException {
        return this.getUser("default", userId);
    }

    public User_I getUser(String realm, String userId) throws NotFoundException {
        UserProvider up = this.accessor.getUserProvider(realm);
        return up.getUser(userId);
    }

    public ArrayList getGroups() throws NotFoundException {
        return this.getGroups("default");
    }

    public ArrayList getGroups(String realm) throws NotFoundException {
        UserProvider up = this.accessor.getUserProvider(realm);
        return up.getGroups();
    }

    public Group_I getGroup(String groupId) throws NotFoundException {
        return this.getGroup("default", groupId);
    }

    public Group_I getGroup(String realm, String groupId) throws NotFoundException {
        UserProvider up = this.accessor.getUserProvider(realm);
        return up.getGroup(groupId);
    }

    public Acl_I getAclById(Long aclId) throws NotFoundException {
        return this.getAclById("default", aclId);
    }

    public Acl_I getAclById(String realm, Long aclId) throws NotFoundException {
        ResourceProvider rp = this.accessor.getResourceProvider(realm);
        return rp.getAclsByAclId(aclId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = Logger.getLogger((Class)(class$com$opensymphony$module$access$AccessManager == null ? (class$com$opensymphony$module$access$AccessManager = AccessManager.class$("com.opensymphony.module.access.AccessManager")) : class$com$opensymphony$module$access$AccessManager));
    }

    public class Accessor
    implements Serializable {
        public ResourceProvider getResourceProvider(String name) {
            return (ResourceProvider)AccessManager.this.getProvider(name, AccessManager.this.resourceProviders);
        }

        public UserProvider getUserProvider(String name) {
            return (UserProvider)AccessManager.this.getProvider(name, AccessManager.this.accessProviders);
        }

        public AccessManager getAccessManager() {
            return AccessManager.this;
        }
    }
}

