/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.access;

import com.opensymphony.module.access.AccessManager;
import com.opensymphony.module.access.ImmutableException;
import com.opensymphony.module.access.provider.ResourceProvider;
import com.opensymphony.module.access.provider.UserProvider;
import java.io.Serializable;

public abstract class Entity
implements Serializable {
    protected String name;
    protected boolean mutable;
    protected Accessor accessor;
    private AccessManager.Accessor managerAccessor;

    protected Entity(String name, AccessManager.Accessor managerAccessor) {
        this.name = name;
        this.managerAccessor = managerAccessor;
    }

    public String getName() {
        return this.name;
    }

    public abstract void remove() throws ImmutableException;

    public void store() throws ImmutableException {
        if (!this.mutable) {
            throw new ImmutableException();
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public UserProvider getAccessProvider() {
        return this.managerAccessor.getUserProvider(this.name);
    }

    public ResourceProvider getResourceProvider() {
        return this.managerAccessor.getResourceProvider(this.name);
    }

    public AccessManager getUserManager() {
        return this.managerAccessor.getAccessManager();
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.name.equals(((Entity)obj).getName());
    }

    public abstract class Accessor
    implements Serializable {
        public Entity getEntity() {
            return Entity.this;
        }

        public void setName(String name) {
            Entity.this.name = name;
        }

        public void setMutable(boolean mutable) {
            Entity.this.mutable = mutable;
        }
    }
}

