/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.access.util;

import com.opensymphony.module.access.AccessManager;
import com.opensymphony.module.access.provider.BaseProvider;
import com.opensymphony.module.access.provider.ejb.application.OsApplications;
import com.opensymphony.module.access.provider.ejb.application.OsApplicationsHome;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigLoader
extends DefaultHandler {
    public static final Logger logger = Logger.getLogger((Class)(class$com$opensymphony$module$access$util$ConfigLoader == null ? (class$com$opensymphony$module$access$util$ConfigLoader = ConfigLoader.class$("com.opensymphony.module.access.util.ConfigLoader")) : class$com$opensymphony$module$access$util$ConfigLoader));
    protected Properties currentProperties;
    protected AccessManager userManager;
    protected String osApplication_;
    static /* synthetic */ Class class$com$opensymphony$module$access$util$ConfigLoader;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$application$OsApplicationsHome;

    public synchronized void load(String osApplication, AccessManager userManager) {
        this.osApplication_ = osApplication;
        this.userManager = userManager;
        this.loadDataFromDatabase();
    }

    private void loadDataFromDatabase() {
        logger.debug((Object)"will add Application from database");
        String userProvider = new String();
        String resourceProvider = new String();
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup(this.osApplication_);
            OsApplicationsHome home = (OsApplicationsHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$application$OsApplicationsHome == null ? (class$com$opensymphony$module$access$provider$ejb$application$OsApplicationsHome = ConfigLoader.class$("com.opensymphony.module.access.provider.ejb.application.OsApplicationsHome")) : class$com$opensymphony$module$access$provider$ejb$application$OsApplicationsHome));
            Vector allApps = new Vector(home.findAll());
            if (allApps == null) {
                return;
            }
            Iterator iter = allApps.iterator();
            while (iter.hasNext()) {
                OsApplications osApp = (OsApplications)iter.next();
                this.currentProperties = new Properties();
                this.currentProperties.setProperty("realm", osApp.getRealm());
                this.currentProperties.setProperty("aclLocation", osApp.getAcllocation());
                this.currentProperties.setProperty("resourceLocation", osApp.getResourcelocation());
                userProvider = osApp.getOsuserprovider();
                resourceProvider = osApp.getOsresourceprovider();
                this.addProvider(userProvider);
                this.addProvider(resourceProvider);
            }
        }
        catch (FinderException ex) {
            logger.error((Object)ex.toString());
        }
        catch (NamingException ex) {
            logger.error((Object)ex.toString());
        }
        catch (ClassCastException ex) {
            logger.error((Object)ex.toString());
        }
    }

    private void addProvider(String currentClass) {
        block6: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Provider class = " + currentClass + " " + this.currentProperties));
            }
            if (this.userManager == null) break block6;
            try {
                BaseProvider provider;
                try {
                    provider = (BaseProvider)Class.forName(currentClass).newInstance();
                }
                catch (NoClassDefFoundError ee) {
                    provider = (BaseProvider)Class.forName(currentClass, true, Thread.currentThread().getContextClassLoader()).newInstance();
                }
                if (provider.init(this.currentProperties)) {
                    this.userManager.addProvider(provider);
                    break block6;
                }
                logger.error((Object)("Could not initialize provider " + currentClass));
            }
            catch (Exception e) {
                logger.error((Object)"Could not create instance of provider", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

