/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.cached;

import com.opensymphony.module.propertyset.PropertiesException;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.module.propertyset.PropertySetSchema;
import com.opensymphony.module.propertyset.memory.SerializablePropertySet;
import com.opensymphony.util.DataUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Document;

public class CachingPropertySet
implements PropertySet,
Serializable {
    SerializablePropertySet cachePS;
    PropertySet decoratedPS;

    public void init(Map config, Map args) {
        this.decoratedPS = (PropertySet)args.get("PropertySet");
        String serializableName = (String)config.get("serializableName");
        if (serializableName == null) {
            serializableName = "serializable";
        }
        this.cachePS = (SerializablePropertySet)PropertySetManager.getInstance(serializableName, null);
        Boolean bulkload = (Boolean)args.get("bulkload");
        if (bulkload != null && bulkload.booleanValue()) {
            PropertySetManager.clone(this.decoratedPS, this.cachePS);
        }
    }

    public boolean getBoolean(String key) throws PropertiesException {
        if (!this.cachePS.exists(key)) {
            this.cachePS.setBoolean(key, this.decoratedPS.getBoolean(key));
        }
        return this.cachePS.getBoolean(key);
    }

    public void setBoolean(String key, boolean value) throws PropertiesException {
        this.decoratedPS.setBoolean(key, value);
        this.cachePS.setBoolean(key, value);
    }

    public int getInt(String key) throws PropertiesException {
        if (!this.cachePS.exists(key)) {
            this.cachePS.setInt(key, this.decoratedPS.getInt(key));
        }
        return this.cachePS.getInt(key);
    }

    public void setInt(String key, int value) throws PropertiesException {
        this.decoratedPS.setInt(key, value);
        this.cachePS.setInt(key, value);
    }

    public long getLong(String key) throws PropertiesException {
        if (!this.cachePS.exists(key)) {
            this.cachePS.setLong(key, this.decoratedPS.getLong(key));
        }
        return this.cachePS.getLong(key);
    }

    public void setLong(String key, long value) throws PropertiesException {
        this.decoratedPS.setLong(key, value);
        this.cachePS.setLong(key, value);
    }

    public double getDouble(String key) throws PropertiesException {
        if (!this.cachePS.exists(key)) {
            this.cachePS.setDouble(key, this.decoratedPS.getDouble(key));
        }
        return this.cachePS.getDouble(key);
    }

    public void setDouble(String key, double value) throws PropertiesException {
        this.decoratedPS.setDouble(key, value);
        this.cachePS.setDouble(key, value);
    }

    public String getString(String key) throws PropertiesException {
        if (!this.cachePS.exists(key)) {
            this.cachePS.setString(key, this.decoratedPS.getString(key));
        }
        return this.cachePS.getString(key);
    }

    public void setString(String key, String value) throws PropertiesException {
        this.decoratedPS.setString(key, value);
        this.cachePS.setString(key, value);
    }

    public String getText(String key) throws PropertiesException {
        if (!this.cachePS.exists(key)) {
            this.cachePS.setText(key, this.decoratedPS.getText(key));
        }
        return this.cachePS.getText(key);
    }

    public void setText(String key, String value) throws PropertiesException {
        this.decoratedPS.setText(key, value);
        this.cachePS.setText(key, value);
    }

    public Long getDate(String key) throws PropertiesException {
        if (!this.cachePS.exists(key)) {
            this.cachePS.setDate(key, this.decoratedPS.getDate(key));
        }
        return this.cachePS.getDate(key);
    }

    public void setDate(String key, Long value) throws PropertiesException {
        this.decoratedPS.setDate(key, value);
        this.cachePS.setDate(key, value);
    }

    public Object getObject(String key) throws PropertiesException {
        if (!this.cachePS.exists(key)) {
            this.cachePS.setObject(key, this.decoratedPS.getObject(key));
        }
        return this.cachePS.getObject(key);
    }

    public void setObject(String key, Object value) throws PropertiesException {
        this.decoratedPS.setObject(key, value);
        this.cachePS.setObject(key, value);
    }

    public Document getXML(String key) throws PropertiesException {
        if (!this.cachePS.exists(key)) {
            this.cachePS.setXML(key, this.decoratedPS.getXML(key));
        }
        return this.cachePS.getXML(key);
    }

    public void setXML(String key, Document value) throws PropertiesException {
        this.decoratedPS.setXML(key, value);
        this.cachePS.setXML(key, value);
    }

    public byte[] getData(String key) throws PropertiesException {
        if (!this.cachePS.exists(key)) {
            this.cachePS.setData(key, this.decoratedPS.getData(key));
        }
        return this.cachePS.getData(key);
    }

    public void setData(String key, byte[] value) throws PropertiesException {
        this.decoratedPS.setData(key, value);
        this.cachePS.setData(key, value);
    }

    public Properties getProperties(String key) throws PropertiesException {
        if (!this.cachePS.exists(key)) {
            this.cachePS.setProperties(key, this.decoratedPS.getProperties(key));
        }
        return this.cachePS.getProperties(key);
    }

    public void setProperties(String key, Properties value) throws PropertiesException {
        this.decoratedPS.setProperties(key, value);
        this.cachePS.setProperties(key, value);
    }

    public void setSchema(PropertySetSchema schema) throws PropertiesException {
        this.decoratedPS.setSchema(schema);
    }

    public PropertySetSchema getSchema() throws PropertiesException {
        return this.decoratedPS.getSchema();
    }

    public boolean exists(String key) throws PropertiesException {
        return this.decoratedPS.exists(key);
    }

    public void remove(String key) throws PropertiesException {
        this.cachePS.remove(key);
        this.decoratedPS.remove(key);
    }

    public int getType(String key) throws PropertiesException {
        return this.decoratedPS.getType(key);
    }

    public Collection getKeys() throws PropertiesException {
        return this.decoratedPS.getKeys();
    }

    public Collection getKeys(int type) throws PropertiesException {
        return this.decoratedPS.getKeys(type);
    }

    public Collection getKeys(String prefix) throws PropertiesException {
        return this.decoratedPS.getKeys(prefix);
    }

    public Collection getKeys(String prefix, int type) throws PropertiesException {
        return this.decoratedPS.getKeys(prefix, type);
    }

    public boolean supportsTypes() {
        return this.decoratedPS.supportsTypes();
    }

    public boolean supportsType(int type) {
        return this.decoratedPS.supportsType(type);
    }

    public boolean isSettable(String property) {
        return this.decoratedPS.isSettable(property);
    }

    public void setAsActualType(String key, Object value) throws PropertiesException {
        if (value instanceof Boolean) {
            this.setBoolean(key, DataUtil.getBoolean((Boolean)value));
        } else if (value instanceof Integer) {
            this.setInt(key, DataUtil.getInt((Integer)value));
        } else if (value instanceof Long) {
            this.setLong(key, DataUtil.getLong((Long)value));
        } else if (value instanceof Double) {
            this.setDouble(key, DataUtil.getDouble((Double)value));
        } else if (value instanceof String) {
            this.setString(key, (String)value);
        } else if (value instanceof Date) {
            this.setDate(key, (Long)value);
        } else if (value instanceof Document) {
            this.setXML(key, (Document)value);
        } else if (value instanceof byte[]) {
            this.setData(key, (byte[])value);
        } else if (value instanceof Properties) {
            this.setProperties(key, (Properties)value);
        } else {
            this.setObject(key, value);
        }
    }
}

