/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PropertySetConfig {
    private static PropertySetConfig config;
    private HashMap propertySets = new HashMap();
    private HashMap propertySetArgs = new HashMap();

    public static PropertySetConfig getConfig() {
        if (config == null) {
            config = new PropertySetConfig();
        }
        return config;
    }

    public String getClassName(String name) {
        return (String)this.propertySets.get(name);
    }

    public Map getArgs(String name) {
        return (Map)this.propertySetArgs.get(name);
    }

    private PropertySetConfig() {
        InputStream is = this.load();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document doc = null;
        try {
            doc = db.parse(is);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Element root = (Element)doc.getElementsByTagName("propertysets").item(0);
        NodeList propertySets = root.getElementsByTagName("propertyset");
        int i = 0;
        while (i < propertySets.getLength()) {
            Element propertySet = (Element)propertySets.item(i);
            String name = propertySet.getAttribute("name");
            String clazz = propertySet.getAttribute("class");
            this.propertySets.put(name, clazz);
            NodeList args = propertySet.getElementsByTagName("arg");
            HashMap<String, String> argsMap = new HashMap<String, String>();
            int j = 0;
            while (j < args.getLength()) {
                Element arg = (Element)args.item(j);
                String argName = arg.getAttribute("name");
                String argValue = arg.getAttribute("value");
                argsMap.put(argName, argValue);
                ++j;
            }
            this.propertySetArgs.put(name, argsMap);
            ++i;
        }
    }

    private InputStream load() {
        InputStream is;
        block16: {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            is = null;
            try {
                is = classLoader.getResourceAsStream("propertyset.xml");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (is == null) {
                try {
                    is = classLoader.getResourceAsStream("/propertyset.xml");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (is == null) {
                try {
                    is = classLoader.getResourceAsStream("META-INF/propertyset.xml");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (is == null) {
                try {
                    is = classLoader.getResourceAsStream("/META-INF/propertyset.xml");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (is == null) {
                try {
                    is = classLoader.getResourceAsStream("META-INF/propertyset-default.xml");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (is != null) break block16;
            try {
                is = classLoader.getResourceAsStream("/META-INF/propertyset-default.xml");
            }
            catch (Exception e) {}
        }
        return is;
    }
}

