/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.ejb;

import com.opensymphony.module.propertyset.AbstractPropertySet;
import com.opensymphony.module.propertyset.PropertiesException;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import com.opensymphony.module.propertyset.ejb.PropertyStoreLocal;
import com.opensymphony.module.propertyset.ejb.PropertyStoreLocalHome;
import com.opensymphony.util.DataUtil;
import com.opensymphony.util.EJBUtils;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Map;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EJBPropertySet
extends AbstractPropertySet
implements Serializable {
    private static final Log logger = LogFactory.getLog((Class)(class$com$opensymphony$module$propertyset$ejb$EJBPropertySet == null ? (class$com$opensymphony$module$propertyset$ejb$EJBPropertySet = EJBPropertySet.class$("com.opensymphony.module.propertyset.ejb.EJBPropertySet")) : class$com$opensymphony$module$propertyset$ejb$EJBPropertySet));
    private PropertyStoreLocal store;
    private String entityName;
    private long entityId;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$ejb$EJBPropertySet;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$ejb$PropertyStoreLocalHome;

    public void init(Map config, Map args) {
        this.entityId = DataUtil.getLong((Long)args.get("entityId"));
        this.entityName = (String)args.get("entityName");
        String storeLocation = (String)config.get("storeLocation");
        if (storeLocation == null) {
            storeLocation = "os.PropertyStore";
        }
        try {
            PropertyStoreLocalHome home = (PropertyStoreLocalHome)EJBUtils.lookup(storeLocation, class$com$opensymphony$module$propertyset$ejb$PropertyStoreLocalHome == null ? (class$com$opensymphony$module$propertyset$ejb$PropertyStoreLocalHome = EJBPropertySet.class$("com.opensymphony.module.propertyset.ejb.PropertyStoreLocalHome")) : class$com$opensymphony$module$propertyset$ejb$PropertyStoreLocalHome);
            this.store = home.create();
        }
        catch (NamingException e) {
            logger.error((Object)"home not found");
            e.printStackTrace();
        }
        catch (RemoteException e) {
            logger.error((Object)"remote error");
            e.printStackTrace();
        }
        catch (CreateException e) {
            logger.error((Object)"create error");
            e.printStackTrace();
        }
    }

    protected Object get(int type, String key) throws PropertiesException {
        logger.debug((Object)("get ==>>> entityName: " + this.entityName + " ,type: " + type + " ,key: " + key));
        try {
            return this.store.get(this.entityName, this.entityId, type, key);
        }
        catch (Exception re) {
            throw new PropertyImplementationException(re);
        }
    }

    protected void setImpl(int type, String key, Object value) throws PropertiesException {
        try {
            this.store.set(this.entityName, this.entityId, key, type, (Serializable)value);
        }
        catch (Exception re) {
            logger.error((Object)"Execption while setting property", (Throwable)re);
            throw new PropertyImplementationException(re);
        }
    }

    public boolean exists(String key) throws PropertiesException {
        try {
            return this.store.exists(this.entityName, this.entityId, key);
        }
        catch (Exception re) {
            throw new PropertyImplementationException(re);
        }
    }

    public void remove(String key) throws PropertiesException {
        try {
            this.store.remove(this.entityName, this.entityId, key);
        }
        catch (Exception re) {
            throw new PropertyImplementationException(re);
        }
    }

    public int getType(String key) throws PropertiesException {
        try {
            return this.store.getType(this.entityName, this.entityId, key);
        }
        catch (Exception re) {
            throw new PropertyImplementationException(re);
        }
    }

    public Collection getKeys(String prefix, int type) throws PropertiesException {
        try {
            return this.store.getKeys(this.entityName, this.entityId, prefix, type);
        }
        catch (Exception re) {
            throw new PropertyImplementationException(re);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

