/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.user.ImmutableException;
import com.opensymphony.module.user.UserManager;
import com.opensymphony.module.user.provider.AccessProvider;
import com.opensymphony.module.user.provider.CredentialsProvider;
import com.opensymphony.module.user.provider.ProfileProvider;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Entity
implements Serializable {
    private static final Log logger = LogFactory.getLog((Class)(class$com$opensymphony$module$user$Entity == null ? (class$com$opensymphony$module$user$Entity = Entity.class$("com.opensymphony.module.user.Entity")) : class$com$opensymphony$module$user$Entity));
    protected String name;
    protected Long id_;
    protected boolean mutable;
    protected Accessor accessor;
    private UserManager.Accessor managerAccessor;
    static /* synthetic */ Class class$com$opensymphony$module$user$Entity;

    protected Entity(String name, UserManager.Accessor managerAccessor) {
        this.name = name;
        this.managerAccessor = managerAccessor;
    }

    public String getName() {
        return this.name;
    }

    public PropertySet getPropertySet() {
        ProfileProvider profileProvider = this.getProfileProvider();
        if (!profileProvider.handles(this.name)) {
            profileProvider.create(this.name);
        }
        return profileProvider.getPropertySet(this.name);
    }

    public abstract void remove() throws ImmutableException;

    public void store() throws ImmutableException {
        if (!this.mutable) {
            throw new ImmutableException();
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public AccessProvider getAccessProvider() {
        return this.managerAccessor.getAccessProvider(this.name);
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.managerAccessor.getCredentialsProvider(this.name);
    }

    public ProfileProvider getProfileProvider() {
        return this.managerAccessor.getProfileProvider(this.name);
    }

    public UserManager getUserManager() {
        return this.managerAccessor.getUserManager();
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.name.equals(((Entity)obj).getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract class Accessor
    implements Serializable {
        public Entity getEntity() {
            return Entity.this;
        }

        public void setName(String name) {
            Entity.this.name = name;
        }

        public void setMutable(boolean mutable) {
            Entity.this.mutable = mutable;
        }
    }
}

