/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user;

import com.opensymphony.module.user.DuplicateEntityException;
import com.opensymphony.module.user.Entity;
import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.Group;
import com.opensymphony.module.user.ImmutableException;
import com.opensymphony.module.user.User;
import com.opensymphony.module.user.authenticator.Authenticator;
import com.opensymphony.module.user.provider.AccessProvider;
import com.opensymphony.module.user.provider.CredentialsProvider;
import com.opensymphony.module.user.provider.ProfileProvider;
import com.opensymphony.module.user.provider.UserProvider;
import com.opensymphony.module.user.util.ConfigLoader;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UserManager
implements Serializable {
    private static UserManager instance;
    private static final Log logger;
    private Accessor accessor;
    private List credentialsProviders = new ArrayList();
    private List accessProviders = new ArrayList();
    private List profileProviders = new ArrayList();
    private Authenticator authenticator = null;
    private static final int TYPE_USER = 0;
    private static final int TYPE_GROUP = 1;
    static /* synthetic */ Class class$com$opensymphony$module$user$UserManager;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$CredentialsProvider;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$AccessProvider;

    private UserManager() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.accessor = new Accessor();
        ConfigLoader configLoader = new ConfigLoader();
        String loc = "/osuser.xml";
        InputStream in = classLoader.getResourceAsStream(loc);
        if (in == null) {
            loc = "osuser.xml";
            in = classLoader.getResourceAsStream(loc);
        }
        if (in == null) {
            loc = "osuser-default.xml";
            in = classLoader.getResourceAsStream(loc);
        }
        if (in == null) {
            loc = "/META-INF/osuser.xml";
            in = classLoader.getResourceAsStream(loc);
        }
        if (in == null) {
            loc = "META-INF/osuser.xml";
            in = classLoader.getResourceAsStream(loc);
        }
        if (in == null) {
            loc = "/META-INF/osuser-default.xml";
            in = classLoader.getResourceAsStream(loc);
        }
        if (in == null) {
            loc = "META-INF/osuser-default.xml";
            in = classLoader.getResourceAsStream(loc);
        }
        configLoader.load(in, this);
        logger.debug((Object)("loaded using config : " + loc));
    }

    public static UserManager getInstance() {
        try {
            if (instance == null) {
                instance = new UserManager();
            }
        }
        catch (RuntimeException e) {
            return null;
        }
        return instance;
    }

    public static void restart() {
        instance = new UserManager();
    }

    public User getUser(String name) throws EntityNotFoundException {
        return (User)this.getEntity(name, this.credentialsProviders, 0);
    }

    public List getUsers() {
        return this.getEntities(this.credentialsProviders, 0);
    }

    public Group getGroup(String name) throws EntityNotFoundException {
        return (Group)this.getEntity(name, this.accessProviders, 1);
    }

    public List getGroups() {
        return this.getEntities(this.accessProviders, 1);
    }

    public Group createGroup(String name) throws DuplicateEntityException, ImmutableException {
        return (Group)this.createEntity(name, this.accessProviders, 1);
    }

    public User createUser(String name) throws DuplicateEntityException, ImmutableException {
        return (User)this.createEntity(name, this.credentialsProviders, 0);
    }

    public void addProvider(UserProvider provider) {
        if (provider instanceof CredentialsProvider) {
            this.credentialsProviders.add(provider);
        }
        if (provider instanceof ProfileProvider) {
            this.profileProviders.add(provider);
        }
        if (provider instanceof AccessProvider) {
            this.accessProviders.add(provider);
        }
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public Collection getCredentialsProviders() {
        return this.credentialsProviders;
    }

    public Collection getAccessProviders() {
        return this.accessProviders;
    }

    public Collection getProfileProviders() {
        return this.profileProviders;
    }

    public void flushCaches() {
        Iterator iterator = this.accessProviders.iterator();
        while (iterator.hasNext()) {
            UserProvider userProvider = (UserProvider)iterator.next();
            userProvider.flushCaches();
        }
        Iterator iterator2 = this.credentialsProviders.iterator();
        while (iterator2.hasNext()) {
            UserProvider userProvider = (UserProvider)iterator2.next();
            userProvider.flushCaches();
        }
        Iterator iterator3 = this.profileProviders.iterator();
        while (iterator3.hasNext()) {
            UserProvider userProvider = (UserProvider)iterator3.next();
            userProvider.flushCaches();
        }
    }

    private Entity buildEntity(String name, UserProvider provider, int type) {
        switch (type) {
            case 0: {
                return new User(name, this.accessor);
            }
            case 1: {
                return new Group(name, this.accessor);
            }
        }
        return null;
    }

    private List getEntities(List providers, int type) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        List toCheck = this.credentialsProviders;
        if (type == 1) {
            toCheck = this.accessProviders;
        }
        Iterator i = toCheck.iterator();
        while (i.hasNext()) {
            UserProvider provider = (UserProvider)i.next();
            List entities = provider.list();
            if (entities == null) continue;
            Iterator j = entities.iterator();
            while (j.hasNext()) {
                String name = (String)j.next();
                if (name == null) continue;
                Entity entity = this.buildEntity(name, provider, type);
                result.add(entity);
            }
        }
        return result;
    }

    private Entity getEntity(String name, List providers, int type) throws EntityNotFoundException {
        UserProvider provider = this.getProvider(name, type == 0 ? this.credentialsProviders : this.accessProviders);
        if (provider == null) {
            throw new EntityNotFoundException("No " + (type == 0 ? "user " : "group ") + name + " found");
        }
        return this.buildEntity(name, provider, type);
    }

    private Entity createEntity(String name, List providers, int type) throws DuplicateEntityException, ImmutableException {
        List providerList = this.credentialsProviders;
        if (type == 1) {
            providerList = this.accessProviders;
        }
        if (this.getProvider(name, providerList) != null) {
            throw new DuplicateEntityException((type == 0 ? "user " : "group ") + name + " already exists");
        }
        Iterator i = providerList.iterator();
        while (i.hasNext()) {
            Class toCheck;
            UserProvider provider = (UserProvider)i.next();
            Class clazz = toCheck = class$com$opensymphony$module$user$provider$CredentialsProvider == null ? UserManager.class$("com.opensymphony.module.user.provider.CredentialsProvider") : class$com$opensymphony$module$user$provider$CredentialsProvider;
            if (type == 1) {
                Class clazz2 = toCheck = class$com$opensymphony$module$user$provider$AccessProvider == null ? UserManager.class$("com.opensymphony.module.user.provider.AccessProvider") : class$com$opensymphony$module$user$provider$AccessProvider;
            }
            if (!toCheck.isAssignableFrom(provider.getClass()) || !provider.create(name)) continue;
            return this.buildEntity(name, provider, type);
        }
        throw new ImmutableException("No provider successfully created entity " + name);
    }

    private UserProvider getProvider(String name, List providers) {
        Iterator i = providers.iterator();
        while (i.hasNext()) {
            UserProvider provider = (UserProvider)i.next();
            if (!provider.handles(name)) continue;
            return provider;
        }
        if (providers == this.profileProviders) {
            Iterator i2 = providers.iterator();
            while (i2.hasNext()) {
                UserProvider provider = (UserProvider)i2.next();
                logger.debug((Object)("provider " + provider + " -> providers " + providers));
                if (!provider.create(name)) continue;
                return provider;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = LogFactory.getLog((Class)(class$com$opensymphony$module$user$UserManager == null ? (class$com$opensymphony$module$user$UserManager = UserManager.class$("com.opensymphony.module.user.UserManager")) : class$com$opensymphony$module$user$UserManager));
    }

    public class Accessor
    implements Serializable {
        public CredentialsProvider getCredentialsProvider(String name) {
            return (CredentialsProvider)UserManager.this.getProvider(name, UserManager.this.credentialsProviders);
        }

        public ProfileProvider getProfileProvider(String name) {
            return (ProfileProvider)UserManager.this.getProvider(name, UserManager.this.profileProviders);
        }

        public AccessProvider getAccessProvider(String name) {
            return (AccessProvider)UserManager.this.getProvider(name, UserManager.this.accessProviders);
        }

        public UserManager getUserManager() {
            return UserManager.this;
        }
    }
}

