/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user.provider.castor.entity;

import com.opensymphony.module.user.provider.castor.entity.BaseCastorEntity;
import com.opensymphony.module.user.provider.ejb.util.Base64;
import com.opensymphony.module.user.provider.ejb.util.PasswordDigester;
import java.util.ArrayList;

public class CastorUser
extends BaseCastorEntity {
    private String passwordHash = null;
    private String fullName = null;
    private String email = null;
    private ArrayList groups = null;

    public ArrayList getGroups() {
        return this.groups;
    }

    public void setGroups(ArrayList groups) {
        if (groups != null) {
            this.groups = new ArrayList(groups);
        }
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String name) {
        this.fullName = name;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public boolean authenticate(String password) {
        if (password == null || this.getPasswordHash() == null || password.length() == 0) {
            return false;
        }
        return this.compareHash(this.getPasswordHash(), password);
    }

    public void setPassword(String password) {
        this.setPasswordHash(this.createHash(password));
    }

    private String createHash(String original) {
        byte[] digested = PasswordDigester.digest(original.getBytes());
        byte[] encoded = Base64.encode(digested);
        return new String(encoded);
    }

    private boolean compareHash(String hashedValue, String unhashedValue) {
        return hashedValue.equals(this.createHash(unhashedValue));
    }
}

