/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user.provider.ejb;

import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import com.opensymphony.module.user.Entity;
import com.opensymphony.module.user.UserManagerImplementationException;
import com.opensymphony.module.user.provider.AccessProvider;
import com.opensymphony.module.user.provider.ejb.entity.OsMembership;
import com.opensymphony.module.user.provider.ejb.entity.OsMembershipHome;
import com.opensymphony.module.user.provider.ejb.entity.OsUser;
import com.opensymphony.module.user.provider.ejb.entity.OsUserHome;
import com.opensymphony.module.user.provider.ejb.entity.OsgroupRemote;
import com.opensymphony.module.user.provider.ejb.entity.OsgroupRemoteHome;
import com.opensymphony.util.EJBUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EJBAccessProvider
implements AccessProvider {
    private OsUserHome userHome;
    private OsgroupRemoteHome groupHome;
    private OsMembershipHome membershipHome;
    private static final Log logger = LogFactory.getLog((Class)(class$com$opensymphony$module$user$provider$ejb$EJBAccessProvider == null ? (class$com$opensymphony$module$user$provider$ejb$EJBAccessProvider = EJBAccessProvider.class$("com.opensymphony.module.user.provider.ejb.EJBAccessProvider")) : class$com$opensymphony$module$user$provider$ejb$EJBAccessProvider));
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$EJBAccessProvider;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$OsgroupRemoteHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$OsMembershipHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$OsgroupRemote;

    public boolean init(Properties properties) {
        try {
            try {
                InitialContext context = new InitialContext();
                String userLocation = properties.getProperty("location.user", "ejb/osuser/User");
                this.userHome = (OsUserHome)EJBUtils.lookup(userLocation, class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = EJBAccessProvider.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            String groupLocation = properties.getProperty("location.group", "ejb/osuser/Group");
            try {
                this.groupHome = (OsgroupRemoteHome)EJBUtils.lookup(groupLocation, class$com$opensymphony$module$user$provider$ejb$entity$OsgroupRemoteHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsgroupRemoteHome = EJBAccessProvider.class$("com.opensymphony.module.user.provider.ejb.entity.OsgroupRemoteHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsgroupRemoteHome);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            String membershipLocation = properties.getProperty("location.membership", "ejb/osuser/Membership");
            try {
                this.membershipHome = (OsMembershipHome)EJBUtils.lookup(membershipLocation, class$com$opensymphony$module$user$provider$ejb$entity$OsMembershipHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsMembershipHome = EJBAccessProvider.class$("com.opensymphony.module.user.provider.ejb.entity.OsMembershipHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsMembershipHome);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            return true;
        }
        catch (Exception e) {
            logger.fatal((Object)e);
            throw new UserManagerImplementationException("Could not lookup User home interface", e);
        }
    }

    public boolean handles(String name) {
        try {
            try {
                this.groupHome.findByName(name);
                return true;
            }
            catch (ObjectNotFoundException e) {
                try {
                    this.userHome.findByName(name);
                    return true;
                }
                catch (ObjectNotFoundException e2) {
                }
            }
        }
        catch (Exception e) {
            throw new UserManagerImplementationException(e);
        }
        return false;
    }

    public List list() {
        try {
            Collection groups = this.groupHome.findAll();
            ArrayList<String> result = new ArrayList<String>(groups.size());
            Iterator i = groups.iterator();
            while (i.hasNext()) {
                OsgroupRemote group = (OsgroupRemote)EJBUtils.narrow(i.next(), class$com$opensymphony$module$user$provider$ejb$entity$OsgroupRemote == null ? EJBAccessProvider.class$("com.opensymphony.module.user.provider.ejb.entity.OsgroupRemote") : class$com$opensymphony$module$user$provider$ejb$entity$OsgroupRemote);
                result.add(group.getName());
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"Could not list groups", (Throwable)e);
            throw new UserManagerImplementationException(e);
        }
    }

    public boolean load(String name, Entity.Accessor accessor) {
        accessor.setMutable(true);
        return true;
    }

    public boolean store(String name, Entity.Accessor accessor) {
        return true;
    }

    public boolean create(String name) {
        try {
            this.groupHome.create(name);
            return true;
        }
        catch (Exception e) {
            throw new UserManagerImplementationException(e);
        }
    }

    public boolean remove(String name) {
        try {
            Collection c = this.membershipHome.findByGroup(name);
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                try {
                    OsMembership home = (OsMembership)itr.next();
                    home.remove();
                }
                catch (RemoveException e) {
                    // empty catch block
                }
            }
            this.groupHome.findByName(name).remove();
            return true;
        }
        catch (RemoveException e) {
            return false;
        }
        catch (Exception e) {
            throw new UserManagerImplementationException(e);
        }
    }

    public boolean inGroup(String username, String groupname) {
        return this.getMembership(username, groupname) != null;
    }

    public boolean addToGroup(String username, String groupname) {
        if (this.inGroup(username, groupname)) {
            return true;
        }
        try {
            logger.debug((Object)("adding user (" + username + ") to group (" + groupname + ")"));
            OsUser user = this.userHome.findByName(username);
            OsgroupRemote group = this.groupHome.findByName(groupname);
            this.membershipHome.create(group.getName(), user.getName());
            logger.debug((Object)"success");
            return true;
        }
        catch (ObjectNotFoundException e) {
            logger.debug((Object)"not found");
            return false;
        }
        catch (Exception e) {
            throw new UserManagerImplementationException(e);
        }
    }

    public boolean removeFromGroup(String username, String groupname) {
        logger.debug((Object)("removing user (" + username + ") from group (" + groupname + ")"));
        OsMembership membership = this.getMembership(username, groupname);
        if (membership == null) {
            return false;
        }
        try {
            logger.debug((Object)("found membership for user (" + membership.getUser() + ") to group (" + membership.getGroup() + ")"));
            membership.remove();
            return true;
        }
        catch (Exception e) {
            throw new UserManagerImplementationException(e);
        }
    }

    public List listUsersInGroup(String groupname) {
        try {
            OsgroupRemote group = this.groupHome.findByName(groupname);
            Collection memberships = this.membershipHome.findByGroup(group.getName());
            ArrayList<String> result = new ArrayList<String>(memberships.size());
            Iterator iterator = memberships.iterator();
            while (iterator.hasNext()) {
                OsMembership membership = (OsMembership)iterator.next();
                result.add(membership.getUser());
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)e);
            throw new UserManagerImplementationException(e);
        }
    }

    public List listGroupsContainingUser(String username) {
        try {
            OsUser user = this.userHome.findByName(username);
            Collection memberships = this.membershipHome.findByUser(user.getName());
            ArrayList<SmallGroupVO> result = new ArrayList<SmallGroupVO>(memberships.size());
            Iterator iterator = memberships.iterator();
            while (iterator.hasNext()) {
                OsMembership membership = (OsMembership)iterator.next();
                result.add(new SmallGroupVO(membership.getGroup()));
            }
            return result;
        }
        catch (Exception e) {
            logger.info((Object)e);
            throw new UserManagerImplementationException(e);
        }
    }

    public void flushCaches() {
    }

    private OsMembership getMembership(String username, String groupname) {
        logger.debug((Object)("Getting membership for user (" + username + ") to group (" + groupname + ")"));
        try {
            OsUser user = this.userHome.findByName(username);
            OsgroupRemote group = this.groupHome.findByName(groupname);
            return this.membershipHome.findByUserAndGroup(user.getName(), group.getName());
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new UserManagerImplementationException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

