/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user.provider.jdbc;

import com.opensymphony.module.user.provider.CredentialsProvider;
import com.opensymphony.module.user.provider.ejb.util.Base64;
import com.opensymphony.module.user.provider.ejb.util.PasswordDigester;
import com.opensymphony.module.user.provider.jdbc.BaseJDBCProvider;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCCredentialsProvider
extends BaseJDBCProvider
implements CredentialsProvider {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$module$user$provider$jdbc$JDBCCredentialsProvider == null ? (class$com$opensymphony$module$user$provider$jdbc$JDBCCredentialsProvider = JDBCCredentialsProvider.class$("com.opensymphony.module.user.provider.jdbc.JDBCCredentialsProvider")) : class$com$opensymphony$module$user$provider$jdbc$JDBCCredentialsProvider));
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$jdbc$JDBCCredentialsProvider;

    public boolean handles(String name) {
        boolean handles = false;
        try {
            Connection conn = DriverManager.getConnection(this.connectionParameter, this.databaseUserName, this.databasePassword);
            if (conn == null) {
                log.fatal((Object)"Error: JDBC-Database-Connection is null");
                return false;
            }
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.userTable + " WHERE " + this.membershipUserName + " = ?");
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            handles = rs.next();
            rs.close();
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not see if [" + name + "] is handled at " + this.userTable), (Throwable)e);
        }
        return handles;
    }

    public List list() {
        ArrayList<String> users = new ArrayList<String>();
        try {
            Connection conn = DriverManager.getConnection(this.connectionParameter, this.databaseUserName, this.databasePassword);
            PreparedStatement ps = conn.prepareStatement("SELECT " + this.userName + " FROM " + this.userTable + " ORDER BY " + this.userName);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                users.add(rs.getString(1));
            }
            rs.close();
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)"Could not list users", (Throwable)e);
        }
        return users;
    }

    public boolean create(String name) {
        boolean created = false;
        try {
            Connection conn = DriverManager.getConnection(this.connectionParameter, this.databaseUserName, this.databasePassword);
            log.debug((Object)("INSERT INTO " + this.userTable + " (" + this.userName + ") VALUES (" + name + " )"));
            PreparedStatement ps = conn.prepareStatement("INSERT INTO " + this.userTable + " (" + this.userName + ") VALUES (?)");
            ps.setString(1, name);
            try {
                ps.executeUpdate();
                created = true;
            }
            catch (SQLException e) {
                log.warn((Object)("User [" + name + "] must already exist"), (Throwable)e);
            }
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not create user [" + name + "]"), (Throwable)e);
        }
        return created;
    }

    public boolean remove(String name) {
        boolean removed = false;
        try {
            Connection conn = DriverManager.getConnection(this.connectionParameter, this.databaseUserName, this.databasePassword);
            log.debug((Object)("DELETE FROM " + this.membershipTable + " WHERE " + this.membershipUserName + " = " + name));
            PreparedStatement ps = conn.prepareStatement("DELETE FROM " + this.membershipTable + " WHERE " + this.membershipUserName + " = ?");
            ps.setString(1, name);
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement("DELETE FROM " + this.userTable + " WHERE " + this.userName + " = ?");
            ps.setString(1, name);
            log.debug((Object)("DELETE FROM " + this.userTable + " WHERE " + this.userName + " = " + name));
            int rows = ps.executeUpdate();
            if (rows == 1) {
                removed = true;
            }
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Unable to remove user [" + name + "]"), (Throwable)e);
        }
        return removed;
    }

    public boolean authenticate(String name, String password) {
        boolean authenticated = false;
        try {
            Connection conn = DriverManager.getConnection(this.connectionParameter, this.databaseUserName, this.databasePassword);
            PreparedStatement ps = conn.prepareStatement("SELECT " + this.userPassword + " FROM " + this.userTable + " WHERE " + this.userName + " = ?");
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                authenticated = this.compareHash(rs.getString(1), password);
            }
            rs.close();
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not authenticate user [" + name + "]"), (Throwable)e);
        }
        return authenticated;
    }

    private String createHash(String original) {
        byte[] digested = PasswordDigester.digest(original.getBytes());
        byte[] encoded = Base64.encode(digested);
        return new String(encoded);
    }

    private boolean compareHash(String hashedValue, String unhashedValue) {
        return hashedValue.equals(this.createHash(unhashedValue));
    }

    public boolean changePassword(String name, String password) {
        boolean changedPassword = false;
        try {
            Connection conn = DriverManager.getConnection(this.connectionParameter, this.databaseUserName, this.databasePassword);
            PreparedStatement ps = conn.prepareStatement("UPDATE " + this.userTable + " SET " + this.userPassword + " = ? WHERE " + this.userName + " = ?");
            log.debug((Object)("UPDATE " + this.userTable + " SET " + this.userPassword + " = ? WHERE " + this.userName + " = ?"));
            ps.setString(1, this.createHash(password));
            ps.setString(2, name);
            ps.executeUpdate();
            changedPassword = true;
            ps.close();
            conn.close();
        }
        catch (SQLException e) {
            log.fatal((Object)("Could not change password for user [" + name + "]"), (Throwable)e);
        }
        return changedPassword;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

