/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user.provider.ofbiz;

import com.opensymphony.module.user.Entity;
import com.opensymphony.module.user.provider.UserProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public abstract class OFBizAbstractProvider
implements UserProvider {
    protected String userEntity;
    protected String delegator;
    protected boolean exclusiveAccess = false;
    protected final Category LOG = Category.getInstance(this.getClass());
    protected Map nameCache;

    public boolean init(Properties properties) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("init(" + properties.toString() + ")"));
        }
        if (properties.getProperty("exclusive-access") != null && "true".equalsIgnoreCase(properties.getProperty("exclusive-access"))) {
            this.exclusiveAccess = true;
            this.nameCache = new HashMap();
        }
        this.delegator = properties.getProperty("delegator", "default");
        this.userEntity = properties.getProperty("userEntity", "OSUser");
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("delegator: " + this.delegator));
            this.LOG.debug((Object)("exclusiveAccess: " + this.exclusiveAccess));
            this.LOG.debug((Object)("userEntity: " + this.userEntity));
        }
        return true;
    }

    public boolean create(String s) {
        return true;
    }

    public boolean load(String s, Entity.Accessor accessor) {
        return true;
    }

    public boolean remove(String s) {
        return true;
    }

    public boolean store(String s, Entity.Accessor accessor) {
        return true;
    }

    public List list() {
        return null;
    }

    public void flushCaches() {
        this.nameCache = new HashMap();
        this.clearAllCache();
    }

    protected GenericDelegator getDelegator() {
        return GenericDelegator.getGenericDelegator((String)this.delegator);
    }

    protected GenericValue findUser(String name) throws GenericEntityException {
        GenericValue user = null;
        if (this.exclusiveAccess) {
            user = (GenericValue)this.nameCache.get(name);
        }
        if (user == null) {
            user = EntityUtil.getOnly((List)this.getDelegator().findByAnd(this.userEntity, UtilMisc.toMap((String)"name", (Object)name)));
            if (this.exclusiveAccess && user != null) {
                this.nameCache.put(name, user);
            }
        }
        if (user == null) {
            this.LOG.debug((Object)("user " + name + " not found"));
        }
        return user;
    }

    protected void clearUserCache(String name) {
        if (this.exclusiveAccess) {
            this.nameCache.remove(name);
        }
    }

    protected void clearAllCache() {
        if (this.exclusiveAccess) {
            this.getDelegator().clearCacheLine(this.userEntity, null);
        }
    }
}

