/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.util;

import com.opensymphony.util.MailUtils;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TextUtils {
    public static final String[] SINGLE_TAGS = new String[]{"br", "p", "hr"};

    public static final String br(String s) {
        s = TextUtils.noNull(s);
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n') {
                str.append("<br>");
            }
            str.append(s.charAt(i));
            ++i;
        }
        return str.toString();
    }

    public static final String closeTags(String str) {
        HashMap<String, Integer> openTags = new HashMap<String, Integer>();
        str = TextUtils.noNull(str);
        boolean inTag = false;
        boolean inTagName = false;
        boolean inOpenTag = true;
        String tagName = "";
        List<String> singleTags = Arrays.asList(SINGLE_TAGS);
        char[] strA = str.toCharArray();
        int i = 0;
        while (i < strA.length) {
            char c = strA[i];
            if (!inTag) {
                if (c == '<') {
                    inTag = true;
                    inTagName = true;
                    inOpenTag = true;
                    tagName = "";
                }
            } else if (tagName.equals("") && c == '/') {
                inOpenTag = false;
            } else if (inTagName && (c == ' ' || c == '>' || c == '/')) {
                int tagCount;
                inTagName = false;
                if (inOpenTag && !singleTags.contains(tagName.toLowerCase())) {
                    if (openTags.get(tagName) == null) {
                        openTags.put(tagName, new Integer(1));
                    } else {
                        tagCount = (Integer)openTags.get(tagName);
                        openTags.put(tagName, new Integer(tagCount + 1));
                    }
                } else if (openTags.get(tagName) != null) {
                    tagCount = (Integer)openTags.get(tagName);
                    if (tagCount > 1) {
                        openTags.put(tagName, new Integer(tagCount - 1));
                    } else {
                        openTags.remove(tagName);
                    }
                }
                if (c == '>') {
                    inTag = false;
                }
            } else if (inTagName) {
                tagName = tagName + c;
            } else if (c == '>') {
                inTag = false;
            }
            ++i;
        }
        Iterator openTagNames = openTags.keySet().iterator();
        StringBuffer closedString = new StringBuffer(str);
        while (openTagNames.hasNext()) {
            String openTagName = (String)openTagNames.next();
            int i2 = 0;
            while (i2 < (Integer)openTags.get(openTagName)) {
                closedString.append("</" + openTagName + ">");
                ++i2;
            }
        }
        return closedString.toString();
    }

    public static final String colorToHex(Color c) {
        String r = Integer.toHexString(c.getRed());
        String g = Integer.toHexString(c.getGreen());
        String b = Integer.toHexString(c.getBlue());
        if (r.length() < 2) {
            r = '0' + r;
        }
        if (g.length() < 2) {
            g = '0' + g;
        }
        if (b.length() < 2) {
            b = '0' + b;
        }
        return '#' + r + g + b;
    }

    public static final byte[] decodeBytes(String str) throws IOException {
        return MailUtils.decodeBytes(str);
    }

    public static final Object decodeObject(String str) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bytes = new ByteArrayInputStream(TextUtils.decodeBytes(str));
        ObjectInputStream stream = new ObjectInputStream(bytes);
        Object result = stream.readObject();
        stream.close();
        return result;
    }

    public static final String encodeBytes(byte[] data) throws IOException {
        return MailUtils.encodeBytes(data);
    }

    public static final String encodeObject(Object o) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(bytes);
        stream.writeObject(o);
        stream.close();
        bytes.flush();
        return TextUtils.encodeBytes(bytes.toByteArray());
    }

    public static final String extractNumber(String in) {
        if (in == null) {
            return "0";
        }
        StringBuffer result = new StringBuffer();
        boolean seenDot = false;
        boolean seenMinus = false;
        boolean seenNumber = false;
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            if (c == '.') {
                if (!seenDot) {
                    seenDot = true;
                    if (!seenNumber) {
                        result.append('0');
                    }
                    result.append('.');
                }
            } else if (c == '-') {
                if (!seenMinus) {
                    seenMinus = true;
                    result.append('-');
                }
            } else if (c == '0' || c >= '1' && c <= '9') {
                seenNumber = true;
                result.append(c);
            }
            ++i;
        }
        int length = result.length();
        if (length > 0 && result.charAt(length - 1) == '.') {
            result.deleteCharAt(length - 1);
        }
        return result.length() == 0 ? "0" : result.toString();
    }

    public static final Color hexToColor(String color) {
        try {
            if (color.charAt(0) == '#') {
                color = color.substring(1, 7);
            }
            int[] col = new int[3];
            int i = 0;
            while (i < 3) {
                col[i] = Integer.parseInt(color.substring(i * 2, i * 2 + 2), 16);
                ++i;
            }
            return new Color(col[0], col[1], col[2]);
        }
        catch (Exception e) {
            return Color.black;
        }
    }

    public static final String html(String s) {
        return TextUtils.htmlEncode(s);
    }

    public static final String htmlEncode(String s) {
        s = TextUtils.noNull(s);
        StringBuffer str = new StringBuffer();
        int j = 0;
        while (j < s.length()) {
            char c = s.charAt(j);
            if (c < '\u0080') {
                switch (c) {
                    case '\"': {
                        str.append("&quot;");
                        break;
                    }
                    case '&': {
                        str.append("&amp;");
                        break;
                    }
                    case '<': {
                        str.append("&lt;");
                        break;
                    }
                    case '>': {
                        str.append("&gt;");
                        break;
                    }
                    default: {
                        str.append(c);
                        break;
                    }
                }
            } else if (c < '\u00ff') {
                String hexChars = new String("0123456789ABCDEF");
                int a = c % 16;
                int b = (c - a) / 16;
                String hex = "" + hexChars.charAt(b) + hexChars.charAt(a);
                str.append("&#x" + hex + ";");
            } else {
                str.append(c);
            }
            ++j;
        }
        return str.toString();
    }

    public static final String hyperlink(String text) {
        return TextUtils.hyperlink(text, null);
    }

    public static final String hyperlink(String text, String target) {
        text = TextUtils.noNull(text);
        text = TextUtils.linkEmail(text);
        text = TextUtils.linkURL(text, target);
        return text;
    }

    public static final String indent(String string, int indentSize, boolean initialLine) {
        int i;
        String indent;
        if (indentSize == 0) {
            indent = "\t";
        } else {
            StringBuffer s = new StringBuffer();
            i = 0;
            while (i < indentSize) {
                s.append(' ');
                ++i;
            }
            indent = s.toString();
        }
        StringBuffer result = new StringBuffer();
        if (initialLine) {
            result.append(indent);
        }
        i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            result.append(c);
            if (c == '\n') {
                result.append(indent);
            }
            ++i;
        }
        return result.toString();
    }

    public static final String innerTrim(String s) {
        int l;
        StringBuffer b = new StringBuffer(s);
        int index = 0;
        while (b.length() != 0 && b.charAt(0) == ' ') {
            b.deleteCharAt(0);
        }
        while (index < b.length()) {
            if (Character.isWhitespace(b.charAt(index)) && index + 1 < b.length() && Character.isWhitespace(b.charAt(index + 1))) {
                b.deleteCharAt(index + 1);
                --index;
            }
            ++index;
        }
        if (b.length() > 0 && b.charAt(l = b.length() - 1) == ' ') {
            b.setLength(l);
        }
        String result = b.toString();
        return result;
    }

    public static final String join(String glue, Iterator pieces) {
        StringBuffer s = new StringBuffer();
        while (pieces.hasNext()) {
            s.append(pieces.next().toString());
            if (!pieces.hasNext()) continue;
            s.append(glue);
        }
        return s.toString();
    }

    public static final String join(String glue, String[] pieces) {
        return TextUtils.join(glue, Arrays.asList(pieces).iterator());
    }

    public static final String join(String glue, Collection pieces) {
        return TextUtils.join(glue, pieces.iterator());
    }

    public static final String left(String s, int n) {
        if (n >= s.length()) {
            return s;
        }
        return s.substring(0, n);
    }

    public static final String linkEmail(String str) {
        int atIndex;
        int lastEndIndex = -1;
        while ((atIndex = str.indexOf(64, lastEndIndex + 1)) != -1) {
            char lastChar;
            String partBeforeAt = "";
            int linkStartIndex = atIndex;
            boolean reachedStart = false;
            while (!reachedStart) {
                if (--linkStartIndex < 0) {
                    reachedStart = true;
                    continue;
                }
                if (TextUtils.isValidEmailChar(str.charAt(linkStartIndex))) {
                    partBeforeAt = str.charAt(linkStartIndex) + partBeforeAt;
                    continue;
                }
                reachedStart = true;
            }
            ++linkStartIndex;
            String partAfterAt = "";
            int linkEndIndex = atIndex;
            boolean reachedEnd = false;
            while (!reachedEnd) {
                if (++linkEndIndex == str.length()) {
                    reachedEnd = true;
                    continue;
                }
                if (TextUtils.isValidEmailChar(str.charAt(linkEndIndex))) {
                    partAfterAt = partAfterAt + str.charAt(linkEndIndex);
                    continue;
                }
                reachedEnd = true;
            }
            --linkEndIndex;
            String emailStr = partBeforeAt + "@" + partAfterAt;
            while ((lastChar = emailStr.charAt(emailStr.length() - 1)) == '.' || lastChar == ':' || lastChar == '-' || lastChar == '/' || lastChar == '~') {
                emailStr = emailStr.substring(0, emailStr.length() - 1);
                --linkEndIndex;
            }
            if (TextUtils.verifyEmail(emailStr)) {
                String emailLink = "<a href='mailto:" + emailStr + "'>" + emailStr + "</a>";
                String partBeforeEmail = str.substring(0, linkStartIndex);
                String partAfterEmail = str.substring(linkEndIndex + 1);
                str = partBeforeEmail + emailLink + partAfterEmail;
                lastEndIndex = linkStartIndex - 1 + emailLink.length();
                continue;
            }
            lastEndIndex = linkStartIndex - 1 + emailStr.length();
        }
        return str;
    }

    public static final String linkURL(String str) {
        return TextUtils.linkURL(str, null);
    }

    public static final String linkURL(String str, String target) {
        int lastEndIndex = -1;
        String targetString = target == null || target.trim().length() == 0 ? "" : " target=\"" + target.trim() + "\"";
        while (true) {
            char lastChar;
            int linkStartIndex;
            int tempLinkStartIndex2;
            int httpIndex = str.toLowerCase().indexOf("http://", lastEndIndex + 1);
            int httpsIndex = str.toLowerCase().indexOf("https://", lastEndIndex + 1);
            int wwwIndex = str.toLowerCase().indexOf("www.", lastEndIndex + 1);
            int ftpIndex = str.toLowerCase().indexOf("ftp://", lastEndIndex + 1);
            if (httpIndex == -1 && httpsIndex == -1 && wwwIndex == -1 && ftpIndex == -1) break;
            int tempLinkStartIndex = Math.min(httpIndex, httpsIndex);
            if (tempLinkStartIndex == -1) {
                tempLinkStartIndex = httpIndex == -1 ? httpsIndex : httpIndex;
            }
            if ((tempLinkStartIndex2 = Math.min(tempLinkStartIndex, wwwIndex)) == -1) {
                tempLinkStartIndex2 = tempLinkStartIndex == -1 ? wwwIndex : tempLinkStartIndex;
            }
            if ((linkStartIndex = Math.min(tempLinkStartIndex2, ftpIndex)) == -1) {
                linkStartIndex = tempLinkStartIndex2 == -1 ? ftpIndex : tempLinkStartIndex2;
            }
            int linkEndIndex = linkStartIndex;
            String urlStr = "";
            do {
                String all5Chars;
                if (str.charAt(linkEndIndex) == '&' && linkEndIndex + 5 <= str.length() && (all5Chars = str.substring(linkEndIndex, linkEndIndex + 5)).equalsIgnoreCase("&amp;")) {
                    str = TextUtils.removeAndInsert(str, linkEndIndex, linkEndIndex + 5, "&");
                }
                if (!TextUtils.isValidURLChar(str.charAt(linkEndIndex))) break;
                urlStr = urlStr + str.charAt(linkEndIndex);
            } while (++linkEndIndex != str.length());
            --linkEndIndex;
            while ((lastChar = urlStr.charAt(urlStr.length() - 1)) == '.' || lastChar == ':' || lastChar == '-' || lastChar == '~') {
                urlStr = urlStr.substring(0, urlStr.length() - 1);
                --linkEndIndex;
            }
            String urlToDisplay = TextUtils.htmlEncode(urlStr);
            if (urlStr.toLowerCase().startsWith("www.")) {
                urlStr = "http://" + urlStr;
            }
            if (TextUtils.verifyUrl(urlStr)) {
                String urlLink = "<a href=\"" + urlStr + "\"" + targetString + ">" + urlToDisplay + "</a>";
                str = TextUtils.removeAndInsert(str, linkStartIndex, linkEndIndex + 1, urlLink);
                lastEndIndex = linkStartIndex - 1 + urlLink.length();
                continue;
            }
            lastEndIndex = linkStartIndex - 1 + urlStr.length();
        }
        return str;
    }

    public static final String list(String str) {
        str = TextUtils.noNull(str);
        String strToRet = "";
        boolean inList = false;
        if (str.startsWith("-") || str.startsWith("*")) {
            str = '\n' + str;
        }
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\n') {
                if (i != str.length() - 1) {
                    if (str.charAt(i + 1) == '-' || str.charAt(i + 1) == '*') {
                        if (!inList) {
                            strToRet = strToRet + "<ul>";
                            inList = true;
                        } else {
                            strToRet = strToRet + "</li>";
                        }
                        strToRet = strToRet + "<li>";
                        ++i;
                    } else if (inList) {
                        strToRet = strToRet + "</li></ul>";
                        inList = false;
                    } else {
                        strToRet = strToRet + str.charAt(i);
                    }
                } else if (inList) {
                    strToRet = strToRet + "</li></ul>";
                }
            } else {
                strToRet = strToRet + str.charAt(i);
            }
            ++i;
        }
        if (inList) {
            strToRet = strToRet + "</li></ul>";
        }
        return strToRet;
    }

    public static final String noNull(String string, String defaultString) {
        return TextUtils.stringSet(string) ? string : defaultString;
    }

    public static final String noNull(String string) {
        return TextUtils.noNull(string, "");
    }

    public static final boolean parseBoolean(String in) {
        if ((in = TextUtils.noNull(in)).length() == 0) {
            return false;
        }
        switch (in.charAt(0)) {
            case '1': 
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    public static final Date parseDate(String year, String month, String day) {
        year = TextUtils.noNull(year);
        month = TextUtils.noNull(month);
        day = TextUtils.noNull(day);
        int y = TextUtils.parseInt(year);
        int m = TextUtils.parseInt(month) - 1;
        int d = TextUtils.parseInt(TextUtils.extractNumber(day));
        if (m == -1) {
            String str;
            if (month.length() < 3) {
                month = month + "   ";
            }
            m = (str = month.toLowerCase().substring(0, 3)).equals("jan") ? 0 : (str.equals("feb") ? 1 : (str.equals("mar") ? 2 : (str.equals("apr") ? 3 : (str.equals("may") ? 4 : (str.equals("jun") ? 5 : (str.equals("jul") ? 6 : (str.equals("aug") ? 7 : (str.equals("sep") ? 8 : (str.equals("oct") ? 9 : (str.equals("nov") ? 10 : (str.equals("dec") ? 11 : 0)))))))))));
        }
        if (d == 0) {
            d = 1;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(y, m, d);
        return cal.getTime();
    }

    public static final double parseDouble(String in) {
        double d = 0.0;
        try {
            d = Double.parseDouble(in);
        }
        catch (Exception e) {}
        return d;
    }

    public static final float parseFloat(String in) {
        float f = 0.0f;
        try {
            f = Float.parseFloat(in);
        }
        catch (Exception e) {}
        return f;
    }

    public static final int parseInt(String in) {
        int i = 0;
        try {
            i = Integer.parseInt(in);
        }
        catch (Exception e) {
            i = (int)TextUtils.parseFloat(in);
        }
        return i;
    }

    public static final long parseLong(String in) {
        long l = 0L;
        try {
            l = Long.parseLong(in);
        }
        catch (Exception e) {
            l = (long)TextUtils.parseDouble(in);
        }
        return l;
    }

    public static final String plainTextToHtml(String str) {
        return TextUtils.plainTextToHtml(str, null);
    }

    public static final String plainTextToHtml(String str, String target) {
        str = TextUtils.noNull(str);
        str = TextUtils.htmlEncode(str);
        str = TextUtils.br(str);
        str = TextUtils.hyperlink(str, target);
        return str;
    }

    public static final String removeAndInsert(String str, int removeAndInsertStart, int removeEnd, String insertStr) {
        String partBefore = str.substring(0, removeAndInsertStart);
        String partAfter = str.substring(removeEnd);
        str = partBefore + insertStr + partAfter;
        return str;
    }

    public static final String slashes(String s) {
        s = TextUtils.noNull(s);
        StringBuffer str = new StringBuffer();
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\\' || chars[i] == '\"' || chars[i] == '\'') {
                str.append('\\');
            }
            str.append(chars[i]);
            ++i;
        }
        return str.toString();
    }

    public static final boolean stringSet(String string) {
        return string != null && !"".equals(string);
    }

    public static final String trimToEndingChar(String str, int len) {
        boolean inTag = false;
        boolean anyTags = false;
        String result = "";
        int goodChars = 0;
        int lastEndingCharPos = -1;
        if (str.length() < len) {
            return str;
        }
        char[] strA = str.toCharArray();
        int i = 0;
        while (i < strA.length) {
            if (strA[i] == '<' && !inTag) {
                anyTags = true;
                inTag = true;
            }
            if (strA[i] == '>' && inTag) {
                inTag = false;
            }
            if (!inTag) {
                if (TextUtils.isEndingChar(strA[i])) {
                    lastEndingCharPos = i;
                }
                ++goodChars;
            }
            result = result + strA[i];
            if (goodChars == len) break;
            ++i;
        }
        if (lastEndingCharPos + 1 != result.length()) {
            if (lastEndingCharPos != -1) {
                result = result.substring(0, lastEndingCharPos + 1);
            } else {
                int spacePos = result.lastIndexOf(32);
                if (spacePos != -1) {
                    result = result.substring(0, spacePos);
                }
            }
        }
        if (anyTags) {
            return TextUtils.closeTags(result);
        }
        return result;
    }

    public static final boolean verifyEmail(String email) {
        return MailUtils.verifyEmail(email);
    }

    public static final boolean verifyUrl(String url) {
        if (url == null) {
            return false;
        }
        if (url.startsWith("https://")) {
            url = "http://" + url.substring(8);
        }
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static final String wrapParagraph(String s) {
        s = TextUtils.noNull(s);
        StringBuffer result = new StringBuffer();
        result.append("<p>");
        int lastC = 0;
        char thisC = '\u0000';
        int i = 0;
        while (i < s.length()) {
            thisC = s.charAt(i);
            if (thisC == '\n' && lastC == 10) {
                result.append("</p>\n\n<p>");
            } else {
                result.append(thisC);
            }
            lastC = thisC;
            ++i;
        }
        result.append("</p>");
        return result.toString();
    }

    private static final boolean isEndingChar(char c) {
        return c == '.' || c == '!' || c == ',' || c == '?';
    }

    private static final boolean isValidEmailChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '-' || c == '.' || c >= '0' && c <= '9';
    }

    private static final boolean isValidURLChar(char c) {
        if (TextUtils.isValidEmailChar(c)) {
            return true;
        }
        return c == '?' || c == '&' || c == '%' || c == '/' || c == '~' || c == ':' || c == '=' || c == '#' || c == '_';
    }
}

