/*
 * Decompiled with CFR 0.152.
 */
package server.Management.application;

import at.tugraz.genome.usermanagement.server.admin.VO.AdminVO;
import at.tugraz.genome.usermanagement.server.admin.VO.AdminsgroupVOFactory;
import at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO;
import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.logging.VO.LoggingVOFactory;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VOFactory.ExtendedUserVOFactory;
import at.tugraz.genome.usermanagement.server.user.cache.ExtendedUserVOCache;
import at.tugraz.genome.util.GeneralComparator;
import com.opensymphony.module.access.AccessManager;
import com.opensymphony.module.access.ImmutableException;
import com.opensymphony.module.access.NotFoundException;
import com.opensymphony.module.access.provider.BaseProvider;
import com.opensymphony.module.access.provider.ejb.AclEntity;
import com.opensymphony.module.access.provider.ejb.OsAdmins;
import com.opensymphony.module.access.provider.ejb.OsAdminsHome;
import com.opensymphony.module.access.provider.ejb.OsAdminsgroup;
import com.opensymphony.module.access.provider.ejb.OsAdminsgroupHome;
import com.opensymphony.module.access.provider.ejb.OsAuthenticationrules;
import com.opensymphony.module.access.provider.ejb.OsAuthenticationrulesHome;
import com.opensymphony.module.access.provider.ejb.OsGroupInRealm;
import com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome;
import com.opensymphony.module.access.provider.ejb.OsLogging;
import com.opensymphony.module.access.provider.ejb.OsLoggingHome;
import com.opensymphony.module.access.provider.ejb.OsUserInRealm;
import com.opensymphony.module.access.provider.ejb.OsUserInRealmHome;
import com.opensymphony.module.access.provider.ejb.ResourceEntity;
import com.opensymphony.module.access.provider.ejb.VO.ApplicationPasswordVO;
import com.opensymphony.module.access.provider.ejb.VOFactory.ApplicationPasswordVOFactory;
import com.opensymphony.module.access.provider.ejb.admin.OsLastlogin;
import com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome;
import com.opensymphony.module.access.provider.ejb.application.OsApplicationPasswords;
import com.opensymphony.module.access.provider.ejb.application.OsApplicationPasswordsHome;
import com.opensymphony.module.access.provider.ejb.application.OsApplications;
import com.opensymphony.module.access.provider.ejb.application.OsApplicationsHome;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.User;
import com.opensymphony.module.user.UserManager;
import com.opensymphony.module.user.provider.ejb.util.Base64;
import com.opensymphony.module.user.provider.ejb.util.PasswordDigester;
import com.opensymphony.util.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import server.Management.Management;
import server.Management.application.ejb.SharedGroup;
import server.Management.application.ejb.SharedGroupHome;
import server.Management.application.ejb.SharedGroupPK;
import server.Management.group.VOFactory.SmallGroupVOFactory;
import server.Management.util.FilterDoubleEntries;
import server.security.AuthenticationHandler;

public class ApplicationManagerBean
extends Management
implements SessionBean {
    private static final Logger logger = Logger.getLogger((Class)(class$server$Management$application$ApplicationManagerBean == null ? (class$server$Management$application$ApplicationManagerBean = ApplicationManagerBean.class$("server.Management.application.ApplicationManagerBean")) : class$server$Management$application$ApplicationManagerBean));
    SessionContext sessionContext;
    private UserManager userManager_;
    static /* synthetic */ Class class$server$Management$application$ApplicationManagerBean;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$application$OsApplicationsHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsAdminsHome;
    static /* synthetic */ Class class$server$Management$application$ejb$SharedGroupHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsLoggingHome;

    public void ejbCreate() throws CreateException {
        this.accessManager_ = this.getAccessManager();
        this.userManager_ = UserManager.getInstance();
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public Vector getAllApplications() {
        logger.info((Object)"getAllApplications");
        this.accessManager_ = AccessManager.getInstance();
        Vector<ApplicationVO> list = new Vector<ApplicationVO>();
        logger.debug((Object)"return application-List");
        Vector v = new Vector(this.accessManager_.getResourceProviders());
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            String realm = ((BaseProvider)iter.next()).getRealm();
            logger.debug((Object)("add " + realm));
            list.add(new ApplicationVO(realm));
        }
        Collections.sort(list, new GeneralComparator("at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO", "getApplicationname", "java.lang.String"));
        return list;
    }

    public boolean addUserToApplication(String realm, String username) {
        logger.info((Object)("addUserToApplication " + realm + " " + username));
        if (realm == null || username == null) {
            return false;
        }
        if (!this.checkRealm(realm)) {
            logger.error((Object)("realm \"" + realm + "\" not found"));
            return false;
        }
        this.userManager_ = this.getUserManager();
        try {
            this.userManager_.getUser(username);
        }
        catch (EntityNotFoundException ex) {
            logger.error((Object)("could not add not existing user \"" + username + "\" to realm"));
            return false;
        }
        OsUserInRealmHome home = null;
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsUserInRealm");
            home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            OsUserInRealm user = null;
            try {
                user = home.findUserInRealm(username, realm);
            }
            catch (FinderException ex1) {
                try {
                    user = home.create(username, realm);
                }
                catch (CreateException ex2) {
                    ex2.printStackTrace();
                    return false;
                }
                logger.info((Object)("addUserToApplication : enabled user " + username + " in Application " + realm));
                user.setIsEnabled(new Long(1L));
                ExtendedUserVOCache.getInstance().updateUser(username);
                return true;
            }
            user.setIsEnabled(new Long(1L));
            logger.info((Object)("addUserToApplication : enabled user " + username + " in Application " + realm));
            ExtendedUserVOCache.getInstance().updateUser(username);
            return true;
        }
        catch (NamingException ex) {
            logger.error((Object)("could not connect to server " + ex));
            return false;
        }
    }

    public boolean addGroupToApplication(String realm, String groupname) {
        logger.info((Object)("addGroupToApplication " + realm + " " + groupname));
        if (realm == null || groupname == null) {
            return false;
        }
        if (!this.checkRealm(realm)) {
            logger.error((Object)("realm " + realm + " not found"));
            return false;
        }
        this.accessManager_ = this.getAccessManager();
        try {
            this.accessManager_.getGroup(realm, groupname);
        }
        catch (Exception ex) {
            logger.error((Object)("could not add not existing group \"" + groupname + "\" to realm"));
            ex.printStackTrace();
            return false;
        }
        OsGroupInRealmHome home = null;
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsGroupInRealm");
            home = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
            OsGroupInRealm group = home.findGroupInRealm(groupname, realm);
            return true;
        }
        catch (NamingException ex) {
            logger.error((Object)"could not connect to server");
            return false;
        }
        catch (ObjectNotFoundException ex) {
            try {
                OsGroupInRealm group = home.create(groupname, realm);
                group.setIsEnabled(new Long(1L));
            }
            catch (CreateException exc) {
                exc.printStackTrace();
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean deleteUserInApplication(String realm, String username) {
        logger.info((Object)("deleteUserInApplication " + realm + " " + username));
        if (realm == null || username == null) {
            return false;
        }
        if (!this.checkRealm(realm)) {
            logger.error((Object)("realm " + realm + " not found"));
            return false;
        }
        boolean alreadyActive = false;
        InitialContext ctx = null;
        try {
            InitialContext userctx = new InitialContext();
            ctx = new InitialContext();
            Object loggedIn = ctx.lookup("OsLastlogin");
            OsLastloginHome loginHome = (OsLastloginHome)PortableRemoteObject.narrow((Object)loggedIn, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome));
            OsLastlogin loggedInBefore = loginHome.findByUsername(username);
            if (realm.equals(loggedInBefore.getApplication())) {
                logger.info((Object)("user : " + username + " logged in before, cannot be disabled"));
                alreadyActive = true;
            }
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        catch (FinderException ex) {
            // empty catch block
        }
        try {
            ctx = new InitialContext();
            Object ref = ctx.lookup("OsUserInRealm");
            OsUserInRealmHome home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            OsUserInRealm userInRealm = home.findUserInRealm(username, realm);
            if (alreadyActive && userInRealm.getRealm().equals(realm)) {
                logger.debug((Object)"user cannot be deleted from Application, user will be disabled");
                userInRealm.setIsEnabled(new Long(0L));
                ExtendedUserVOCache.getInstance().updateUser(username);
                return false;
            }
            userInRealm.remove();
            logger.debug((Object)"user removed from application");
            ExtendedUserVOCache.getInstance().updateUser(username);
            return true;
        }
        catch (RemoveException ex) {
            logger.error((Object)("could not disable user in application : " + (Object)((Object)ex)));
        }
        catch (EJBException ex) {
            logger.error((Object)("ejb error : " + (Object)((Object)ex)));
        }
        catch (FinderException ex) {
            logger.error((Object)("could not find " + (Object)((Object)ex)));
        }
        catch (NamingException ex) {
            logger.error((Object)("could not connect to server " + ex));
        }
        return false;
    }

    public boolean deleteGroupInApplication(String realm, String groupname) {
        logger.info((Object)("deleteGroupInApplication " + realm + " " + groupname));
        if (realm == null || groupname == null) {
            return false;
        }
        if (!this.checkRealm(realm)) {
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsGroupInRealm");
            OsGroupInRealmHome home = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
            OsGroupInRealm groupInRealm = home.findGroupInRealm(groupname, realm);
            groupInRealm.remove();
            return true;
        }
        catch (RemoveException ex) {
            logger.error((Object)("could not disable group in application : " + (Object)((Object)ex)));
        }
        catch (EJBException ex) {
            logger.error((Object)("ejb error : " + (Object)((Object)ex)));
        }
        catch (FinderException ex) {
            logger.error((Object)("could not find groupname " + groupname + " => " + (Object)((Object)ex)));
        }
        catch (NamingException ex) {
            logger.error((Object)("could not connect to server " + ex));
        }
        return false;
    }

    public Vector getAllGroupsEnabledInApplication(String realm) {
        logger.info((Object)("getAllGroupsEnabledInApplication " + realm));
        if (realm == null) {
            return null;
        }
        if (!this.checkRealm(realm)) {
            logger.error((Object)("realm " + realm + " not found"));
            return null;
        }
        Vector<SmallGroupVO> listOfGroups = new Vector<SmallGroupVO>();
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsGroupInRealm");
            OsGroupInRealmHome home = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
            Vector groupList = new Vector(home.findAllGroupsOfRealm(realm));
            Iterator iter = groupList.iterator();
            while (iter.hasNext()) {
                listOfGroups.add(SmallGroupVOFactory.getData((OsGroupInRealm)iter.next()));
            }
            return listOfGroups;
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            logger.error((Object)("class not found " + ex));
            return null;
        }
        catch (NamingException ex) {
            logger.error((Object)("could not find bean " + ex));
        }
        catch (FinderException ex) {
            logger.error((Object)("could not find realm " + (Object)((Object)ex)));
        }
        return null;
    }

    private boolean checkRealm(String realm) {
        this.accessManager_ = this.getAccessManager();
        Vector v = new Vector(this.accessManager_.getResourceProviders());
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            String tmp = ((BaseProvider)iter.next()).getRealm();
            if (!tmp.equals(realm)) continue;
            return true;
        }
        return false;
    }

    private byte[] writeXML(Document doc) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            XMLUtils.print(doc, bytes);
            bytes.flush();
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new PropertyImplementationException("Cannot serialize XML", e);
        }
    }

    private Document readXML(byte[] data) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(data);
            return XMLUtils.parse(bytes);
        }
        catch (Exception e) {
            throw new PropertyImplementationException("Cannot parse XML data.", e);
        }
    }

    public boolean setAuthenticationRule(String realm, byte[] rule) {
        logger.debug((Object)("setAuthenticationRule " + realm));
        if (realm == null || rule == null) {
            return false;
        }
        String xml = new String(rule);
        Document doc = null;
        try {
            doc = XMLUtils.parse(xml);
        }
        catch (SAXException ex) {
            logger.error((Object)("XML File error" + ex.getMessage()));
            return false;
        }
        catch (IOException ex) {
            logger.error((Object)"XML io-File error");
            return false;
        }
        catch (ParserConfigurationException ex) {
            logger.error((Object)"XML File: ParserConfig-Error");
            return false;
        }
        OsAuthenticationrules rules = null;
        OsAuthenticationrulesHome home = null;
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsAuthenticationrules");
            home = (OsAuthenticationrulesHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAuthenticationrulesHome")) : class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome));
            try {
                rules = home.findByPrimaryKey(realm);
                logger.debug((Object)"xml file found");
            }
            catch (FinderException ex) {
                logger.error((Object)"no xml file exist");
            }
            if (rules == null) {
                try {
                    rules = home.create(realm);
                    logger.debug((Object)"new xml added");
                }
                catch (CreateException ex) {
                    logger.error((Object)"no new xml created");
                }
            }
            rules.setRulefile(rule);
        }
        catch (NamingException ex) {
            logger.error((Object)"could not find server");
            return false;
        }
        return true;
    }

    public byte[] getAuthenticationRule(String realm) {
        logger.info((Object)("getAuthenticationRule " + realm));
        if (realm == null) {
            return null;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsAuthenticationrules");
            OsAuthenticationrulesHome home = (OsAuthenticationrulesHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAuthenticationrulesHome")) : class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome));
            OsAuthenticationrules rules = null;
            rules = home.findByPrimaryKey(realm);
            return rules.getRulefile();
        }
        catch (FinderException ex) {
            return null;
        }
        catch (NamingException ex) {
            logger.error((Object)("could not find server " + ex));
            return null;
        }
    }

    public boolean addApplication(String realm) {
        logger.info((Object)("addApplication " + realm));
        if (realm == null) {
            return false;
        }
        if (realm.length() == 0) {
            return false;
        }
        String acl = "Acl";
        String resource = "Resource";
        String osUserProvider = "com.opensymphony.module.access.provider.osuser.OSUserUserProvider";
        String osResourceProvider = "com.opensymphony.module.access.provider.ejb.EJBResourceProvider";
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsApplications");
            OsApplicationsHome home = (OsApplicationsHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$application$OsApplicationsHome == null ? (class$com$opensymphony$module$access$provider$ejb$application$OsApplicationsHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.application.OsApplicationsHome")) : class$com$opensymphony$module$access$provider$ejb$application$OsApplicationsHome));
            try {
                home.create(realm, osResourceProvider, osUserProvider, resource, acl);
                AccessManager.restart();
                return true;
            }
            catch (CreateException ex) {
                logger.error((Object)ex.toString());
                return false;
            }
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            logger.error((Object)ex.toString());
            return false;
        }
        catch (NamingException ex) {
            logger.error((Object)ex.toString());
            return false;
        }
    }

    public boolean deleteApplication(String realm) {
        Object ref;
        Iterator iter;
        ArrayList list;
        logger.info((Object)("deleteApplication " + realm));
        if (realm == null) {
            return false;
        }
        if (realm.length() == 0) {
            return false;
        }
        InitialContext ctx = null;
        logger.debug((Object)"delete all resources");
        try {
            list = AccessManager.getInstance().getResources(realm);
            iter = list.iterator();
            while (iter.hasNext()) {
                ResourceEntity entity = (ResourceEntity)iter.next();
                try {
                    entity.remove();
                }
                catch (ImmutableException ex) {
                    logger.error((Object)ex);
                }
            }
            logger.debug((Object)"deleted all Resources of application");
        }
        catch (NotFoundException ex) {
            logger.info((Object)("No resources found when deleting " + realm));
        }
        logger.debug((Object)"delete all acls");
        try {
            list = AccessManager.getInstance().getAcls(realm);
            iter = list.iterator();
            while (iter.hasNext()) {
                AclEntity acl = (AclEntity)iter.next();
                try {
                    acl.remove();
                    logger.debug((Object)("deleted acl " + acl.getResourceKey()));
                }
                catch (ImmutableException ex) {
                    logger.error((Object)ex);
                }
            }
            logger.debug((Object)"deleted all Acls of application");
        }
        catch (NotFoundException ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)"delete  application passwords");
        try {
            ctx = new InitialContext();
            Object refpasswd = ctx.lookup("OsApplicationPasswords");
            OsApplicationPasswordsHome passwd = (OsApplicationPasswordsHome)PortableRemoteObject.narrow((Object)refpasswd, (Class)(class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome == null ? (class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.application.OsApplicationPasswordsHome")) : class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome));
            passwd.findByApplicationname(realm).remove();
            AuthenticationHandler.getInstance().updateApplicationPasswords();
        }
        catch (FinderException ex4) {
            logger.info((Object)"no application passwords found");
        }
        catch (EJBException ex4) {
            ex4.printStackTrace();
        }
        catch (RemoveException ex4) {
            ex4.printStackTrace();
        }
        catch (NamingException ex4) {
            ex4.printStackTrace();
        }
        logger.debug((Object)"delete users enabled in realm");
        Vector userList = null;
        try {
            ctx = new InitialContext();
            ref = ctx.lookup("OsUserInRealm");
            OsUserInRealmHome userHome = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            userList = new Vector(userHome.findAllUsersOfRealm(realm));
        }
        catch (FinderException ex5) {
            logger.info((Object)"no enabled users found");
        }
        catch (NamingException ex5) {
            ex5.printStackTrace();
        }
        if (userList == null) {
            userList = new Vector();
        }
        iter = userList.iterator();
        try {
            while (iter.hasNext()) {
                OsUserInRealm user = (OsUserInRealm)iter.next();
                logger.debug((Object)("will delete OsUserInRealm " + user.getUsername()));
                user.remove();
            }
        }
        catch (EJBException ex6) {
            ex6.printStackTrace();
        }
        catch (RemoveException ex6) {
            ex6.printStackTrace();
        }
        logger.debug((Object)"deleted all users enabled in application");
        logger.debug((Object)"delete Groups enabled in realm");
        try {
            ctx = new InitialContext();
            ref = ctx.lookup("OsGroupInRealm");
            OsGroupInRealmHome groupHome = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
            Vector groupList = new Vector(groupHome.findAllGroupsOfRealm(realm));
            if (groupList == null) {
                groupList = new Vector();
            }
            iter = groupList.iterator();
            while (iter.hasNext()) {
                OsGroupInRealm group = (OsGroupInRealm)iter.next();
                logger.debug((Object)("will delete OsGroupInRealm " + group.getGroupname()));
                group.remove();
            }
        }
        catch (EJBException ex7) {
            ex7.printStackTrace();
        }
        catch (RemoveException ex7) {
            ex7.printStackTrace();
        }
        catch (FinderException ex7) {
            logger.info((Object)"no enabled groups found");
        }
        catch (NamingException ex7) {
            ex7.printStackTrace();
        }
        logger.debug((Object)"deleted all groups enabled in application");
        logger.debug((Object)"delete Authenticationrules");
        try {
            ctx = new InitialContext();
            ref = ctx.lookup("OsAuthenticationrules");
            OsAuthenticationrulesHome authRuleHome = (OsAuthenticationrulesHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAuthenticationrulesHome")) : class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome));
            authRuleHome.findByPrimaryKey(realm).remove();
            logger.debug((Object)"deleted auth rule of application");
        }
        catch (FinderException ex9) {
            logger.info((Object)"No Authenticationrules found");
        }
        catch (EJBException ex9) {
            ex9.printStackTrace();
        }
        catch (RemoveException ex9) {
            ex9.printStackTrace();
        }
        catch (ClassCastException ex9) {
            ex9.printStackTrace();
        }
        catch (NamingException ex9) {
            ex9.printStackTrace();
        }
        OsAdminsgroupHome adminHome = null;
        Vector groupadminslist = null;
        try {
            ctx = new InitialContext();
            Object adminRef = ctx.lookup("OsAdminsgroup");
            adminHome = (OsAdminsgroupHome)PortableRemoteObject.narrow((Object)adminRef, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAdminsgroupHome")) : class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome));
            groupadminslist = new Vector(adminHome.findByRealm(realm));
            if (groupadminslist != null) {
                iter = groupadminslist.iterator();
                while (iter.hasNext()) {
                    OsAdminsgroup grAdmin = (OsAdminsgroup)iter.next();
                    grAdmin.remove();
                }
            }
        }
        catch (FinderException ex10) {
            logger.info((Object)"No admingroups found");
        }
        catch (NamingException ex10) {
            ex10.printStackTrace();
        }
        catch (RemoveException ex10) {
            ex10.printStackTrace();
        }
        try {
            ref = ctx.lookup("OsAdmins");
            OsAdminsHome Adminhome = null;
            Adminhome = (OsAdminsHome)PortableRemoteObject.narrow(Adminhome, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAdminsHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAdminsHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAdminsHome")) : class$com$opensymphony$module$access$provider$ejb$OsAdminsHome));
            Vector useradminslist = new Vector(adminHome.findByRealm(realm));
            if (useradminslist != null) {
                while (iter.hasNext()) {
                    iter = useradminslist.iterator();
                    OsAdmins userAdmin = (OsAdmins)iter.next();
                    userAdmin.remove();
                }
            }
        }
        catch (EJBException ex2) {
            ex2.printStackTrace();
        }
        catch (RemoveException ex2) {
            ex2.printStackTrace();
        }
        catch (FinderException ex2) {
            logger.info((Object)"No Admins found");
        }
        catch (NamingException ex2) {
            ex2.printStackTrace();
        }
        try {
            ctx = new InitialContext();
            ref = ctx.lookup("OsApplications");
            OsApplicationsHome home = (OsApplicationsHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$application$OsApplicationsHome == null ? (class$com$opensymphony$module$access$provider$ejb$application$OsApplicationsHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.application.OsApplicationsHome")) : class$com$opensymphony$module$access$provider$ejb$application$OsApplicationsHome));
            OsApplications osApp = home.findByPrimaryKey(realm);
            osApp.remove();
        }
        catch (EJBException ex3) {
            ex3.printStackTrace();
        }
        catch (RemoveException ex3) {
            ex3.printStackTrace();
        }
        catch (FinderException ex3) {
            logger.error((Object)("Application not found " + realm));
        }
        catch (NamingException ex3) {
            ex3.printStackTrace();
        }
        AccessManager.restart();
        logger.info((Object)"Done deleting application");
        return true;
    }

    public boolean deleteDefaultRuleset(String realm) {
        logger.info((Object)("deleteDefaultRuleset " + realm));
        Object ref = null;
        try {
            InitialContext ctx = new InitialContext();
            ref = ctx.lookup("OsAuthenticationrules");
            OsAuthenticationrules rules = null;
            OsAuthenticationrulesHome home = null;
            home = (OsAuthenticationrulesHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAuthenticationrulesHome")) : class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome));
            try {
                rules = home.findByPrimaryKey(realm);
                logger.debug((Object)"xml file found");
                try {
                    rules.remove();
                }
                catch (RemoveException ex) {
                    logger.error((Object)("Ruleset found, but could not be deleted, " + ex.toString()));
                    return false;
                }
                catch (EJBException ex) {
                    logger.error((Object)("Ruleset found, but could not be deleted, " + ex.toString()));
                    return false;
                }
                return true;
            }
            catch (FinderException ex) {
                logger.error((Object)"no xml file exist");
            }
        }
        catch (NamingException ex) {
            logger.error((Object)"could not find server");
            return false;
        }
        return false;
    }

    public String getDefaultRuleset(String realm) {
        logger.info((Object)("getDefaultRuleset " + realm));
        Object ref = null;
        try {
            InitialContext ctx = new InitialContext();
            ref = ctx.lookup("OsAuthenticationrules");
            OsAuthenticationrules rules = null;
            OsAuthenticationrulesHome home = null;
            home = (OsAuthenticationrulesHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAuthenticationrulesHome")) : class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome));
            try {
                rules = home.findByPrimaryKey(realm);
                logger.debug((Object)"xml file found");
                return new String(rules.getRulefile());
            }
            catch (FinderException ex) {
                logger.error((Object)"no xml file exist");
            }
        }
        catch (NamingException ex) {
            logger.error((Object)"could not find server");
            return null;
        }
        return null;
    }

    public boolean setAdminForRealm(String realm, String username) {
        logger.info((Object)("setAdminForRealm " + realm + " " + username));
        if (realm == null || realm.length() == 0) {
            return false;
        }
        if (username == null || username.length() == 0) {
            return false;
        }
        Object ref = null;
        try {
            InitialContext ctx = new InitialContext();
            ref = ctx.lookup("OsAdmins");
            OsAdminsHome home = null;
            home = (OsAdminsHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAdminsHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAdminsHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAdminsHome")) : class$com$opensymphony$module$access$provider$ejb$OsAdminsHome));
            try {
                try {
                    home.findByRealmAndUsername(realm, username);
                }
                catch (FinderException ex) {
                    home.create(realm, username);
                }
                return true;
            }
            catch (CreateException ex) {
                logger.error((Object)ex.toString());
                return false;
            }
        }
        catch (NamingException ex) {
            logger.error((Object)"could not find server");
            return false;
        }
    }

    public Vector getAdminOfRealm(String realm) {
        logger.info((Object)("getAdminOfRealm " + realm));
        if (realm == null || realm.length() == 0) {
            return null;
        }
        Object ref = null;
        Collection admins = null;
        Vector<AdminVO> result = new Vector<AdminVO>();
        OsAdminsHome home = null;
        home = this.getOsAdminsHome();
        try {
            admins = home.findAdminsOfRealm(realm);
            Iterator iter = admins.iterator();
            while (iter.hasNext()) {
                OsAdmins admin = (OsAdmins)iter.next();
                AdminVO adminVO = new AdminVO(admin.getRealm(), admin.getUsername());
                ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(admin.getUsername(), false);
                if (vo != null) {
                    adminVO.setApplicationAuthenticationEnabled(vo.isApplicationAuthenticationEnabled());
                }
                result.add(adminVO);
            }
            return result;
        }
        catch (FinderException ex) {
            logger.error((Object)("no admins for realm: " + realm + " found, " + ex.toString()));
            return null;
        }
    }

    public boolean isAdminOfRealm(String realm, String username) {
        logger.info((Object)("isAdminOfRealm " + realm + " " + username));
        if (realm == null || realm.length() == 0 || username == null || username.length() == 0) {
            return false;
        }
        OsAdmins admin = null;
        OsAdminsHome home = null;
        home = this.getOsAdminsHome();
        try {
            admin = home.findByRealmAndUsername(realm, username);
            return true;
        }
        catch (FinderException ex) {
            OsAdminsgroupHome homegroup = null;
            User user = null;
            try {
                user = this.userManager_.getUser(username);
            }
            catch (EntityNotFoundException ex2) {
                return false;
            }
            Vector groupOfUser = new Vector(user.getGroups());
            homegroup = this.getOsAdminsGroupHome();
            Iterator iter = null;
            try {
                iter = homegroup.findByRealm(realm).iterator();
                while (iter.hasNext()) {
                    OsAdminsgroup entity = (OsAdminsgroup)iter.next();
                    if (!groupOfUser.contains(new SmallGroupVO(entity.getGroupname()))) continue;
                    return true;
                }
                return false;
            }
            catch (FinderException ex1) {
                return false;
            }
        }
    }

    public boolean deleteAdminOfRealm(String realm, String username) {
        logger.info((Object)("deleteAdminOfRealm " + realm + " " + username));
        if (realm == null || realm.length() == 0 || username == null || username.length() == 0) {
            return false;
        }
        OsAdmins admin = null;
        OsAdminsHome home = null;
        home = this.getOsAdminsHome();
        try {
            admin = home.findByRealmAndUsername(realm, username);
            try {
                admin.remove();
            }
            catch (RemoveException ex) {
                return false;
            }
            catch (EJBException ex) {
                return false;
            }
            return true;
        }
        catch (FinderException ex) {
            logger.error((Object)ex.toString());
            return true;
        }
    }

    private OsAdminsHome getOsAdminsHome() {
        try {
            Object ref = null;
            InitialContext ctx = new InitialContext();
            ref = ctx.lookup("OsAdmins");
            OsAdminsHome home = (OsAdminsHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAdminsHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAdminsHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAdminsHome")) : class$com$opensymphony$module$access$provider$ejb$OsAdminsHome));
            return home;
        }
        catch (NamingException ex) {
            logger.error((Object)ex.toString());
            return null;
        }
        catch (ClassCastException ex) {
            logger.error((Object)("6 " + ex.toString()));
            return null;
        }
    }

    private SharedGroupHome getSharedGroupHome() {
        try {
            Object ref = null;
            InitialContext ctx = new InitialContext();
            ref = ctx.lookup("SharedGroup");
            SharedGroupHome home = (SharedGroupHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$application$ejb$SharedGroupHome == null ? (class$server$Management$application$ejb$SharedGroupHome = ApplicationManagerBean.class$("server.Management.application.ejb.SharedGroupHome")) : class$server$Management$application$ejb$SharedGroupHome));
            return home;
        }
        catch (NamingException ex) {
            logger.error((Object)ex.toString());
            return null;
        }
        catch (ClassCastException ex) {
            logger.error((Object)("6 " + ex.toString()));
            return null;
        }
    }

    private OsAdminsgroupHome getOsAdminsGroupHome() {
        try {
            Object ref = null;
            InitialContext ctx = new InitialContext();
            ref = ctx.lookup("OsAdminsgroup");
            OsAdminsgroupHome home = (OsAdminsgroupHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAdminsgroupHome")) : class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome));
            return home;
        }
        catch (NamingException ex) {
            logger.error((Object)ex.toString());
            return null;
        }
        catch (ClassCastException ex) {
            logger.error((Object)("5 " + ex.toString()));
            return null;
        }
    }

    public Vector getAllUsersEnabledInApplication(String realm, boolean includeGlobalyDisabledUsers) {
        logger.info((Object)("getAllUsersEnabledInApplication " + realm + " includeGlobalyDisabledUsers:" + includeGlobalyDisabledUsers));
        if (realm == null) {
            return null;
        }
        if (!this.checkRealm(realm)) {
            logger.error((Object)("realm " + realm + " not found"));
            return null;
        }
        Vector<ExtendedUserVO> listOfUsers = new Vector<ExtendedUserVO>();
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException ex1) {
            logger.error((Object)ex1);
            return null;
        }
        try {
            Object userRef = ctx.lookup("OsUserInRealm");
            OsUserInRealmHome home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)userRef, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            Vector userList = home.findAllUsersOfRealm(realm);
            if (userList == null) {
                userList = new Vector();
            }
            Iterator iter = userList.iterator();
            while (iter.hasNext()) {
                OsUserInRealm user = (OsUserInRealm)iter.next();
                ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(user.getUsername(), false);
                vo.setNameOfCurrentAplication(realm);
                if (!vo.isApplicationAuthenticationEnabled() && !includeGlobalyDisabledUsers) continue;
                listOfUsers.add(vo);
            }
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
            return null;
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
        }
        return FilterDoubleEntries.filterUsers(listOfUsers);
    }

    public ApplicationPasswordVO getApplicationPassword(String realm) {
        if (realm == null) {
            return null;
        }
        if (!this.checkRealm(realm)) {
            logger.error((Object)("realm " + realm + " not found"));
            return null;
        }
        try {
            Object ref = null;
            InitialContext ctx = new InitialContext();
            ref = ctx.lookup("OsApplicationPasswords");
            OsApplicationPasswordsHome templateHome = (OsApplicationPasswordsHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome == null ? (class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.application.OsApplicationPasswordsHome")) : class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome));
            OsApplicationPasswords passwd = templateHome.findByApplicationname(realm);
            return ApplicationPasswordVOFactory.getData(passwd);
        }
        catch (ClassCastException ex) {
            logger.error((Object)("3 " + ex));
            return null;
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
            return null;
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    public boolean setNewApplicationPassword(String realm) {
        if (realm == null) {
            return false;
        }
        if (!this.checkRealm(realm)) {
            logger.error((Object)("realm " + realm + " not found"));
            return false;
        }
        logger.debug((Object)"set Applicationpassword");
        String randomPassword = new String();
        int i = 0;
        while (i < 60) {
            Character random = new Character((char)((Math.random() < 0.5 ? 64 : 96) | 1 + (int)(Math.random() * 26.0)));
            randomPassword = randomPassword.concat(random.toString());
            ++i;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsApplicationPasswords");
            OsApplicationPasswordsHome templateHome = (OsApplicationPasswordsHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome == null ? (class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.application.OsApplicationPasswordsHome")) : class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome));
            try {
                templateHome.findByApplicationname(realm);
                return false;
            }
            catch (FinderException fe) {
                templateHome.create(realm, randomPassword);
                AuthenticationHandler.getInstance().updateApplicationPasswords();
                return true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return false;
        }
    }

    public boolean editApplicationPassword(String realm, String password) {
        if (realm == null) {
            return false;
        }
        if (!this.checkRealm(realm)) {
            logger.error((Object)("realm " + realm + " not found"));
            return false;
        }
        if (password.length() < 60) {
            return false;
        }
        logger.debug((Object)"set Applicationpassword");
        String randomPassword = new String();
        int i = 0;
        while (i < 60) {
            Character random = new Character((char)((Math.random() < 0.5 ? 64 : 96) | 1 + (int)(Math.random() * 26.0)));
            randomPassword = randomPassword.concat(random.toString());
            ++i;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsApplicationPasswords");
            OsApplicationPasswordsHome appPwdHome = (OsApplicationPasswordsHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome == null ? (class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.application.OsApplicationPasswordsHome")) : class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome));
            try {
                OsApplicationPasswords appPwd = appPwdHome.findByApplicationname(realm);
                appPwd.setPassword(password);
                AuthenticationHandler.getInstance().updateApplicationPasswords();
            }
            catch (FinderException fe) {
                return false;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return false;
    }

    private static String createHash(String original) {
        byte[] digested = PasswordDigester.digest(original.getBytes());
        byte[] encoded = Base64.encode(digested);
        return new String(encoded);
    }

    public boolean deleteApplicationPassword(String realm) {
        if (realm == null) {
            return false;
        }
        if (!this.checkRealm(realm)) {
            logger.error((Object)("realm " + realm + " not found"));
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsApplicationPasswords");
            OsApplicationPasswordsHome templateHome = (OsApplicationPasswordsHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome == null ? (class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.application.OsApplicationPasswordsHome")) : class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome));
            templateHome.findByApplicationname(realm).remove();
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return false;
        }
    }

    public boolean disableUserInApplication(String username, String realm) {
        InitialContext ctx = null;
        OsUserInRealmHome home = null;
        try {
            ctx = new InitialContext();
            Object ref = ctx.lookup("OsUserInRealm");
            home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            OsUserInRealm user = home.findUserInRealm(username, realm);
            user.setIsEnabled(new Long(0L));
            logger.info((Object)("disabled user: " + username + " in Application: " + realm));
            ExtendedUserVOCache.getInstance().updateUser(username);
            return true;
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
            return false;
        }
        catch (FinderException ex) {
            try {
                logger.info((Object)("will add the user " + username + " to the application " + realm + " before disabling the user"));
                OsUserInRealm user = home.create(username, realm);
                user.setIsEnabled(new Long(0L));
            }
            catch (CreateException ex1) {
                ex1.printStackTrace();
            }
            return false;
        }
    }

    public boolean enableUserInApplication(String username, String realm) {
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsUserInRealm");
            OsUserInRealmHome home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            OsUserInRealm user = home.findUserInRealm(username, realm);
            user.setIsEnabled(new Long(1L));
            logger.debug((Object)("enabled user: " + username + " in Application: " + realm));
            ExtendedUserVOCache.getInstance().updateUser(username);
            return true;
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
            return false;
        }
        catch (FinderException ex) {
            logger.error((Object)("you must add the user " + username + " to the application " + realm + " before enabling the user"));
            return false;
        }
    }

    public boolean disableGroupInApplication(String groupname, String realm) {
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsGroupInRealm");
            OsGroupInRealmHome home = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
            OsGroupInRealm groupInRealm = home.findGroupInRealm(groupname, realm);
            groupInRealm.setIsEnabled(new Long(0L));
            logger.debug((Object)("disabled group " + groupname + " in application " + realm));
            return true;
        }
        catch (FinderException ex) {
            logger.error((Object)("cannot disable not existing group and realm " + (Object)((Object)ex)));
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            logger.error((Object)ex);
        }
        return false;
    }

    public boolean enableGroupInApplication(String groupname, String realm) {
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsGroupInRealm");
            OsGroupInRealmHome home = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
            OsGroupInRealm groupInRealm = home.findGroupInRealm(groupname, realm);
            groupInRealm.setIsEnabled(new Long(1L));
            logger.debug((Object)("enabled group " + groupname + " in application " + realm));
            return true;
        }
        catch (FinderException ex) {
            logger.error((Object)("cannot enable not existing group and realm " + (Object)((Object)ex)));
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            logger.error((Object)ex);
        }
        return false;
    }

    public Vector getLoggingInformation(String username, String applicationname) {
        if (username == null && applicationname == null) {
            return null;
        }
        logger.debug((Object)("getLoggingInformation " + username + " " + applicationname));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsLogging");
            OsLoggingHome authenticationLog = (OsLoggingHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsLoggingHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsLoggingHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsLoggingHome")) : class$com$opensymphony$module$access$provider$ejb$OsLoggingHome));
            if (username == null && applicationname != null) {
                return LoggingVOFactory.createDtos(authenticationLog.findByApplication(applicationname));
            }
            if (username != null && applicationname == null) {
                return LoggingVOFactory.createDtos(authenticationLog.findByUsername(username));
            }
            return LoggingVOFactory.createDtos(authenticationLog.findByNameAndApplication(username, applicationname));
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
            return new Vector();
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            logger.error((Object)ex);
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
        }
        return null;
    }

    public Vector getAdmingroup(String realm) {
        if (realm == null) {
            return null;
        }
        logger.debug((Object)("getAdmingroup : " + realm));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsAdminsgroup");
            OsAdminsgroupHome home = (OsAdminsgroupHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAdminsgroupHome")) : class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome));
            logger.debug((Object)("home.findByRealm(realm).size()" + home.findByRealm(realm).size()));
            return AdminsgroupVOFactory.createDtos(home.findByRealm(realm));
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            logger.error((Object)ex);
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
        }
        return null;
    }

    public boolean deleteLogging(String application, String username, boolean state) {
        if (username == null || application == null) {
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsLogging");
            OsLoggingHome authenticationLog = (OsLoggingHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsLoggingHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsLoggingHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsLoggingHome")) : class$com$opensymphony$module$access$provider$ejb$OsLoggingHome));
            Collection logs = authenticationLog.findByNameAndApplication(username, application);
            logger.debug((Object)("size: " + logs.size()));
            Iterator iter = logs.iterator();
            while (iter.hasNext()) {
                OsLogging log = (OsLogging)iter.next();
                logger.debug((Object)("log: " + log.getId()));
                if (log != null && log.getSuccess() > 0L && state) {
                    try {
                        log.remove();
                    }
                    catch (EJBException ex1) {
                        ex1.printStackTrace();
                    }
                    catch (RemoveException ex1) {
                        ex1.printStackTrace();
                    }
                    continue;
                }
                if (log == null || log.getSuccess() != 0L || state) continue;
                try {
                    log.remove();
                }
                catch (EJBException ex1) {
                    ex1.printStackTrace();
                }
                catch (RemoveException ex1) {
                    ex1.printStackTrace();
                }
            }
            return true;
        }
        catch (FinderException ex) {
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public boolean deleteLoggingDate(String application, String username, Long date1, Long date2) {
        if (username == null || application == null || date1 == null || date2 == null) {
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsLogging");
            OsLoggingHome authenticationLog = (OsLoggingHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsLoggingHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsLoggingHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsLoggingHome")) : class$com$opensymphony$module$access$provider$ejb$OsLoggingHome));
            Collection logs = authenticationLog.findByBetweenDates(date1, date2);
            Iterator iter = logs.iterator();
            while (iter.hasNext()) {
                OsLogging log = (OsLogging)iter.next();
                try {
                    log.remove();
                }
                catch (EJBException ex1) {
                }
                catch (RemoveException ex1) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (FinderException ex) {
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public Vector getLoggingInfoDates(String application, String username, Long date1, Long date2) {
        if (username == null || application == null || date1 == null || date2 == null) {
            return null;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsLogging");
            OsLoggingHome authenticationLog = (OsLoggingHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsLoggingHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsLoggingHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsLoggingHome")) : class$com$opensymphony$module$access$provider$ejb$OsLoggingHome));
            return LoggingVOFactory.createDtos(authenticationLog.findByBetweenDates(date1, date2));
        }
        catch (FinderException ex) {
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
        }
        catch (NamingException ex) {
        }
        return null;
    }

    public boolean deleteLoggingOfApplication(String application) {
        if (application == null) {
            return false;
        }
        logger.info((Object)("will delete all logininfo forapplication: " + application));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsLogging");
            OsLoggingHome authenticationLog = (OsLoggingHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsLoggingHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsLoggingHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsLoggingHome")) : class$com$opensymphony$module$access$provider$ejb$OsLoggingHome));
            ref = ctx.lookup("OsLastlogin");
            Collection all = authenticationLog.findByApplication(application);
            Iterator iter = all.iterator();
            while (iter.hasNext()) {
                OsLogging log = (OsLogging)iter.next();
                try {
                    if (log.getSuccess() == 1L && log.getExpectedLogoutdate() >= System.currentTimeMillis()) continue;
                    log.remove();
                }
                catch (EJBException ex1) {
                    ex1.printStackTrace();
                }
                catch (RemoveException ex1) {
                    ex1.printStackTrace();
                }
            }
            return true;
        }
        catch (FinderException ex) {
            ex.printStackTrace();
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public Vector getAllUsersOfApplicationWithGroups(String realm, boolean includeGlobalyDisabledUsers) {
        Object home;
        logger.info((Object)("getAllUsersOfApplicationWithGroups " + realm + ",includeGlobalyDisabledUsers " + includeGlobalyDisabledUsers));
        if (realm == null) {
            return null;
        }
        if (!this.checkRealm(realm)) {
            logger.error((Object)("realm " + realm + " not found"));
            return null;
        }
        Vector<ExtendedUserVO> listOfUsers = new Vector<ExtendedUserVO>();
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException ex1) {
            logger.error((Object)ex1);
            return null;
        }
        try {
            Object userRef = ctx.lookup("OsUserInRealm");
            home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)userRef, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            Vector userList = home.findAllUsersOfRealm(realm);
            if (userList == null) {
                userList = new Vector();
            }
            Iterator iter = userList.iterator();
            while (iter.hasNext()) {
                OsUserInRealm user = (OsUserInRealm)iter.next();
                ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(user.getUsername(), false);
                vo.setNameOfCurrentAplication(realm);
                if (!vo.isApplicationAuthenticationEnabled() && !includeGlobalyDisabledUsers) continue;
                listOfUsers.add(vo);
            }
        }
        catch (NamingException ex) {
            logger.error((Object)("getAllUsersOfApplicationWithGroups " + ex));
            return null;
        }
        catch (FinderException ex) {
            logger.error((Object)("getAllUsersOfApplicationWithGroups " + (Object)((Object)ex)));
        }
        try {
            Object groupRef = ctx.lookup("OsGroupInRealm");
            home = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)groupRef, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
            Collection groupList = home.findAllGroupsOfRealm(realm);
            Iterator groups = groupList.iterator();
            UserManager um = UserManager.getInstance();
            while (groups.hasNext()) {
                OsGroupInRealm group = (OsGroupInRealm)groups.next();
                Vector members = null;
                try {
                    members = um.getGroup(group.getGroupname()).getUsers();
                }
                catch (EntityNotFoundException ex3) {
                    members = new Vector();
                }
                Iterator iter2 = members.iterator();
                while (iter2.hasNext()) {
                    String user = (String)iter2.next();
                    logger.debug((Object)("add new member of group, user added: " + user));
                    ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(user, false);
                    vo.setNameOfCurrentAplication(realm);
                    if (!vo.isApplicationAuthenticationEnabled() && !includeGlobalyDisabledUsers) continue;
                    listOfUsers.add(vo);
                }
            }
        }
        catch (FinderException ex2) {
            logger.error((Object)("getAllUsersOfApplicationWithGroups " + (Object)((Object)ex2)));
        }
        catch (NamingException ex2) {
            logger.error((Object)("getAllUsersOfApplicationWithGroups " + ex2));
        }
        return FilterDoubleEntries.filterUsers(listOfUsers);
    }

    public boolean deleteUserInRealmEntry(String username, String realm) {
        logger.info((Object)("deleteUserInRealmEntry " + realm));
        if (username == null || realm == null) {
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsUserInRealm");
            OsUserInRealmHome home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = ApplicationManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            Collection result = home.findUserInRealmToDelete(username, realm);
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                OsUserInRealm user = (OsUserInRealm)iter.next();
                user.remove();
            }
            return true;
        }
        catch (FinderException ex) {
            logger.error((Object)("user " + username + " not found in realm : " + realm));
        }
        catch (EJBException ex) {
            ex.printStackTrace();
        }
        catch (RemoveException ex) {
            logger.error((Object)"cannot delete user in realm");
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public Vector getApplicationsWhereUserIsAdmin(String username) {
        logger.info((Object)("getApplicationsWhereUserIsAdmin " + username));
        if (username == null || username.length() == 0) {
            return null;
        }
        Object ref = null;
        Collection admins = null;
        Vector<ApplicationVO> result = new Vector<ApplicationVO>();
        OsAdminsHome home = null;
        home = this.getOsAdminsHome();
        try {
            admins = home.findRealmsOfAdmin(username);
            Iterator iter = admins.iterator();
            while (iter.hasNext()) {
                OsAdmins admin = (OsAdmins)iter.next();
                AdminVO adminVO = new AdminVO(admin.getRealm(), admin.getUsername());
                result.add(new ApplicationVO(adminVO.getRealm()));
            }
            Collections.sort(result, new GeneralComparator("at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO", "getApplicationname", "java.lang.String"));
            return result;
        }
        catch (FinderException ex) {
            logger.error((Object)("no realms for admin: " + username + " found, " + ex.toString()));
            return result;
        }
    }

    public Vector getGroupsWhereUserIsAmin(String username, boolean includeShared) {
        Vector<SmallGroupVO> groups = new Vector<SmallGroupVO>();
        HashMap<String, SmallGroupVO> groupHash = new HashMap<String, SmallGroupVO>();
        Vector applications = this.getApplicationsWhereUserIsAdmin(username);
        int i = 0;
        while (i != applications.size()) {
            Vector sharedGroups;
            ApplicationVO appVO = (ApplicationVO)applications.get(i);
            Vector groupsOfRealm = this.getAllGroupsEnabledInApplication(appVO.getApplicationname());
            if (groupsOfRealm != null) {
                int j = 0;
                while (j != groupsOfRealm.size()) {
                    SmallGroupVO groupVO = (SmallGroupVO)groupsOfRealm.get(j);
                    if (!groupHash.containsKey(groupVO.getName())) {
                        groupHash.put(groupVO.getName(), groupVO);
                        groups.add(groupVO);
                    }
                    ++j;
                }
            }
            if (includeShared && (sharedGroups = this.getSharedGroupsOfApplication(appVO.getApplicationname())) != null) {
                int j = 0;
                while (j != sharedGroups.size()) {
                    SmallGroupVO groupVO = (SmallGroupVO)sharedGroups.get(j);
                    if (!groupHash.containsKey(groupVO.getName())) {
                        groupHash.put(groupVO.getName(), groupVO);
                        groups.add(groupVO);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Collections.sort(groups, new GeneralComparator("at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO", "getName", "java.lang.String"));
        return groups;
    }

    public boolean addSharedGroupToApplication(String application, String groupname) {
        try {
            SharedGroupHome home = this.getSharedGroupHome();
            try {
                home.create(application, groupname);
                return true;
            }
            catch (CreateException ex) {
                logger.error((Object)ex.toString());
                return false;
            }
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            logger.error((Object)ex.toString());
            return false;
        }
    }

    public boolean removeSharedGroupFromApplication(String application, String groupname) {
        try {
            SharedGroupHome home = this.getSharedGroupHome();
            try {
                SharedGroupPK pk = new SharedGroupPK(application, groupname);
                home.remove(pk);
                return true;
            }
            catch (RemoveException ex) {
                logger.error((Object)ex.toString());
                return false;
            }
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            logger.error((Object)ex.toString());
            return false;
        }
    }

    public Vector getSharedGroupsOfApplication(String application) {
        Vector<SmallGroupVO> groups = new Vector<SmallGroupVO>();
        try {
            SharedGroupHome home = this.getSharedGroupHome();
            try {
                Iterator it = home.findByRealm(application).iterator();
                while (it.hasNext()) {
                    SmallGroupVO groupVO = SmallGroupVOFactory.getData(((SharedGroup)it.next()).getGroupname());
                    groups.add(groupVO);
                }
            }
            catch (FinderException ex) {
                logger.error((Object)ex.toString());
            }
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            logger.error((Object)ex.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)ex.toString());
        }
        return groups;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

