/*
 * Decompiled with CFR 0.152.
 */
package server.Management.institut;

import at.tugraz.genome.usermanagement.server.institut.VO.InstitutMembersVO;
import at.tugraz.genome.usermanagement.server.institut.VO.InstitutMembersVOFactory;
import at.tugraz.genome.usermanagement.server.institut.VO.InstitutVO;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VOFactory.ExtendedUserVOFactory;
import at.tugraz.genome.usermanagement.server.user.cache.ExtendedUserVOCache;
import com.opensymphony.module.access.provider.ejb.admin.OsInstitutes;
import com.opensymphony.module.access.provider.ejb.admin.OsInstitutesHome;
import com.opensymphony.module.access.provider.ejb.institut.InstituteAdmin;
import com.opensymphony.module.access.provider.ejb.institut.InstituteAdminHome;
import com.opensymphony.module.access.provider.ejb.institut.InstituteAdminPK;
import com.opensymphony.module.access.provider.ejb.institut.OsInstitutMembers;
import com.opensymphony.module.access.provider.ejb.institut.OsInstitutMembersHome;
import com.opensymphony.module.access.provider.ejb.institut.SubInstitute;
import com.opensymphony.module.access.provider.ejb.institut.SubInstituteHome;
import com.opensymphony.module.user.User;
import com.opensymphony.module.user.UserManager;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.Management.Management;
import server.Management.institut.VOFactory.InstitutVOFactory;

public class InstitutManagerBean
extends Management
implements SessionBean {
    private SessionContext sessionContext;
    private static final Log logger = LogFactory.getLog((Class)(class$server$Management$institut$InstitutManagerBean == null ? (class$server$Management$institut$InstitutManagerBean = InstitutManagerBean.class$("server.Management.institut.InstitutManagerBean")) : class$server$Management$institut$InstitutManagerBean));
    static /* synthetic */ Class class$server$Management$institut$InstitutManagerBean;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$admin$OsInstitutesHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$institut$SubInstituteHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$institut$InstituteAdminHome;

    public void ejbCreate() throws CreateException {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public Vector getAll() {
        logger.info((Object)"getAll");
        try {
            Vector<InstitutVO> result = new Vector<InstitutVO>();
            Iterator iter = this.getInstitutSB().findAll().iterator();
            while (iter.hasNext()) {
                OsInstitutes institute = (OsInstitutes)iter.next();
                result.add(InstitutVOFactory.createDto(institute));
            }
            return result;
        }
        catch (FinderException ex) {
            return null;
        }
    }

    public boolean addNew(String name, String address, String city, String telephone, String email, String country, String fax) {
        logger.info((Object)("addNew " + name));
        return this.addNew(name, address, city, telephone, email, country, fax, null);
    }

    private boolean addNew(String name, String address, String city, String telephone, String email, String country, String fax, Long mainInstituteId) {
        logger.info((Object)("private addNew " + name));
        try {
            OsInstitutes institut = this.getInstitutSB().create(name);
            institut.setAddress(address);
            institut.setCity(city);
            institut.setTelephone(telephone);
            institut.setEmail(email);
            institut.setCountry(country);
            institut.setFax(fax);
            if (mainInstituteId != null && mainInstituteId != 0L) {
                this.getSubInstitutesSB().create(mainInstituteId, institut.getId());
            }
            return true;
        }
        catch (CreateException ex) {
            logger.error((Object)ex);
            return false;
        }
        catch (NamingException nex) {
            logger.error((Object)nex);
            return false;
        }
    }

    public boolean deleteByName(String name) {
        logger.info((Object)("deleteByName " + name));
        try {
            OsInstitutes inst = this.getInstitutSB().findByName(name);
            this.removeRelationsToInstitute(inst.getId());
            this.deleteById(inst.getId());
            inst.remove();
            this.updateAllUsersInCache();
            return true;
        }
        catch (NamingException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
            return false;
        }
        catch (EJBException ex) {
            logger.error((Object)ex);
            return false;
        }
        catch (RemoveException ex) {
            logger.error((Object)ex);
            return false;
        }
    }

    public boolean deleteById(Long id) {
        logger.info((Object)("deleteById " + id));
        try {
            this.deleteRelationshipToOtherInstitutes(id);
            OsInstitutes inst = this.getInstitutSB().findByPrimaryKey(id);
            this.removeRelationsToInstitute(inst.getId());
            inst.remove();
            this.updateAllUsersInCache();
            return true;
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
            return false;
        }
        catch (NamingException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (EJBException ex) {
            logger.error((Object)ex);
            return false;
        }
        catch (RemoveException ex) {
            logger.error((Object)ex);
            return false;
        }
    }

    private boolean deleteRelationshipToOtherInstitutes(Long id) {
        logger.info((Object)("deleteRelationShipsToOhterInstitutes " + id));
        try {
            Iterator it;
            SubInstituteHome home = this.getSubInstitutesSB();
            try {
                Collection subinstitutes = home.findByMainInstituteId(id);
                if (subinstitutes != null) {
                    it = subinstitutes.iterator();
                    while (it.hasNext()) {
                        ((SubInstitute)it.next()).remove();
                    }
                }
            }
            catch (FinderException ex) {
                logger.error((Object)ex);
            }
            catch (NoSuchElementException nsx) {
                logger.error((Object)nsx);
            }
            try {
                Collection maininstitutes = home.findBySubInstitute(id);
                if (maininstitutes != null) {
                    it = maininstitutes.iterator();
                    while (it.hasNext()) {
                        ((SubInstitute)it.next()).remove();
                    }
                }
            }
            catch (FinderException ex) {
                logger.error((Object)ex);
            }
            catch (NoSuchElementException nsx) {
                logger.error((Object)nsx);
            }
            return true;
        }
        catch (EJBException ex) {
            logger.error((Object)ex);
        }
        catch (NamingException nex) {
            nex.printStackTrace();
        }
        catch (RemoveException ex) {
            logger.error((Object)ex);
        }
        return false;
    }

    public InstitutVO getById(Long Id) {
        logger.debug((Object)("getById " + Id));
        try {
            return InstitutVOFactory.createDto(this.getInstitutSB().findByPrimaryKey(Id));
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    public InstitutVO getByName(String name) {
        logger.debug((Object)("getByName " + name));
        try {
            return InstitutVOFactory.createDto(this.getInstitutSB().findByName(name));
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    private static OsInstitutesHome getInstitutSB() {
        OsInstitutesHome home = null;
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsInstitutes");
            home = (OsInstitutesHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsInstitutesHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsInstitutesHome = InstitutManagerBean.class$("com.opensymphony.module.access.provider.ejb.admin.OsInstitutesHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsInstitutesHome));
        }
        catch (ClassCastException ex) {
        }
        catch (NamingException ex) {}
        return home;
    }

    private static OsInstitutMembersHome getInstitutMembersSB() {
        OsInstitutMembersHome home = null;
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsInstitutMembers");
            home = (OsInstitutMembersHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome == null ? (class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome = InstitutManagerBean.class$("com.opensymphony.module.access.provider.ejb.institut.OsInstitutMembersHome")) : class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome));
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        return home;
    }

    private static SubInstituteHome getSubInstitutesSB() throws NamingException {
        SubInstituteHome home = null;
        InitialContext ctx = new InitialContext();
        Object ref = ctx.lookup("SubInstitute");
        home = (SubInstituteHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$institut$SubInstituteHome == null ? (class$com$opensymphony$module$access$provider$ejb$institut$SubInstituteHome = InstitutManagerBean.class$("com.opensymphony.module.access.provider.ejb.institut.SubInstituteHome")) : class$com$opensymphony$module$access$provider$ejb$institut$SubInstituteHome));
        return home;
    }

    private static InstituteAdminHome getInstituteAdminHome() throws NamingException {
        InstituteAdminHome home = null;
        InitialContext ctx = new InitialContext();
        Object ref = ctx.lookup("InstituteAdmin");
        home = (InstituteAdminHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$institut$InstituteAdminHome == null ? (class$com$opensymphony$module$access$provider$ejb$institut$InstituteAdminHome = InstitutManagerBean.class$("com.opensymphony.module.access.provider.ejb.institut.InstituteAdminHome")) : class$com$opensymphony$module$access$provider$ejb$institut$InstituteAdminHome));
        return home;
    }

    public boolean addUserToInstitut(String username, Long id) {
        logger.info((Object)("addUserToInstitut " + username + " " + id));
        if (username == null || id == null) {
            return false;
        }
        return this.addUserToInstitut(username, id, true);
    }

    private boolean addUserToInstitut(String username, Long id, boolean isMaininstitute) {
        try {
            OsInstitutMembersHome home = this.getInstitutMembersSB();
            try {
                if (isMaininstitute) {
                    OsInstitutMembers entity = (OsInstitutMembers)home.findByUsername(username, true).iterator().next();
                    try {
                        OsInstitutMembers entity2 = home.findByUsernameAndInstitutId(username, id);
                        entity2.remove();
                        entity.setMainInstitute(new Boolean(false));
                    }
                    catch (FinderException ex1) {
                        entity.remove();
                    }
                    catch (RemoveException ex1) {
                        ex1.printStackTrace();
                    }
                } else {
                    OsInstitutMembers entity = home.findByUsernameAndInstitutId(username, id);
                    entity.remove();
                }
            }
            catch (FinderException ex1) {
            }
            catch (NoSuchElementException nsx) {
            }
            catch (RemoveException ex1) {
                ex1.printStackTrace();
            }
            catch (Exception ex) {
                // empty catch block
            }
            home.create(id, username, new Boolean(isMaininstitute));
            ExtendedUserVOCache.getInstance().updateUser(username);
            return true;
        }
        catch (EJBException ex1) {
            ex1.printStackTrace();
        }
        catch (CreateException ex) {
            logger.error((Object)ex);
        }
        return false;
    }

    public boolean deleteUserFromInstitut(String username, Long id) {
        logger.info((Object)("deleteUserFromInstitut " + username + " " + id));
        if (username == null || id == null) {
            return false;
        }
        OsInstitutMembersHome home = null;
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsInstitutMembers");
            home = (OsInstitutMembersHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome == null ? (class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome = InstitutManagerBean.class$("com.opensymphony.module.access.provider.ejb.institut.OsInstitutMembersHome")) : class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome));
            home.findByUsernameAndInstitutId(username, id).remove();
            ExtendedUserVOCache.getInstance().updateUser(username);
            return true;
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
        }
        catch (EJBException ex) {
            logger.error((Object)ex);
        }
        catch (RemoveException ex) {
            logger.error((Object)ex);
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
        }
        return false;
    }

    public Vector getAllUsersOfInstitut(Long id) {
        logger.debug((Object)("getAllUsersOfInstitut " + id));
        if (id == null) {
            return null;
        }
        return InstitutManagerBean.getAllUsersOfInstitut(id, false);
    }

    public static Vector getAllUsersOfInstitut(Long id, boolean onlyAdditionalOnes) {
        OsInstitutMembersHome home = InstitutManagerBean.getInstitutMembersSB();
        Vector result = new Vector();
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsInstitutMembers");
            home = (OsInstitutMembersHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome == null ? (class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome = InstitutManagerBean.class$("com.opensymphony.module.access.provider.ejb.institut.OsInstitutMembersHome")) : class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome));
            Collection member = new Vector();
            member = onlyAdditionalOnes ? home.findByInstitutID(id, false) : home.findByInsitutID(id);
            logger.debug((Object)("getAllUsersOfInstitut " + member));
            result = InstitutMembersVOFactory.createDtos(member);
            logger.debug((Object)("getAllUsersOfInstitut " + result));
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return result;
        }
    }

    public static InstitutVO getInstitutOfUser(String username) {
        logger.debug((Object)("getInstitutOfUser " + username));
        if (username == null) {
            return null;
        }
        OsInstitutMembersHome home = InstitutManagerBean.getInstitutMembersSB();
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsInstitutMembers");
            home = (OsInstitutMembersHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome == null ? (class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome = InstitutManagerBean.class$("com.opensymphony.module.access.provider.ejb.institut.OsInstitutMembersHome")) : class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome));
            InstitutMembersVO vo = InstitutMembersVOFactory.createDto((OsInstitutMembers)home.findByUsername(username, true).iterator().next());
            OsInstitutesHome instHome = InstitutManagerBean.getInstitutSB();
            return InstitutVOFactory.createDto(instHome.findByPrimaryKey(vo.getInstitutid()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean updateInstitut(Long id, String name, String address, String city, String telephone, String email, String country, String fax) {
        logger.info((Object)("updateInstitut " + name));
        try {
            OsInstitutes institut = this.getInstitutSB().findByPrimaryKey(id);
            institut.setAddress(address);
            institut.setCity(city);
            institut.setTelephone(telephone);
            institut.setEmail(email);
            institut.setCountry(country);
            institut.setFax(fax);
            this.updateAllUsersInCache();
            return true;
        }
        catch (FinderException ex) {
            return false;
        }
    }

    public boolean addUserToInstitut(String username, String institutname) {
        logger.info((Object)("addUserToInstitut " + institutname));
        if (username == null || institutname == null) {
            return false;
        }
        return this.addUserToInstitut(username, institutname, true);
    }

    private boolean addUserToInstitut(String username, String institutname, boolean isMaininstitute) {
        Long id = null;
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsInstitutes");
            OsInstitutesHome home = (OsInstitutesHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsInstitutesHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsInstitutesHome = InstitutManagerBean.class$("com.opensymphony.module.access.provider.ejb.admin.OsInstitutesHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsInstitutesHome));
            id = home.findByName(institutname).getId();
            return this.addUserToInstitut(username, id, isMaininstitute);
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
            return false;
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
            return false;
        }
    }

    private void updateAllUsersInCache() {
        UserManager userManager_ = UserManager.getInstance();
        List userList = userManager_.getUsers();
        Iterator iter = userList.iterator();
        logger.debug((Object)"got all users");
        while (iter.hasNext()) {
            User user = (User)iter.next();
            ExtendedUserVOCache.getInstance().updateUser(user.getName());
        }
    }

    public boolean addUserToAdditionalInstitute(String username, String institutename) {
        logger.info((Object)("addUserToAdditionalInstitut " + institutename));
        if (username == null || institutename == null) {
            return false;
        }
        return this.addUserToInstitut(username, institutename, false);
    }

    public boolean addUserToAdditionalInstitute(String username, Long id) {
        logger.info((Object)("addUserToInstitut " + username + " " + id));
        if (username == null || id == null) {
            return false;
        }
        return this.addUserToInstitut(username, id, false);
    }

    public Vector getAdditionalUsersOfInstitute(Long id) {
        logger.debug((Object)("getAdditionalUsersOfInstitut " + id));
        if (id == null) {
            return null;
        }
        return InstitutManagerBean.getAllUsersOfInstitut(id, true);
    }

    public boolean addSubinstitute(Long mainInstituteId, InstitutVO vo) {
        return this.addNew(vo.getName(), vo.getAddress(), vo.getCity(), vo.getTelephone(), vo.getEmail(), vo.getCountry(), vo.getFax(), mainInstituteId);
    }

    public static Vector getSubinstitutes(Long mainInstituteId) {
        return InstitutManagerBean.getAllSubinstitutes(mainInstituteId);
    }

    public static Vector getAllSubinstitutes(Long mainInstituteId) {
        Vector<InstitutVO> subinstitutes;
        block7: {
            subinstitutes = new Vector<InstitutVO>();
            try {
                SubInstituteHome home = InstitutManagerBean.getSubInstitutesSB();
                OsInstitutesHome instHome = InstitutManagerBean.getInstitutSB();
                Collection subColl = home.findByMainInstituteId(mainInstituteId);
                if (subColl == null || subColl.iterator() == null) break block7;
                Iterator it = subColl.iterator();
                while (it.hasNext()) {
                    SubInstitute subInst = (SubInstitute)it.next();
                    OsInstitutes institute = instHome.findByPrimaryKey(subInst.getSubInstituteId());
                    subinstitutes.add(InstitutVOFactory.createDto(institute));
                    Vector subsubInsts = InstitutManagerBean.getAllSubinstitutes(institute.getId());
                    int i = 0;
                    while (i != subsubInsts.size()) {
                        subinstitutes.add((InstitutVO)subsubInsts.get(i));
                        ++i;
                    }
                }
            }
            catch (EJBException ex) {
                logger.error((Object)ex);
            }
            catch (NamingException nex) {
                nex.printStackTrace();
            }
            catch (FinderException ex) {
            }
            catch (NoSuchElementException nsx) {}
        }
        return subinstitutes;
    }

    public InstitutVO getMainInstitute(Long subInstituteId) {
        try {
            SubInstituteHome home = this.getSubInstitutesSB();
            OsInstitutesHome instHome = this.getInstitutSB();
            Collection mainInsts = home.findBySubInstitute(subInstituteId);
            if (mainInsts != null && mainInsts.iterator() != null) {
                SubInstitute subInst = (SubInstitute)mainInsts.iterator().next();
                OsInstitutes institute = instHome.findByPrimaryKey(subInst.getMainInstituteId());
                return InstitutVOFactory.createDto(institute);
            }
        }
        catch (EJBException ex) {
            logger.error((Object)ex);
        }
        catch (NamingException nex) {
            nex.printStackTrace();
        }
        catch (FinderException ex) {
        }
        catch (NoSuchElementException nsx) {}
        return null;
    }

    public boolean addInstituteAdmin(Long instituteId, Long userId) {
        try {
            InstituteAdminHome home = this.getInstituteAdminHome();
            InstituteAdminPK pk = new InstituteAdminPK(instituteId, userId);
            try {
                InstituteAdmin entity = home.findByPrimaryKey(pk);
                entity.remove();
            }
            catch (FinderException ex1) {
            }
            catch (NoSuchElementException nsx) {
            }
            catch (RemoveException ex1) {
                ex1.printStackTrace();
            }
            home.create(instituteId, userId);
            return true;
        }
        catch (EJBException ex1) {
            ex1.printStackTrace();
        }
        catch (CreateException ex) {
            logger.error((Object)ex);
        }
        catch (NamingException nex) {
            logger.error((Object)nex);
        }
        return false;
    }

    public boolean deleteInstituteAdmin(Long instituteId, Long userId) {
        try {
            InstituteAdminHome home = this.getInstituteAdminHome();
            InstituteAdminPK pk = new InstituteAdminPK(instituteId, userId);
            InstituteAdmin entity = home.findByPrimaryKey(pk);
            entity.remove();
            return true;
        }
        catch (EJBException ex1) {
            ex1.printStackTrace();
        }
        catch (RemoveException ex1) {
            ex1.printStackTrace();
        }
        catch (NamingException nex) {
            logger.error((Object)nex);
        }
        catch (FinderException fex) {
            logger.error((Object)fex);
        }
        return false;
    }

    public Vector getAllInstitutesWhereUserIsAdmin(Long userId) {
        return InstitutManagerBean.getInstitutesWherUserIsAdmin(userId, true);
    }

    public static Vector getInstitutesWherUserIsAdmin(Long userId, boolean includeHierarchyInstitues) {
        Vector<InstitutVO> institutes;
        block9: {
            institutes = new Vector<InstitutVO>();
            Hashtable<Long, Long> addedInsts = new Hashtable<Long, Long>();
            try {
                InstituteAdminHome home = InstitutManagerBean.getInstituteAdminHome();
                OsInstitutesHome instHome = InstitutManagerBean.getInstitutSB();
                Collection insts = home.findByUserId(userId);
                if (insts == null || insts.iterator() == null) break block9;
                Iterator it = insts.iterator();
                while (it.hasNext()) {
                    OsInstitutes inst = instHome.findByPrimaryKey(((InstituteAdmin)it.next()).getInstituteId());
                    InstitutVO instVO = InstitutVOFactory.createDto(inst);
                    if (!addedInsts.containsKey(instVO.getId())) {
                        addedInsts.put(instVO.getId(), instVO.getId());
                        institutes.add(instVO);
                    }
                    if (!includeHierarchyInstitues) continue;
                    Vector subinstitutes = InstitutManagerBean.getSubinstitutes(instVO.getId());
                    int i = 0;
                    while (i != subinstitutes.size()) {
                        InstitutVO subInstVO = (InstitutVO)subinstitutes.get(i);
                        if (!addedInsts.containsKey(subInstVO.getId())) {
                            addedInsts.put(subInstVO.getId(), subInstVO.getId());
                            institutes.add(subInstVO);
                        }
                        ++i;
                    }
                }
            }
            catch (EJBException ex1) {
                ex1.printStackTrace();
            }
            catch (NamingException nex) {
                logger.error((Object)nex);
            }
            catch (FinderException fex) {
                logger.error((Object)fex);
            }
            catch (NoSuchElementException nsx) {
                logger.error((Object)nsx);
            }
        }
        return institutes;
    }

    public Vector getInstitutesWhereUserIsDirectAdmin(Long userId) {
        return InstitutManagerBean.getInstitutesWherUserIsAdmin(userId, false);
    }

    public Vector getAdminsOfInstitute(Long instituteId) {
        Vector<ExtendedUserVO> users;
        block8: {
            users = new Vector<ExtendedUserVO>();
            try {
                InstituteAdminHome home = this.getInstituteAdminHome();
                Collection usrs = home.findByInstituteId(instituteId);
                if (usrs == null || usrs.iterator() == null) break block8;
                Iterator it = usrs.iterator();
                while (it.hasNext()) {
                    InstituteAdmin admin = (InstituteAdmin)it.next();
                    ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(admin.getUserId(), false);
                    if (vo != null) {
                        users.add(vo);
                        continue;
                    }
                    admin.remove();
                }
            }
            catch (EJBException ex1) {
                ex1.printStackTrace();
            }
            catch (NamingException nex) {
                logger.error((Object)nex);
            }
            catch (FinderException fex) {
                logger.error((Object)fex);
            }
            catch (NoSuchElementException nsx) {
                logger.error((Object)nsx);
            }
            catch (RemoveException rvx) {
                logger.error((Object)rvx);
            }
        }
        return users;
    }

    public Vector getAllInstitutesWhereUserIsAdmin(String username) {
        ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(username, false);
        return this.getAllInstitutesWhereUserIsAdmin(vo.getID());
    }

    public Vector getInstitutesWhereUserIsDirectAdmin(String username) {
        ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(username, false);
        return this.getInstitutesWhereUserIsDirectAdmin(vo.getID());
    }

    public boolean addInstituteAdmin(Long instituteId, String username) {
        ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(username, false);
        return this.addInstituteAdmin(instituteId, vo.getID());
    }

    public boolean deleteInstituteAdmin(Long instituteId, String username) {
        ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(username, false);
        return this.deleteInstituteAdmin(instituteId, vo.getID());
    }

    public Vector getIndirektUsersOfInstitute(Long instituteId) {
        Vector<InstitutMembersVO> users = new Vector<InstitutMembersVO>();
        Hashtable<String, String> usersTable = new Hashtable<String, String>();
        Vector mainInstitutes = new Vector();
        InstitutVO mainInstVO = this.getMainInstitute(instituteId);
        if (mainInstVO != null) {
            mainInstitutes = this.getAllMainInstitutes(mainInstVO);
        }
        int i = 0;
        while (i != mainInstitutes.size()) {
            InstitutVO instVO = (InstitutVO)mainInstitutes.get(i);
            Vector usersOfOneInstitute = this.getAllUsersOfInstitut(instVO.getId());
            int j = 0;
            while (j != usersOfOneInstitute.size()) {
                InstitutMembersVO vo = (InstitutMembersVO)usersOfOneInstitute.get(j);
                if (!usersTable.containsKey(vo.getUsername())) {
                    usersTable.put(vo.getUsername(), vo.getUsername());
                    users.add(vo);
                }
                ++j;
            }
            ++i;
        }
        return users;
    }

    private Vector getAllMainInstitutes(InstitutVO vo) {
        Vector mainInstitutes = new Vector();
        InstitutVO mainInstVO = this.getMainInstitute(vo.getId());
        if (mainInstVO != null) {
            mainInstitutes = this.getAllMainInstitutes(mainInstVO);
        }
        mainInstitutes.add(vo);
        return mainInstitutes;
    }

    public Vector getIndirectAdminsOfInstitute(Long instituteId) {
        Vector<ExtendedUserVO> users = new Vector<ExtendedUserVO>();
        Hashtable<String, String> usersTable = new Hashtable<String, String>();
        Vector mainInstitutes = new Vector();
        InstitutVO mainInstVO = this.getMainInstitute(instituteId);
        if (mainInstVO != null) {
            mainInstitutes = this.getAllMainInstitutes(mainInstVO);
        }
        int i = 0;
        while (i != mainInstitutes.size()) {
            InstitutVO instVO = (InstitutVO)mainInstitutes.get(i);
            Vector usersOfOneInstitute = this.getAdminsOfInstitute(instVO.getId());
            int j = 0;
            while (j != usersOfOneInstitute.size()) {
                ExtendedUserVO vo = (ExtendedUserVO)usersOfOneInstitute.get(j);
                if (!usersTable.containsKey(vo.getName())) {
                    usersTable.put(vo.getName(), vo.getName());
                    users.add(vo);
                }
                ++j;
            }
            ++i;
        }
        return users;
    }

    public static InstitutVO getInstitut(String username, Context ctx) {
        OsInstitutMembersHome memberHome = null;
        Long id = null;
        try {
            OsInstitutMembers member;
            Object ref = ctx.lookup("OsInstitutMembers");
            memberHome = (OsInstitutMembersHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome == null ? (class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome = InstitutManagerBean.class$("com.opensymphony.module.access.provider.ejb.institut.OsInstitutMembersHome")) : class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome));
            Collection members = memberHome.findByUsername(username, true);
            if (members != null && (id = (member = (OsInstitutMembers)members.iterator().next()).getInstitutid()) != null) {
                Object refInst = ctx.lookup("OsInstitutes");
                OsInstitutesHome home = (OsInstitutesHome)PortableRemoteObject.narrow((Object)refInst, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsInstitutesHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsInstitutesHome = InstitutManagerBean.class$("com.opensymphony.module.access.provider.ejb.admin.OsInstitutesHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsInstitutesHome));
                return InstitutVOFactory.createDto(home.findByPrimaryKey(id));
            }
        }
        catch (FinderException ex) {
            logger.debug((Object)("no Institute found for User " + username));
        }
        catch (NamingException ex) {
            logger.error((Object)("getInstitut " + ex));
        }
        catch (NoSuchElementException nsx) {
            logger.debug((Object)("no Institute found for User " + username));
        }
        InstitutVO vo = new InstitutVO();
        vo.setAddress("not available");
        vo.setCity("not available");
        vo.setFax("not available");
        vo.setCountry("not available");
        vo.setEmail("not available");
        vo.setName("not available");
        vo.setTelephone("not available");
        vo.setId(new Long(0L));
        return vo;
    }

    public static Vector getAddtionalInstitutes(String username, Context ctx, InstitutVO instVO) {
        OsInstitutMembersHome memberHome = null;
        Vector<InstitutVO> addInstitutes = new Vector<InstitutVO>();
        Vector<InstitutVO> addInstiutesPlusSubinstitutes = new Vector<InstitutVO>();
        Hashtable<Long, Long> addedInstitutes = new Hashtable<Long, Long>();
        Long id = null;
        try {
            Object ref = ctx.lookup("OsInstitutMembers");
            memberHome = (OsInstitutMembersHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome == null ? (class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome = InstitutManagerBean.class$("com.opensymphony.module.access.provider.ejb.institut.OsInstitutMembersHome")) : class$com$opensymphony$module$access$provider$ejb$institut$OsInstitutMembersHome));
            Collection addInstituteBeans = memberHome.findByUsername(username, false);
            if (addInstituteBeans != null) {
                Iterator it = addInstituteBeans.iterator();
                while (it.hasNext()) {
                    OsInstitutMembers member = (OsInstitutMembers)it.next();
                    id = member.getInstitutid();
                    if (id == null) continue;
                    Object refInst = ctx.lookup("OsInstitutes");
                    OsInstitutesHome home = (OsInstitutesHome)PortableRemoteObject.narrow((Object)refInst, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsInstitutesHome == null ? InstitutManagerBean.class$("com.opensymphony.module.access.provider.ejb.admin.OsInstitutesHome") : class$com$opensymphony$module$access$provider$ejb$admin$OsInstitutesHome));
                    addInstitutes.add(InstitutVOFactory.createDto(home.findByPrimaryKey(id)));
                }
            }
        }
        catch (FinderException ex) {
            logger.debug((Object)("no Institute found for User " + username));
        }
        catch (NamingException ex) {
            logger.error((Object)("getInstitut " + ex));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        addedInstitutes.put(instVO.getId(), instVO.getId());
        Vector subInst = InstitutManagerBean.getAllSubinstitutes(instVO.getId());
        addInstiutesPlusSubinstitutes = subInst == null ? new Vector() : new Vector(subInst);
        int i = 0;
        while (i != addInstitutes.size()) {
            InstitutVO addInstVO = (InstitutVO)addInstitutes.get(i);
            if (!addedInstitutes.containsKey(addInstVO.getId())) {
                addInstiutesPlusSubinstitutes.add(addInstVO);
                addedInstitutes.put(addInstVO.getId(), addInstVO.getId());
            }
            subInst = InstitutManagerBean.getAllSubinstitutes(addInstVO.getId());
            int j = 0;
            while (j != subInst.size()) {
                InstitutVO addSubInst = (InstitutVO)subInst.get(j);
                if (!addedInstitutes.containsKey(addSubInst.getId())) {
                    addInstiutesPlusSubinstitutes.add(addSubInst);
                    addedInstitutes.put(addSubInst.getId(), addSubInst.getId());
                }
                ++j;
            }
            ++i;
        }
        return addInstiutesPlusSubinstitutes;
    }

    private void removeRelationsToInstitute(Long instituteId) throws NamingException, RemoveException {
        block15: {
            Iterator it;
            try {
                Collection mainInsts = this.getSubInstitutesSB().findBySubInstitute(instituteId);
                if (mainInsts != null) {
                    it = mainInsts.iterator();
                    while (it.hasNext()) {
                        ((SubInstitute)it.next()).remove();
                    }
                }
            }
            catch (FinderException fex) {
                fex.printStackTrace();
            }
            try {
                Collection subInsts = this.getSubInstitutesSB().findByMainInstituteId(instituteId);
                if (subInsts != null) {
                    it = subInsts.iterator();
                    while (it.hasNext()) {
                        ((SubInstitute)it.next()).remove();
                    }
                }
            }
            catch (FinderException fex) {
                fex.printStackTrace();
            }
            try {
                Collection members = this.getInstitutMembersSB().findByInsitutID(instituteId);
                if (members != null) {
                    it = members.iterator();
                    while (it.hasNext()) {
                        ((OsInstitutMembers)it.next()).remove();
                    }
                }
            }
            catch (FinderException fex) {
                fex.printStackTrace();
            }
            try {
                Collection admins = this.getInstituteAdminHome().findByInstituteId(instituteId);
                if (admins == null) break block15;
                it = admins.iterator();
                while (it.hasNext()) {
                    ((InstituteAdmin)it.next()).remove();
                }
            }
            catch (FinderException fex) {
                fex.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

