/*
 * Decompiled with CFR 0.152.
 */
package server.Management.resource;

import at.tugraz.genome.usermanagement.server.resource.VO.ResourceVO;
import com.opensymphony.module.access.AccessManager;
import com.opensymphony.module.access.DuplicateKeyException;
import com.opensymphony.module.access.ImmutableException;
import com.opensymphony.module.access.NotFoundException;
import com.opensymphony.module.access.entities.Resource_I;
import com.opensymphony.module.access.provider.BaseProvider;
import com.opensymphony.module.access.provider.ejb.AclEntity;
import com.opensymphony.module.access.provider.ejb.ResourceEntity;
import com.opensymphony.module.access.provider.ejb.VOFactory.ResourceVOFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.Management.Management;

public class ResourceManagerBean
extends Management
implements SessionBean {
    SessionContext sessionContext;
    private static final Log logger = LogFactory.getLog((Class)(class$server$Management$resource$ResourceManagerBean == null ? (class$server$Management$resource$ResourceManagerBean = ResourceManagerBean.class$("server.Management.resource.ResourceManagerBean")) : class$server$Management$resource$ResourceManagerBean));
    static /* synthetic */ Class class$server$Management$resource$ResourceManagerBean;

    public void ejbCreate() throws CreateException {
        this.accessManager_ = this.getAccessManager();
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public boolean createResource(String realm, String key, String description, String access) {
        if (realm == null || key == null || description == null || access == null) {
            return false;
        }
        if (realm.trim().length() == 0 || key.trim().length() == 0 || description.trim().length() == 0 || access.trim().length() == 0) {
            return false;
        }
        try {
            logger.debug((Object)("will create " + realm + " " + key + " " + description + " " + access));
            this.accessManager_.createResource(realm, key, description, access);
            return true;
        }
        catch (ImmutableException ex) {
            logger.error((Object)("cannot create resource: " + ex));
        }
        catch (DuplicateKeyException ex) {
            logger.error((Object)("resource already exists " + ex));
        }
        return false;
    }

    public boolean deleteResource(String realm, String key) {
        if (realm == null || key == null) {
            return false;
        }
        if (realm.trim().length() == 0 || key.trim().length() == 0) {
            return false;
        }
        logger.debug((Object)("will delete key \"" + key + "\" of Realm \"" + realm + "\""));
        try {
            this.accessManager_.deleteResource(realm, key);
            logger.debug((Object)"deleted Resource");
            return true;
        }
        catch (ImmutableException ex) {
            return false;
        }
        catch (NotFoundException ex) {
            return false;
        }
    }

    public Vector getResourcesOfApplication(String realm) {
        if (realm == null) {
            return null;
        }
        if (realm.trim().length() == 0) {
            return null;
        }
        Vector<ResourceVO> listOfResources = new Vector<ResourceVO>();
        this.accessManager_ = AccessManager.getInstance();
        Vector list = null;
        logger.debug((Object)("get resources of " + realm));
        try {
            list = new Vector(this.accessManager_.getResources(realm));
        }
        catch (NotFoundException ex) {
            logger.error((Object)("could not find realm " + realm));
            return null;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ResourceEntity res = (ResourceEntity)iter.next();
            listOfResources.add(ResourceVOFactory.getData(realm, res));
        }
        return listOfResources;
    }

    public ResourceVO getResourceByKeyAndRealm(String realm, String key) {
        if (realm == null || key == null) {
            return null;
        }
        if (realm.trim().length() == 0 || key.trim().length() == 0) {
            return null;
        }
        logger.debug((Object)("Realm : " + realm + ", key: " + key));
        this.accessManager_ = AccessManager.getInstance();
        try {
            Resource_I res = this.accessManager_.getResource(realm, key);
            ResourceVO vo = new ResourceVO();
            vo.setAvailAccess(res.getAvailAccess());
            vo.setRealm(realm);
            vo.setDescription(res.getLongDescription());
            vo.setResourceKey(res.getResourceKey());
            logger.debug((Object)"will return vo");
            return vo;
        }
        catch (NotFoundException ex) {
            return null;
        }
    }

    public Vector getAllResources() {
        String realm;
        Vector<ResourceVO> listOfResources = new Vector<ResourceVO>();
        this.accessManager_ = AccessManager.getInstance();
        Vector v = new Vector(this.accessManager_.getResourceProviders());
        Iterator iter = v.iterator();
        Vector<String> list = new Vector<String>();
        while (iter.hasNext()) {
            realm = ((BaseProvider)iter.next()).getRealm();
            list.add(realm);
        }
        iter = list.iterator();
        while (iter.hasNext()) {
            realm = (String)iter.next();
            Vector tmp = null;
            try {
                tmp = new Vector(this.accessManager_.getResources(realm));
            }
            catch (NotFoundException ex) {
                // empty catch block
            }
            Iterator res = tmp.iterator();
            while (res.hasNext()) {
                ResourceEntity entity = (ResourceEntity)res.next();
                listOfResources.add(ResourceVOFactory.getData(realm, entity));
            }
        }
        return listOfResources;
    }

    public Collection getAclFromResoucre(String realm, String resourceKey) {
        if (realm == null || resourceKey == null) {
            return null;
        }
        if (realm.trim().length() == 0 || resourceKey.trim().length() == 0) {
            return null;
        }
        this.accessManager_ = AccessManager.getInstance();
        Vector list = null;
        try {
            list = new Vector(this.accessManager_.getAclsByResource(realm, resourceKey));
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                AclEntity acl = (AclEntity)iter.next();
                logger.debug((Object)acl.getAccessLevel());
            }
            return list;
        }
        catch (NotFoundException ex) {
            return null;
        }
    }

    public String getAccessLevelsFromResource(String realm, String resourceKey) {
        if (realm == null || resourceKey == null) {
            return null;
        }
        if (realm.trim().length() == 0 || resourceKey.trim().length() == 0) {
            return null;
        }
        logger.debug((Object)("will get AccessLevel of Realm : " + realm + ", key: " + resourceKey));
        this.accessManager_ = AccessManager.getInstance();
        String accessLevel = new String();
        try {
            Resource_I res = this.accessManager_.getResource(realm, resourceKey);
            return res.getAvailAccess();
        }
        catch (NotFoundException ex) {
            return null;
        }
    }

    public boolean updateResource(String realm, String key, String description, String access) {
        if (realm == null || key == null || description == null || access == null) {
            return false;
        }
        if (realm.trim().length() == 0 || key.trim().length() == 0 || description.trim().length() == 0 || access.trim().length() == 0) {
            return false;
        }
        try {
            logger.debug((Object)("will create " + realm + " " + key + " " + description + " " + access));
            String oldAccessLevel = this.accessManager_.getResource(realm, key).getAvailAccess();
            this.accessManager_.deleteResource(realm, key);
            this.accessManager_.createResource(realm, key, description, access);
            return true;
        }
        catch (NotFoundException ex) {
            return false;
        }
        catch (ImmutableException ex) {
            return false;
        }
        catch (DuplicateKeyException ex) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

