/*
 * Decompiled with CFR 0.152.
 */
package server.Management.rights;

import at.tugraz.genome.usermanagement.server.authentication.AuthenticationToken;
import at.tugraz.genome.usermanagement.server.config.ConfigLoader;
import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.right.VO.RightOfResourceVO;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VOFactory.ExtendedUserVOFactory;
import at.tugraz.genome.usermanagement.server.user.cache.ExtendedUserVOCache;
import com.opensymphony.module.access.AccessManager;
import com.opensymphony.module.access.NotFoundException;
import com.opensymphony.module.access.provider.ejb.OsAcl;
import com.opensymphony.module.access.provider.ejb.OsAclHome;
import com.opensymphony.module.access.provider.ejb.OsAdmins;
import com.opensymphony.module.access.provider.ejb.OsAdminsHome;
import com.opensymphony.module.access.provider.ejb.OsGroupInRealm;
import com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome;
import com.opensymphony.module.access.provider.ejb.OsLoggingHome;
import com.opensymphony.module.access.provider.ejb.OsUserInRealm;
import com.opensymphony.module.access.provider.ejb.OsUserInRealmHome;
import com.opensymphony.module.access.provider.ejb.ResourceEntity;
import com.opensymphony.module.access.provider.ejb.VOFactory.AclVOFactory;
import com.opensymphony.module.access.provider.ejb.VOFactory.ResourceVOFactory;
import com.opensymphony.module.access.provider.ejb.admin.OsLastlogin;
import com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome;
import com.opensymphony.module.access.provider.ejb.admin.OsUserChangepasswordHome;
import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.User;
import com.opensymphony.module.user.UserManager;
import com.opensymphony.module.user.provider.ejb.entity.OsUser;
import com.opensymphony.module.user.provider.ejb.entity.OsUserHome;
import com.opensymphony.module.user.provider.ejb.entity.login.OsLoginFailures;
import com.opensymphony.module.user.provider.ejb.entity.login.OsLoginFailuresHome;
import com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordPeriode;
import com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordPeriodeHome;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.Management.Management;
import server.Management.rights.authentication.AuthenticationManager;
import server.Management.rights.authentication.logging.LoginDataHandler;
import server.Management.util.MailManager;
import server.Management.util.ServerConstants;
import server.security.AuthenticationHandler;

public class RightsManagementBean
extends Management
implements SessionBean {
    private SessionContext sessionContext;
    private AccessManager accesssManager_ = null;
    private UserManager userManager_ = null;
    private static final Log logger = LogFactory.getLog((Class)(class$server$Management$rights$RightsManagementBean == null ? (class$server$Management$rights$RightsManagementBean = RightsManagementBean.class$("server.Management.rights.RightsManagementBean")) : class$server$Management$rights$RightsManagementBean));
    private static final String ERROR_MESSAGE = "username or password wrong";
    static /* synthetic */ Class class$server$Management$rights$RightsManagementBean;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsAclHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsLoggingHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$login$OsLoginFailuresHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsAdminsHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome;

    public void ejbCreate() throws CreateException {
        this.accesssManager_ = AccessManager.getInstance();
        this.userManager_ = UserManager.getInstance();
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public boolean hasUserAccessLevel(String username, String realm, String resource, String accessLevel) {
        if (username == null || realm == null || resource == null || accessLevel == null) {
            return false;
        }
        logger.debug((Object)("hasUserAccessLevel : " + username + ", " + realm + ", " + resource + ", " + accessLevel));
        this.accessManager_ = AccessManager.getInstance();
        try {
            return this.accessManager_.userHasAccessLevel(realm, username, resource, accessLevel);
        }
        catch (NotFoundException ex) {
            logger.error((Object)"acl not found");
            return false;
        }
    }

    public AuthenticationToken authenticateUser(String realm, String username, String password, String ipAddress, Long cookieMaxAgeInSeconds) {
        if (realm == null || username == null || password == null) {
            return new AuthenticationToken("username, application, password are null");
        }
        return this.authenticateUser(realm, username, password, ipAddress, cookieMaxAgeInSeconds, null, null);
    }

    public AuthenticationToken authenticateUser(String realm, String username, String ipAddress, Long cookieMaxAgeInSeconds, String samlAlias, String samlRealm) {
        if (realm == null || username == null || samlAlias == null || samlRealm == null) {
            return new AuthenticationToken("username, application, password are null");
        }
        return this.authenticateUser(realm, username, null, ipAddress, cookieMaxAgeInSeconds, samlAlias, samlRealm);
    }

    private AuthenticationToken authenticateUser(String realm, String username, String password, String ipAddress, Long cookieMaxAgeInSeconds, String samlAlias, String samlRealm) {
        String error;
        String error2;
        Object home;
        Object ref;
        String error3;
        logger.info((Object)("authenticateUser " + username + " for " + realm + " from ip " + ipAddress));
        boolean valid = false;
        boolean exlipcitDisabled = false;
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException ex1) {
            logger.fatal((Object)ex1);
            String error4 = "internal server error : " + ex1;
            return new AuthenticationToken(error4);
        }
        try {
            Object ref2 = ctx.lookup("OsUser");
            OsUserHome home2 = (OsUserHome)PortableRemoteObject.narrow((Object)ref2, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = RightsManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser user = home2.findByName(username);
            Long statusOfAllApplications = user.getApplicationAuthenticationEnabled();
            if (statusOfAllApplications < 1L) {
                String error5 = "user is disabled for all registered applications !";
                logger.info((Object)error5);
                return new AuthenticationToken(error5);
            }
        }
        catch (FinderException ex4) {
            logger.fatal((Object)("Tried to log in user " + username + " from ip " + ipAddress + "--> user not in AAS "));
            return new AuthenticationToken(ERROR_MESSAGE);
        }
        catch (NamingException ex4) {
            ex4.printStackTrace();
            String error6 = "Internal Error in authentication error";
            return new AuthenticationToken(error6);
        }
        try {
            Object perioderef = ctx.lookup("OsPasswordPeriode");
            OsPasswordPeriodeHome passwordPeriodeHome = (OsPasswordPeriodeHome)PortableRemoteObject.narrow((Object)perioderef, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome = RightsManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.password.OsPasswordPeriodeHome")) : class$com$opensymphony$module$user$provider$ejb$entity$password$OsPasswordPeriodeHome));
            OsPasswordPeriode passwdPeriode = null;
            try {
                passwdPeriode = passwordPeriodeHome.findByUsername(username);
            }
            catch (FinderException ex3) {
                logger.debug((Object)"no periods of passwordchange set yet: set to 1 Months");
                passwdPeriode = passwordPeriodeHome.create(username, ServerConstants.PERIODE_MONTHLY);
                long time = System.currentTimeMillis();
                logger.debug((Object)("current " + time));
                passwdPeriode.setPwdate(new Long(time));
                passwdPeriode.setPeriod(new Long(time += 2678400000L));
                logger.debug((Object)("set new period to: " + time));
            }
            if (passwdPeriode.getPeriod() < System.currentTimeMillis() && passwdPeriode.getPeriod() != 0L) {
                logger.debug((Object)("password expired - current: " + System.currentTimeMillis() + ", from DB: " + passwdPeriode.getPeriod()));
                logger.debug((Object)("password expired - set hasToChangeFlag for user: " + username));
                this.setUserChangePassword(username);
            }
        }
        catch (CreateException ex2) {
            ex2.printStackTrace();
            String error7 = "Internal Error in authentication error";
            return new AuthenticationToken(error7);
        }
        catch (NamingException ex2) {
            ex2.printStackTrace();
            error3 = "Internal Error in authentication error";
            return new AuthenticationToken(error3);
        }
        long actualDate = System.currentTimeMillis();
        try {
            ctx = new InitialContext();
            ref = ctx.lookup("OsUserInRealm");
            home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = RightsManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            OsUserInRealm userInRealm = null;
            try {
                userInRealm = home.findUserInRealm(username, realm);
                logger.debug((Object)(username + " isEnabled() " + userInRealm.getIsEnabled()));
                valid = true;
                if (userInRealm.getIsEnabled() == 0L) {
                    exlipcitDisabled = true;
                    String error8 = "your account exists in this Application, but was explicit disabled";
                    logger.error((Object)(error8 + ":" + username));
                    this.logAuthentication(username, realm, false, error8, cookieMaxAgeInSeconds, actualDate);
                    return new AuthenticationToken(error8);
                }
            }
            catch (FinderException ex) {
                error2 = "user \"" + username + "\" not enabled in this application " + realm;
                valid = false;
                logger.error((Object)error2);
            }
        }
        catch (NamingException ex) {
            ex.printStackTrace();
            logger.error((Object)"could not connect to server");
            error = "Internal Error in authentication error";
            return new AuthenticationToken(error);
        }
        if (!valid && !exlipcitDisabled) {
            logger.info((Object)"look if user in in enabled group");
            try {
                ctx = new InitialContext();
                ref = ctx.lookup("OsGroupInRealm");
                home = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = RightsManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
                User user = null;
                try {
                    user = this.userManager_.getUser(username);
                }
                catch (EntityNotFoundException ex) {
                    logger.error((Object)"no user in groups found with this name");
                    error2 = "Internal Error in authentication, user not found";
                    this.logAuthentication(username, realm, false, error2, cookieMaxAgeInSeconds, actualDate);
                    return new AuthenticationToken(error2);
                }
                Vector groupList = new Vector(user.getGroups());
                logger.info((Object)("user is in " + groupList.size() + " groups"));
                if (groupList.size() != 0) {
                    Iterator iter = groupList.iterator();
                    while (iter.hasNext()) {
                        SmallGroupVO group = (SmallGroupVO)iter.next();
                        logger.debug((Object)("looking for: " + group.getName()));
                        try {
                            OsGroupInRealm osGroupInRealm = home.findGroupInRealm(group.getName(), realm);
                            if (osGroupInRealm.getRealm().equals(realm) && osGroupInRealm.getIsEnabled() > 0L) {
                                logger.info((Object)("group \"" + group.getName() + "\" of user \"" + username + "\" enabled for application " + realm));
                                valid = true;
                                continue;
                            }
                            logger.debug((Object)("group \"" + group.getName() + "\" of user \"" + username + "\" disabled for application " + realm));
                        }
                        catch (FinderException ex) {
                            logger.debug((Object)("group " + group.getName() + " not enabled for realm " + realm));
                        }
                    }
                }
            }
            catch (NamingException ex) {
                ex.printStackTrace();
                logger.error((Object)("Bean not found " + ex.getMessage()));
                error = "Internal Error in authentication error (NamingException)";
                return new AuthenticationToken(error);
            }
        }
        if (valid && !exlipcitDisabled) {
            logger.info((Object)"user enabled, check password");
            LoginDataHandler.getInstance().setNewData(username);
            AuthenticationManager authManager = new AuthenticationManager(realm, username, password);
            logger.debug((Object)"will do authentication....");
            AuthenticationToken login = null;
            login = password != null && password.length() > 0 ? authManager.makeAuthentication() : authManager.makeSamlAuthentication(samlAlias, samlRealm);
            logger.debug((Object)"...done");
            if (login != null && !login.isError()) {
                this.resetLoginFailure(username);
                this.updateLoginData(username, realm, ipAddress, actualDate);
                this.logAuthentication(username, realm, true, username + " logged in successfully  from IP " + ipAddress, cookieMaxAgeInSeconds, actualDate);
                ExtendedUserVOCache.getInstance().updateUser(username);
            } else {
                if (login.getErrorMessage().endsWith(ERROR_MESSAGE) && !username.equals("admin")) {
                    this.loginfailure(username, realm, ipAddress);
                }
                logger.debug((Object)"return token, at least one token returned an error");
                this.logAuthentication(username, realm, false, login.getErrorMessage() + "  from ip " + ipAddress, cookieMaxAgeInSeconds, actualDate);
            }
            return login;
        }
        error3 = "you account is not enabled in the application: " + realm;
        this.logAuthentication(username, realm, false, error3, cookieMaxAgeInSeconds, actualDate);
        logger.debug((Object)"return token");
        return new AuthenticationToken(error3);
    }

    private void updateLoginData(String username, String application, String ipAddress, long actualDate) {
        InitialContext ctx = null;
        Object ref = null;
        OsLastloginHome lastLogin = null;
        try {
            ctx = new InitialContext();
            Object dataref = ctx.lookup("OsLastlogin");
            lastLogin = (OsLastloginHome)PortableRemoteObject.narrow((Object)dataref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome = RightsManagementBean.class$("com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome));
            OsLastlogin logindata = lastLogin.findByUsername(username);
            logindata.setApplication(application);
            logger.debug((Object)("set new Login Date for user : " + username));
            logindata.setLastlogin(new Long(actualDate));
        }
        catch (FinderException ex) {
            logger.debug((Object)"login data does not exists: create new");
            try {
                OsLastlogin logindata = lastLogin.create(username);
                logindata.setApplication(application);
                logindata.setLastlogin(new Long(actualDate));
                return;
            }
            catch (CreateException ex2) {
                ex.printStackTrace();
                logger.error((Object)ex2);
            }
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
            ex.printStackTrace();
        }
    }

    public ExtendedUserVO getUserVO(String username) {
        if (username == null || username.length() == 0) {
            return null;
        }
        logger.debug((Object)("get UserVO of User : " + username));
        try {
            return ExtendedUserVOFactory.getUserVO(username, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Vector getRightOfResource(String realm, String username) {
        Vector<RightOfResourceVO> result = new Vector<RightOfResourceVO>();
        if (username == null || username.length() == 0) {
            return result;
        }
        if (realm == null || realm.length() == 0) {
            return result;
        }
        ArrayList allResources = null;
        try {
            allResources = AccessManager.getInstance().getResources(realm);
        }
        catch (NotFoundException ex) {
            logger.error((Object)"getRightOfResource: no resources found");
            return null;
        }
        Vector grouspOfUser = null;
        try {
            grouspOfUser = UserManager.getInstance().getUser(username).getGroups();
            logger.debug((Object)("getRightOfResource: user is member of " + grouspOfUser.size() + " groups"));
        }
        catch (EntityNotFoundException ex1) {
            logger.debug((Object)"getRightOfResource: user is not a member of a group");
            grouspOfUser = new Vector();
        }
        Vector aclsOfGroups = new Vector();
        Iterator allRes = allResources.iterator();
        while (allRes.hasNext()) {
            ResourceEntity res = (ResourceEntity)allRes.next();
            RightOfResourceVO entry = new RightOfResourceVO();
            entry.setResourceKey(res.getResourceKey());
            entry.setResource(ResourceVOFactory.getData(realm, res));
            OsAclHome home = null;
            OsAcl acl = null;
            try {
                InitialContext ctx = new InitialContext();
                Object ref = ctx.lookup("Acl");
                home = (OsAclHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAclHome == null ? RightsManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsAclHome") : class$com$opensymphony$module$access$provider$ejb$OsAclHome));
                acl = home.findByRealmAndResourceKeyAndUserId(realm, res.getResourceKey(), username);
                entry.setUserAcl(AclVOFactory.getData(realm, acl));
            }
            catch (Exception ex2) {
                logger.debug((Object)("getRightOfResource: user has no Acl for resource: " + res.getResourceKey()));
            }
            Iterator iterGroups = grouspOfUser.iterator();
            while (iterGroups.hasNext()) {
                SmallGroupVO group = (SmallGroupVO)iterGroups.next();
                logger.debug((Object)("getRightOfResource: actual group: " + group.getName()));
                try {
                    acl = home.findByRealmAndGroupIdAndResourceKey(realm, group.getName(), res.getResourceKey());
                    entry.setGroupAcl(AclVOFactory.getData(realm, acl));
                    logger.debug((Object)("getRightOfResource: group has access for acl: " + acl.getResourceKey()));
                }
                catch (FinderException ex3) {
                    logger.debug((Object)"getRightOfResource: group has no Acl for this resource");
                }
            }
            result.add(entry);
        }
        return result;
    }

    private void logAuthentication(String username, String realm, boolean success, String message, Long cookieAgeInSeconds, long actualTime) {
        Long successTemp = null;
        successTemp = success ? new Long(1L) : new Long(0L);
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsLogging");
            OsLoggingHome authenticationLog = (OsLoggingHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsLoggingHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsLoggingHome = RightsManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsLoggingHome")) : class$com$opensymphony$module$access$provider$ejb$OsLoggingHome));
            Long expectedLogoutdate = new Long(actualTime + cookieAgeInSeconds * 1000L);
            logger.info((Object)("logging=> " + username + " " + realm + " " + actualTime + ", " + expectedLogoutdate + ", " + successTemp + ", " + message));
            authenticationLog.create(username, realm, new Long(actualTime), successTemp, message, expectedLogoutdate, null, null);
        }
        catch (CreateException ex1) {
            ex1.printStackTrace();
            logger.error((Object)ex1);
        }
        catch (NamingException ex1) {
            ex1.printStackTrace();
            logger.error((Object)ex1);
        }
    }

    public boolean checkLogin(String username, String id, String applicationname) {
        if (username == null || id == null || applicationname == null) {
            return false;
        }
        logger.debug((Object)("checkLogin: User " + username + " of Application " + applicationname));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsUserInRealm");
            OsUserInRealmHome home = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = RightsManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
            OsUserInRealm userInRealm = null;
            try {
                userInRealm = home.findUserInRealm(username, applicationname);
                logger.debug((Object)(username + " isEnabled() " + userInRealm.getIsEnabled()));
                return userInRealm.getIsEnabled() >= 1L;
            }
            catch (FinderException ex) {
                String error = "user \"" + username + "\" not enabled in this application";
                logger.error((Object)error);
                ex.printStackTrace();
                return false;
            }
        }
        catch (NamingException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean setStatusLDAPAccount(String username, boolean status) {
        if (username == null) {
            return false;
        }
        logger.debug((Object)("setStatusLDAPAccount " + username + " " + status));
        logger.debug(ConfigLoader.getInstance().getProperties().get("LDAPBaseEntry"));
        try {
            InitialContext ctx = new InitialContext();
            Object userref = ctx.lookup("OsUser");
            OsUserHome userHome = (OsUserHome)PortableRemoteObject.narrow((Object)userref, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = RightsManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            OsUser user = userHome.findByName(username);
            if (!status) {
                user.setLdapAuthenticationEnabled(new Long(0L));
                logger.debug((Object)("disabled ldap account for user " + username));
            } else {
                user.setLdapAuthenticationEnabled(new Long(1L));
                logger.debug((Object)("enabled ldap account for user " + username));
            }
            ExtendedUserVOCache.getInstance().updateUser(username);
            return true;
        }
        catch (FinderException ex) {
            ex.printStackTrace();
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private void resetLoginFailure(String username) {
        InitialContext ctx = null;
        OsLoginFailuresHome home = null;
        try {
            ctx = new InitialContext();
            Object failure = ctx.lookup("OsLoginFailures");
            home = (OsLoginFailuresHome)PortableRemoteObject.narrow((Object)failure, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$login$OsLoginFailuresHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$login$OsLoginFailuresHome = RightsManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.login.OsLoginFailuresHome")) : class$com$opensymphony$module$user$provider$ejb$entity$login$OsLoginFailuresHome));
            home.findbyName(username).remove();
            logger.debug((Object)("reset login failure for user : " + username));
        }
        catch (FinderException ex) {
        }
        catch (EJBException ex) {
            ex.printStackTrace();
        }
        catch (RemoveException ex) {
            ex.printStackTrace();
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
    }

    private void loginfailure(String username, String realmUserWantsToLogin, String ipAddress) {
        block30: {
            logger.error((Object)("loginfailure " + username + " in " + realmUserWantsToLogin + " from " + ipAddress));
            InitialContext ctx = null;
            OsLoginFailuresHome home = null;
            try {
                ctx = new InitialContext();
                Object failure = ctx.lookup("OsLoginFailures");
                home = (OsLoginFailuresHome)PortableRemoteObject.narrow((Object)failure, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$login$OsLoginFailuresHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$login$OsLoginFailuresHome = RightsManagementBean.class$("com.opensymphony.module.user.provider.ejb.entity.login.OsLoginFailuresHome")) : class$com$opensymphony$module$user$provider$ejb$entity$login$OsLoginFailuresHome));
            }
            catch (ClassCastException ex) {
                ex.printStackTrace();
                return;
            }
            catch (NamingException ex) {
                ex.printStackTrace();
                return;
            }
            String apps = new String();
            try {
                OsLoginFailures loginfailures = home.findbyName(username);
                if (loginfailures.getLoginfailures() > 2L) {
                    logger.debug((Object)"will disable user from all apllications");
                    Object applications = null;
                    try {
                        applications = ctx.lookup("OsUserInRealm");
                    }
                    catch (NamingException ex3) {
                        ex3.printStackTrace();
                    }
                    Object allAppliations = null;
                    Object listOfAllApplications = null;
                    OsUserInRealm realm = null;
                    OsUserInRealmHome userInRealmHome = (OsUserInRealmHome)PortableRemoteObject.narrow((Object)applications, (Class)(class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome = RightsManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsUserInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsUserInRealmHome));
                    Iterator iter = userInRealmHome.findAllRealmsOfUser(username).iterator();
                    while (iter.hasNext()) {
                        realm = (OsUserInRealm)iter.next();
                        try {
                            logger.debug((Object)("will disable user from application : " + realm.getRealm()));
                            Object adminref = null;
                            apps = apps + realm.getRealm() + ", ";
                            realm.setIsEnabled(new Long(0L));
                            try {
                                ctx = new InitialContext();
                                adminref = ctx.lookup("OsAdmins");
                                OsAdminsHome adminhome = (OsAdminsHome)PortableRemoteObject.narrow((Object)adminref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAdminsHome == null ? RightsManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsAdminsHome") : class$com$opensymphony$module$access$provider$ejb$OsAdminsHome));
                                Collection admins = null;
                                admins = adminhome.findAdminsOfRealm(realmUserWantsToLogin);
                                Iterator iter3 = admins.iterator();
                                while (iter3.hasNext()) {
                                    OsAdmins admin = (OsAdmins)iter3.next();
                                    User adminUser = null;
                                    try {
                                        adminUser = UserManager.getInstance().getUser(admin.getUsername());
                                        this.sendMailToAdmin(username, adminUser.getEmail(), admin.getRealm());
                                    }
                                    catch (EntityNotFoundException ex10) {
                                        logger.error((Object)"could not find adminstrator of application");
                                    }
                                }
                            }
                            catch (NamingException ex9) {
                                ex9.printStackTrace();
                            }
                        }
                        catch (EJBException ex4) {
                            ex4.printStackTrace();
                        }
                    }
                    Object groupObj = null;
                    try {
                        groupObj = ctx.lookup("OsGroupInRealm");
                    }
                    catch (NamingException ex6) {
                        ex6.printStackTrace();
                    }
                    OsGroupInRealmHome groupsHome = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)groupObj, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = RightsManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
                    Iterator groupsIter = groupsHome.findAllGroupsOfRealm(realmUserWantsToLogin).iterator();
                    logger.debug((Object)("groupsIter size : " + groupsHome.findAllGroupsOfRealm(realmUserWantsToLogin).size()));
                    while (groupsIter.hasNext()) {
                        logger.debug((Object)("groups are enabled in this realm : " + realmUserWantsToLogin));
                        OsGroupInRealm group = (OsGroupInRealm)groupsIter.next();
                        Vector usergroups = null;
                        try {
                            usergroups = this.userManager_.getUser(username).getGroups();
                        }
                        catch (EntityNotFoundException ex7) {
                            ex7.printStackTrace();
                            usergroups = new Vector();
                        }
                        Iterator iter2 = usergroups.iterator();
                        while (iter2.hasNext()) {
                            logger.debug((Object)"user is a member of groups...");
                            if (!group.getGroupname().equals(((SmallGroupVO)iter2.next()).getName())) continue;
                            OsUserInRealm userinrealm = null;
                            try {
                                userinrealm = userInRealmHome.findUserInRealm(username, realmUserWantsToLogin);
                                userinrealm.setIsEnabled(new Long(0L));
                            }
                            catch (FinderException ex8) {
                                try {
                                    userinrealm = userInRealmHome.create(username, realmUserWantsToLogin);
                                }
                                catch (CreateException ex11) {
                                    logger.error((Object)("cannot disable user explizit in application " + realmUserWantsToLogin));
                                }
                                userinrealm.setIsEnabled(new Long(0L));
                            }
                            logger.debug((Object)("user disabled, member of group : " + group.getGroupname()));
                        }
                    }
                    this.resetLoginFailure(username);
                    ExtendedUserVOCache.getInstance().updateUser(username);
                    String message = ConfigLoader.getInstance().getProperties().getProperty("disableMessage1");
                    message = message + ConfigLoader.getInstance().getProperties().getProperty("disableMessage2") + apps + "\n\n";
                    message = message + ConfigLoader.getInstance().getProperties().getProperty("disableMessage3");
                    try {
                        MailManager.send(this.userManager_.getUser(username).getEmail(), message);
                    }
                    catch (EntityNotFoundException ex5) {
                        logger.error((Object)"could not send mail to disabled user");
                    }
                    break block30;
                }
                loginfailures.setLoginfailures(new Long(loginfailures.getLoginfailures() + 1L));
                loginfailures.setIpAddress(ipAddress);
            }
            catch (FinderException ex1) {
                try {
                    home.create(username, ipAddress);
                    logger.debug((Object)("first login failure of user " + username));
                }
                catch (CreateException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
    }

    private boolean setUserChangePassword(String username) {
        if (username == null) {
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsUserChangepassword");
            OsUserChangepasswordHome passwordHome = (OsUserChangepasswordHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome = RightsManagementBean.class$("com.opensymphony.module.access.provider.ejb.admin.OsUserChangepasswordHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsUserChangepasswordHome));
            try {
                passwordHome.findByPrimaryKey(username).remove();
            }
            catch (FinderException ex1) {
            }
            catch (EJBException ex1) {
                ex1.printStackTrace();
            }
            catch (RemoveException ex1) {
                ex1.printStackTrace();
            }
            passwordHome.create(username);
            logger.info((Object)("user: " + username + " has to change password"));
            ExtendedUserVOCache.getInstance().updateUser(username);
            return true;
        }
        catch (CreateException ex) {
            ex.printStackTrace();
            logger.error((Object)ex);
            return false;
        }
        catch (NamingException ex) {
            ex.printStackTrace();
            logger.error((Object)ex);
            return false;
        }
    }

    private void sendMailToAdmin(String username, String emailOfAdmin, String application) {
        String message = ConfigLoader.getInstance().getProperties().getProperty("disableForAdmin1");
        message = message + " " + username + " " + ConfigLoader.getInstance().getProperties().getProperty("disableForAdmin2");
        message = message + " " + application;
        message = message + "\n " + ConfigLoader.getInstance().getProperties().getProperty("disableForAdmin3");
        MailManager.send(emailOfAdmin, message);
        logger.debug((Object)("send mail to admin of application " + application));
    }

    public boolean logoutUser(String username, String applicationname) {
        AuthenticationHandler.getInstance();
        AuthenticationHandler.removeID(username);
        boolean result = LoginDataHandler.getInstance().logoutUser(username, applicationname);
        ExtendedUserVOCache.getInstance().updateUser(username);
        return result;
    }

    public String refreshAuthenticationID(String username, String authenticationID, Long cookieAgeInSeconds) {
        AuthenticationHandler.getInstance();
        return AuthenticationHandler.refreshAuthenticationId(username, authenticationID, cookieAgeInSeconds);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

