/*
 * Decompiled with CFR 0.152.
 */
package server.Management.rights.authentication;

import at.tugraz.genome.crypt.DesEncrypter;
import at.tugraz.genome.usermanagement.server.authentication.AuthenticationToken;
import at.tugraz.genome.usermanagement.server.authentication.cache.CookieKeyCache;
import at.tugraz.genome.usermanagement.server.config.ConfigLoader;
import com.opensymphony.module.access.provider.ejb.OsAuthenticationrules;
import com.opensymphony.module.access.provider.ejb.OsAuthenticationrulesHome;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.log4j.Category;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.TreeWalkerImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import saml.client.sp.IdpServer;
import server.Management.rights.authentication.AuthenticationTokenManager;
import server.Management.rights.authentication.exception.TokenException;
import server.Management.rights.authentication.logging.LoginDataHandler;
import server.Management.rights.authentication.token.AuthToken;
import server.Management.rights.authentication.token.PasswordToken;
import server.Management.util.AllElementsFilter;
import server.Management.util.XMLtoDOM;
import server.security.AuthenticationHandler;

public class AuthenticationManager {
    private boolean parseOnly_ = false;
    private AuthenticationTokenManager tokenManager_;
    private String username_;
    private String realm_;
    private String password_;
    private AuthToken token_;
    private Vector toDoList_ = new Vector();
    static Category logger = Category.getInstance((String)(class$server$Management$rights$authentication$AuthenticationManager == null ? (class$server$Management$rights$authentication$AuthenticationManager = AuthenticationManager.class$("server.Management.rights.authentication.AuthenticationManager")) : class$server$Management$rights$authentication$AuthenticationManager).getName());
    static /* synthetic */ Class class$server$Management$rights$authentication$AuthenticationManager;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome;

    public AuthenticationManager(String realm, String username, String password) {
        this.realm_ = realm;
        this.username_ = username;
        DesEncrypter crypt = new DesEncrypter(CookieKeyCache.getInstance().getKey());
        this.password_ = password != null ? crypt.decrypt(password) : null;
        logger.debug((Object)("password after dencryption: " + this.password_));
        this.tokenManager_ = AuthenticationTokenManager.getInstance();
    }

    private void traverse(TreeWalkerImpl treewalker) {
        NodeImpl node = (NodeImpl)treewalker.getCurrentNode();
        if (node.hasChildNodes()) {
            Node child = treewalker.firstChild();
            while (child != null) {
                if (!this.parseOnly_) {
                    this.registerAction(child);
                }
                child = treewalker.nextSibling();
            }
        }
    }

    private void registerAction(Node node) {
        logger.debug((Object)("registering Action " + ((NodeImpl)node).getNodeName()));
        try {
            this.token_ = this.tokenManager_.createToken((Element)node, this.username_, this.password_);
            logger.debug((Object)("add: " + this.token_.toString()));
            this.toDoList_.add(this.token_);
        }
        catch (ClassNotFoundException exc) {
            logger.debug((Object)("Class - ERROR : " + exc.toString()));
        }
        catch (TokenException exc) {
            logger.debug((Object)("Token - ERROR : " + exc.toString()));
        }
    }

    public AuthenticationToken makeAuthentication() {
        if (this.username_ == null || this.password_ == null || this.realm_ == null) {
            logger.error((Object)"no userdata available");
            return new AuthenticationToken("username, password, applicationname are null");
        }
        AuthenticationToken aToken = new AuthenticationToken();
        logger.info((Object)("calling makeDocument: " + this.realm_));
        if (!this.makeDocument(this.realm_)) {
            aToken.concatError("Internal Server Error ... Can not make Dokument");
            return aToken;
        }
        boolean isAllCorrect = true;
        Iterator iter = this.toDoList_.iterator();
        logger.debug((Object)"login....start.....");
        while (iter.hasNext()) {
            AuthToken auth = (AuthToken)iter.next();
            try {
                logger.debug((Object)("test......." + auth.toString()));
                if (!auth.makeAuthentication()) {
                    aToken.concatError(auth.getErrorMessage());
                    isAllCorrect = false;
                    continue;
                }
                logger.debug((Object)".......correct");
            }
            catch (Exception e) {
                logger.error((Object)e.toString());
                e.printStackTrace();
                return aToken;
            }
        }
        aToken = this.returnTheCorrespondingAuthenticationToken(isAllCorrect, aToken);
        return aToken;
    }

    public AuthenticationToken makeSamlAuthentication(String samlAlias, String samlRealm) {
        if (this.username_ == null || this.realm_ == null || samlAlias == null || samlRealm == null) {
            logger.error((Object)"no userdata available");
            return new AuthenticationToken("username, applicationname, samlAlias, samlRealm are null");
        }
        DesEncrypter crypt = new DesEncrypter(CookieKeyCache.getInstance().getKey());
        String decrSamlAlias = null;
        decrSamlAlias = samlAlias != null ? crypt.decrypt(samlAlias) : null;
        logger.info((Object)("decrypted SAML alias: " + samlAlias));
        AuthenticationToken aToken = new AuthenticationToken();
        logger.info((Object)("calling makeDocument: " + this.realm_));
        if (!this.makeDocument(this.realm_)) {
            aToken.concatError("Internal Server Error ... Can not make Dokument");
            return aToken;
        }
        boolean isAllCorrect = true;
        Iterator iter = this.toDoList_.iterator();
        logger.debug((Object)"login....start.....");
        while (iter.hasNext()) {
            AuthToken auth = (AuthToken)iter.next();
            try {
                logger.debug((Object)("test......." + auth.toString()));
                if (auth instanceof PasswordToken) continue;
                if (!auth.makeAuthentication()) {
                    aToken.concatError(auth.getErrorMessage());
                    isAllCorrect = false;
                    continue;
                }
                logger.debug((Object)".......correct");
            }
            catch (Exception e) {
                logger.error((Object)e.toString());
                e.printStackTrace();
                return aToken;
            }
        }
        try {
            Properties configProperties = ConfigLoader.getInstance().getProperties();
            if (IdpServer.checkServerConnection()) {
                String federatedName = IdpServer.getFederationUserName((String)decrSamlAlias, (String)samlRealm);
                System.out.println("Name from SAML: " + federatedName);
                if (configProperties.containsKey("accept_saml_authentication") && (((String)configProperties.get("accept_saml_authentication")).equalsIgnoreCase("true") || ((String)configProperties.get("accept_saml_authentication")).equalsIgnoreCase("yes"))) {
                    if (federatedName == null || !this.username_.equalsIgnoreCase(federatedName)) {
                        isAllCorrect = false;
                        aToken.concatError("This user does not exist in SAML or the alias is not correct");
                    }
                } else {
                    isAllCorrect = false;
                    aToken.concatError("The SAML authentication is completely disabled");
                }
            } else {
                isAllCorrect = false;
                aToken.concatError("The SAML server is not reachable login normally");
            }
        }
        catch (IOException iox) {
            aToken.concatError(iox.getMessage());
            isAllCorrect = false;
        }
        aToken = this.returnTheCorrespondingAuthenticationToken(isAllCorrect, aToken);
        return aToken;
    }

    private AuthenticationToken returnTheCorrespondingAuthenticationToken(boolean isAllCorrect, AuthenticationToken aToken) {
        if (isAllCorrect) {
            logger.info((Object)"login successfull");
            AuthenticationHandler.getInstance();
            aToken.setAuthenticationID(AuthenticationHandler.getID(this.username_));
            aToken.setInformativeMessage_(LoginDataHandler.getInstance().checkIfUserLoggedOutProperly(this.username_));
        } else {
            aToken.setAuthenticationID("0");
        }
        return aToken;
    }

    private String getXMLDocumentOfRealm(String realm) {
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsAuthenticationrules");
            OsAuthenticationrulesHome home = (OsAuthenticationrulesHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome = AuthenticationManager.class$("com.opensymphony.module.access.provider.ejb.OsAuthenticationrulesHome")) : class$com$opensymphony$module$access$provider$ejb$OsAuthenticationrulesHome));
            OsAuthenticationrules authRule = null;
            try {
                authRule = home.findByPrimaryKey(realm);
            }
            catch (FinderException ex) {
                logger.error((Object)"No Autehntication Rules for Realm");
                return null;
            }
            logger.info((Object)"getRulefile() called........");
            byte[] ruleBytes = authRule.getRulefile();
            logger.info((Object)("ruleBytes: " + ruleBytes.length));
            return new String(ruleBytes);
        }
        catch (NamingException ex) {
            logger.error((Object)"could not connect to server");
            return null;
        }
    }

    private boolean makeDocument(String realm) {
        logger.debug((Object)"makeDocument called! ");
        String xml = this.getXMLDocumentOfRealm(realm);
        XMLtoDOM auth = new XMLtoDOM(xml);
        DocumentImpl doc = (DocumentImpl)auth.parse();
        logger.debug((Object)("After parse doc.getLength(): " + doc.getLength()));
        if (doc != null) {
            Node rootnode = doc.getLastChild();
            logger.debug((Object)("rootnode: " + rootnode.getNodeName()));
            if (!rootnode.getNodeName().equals("Authentication")) {
                logger.error((Object)"Wrong xml file, no node Authentication");
            }
            AllElementsFilter show_all_Elements = new AllElementsFilter();
            TreeWalkerImpl tw = (TreeWalkerImpl)doc.createTreeWalker(rootnode, 1, (NodeFilter)show_all_Elements, true);
            this.traverse(tw);
            return true;
        }
        logger.info((Object)("no document for realm : " + this.realm_));
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

