/*
 * Decompiled with CFR 0.152.
 */
package server.Management.rights.authentication.logging;

import at.tugraz.genome.usermanagement.server.user.cache.ExtendedUserVOCache;
import com.opensymphony.module.access.provider.ejb.OsLogging;
import com.opensymphony.module.access.provider.ejb.OsLoggingHome;
import com.opensymphony.module.access.provider.ejb.admin.OsLastlogin;
import com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.security.AuthenticationHandler;

public class LoginDataHandler {
    private static LoginDataHandler loginHandler_ = null;
    private Map loginDataRealm_ = Collections.synchronizedMap(new HashMap());
    private Map loginDataDate_ = Collections.synchronizedMap(new HashMap());
    private Map isLoggedInServerSide_ = Collections.synchronizedMap(new HashMap());
    private Map loggedOutProperly_ = Collections.synchronizedMap(new HashMap());
    private static final Log logger = LogFactory.getLog((Class)(class$server$Management$rights$authentication$logging$LoginDataHandler == null ? (class$server$Management$rights$authentication$logging$LoginDataHandler = LoginDataHandler.class$("server.Management.rights.authentication.logging.LoginDataHandler")) : class$server$Management$rights$authentication$logging$LoginDataHandler));
    static /* synthetic */ Class class$server$Management$rights$authentication$logging$LoginDataHandler;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsLoggingHome;

    private LoginDataHandler() {
    }

    public static synchronized LoginDataHandler getInstance() {
        if (loginHandler_ == null) {
            loginHandler_ = new LoginDataHandler();
        }
        return loginHandler_;
    }

    public synchronized void setNewData(String username) {
        InitialContext ctx = null;
        Object ref = null;
        try {
            ctx = new InitialContext();
            Object dataref = ctx.lookup("OsLastlogin");
            OsLastloginHome lastLogin = (OsLastloginHome)PortableRemoteObject.narrow((Object)dataref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome = LoginDataHandler.class$("com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome));
            Object loggingDataref = ctx.lookup("OsLogging");
            OsLoggingHome loggingHome = (OsLoggingHome)PortableRemoteObject.narrow((Object)loggingDataref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsLoggingHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsLoggingHome = LoginDataHandler.class$("com.opensymphony.module.access.provider.ejb.OsLoggingHome")) : class$com$opensymphony$module$access$provider$ejb$OsLoggingHome));
            OsLastlogin logindata = lastLogin.findByUsername(username);
            OsLogging detailedLoggingInfo = loggingHome.findByNameApplicationAndDate(username, logindata.getApplication(), logindata.getLastlogin());
            this.loginDataDate_.put(username, logindata.getLastlogin());
            this.loginDataRealm_.put(username, logindata.getApplication());
            if (detailedLoggingInfo.getSuccess() == 2L) {
                this.isLoggedInServerSide_.put(username, new Boolean(false));
                if (!detailedLoggingInfo.getLogoutRealm().equalsIgnoreCase("the user did not log out properly")) {
                    this.loggedOutProperly_.put(username, new Boolean(true));
                } else {
                    this.loggedOutProperly_.put(username, new Boolean(false));
                }
            }
            if (detailedLoggingInfo.getSuccess() == 1L) {
                this.isLoggedInServerSide_.put(username, new Boolean(true));
                this.loggedOutProperly_.put(username, new Boolean(false));
            }
            logger.info((Object)("set last login data for user: " + username + ", date: " + logindata.getLastlogin() + ", Application: " + logindata.getApplication() + ", isLoggedIn: " + (Boolean)this.isLoggedInServerSide_.get(username) + ", loggedOutProperly: " + (Boolean)this.loggedOutProperly_.get(username)));
        }
        catch (FinderException ex) {
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
        }
        catch (ClassCastException ex) {
            logger.error((Object)("OsLastLogin " + ex));
            ex.printStackTrace();
        }
    }

    public String getLastRealm(String username) {
        if (!this.loginDataRealm_.containsKey(username)) {
            return "not available";
        }
        return (String)this.loginDataRealm_.get(username);
    }

    public Long getLastDate(String username) {
        if (!this.loginDataDate_.containsKey(username)) {
            return new Long(0L);
        }
        return (Long)this.loginDataDate_.get(username);
    }

    public boolean isLoggedInServerSide(String username) {
        if (!this.isLoggedInServerSide_.containsKey(username)) {
            return false;
        }
        return (Boolean)this.isLoggedInServerSide_.get(username);
    }

    public boolean loggedOutProperly(String username) {
        if (!this.loggedOutProperly_.containsKey(username)) {
            return false;
        }
        return (Boolean)this.loggedOutProperly_.get(username);
    }

    public synchronized void emptyCache() {
        block7: {
            this.loginDataRealm_ = Collections.synchronizedMap(new HashMap());
            this.loginDataDate_ = Collections.synchronizedMap(new HashMap());
            this.isLoggedInServerSide_ = Collections.synchronizedMap(new HashMap());
            this.loggedOutProperly_ = Collections.synchronizedMap(new HashMap());
            try {
                InitialContext ctx = new InitialContext();
                Object dataref = ctx.lookup("OsLastlogin");
                OsLastloginHome lastLogin = (OsLastloginHome)PortableRemoteObject.narrow((Object)dataref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome = LoginDataHandler.class$("com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome));
                Object loggingDataref = ctx.lookup("OsLogging");
                OsLoggingHome loggingHome = (OsLoggingHome)PortableRemoteObject.narrow((Object)loggingDataref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsLoggingHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsLoggingHome = LoginDataHandler.class$("com.opensymphony.module.access.provider.ejb.OsLoggingHome")) : class$com$opensymphony$module$access$provider$ejb$OsLoggingHome));
                Collection allLoggings = loggingHome.findAll();
                if (allLoggings == null) break block7;
                Iterator it = allLoggings.iterator();
                while (it.hasNext()) {
                    OsLogging detailedLoggingInfo = (OsLogging)it.next();
                    if (detailedLoggingInfo.getSuccess() != 1L || detailedLoggingInfo.getExpectedLogoutdate() + 0x6DDD00L >= System.currentTimeMillis()) continue;
                    detailedLoggingInfo.setSuccess(new Long(2L));
                    detailedLoggingInfo.setLogoutRealm("the user did not log out properly");
                    detailedLoggingInfo.setLogoutdate(new Long(System.currentTimeMillis()));
                    try {
                        OsLastlogin logindata = lastLogin.findByUsername(detailedLoggingInfo.getUsername());
                        if (logindata.getLastlogin().longValue() != detailedLoggingInfo.getLogindate().longValue()) continue;
                        AuthenticationHandler.getInstance();
                        AuthenticationHandler.removeID(logindata.getUsername());
                    }
                    catch (FinderException fex) {
                        // empty catch block
                    }
                }
            }
            catch (FinderException ex) {
                logger.error((Object)ex);
            }
            catch (NamingException ex) {
                logger.error((Object)ex);
            }
            catch (ClassCastException ex) {
                logger.error((Object)("OsLastLogin " + ex));
                ex.printStackTrace();
            }
        }
    }

    public synchronized boolean refreshExpectedLogoutTime(String username, Long cookieAgeInSeconds) {
        try {
            InitialContext ctx = new InitialContext();
            Object dataref = ctx.lookup("OsLastlogin");
            OsLastloginHome lastLoginHome = (OsLastloginHome)PortableRemoteObject.narrow((Object)dataref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome = LoginDataHandler.class$("com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome));
            Object loggingDataref = ctx.lookup("OsLogging");
            OsLoggingHome loggingHome = (OsLoggingHome)PortableRemoteObject.narrow((Object)loggingDataref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsLoggingHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsLoggingHome = LoginDataHandler.class$("com.opensymphony.module.access.provider.ejb.OsLoggingHome")) : class$com$opensymphony$module$access$provider$ejb$OsLoggingHome));
            OsLastlogin lastLogin = lastLoginHome.findByUsername(username);
            OsLogging detailedData = loggingHome.findByNameApplicationAndDate(username, lastLogin.getApplication(), lastLogin.getLastlogin());
            detailedData.setExpectedLogoutdate(new Long(System.currentTimeMillis() + cookieAgeInSeconds * 1000L));
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
        }
        catch (ClassCastException ex) {
            logger.error((Object)("OsLastLogin " + ex));
            ex.printStackTrace();
        }
        return false;
    }

    public String checkIfUserLoggedOutProperly(String username) {
        String anwserString = null;
        if (this.isLoggedInServerSide_.containsKey(username) && !((Boolean)this.isLoggedInServerSide_.get(username)).booleanValue() && !((Boolean)this.loggedOutProperly_.get(username)).booleanValue()) {
            anwserString = "You (" + username + ") have not logged out properly from the application " + (String)this.loginDataRealm_.get(username) + "! Whenever you leave an application log out!";
        }
        return anwserString;
    }

    public synchronized boolean logoutUser(String username, String realm) {
        try {
            InitialContext ctx = new InitialContext();
            Object dataref = ctx.lookup("OsLastlogin");
            OsLastloginHome lastLogin = (OsLastloginHome)PortableRemoteObject.narrow((Object)dataref, (Class)(class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome == null ? (class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome = LoginDataHandler.class$("com.opensymphony.module.access.provider.ejb.admin.OsLastloginHome")) : class$com$opensymphony$module$access$provider$ejb$admin$OsLastloginHome));
            Object loggingDataref = ctx.lookup("OsLogging");
            OsLoggingHome loggingHome = (OsLoggingHome)PortableRemoteObject.narrow((Object)loggingDataref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsLoggingHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsLoggingHome = LoginDataHandler.class$("com.opensymphony.module.access.provider.ejb.OsLoggingHome")) : class$com$opensymphony$module$access$provider$ejb$OsLoggingHome));
            OsLastlogin logindata = lastLogin.findByUsername(username);
            OsLogging detailedLoggingInfo = loggingHome.findByNameApplicationAndDate(username, logindata.getApplication(), logindata.getLastlogin());
            detailedLoggingInfo.setSuccess(new Long(2L));
            detailedLoggingInfo.setLogoutRealm(realm);
            detailedLoggingInfo.setLogoutdate(new Long(System.currentTimeMillis()));
            this.isLoggedInServerSide_.put(username, new Boolean(false));
            this.loggedOutProperly_.put(username, new Boolean(true));
            ExtendedUserVOCache.getInstance().updateUser(username);
            logger.info((Object)("logout user: " + username + ", date: " + logindata.getLastlogin() + ", Application: " + logindata.getApplication() + ", isLoggedIn: " + (Boolean)this.isLoggedInServerSide_.get(username) + ", loggedOutProperly: " + (Boolean)this.loggedOutProperly_.get(username)));
            return true;
        }
        catch (FinderException ex) {
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
        }
        catch (ClassCastException ex) {
            logger.error((Object)("OsLastLogin " + ex));
            ex.printStackTrace();
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

